/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.qa.unittest;

import com.zimbra.common.localconfig.LC;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.client.LmcSession;
import com.zimbra.cs.client.soap.LmcDeleteAccountRequest;
import com.zimbra.cs.db.DbMailbox;
import com.zimbra.cs.db.DbResults;
import com.zimbra.cs.db.DbUtil;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.MailboxManager;
import com.zimbra.cs.store.file.Volume;
import com.zimbra.qa.unittest.TestUtil;
import java.io.File;
import java.util.HashMap;
import junit.framework.TestCase;

public class TestAccount
extends TestCase {
    private static String USER_NAME = "TestAccount";
    private static String PASSWORD = "test123";

    public void setUp() throws Exception {
        this.cleanUp();
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        attrs.put("zimbraMailHost", LC.zimbra_server_hostname.value());
        attrs.put("cn", "TestAccount");
        attrs.put("displayName", "TestAccount unit test user");
        Provisioning.getInstance().createAccount(TestUtil.getAddress(USER_NAME), PASSWORD, attrs);
    }

    public void tearDown() throws Exception {
        this.cleanUp();
    }

    public void testDeleteAccount() throws Exception {
        ZimbraLog.test.debug("testDeleteAccount()");
        Account account = TestUtil.getAccount(USER_NAME);
        Mailbox mbox = MailboxManager.getInstance().getMailboxByAccount(account);
        String dbName = DbMailbox.getDatabaseName(mbox);
        ZimbraLog.test.debug("Account=" + account.getId() + ", mbox=" + mbox.getId());
        DbResults results = DbUtil.executeQuery("SELECT COUNT(*) FROM mailbox WHERE id = " + mbox.getId());
        TestAccount.assertEquals((String)"Could not find row in mailbox table", (int)1, (int)results.getInt(1));
        results = DbUtil.executeQuery("SHOW DATABASES LIKE '" + dbName + "'");
        TestAccount.assertEquals((String)"Could not find mailbox database", (int)1, (int)results.size());
        TestUtil.addMessage(mbox, "TestAccount testDeleteAccount");
        String storePath = Volume.getCurrentMessageVolume().getMessageRootDir(mbox.getId());
        File storeDir = new File(storePath);
        TestAccount.assertTrue((String)(storePath + " does not exist"), (boolean)storeDir.exists());
        TestAccount.assertTrue((String)(storePath + " is not a directory"), (boolean)storeDir.isDirectory());
        LmcSession session = TestUtil.getAdminSoapSession();
        LmcDeleteAccountRequest req = new LmcDeleteAccountRequest(account.getId());
        req.setSession(session);
        req.invoke(TestUtil.getAdminSoapUrl());
        results = DbUtil.executeQuery("SELECT COUNT(*) FROM mailbox WHERE id = " + mbox.getId());
        TestAccount.assertEquals((String)"Unexpected row in mailbox table", (int)0, (int)results.getInt(1));
        TestAccount.assertFalse((String)(storePath + " exists"), (boolean)storeDir.exists());
    }

    private void cleanUp() throws Exception {
        Provisioning prov = Provisioning.getInstance();
        Account account = prov.get(Provisioning.AccountBy.name, TestUtil.getAddress(USER_NAME));
        if (account != null) {
            prov.deleteAccount(account.getId());
        }
    }
}

