/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.qa.unittest;

import com.zimbra.common.auth.ZAuthToken;
import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.common.util.CliUtil;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.AuthToken;
import com.zimbra.cs.account.AuthTokenException;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.service.AuthProvider;
import com.zimbra.cs.service.AuthProviderException;
import com.zimbra.cs.service.UserServlet;
import com.zimbra.cs.servlet.ZimbraServlet;
import com.zimbra.cs.zclient.ZFolder;
import com.zimbra.cs.zclient.ZGrant;
import com.zimbra.cs.zclient.ZMailbox;
import com.zimbra.cs.zclient.ZSearchParams;
import com.zimbra.qa.unittest.TestUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import junit.framework.TestCase;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;

public class TestAccessKeyGrant
extends TestCase {
    private static final String DUMMY_AUTH_PROVIDER = "DUMMY_AUTH_PROVIDER";
    private static final String OWNER_NAME = "user1";
    private static final String USER_GRANTEE_NAME = "user3";
    private static final String ACCESS_KEY = "b931d99fc5dc7e8061a97d90e05e3256";
    private static final String AUTH_K_ATTR = "K";
    private static final String AUTH_H_ATTR = "H";
    private static final String FOLDER_PATH = "Calendar";

    private Account getAccount(String acctName) throws ServiceException {
        Provisioning prov = Provisioning.getInstance();
        Account acct = prov.get(Provisioning.AccountBy.name, acctName);
        TestAccessKeyGrant.assertNotNull((Object)acct);
        return acct;
    }

    private String getAccountId(String acctName) throws ServiceException {
        return this.getAccount(acctName).getId();
    }

    private String getRestUrl(String acctName) throws ServiceException {
        return UserServlet.getRestUrl(this.getAccount(acctName));
    }

    private String getRestCalendarUrl(String acctName) throws ServiceException {
        return UserServlet.getRestUrl(this.getAccount(acctName)) + "/Calendar";
    }

    private ZMailbox getZMailboxByKey() throws Exception {
        HashMap<String, String> authAttrs = new HashMap<String, String>();
        authAttrs.put(AUTH_K_ATTR, ACCESS_KEY);
        authAttrs.put(AUTH_H_ATTR, this.getAccountId(OWNER_NAME));
        ZAuthToken zat = new ZAuthToken(DUMMY_AUTH_PROVIDER, null, authAttrs);
        ZMailbox.Options options = new ZMailbox.Options(zat, TestUtil.getSoapUrl());
        return ZMailbox.getMailbox(options);
    }

    private void dumpGrants(ZMailbox mbox, String folderId) throws Exception {
        ZFolder folder = mbox.getFolderRequestById(folderId);
        System.out.println("--------------------");
        System.out.println(mbox.getName() + ", folder=" + folderId);
        List<ZGrant> grants = folder.getGrants();
        for (ZGrant grant : grants) {
            System.out.println("    type: " + grant.getGranteeType().toString());
            System.out.println("    id: " + grant.getGranteeId());
            System.out.println("    name: " + grant.getGranteeName());
            System.out.println("    rights: " + grant.getPermissions());
            if (grant.getGranteeType() == ZGrant.GranteeType.key) {
                System.out.println("    accesskey: " + grant.getArgs());
            } else if (grant.getGranteeType() == ZGrant.GranteeType.guest) {
                System.out.println("    password: " + grant.getArgs());
            } else {
                TestAccessKeyGrant.assertNull((Object)grant.getArgs());
            }
            System.out.println();
        }
    }

    public void disable_testKeyGrant() throws Exception {
        ZMailbox mbox = this.getZMailboxByKey();
        StringBuffer query = new StringBuffer();
        query.append("(inid:");
        query.append("10");
        query.append(")");
        ZSearchParams sp = new ZSearchParams(query.toString());
        sp.setTypes("appointment");
        mbox.search(sp);
    }

    public void disable_testGetFolderRequest() throws Exception {
        ZMailbox ownerMbox = TestUtil.getZMailbox(OWNER_NAME);
        ZMailbox granteeMbox = TestUtil.getZMailbox(USER_GRANTEE_NAME);
        String mointpointPath = "user1's Calendar";
        this.dumpGrants(TestUtil.getZMailbox("user2"), "259");
        this.dumpGrants(TestUtil.getZMailbox("user4"), "258");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeHttpMethod(HttpClient client, HttpMethod method) throws Exception {
        try {
            int respCode = client.executeMethod(method);
            if (respCode != 200) {
                System.out.println("failed, respCode=" + respCode);
            } else {
                boolean chunked = false;
                boolean textContent = false;
                System.out.println("Headers:");
                System.out.println("--------");
                for (Header header : method.getRequestHeaders()) {
                    System.out.print("    " + header.toString());
                }
                System.out.println();
                System.out.println("Body:");
                System.out.println("-----");
                String respBody = method.getResponseBodyAsString();
                System.out.println(respBody);
            }
            Object var11_10 = null;
            method.releaseConnection();
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            method.releaseConnection();
            throw throwable;
        }
    }

    public void disable_testCalendarGet_Yahoo_accesskey() throws Exception {
        HttpClient client = new HttpClient();
        String accessKey = "3c4877ed3948511cee39379debbf968d-bogus";
        String url = this.getRestCalendarUrl(OWNER_NAME);
        url = url + "?k=" + accessKey + "&h=" + this.getAccountId(OWNER_NAME);
        System.out.println("REST URL: " + url);
        GetMethod method = new GetMethod(url);
        this.executeHttpMethod(client, method);
    }

    public void testCalendarGet_guest() throws Exception {
        HttpState initialState = new HttpState();
        String guestName = "g1@guest.com";
        String guestPassword = "zzz";
        UsernamePasswordCredentials loginCredentials = new UsernamePasswordCredentials(guestName, guestPassword);
        initialState.setCredentials(AuthScope.ANY, loginCredentials);
        HttpClient client = new HttpClient();
        client.setState(initialState);
        String url = this.getRestCalendarUrl(OWNER_NAME);
        System.out.println("REST URL: " + url);
        GetMethod method = new GetMethod(url);
        this.executeHttpMethod(client, method);
    }

    public static void main(String[] args) throws Exception {
        CliUtil.toolSetup();
        TestUtil.runTest(TestAccessKeyGrant.class);
    }

    private static class DummyAuthToken
    extends AuthToken {
        private String mAccessKey;
        private String mOwnerId;

        DummyAuthToken(String accessKey, String ownerId) {
            this.mAccessKey = accessKey;
            this.mOwnerId = ownerId;
        }

        public void encode(HttpClient client, HttpMethod method, boolean isAdminReq, String cookieDomain) throws ServiceException {
            throw ServiceException.FAILURE("Not implemented", null);
        }

        public void encode(HttpState state, boolean isAdminReq, String cookieDomain) throws ServiceException {
            throw ServiceException.FAILURE("Not implemented", null);
        }

        public void encode(HttpServletResponse resp, boolean isAdminReq, boolean secureCookie) throws ServiceException {
            throw ServiceException.FAILURE("Not implemented", null);
        }

        public void encodeAuthResp(Element parent, boolean isAdmin) throws ServiceException {
        }

        public String getAccountId() {
            return this.mOwnerId;
        }

        public String getAdminAccountId() {
            return null;
        }

        public String getCrumb() throws AuthTokenException {
            return null;
        }

        public String getDigest() {
            return null;
        }

        public String getAccessKey() {
            return this.mAccessKey;
        }

        public String getEncoded() throws AuthTokenException {
            return null;
        }

        public long getExpires() {
            return 0L;
        }

        public String getExternalUserEmail() {
            return null;
        }

        public boolean isAdmin() {
            return false;
        }

        public boolean isDomainAdmin() {
            return false;
        }

        public boolean isDelegatedAdmin() {
            return false;
        }

        public boolean isExpired() {
            return false;
        }

        public boolean isZimbraUser() {
            return this.mAccessKey == null;
        }

        public String toString() {
            return null;
        }

        public ZAuthToken toZAuthToken() throws ServiceException {
            HashMap<String, String> attrs = new HashMap<String, String>();
            attrs.put(TestAccessKeyGrant.AUTH_K_ATTR, this.mAccessKey);
            attrs.put(TestAccessKeyGrant.AUTH_H_ATTR, this.mOwnerId);
            return new ZAuthToken(TestAccessKeyGrant.DUMMY_AUTH_PROVIDER, null, attrs);
        }
    }

    public static class DummyAuthProvider
    extends AuthProvider {
        public DummyAuthProvider() {
            super(TestAccessKeyGrant.DUMMY_AUTH_PROVIDER);
        }

        protected AuthToken authToken(HttpServletRequest req, boolean isAdminReq) throws AuthProviderException, AuthTokenException {
            if (isAdminReq) {
                return null;
            }
            String accessKey = req.getParameter("k");
            String hostYid = req.getParameter("h");
            if (accessKey != null && hostYid != null) {
                return new DummyAuthToken(accessKey, hostYid);
            }
            throw AuthProviderException.NO_AUTH_DATA();
        }

        protected AuthToken authToken(Element soapCtxt, Map engineCtxt) throws AuthProviderException, AuthTokenException {
            if (soapCtxt == null) {
                throw AuthProviderException.NO_AUTH_DATA();
            }
            try {
                Element eAuthToken = soapCtxt.getElement("authToken");
                String type = eAuthToken.getAttribute("type");
                if (type == null || !type.equals(TestAccessKeyGrant.DUMMY_AUTH_PROVIDER)) {
                    throw AuthProviderException.NOT_SUPPORTED();
                }
                String ownerId = null;
                String accessKey = null;
                for (Element authAttr : eAuthToken.listElements("a")) {
                    String name = authAttr.getAttribute("n");
                    if (name != null && name.equals(TestAccessKeyGrant.AUTH_K_ATTR)) {
                        accessKey = authAttr.getText();
                        continue;
                    }
                    if (name == null || !name.equals(TestAccessKeyGrant.AUTH_H_ATTR)) continue;
                    ownerId = authAttr.getText();
                }
                if (accessKey != null && ownerId != null) {
                    return new DummyAuthToken(accessKey, ownerId);
                }
            }
            catch (ServiceException x) {
                throw AuthProviderException.NO_AUTH_DATA();
            }
            throw AuthProviderException.NO_AUTH_DATA();
        }

        protected boolean allowURLAccessKeyAuth(HttpServletRequest req, ZimbraServlet servlet) {
            return true;
        }
    }
}

