/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.qa.unittest;

import com.zimbra.common.auth.ZAuthToken;
import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.AccountConstants;
import com.zimbra.common.soap.Element;
import com.zimbra.common.soap.MailConstants;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.DataSource;
import com.zimbra.cs.account.Domain;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.Signature;
import com.zimbra.cs.account.soap.SoapProvisioning;
import com.zimbra.qa.unittest.TestProvisioningUtil;
import com.zimbra.qa.unittest.TestUtil;
import java.util.HashMap;
import junit.framework.Assert;
import junit.framework.TestCase;

public class TestAccess
extends TestCase {
    private String TEST_ID;
    private static String TEST_NAME = "test-access";
    private SoapAdminUser mProvAdmin;
    private SoapUser mSoapUser1;
    private int mBrainDeadSingleThreadRandom = 0;
    private static String PASSWORD = "test123";
    private String DOMAIN_NAME;
    private String ACCT_1_EMAIL;
    private String ACCT_2_EMAIL;
    private String ACCT_1_ID;
    private String ACCT_2_ID;

    public void setUp() throws Exception {
        this.TEST_ID = TestProvisioningUtil.genTestId();
        System.out.println("\nTest " + this.TEST_ID + " setting up...\n");
        this.mProvAdmin = new SoapAdminUser("admin");
        this.mProvAdmin.auth();
        this.DOMAIN_NAME = TestProvisioningUtil.baseDomainName(TEST_NAME, this.TEST_ID);
        this.ACCT_1_EMAIL = "acct-1@" + this.DOMAIN_NAME;
        this.ACCT_2_EMAIL = "acct-2@" + this.DOMAIN_NAME;
        Domain domain = this.createDomain(this.DOMAIN_NAME);
        Account acct1 = this.createAccount(this.ACCT_1_EMAIL);
        Account acct2 = this.createAccount(this.ACCT_2_EMAIL);
        this.ACCT_1_ID = acct1.getId();
        this.ACCT_2_ID = acct2.getId();
        this.mSoapUser1 = new SoapUser(this.ACCT_1_EMAIL, this.ACCT_1_ID);
        this.mSoapUser1.auth();
    }

    private Domain createDomain(String domainName) throws Exception {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        Domain domain = this.mProvAdmin.createDomain(domainName, attrs);
        TestAccess.assertNotNull((Object)domain);
        return domain;
    }

    private Account createAccount(String accountEmail) throws Exception {
        HashMap<String, Object> acctAttrs = new HashMap<String, Object>();
        Account acct = this.mProvAdmin.createAccount(accountEmail, PASSWORD, acctAttrs);
        TestAccess.assertNotNull((Object)acct);
        return acct;
    }

    private String random() {
        return "" + this.mBrainDeadSingleThreadRandom++;
    }

    void accessTest(Role role, Perm perm, Element.XMLElement req) throws Exception {
        String resultCode;
        String expectedCode;
        block7: {
            System.out.println(role.name() + ": " + req.getName());
            expectedCode = perm.getByRole(role);
            resultCode = null;
            try {
                switch (role) {
                    case R_USER: {
                        this.mSoapUser1.invoke(req);
                        break;
                    }
                    case R_USER_TARGET_SELF: {
                        this.mSoapUser1.invokeOnTargetAccount(req, this.ACCT_1_ID);
                        break;
                    }
                    case R_USER_TARGET_OTEHRUSER: {
                        this.mSoapUser1.invokeOnTargetAccount(req, this.ACCT_2_ID);
                        break;
                    }
                    default: {
                        TestAccess.fail();
                    }
                }
                resultCode = "OK";
            }
            catch (ServiceException e) {
                resultCode = e.getCode();
                if (expectedCode.equals(resultCode)) break block7;
                e.printStackTrace();
            }
        }
        TestAccess.assertEquals((String)expectedCode, (String)resultCode);
    }

    public void Auth(Role role, Perm perm) throws Exception {
        Element.XMLElement req = new Element.XMLElement(AccountConstants.AUTH_REQUEST);
        Element a = req.addElement("account");
        a.addAttribute("by", "name");
        a.setText(this.ACCT_2_EMAIL);
        req.addElement("password").setText(PASSWORD);
        this.accessTest(role, perm, req);
    }

    public void AutoCompleteGal(Role role, Perm perm) throws Exception {
        Element.XMLElement req = new Element.XMLElement(AccountConstants.AUTO_COMPLETE_GAL_REQUEST);
        req.addElement("name").setText("phoebe");
        req.addAttribute("type", "all");
        req.addAttribute("limit", "10");
        this.accessTest(role, perm, req);
    }

    public void ChangePassword(Role role, Perm perm) throws Exception {
        Element.XMLElement req = new Element.XMLElement(AccountConstants.CHANGE_PASSWORD_REQUEST);
        Element a = req.addElement("account");
        a.addAttribute("by", "name");
        a.setText(this.ACCT_1_EMAIL);
        req.addElement("oldPassword").setText(PASSWORD);
        req.addElement("password").setText(PASSWORD);
        this.accessTest(role, perm, req);
    }

    public void CreateDataSource(Role role, Perm perm) throws Exception {
        String dateSourceName = "datasource-create-" + this.random();
        Element.XMLElement req = new Element.XMLElement(MailConstants.CREATE_DATA_SOURCE_REQUEST);
        Element dataSource = req.addElement("pop3");
        dataSource.addAttribute("name", dateSourceName);
        dataSource.addAttribute("isEnabled", "true");
        dataSource.addAttribute("host", "pop3.google.com");
        dataSource.addAttribute("port", "8888");
        dataSource.addAttribute("username", "my-pop3-name");
        dataSource.addAttribute("password", "my-pop3-password");
        dataSource.addAttribute("l", "1");
        dataSource.addAttribute("connectionType", "ssl");
        this.accessTest(role, perm, req);
    }

    public void CreateIdentity(Role role, Perm perm) throws Exception {
        String identityName = "identity-create-" + this.random();
        Element.XMLElement req = new Element.XMLElement(AccountConstants.CREATE_IDENTITY_REQUEST);
        Element identity = req.addElement("identity");
        identity.addAttribute("name", identityName);
        this.accessTest(role, perm, req);
    }

    public void CreateSignature(Role role, Perm perm) throws Exception {
        String signatureName = "signature-create-" + this.random();
        Element.XMLElement req = new Element.XMLElement(AccountConstants.CREATE_SIGNATURE_REQUEST);
        Element signature = req.addElement("signature");
        signature.addAttribute("name", signatureName);
        this.accessTest(role, perm, req);
    }

    public void DeleteDataSource(Role role, Perm perm) throws Exception {
        String dateSourceName = "datasource-delete-" + this.random();
        DataSource ds = this.mProvAdmin.setup_createDataSource(this.ACCT_1_EMAIL, dateSourceName);
        Element.XMLElement req = new Element.XMLElement(MailConstants.DELETE_DATA_SOURCE_REQUEST);
        Element dataSource = req.addElement("pop3");
        dataSource.addAttribute("id", ds.getId());
        this.accessTest(role, perm, req);
    }

    public void DeleteIdentity(Role role, Perm perm) throws Exception {
        String identityName = "identity-delete-" + this.random();
        this.mProvAdmin.createIdentity(this.mProvAdmin.get(Provisioning.AccountBy.id, this.ACCT_1_ID), identityName, new HashMap<String, Object>());
        Element.XMLElement req = new Element.XMLElement(AccountConstants.DELETE_IDENTITY_REQUEST);
        Element identity = req.addElement("identity");
        identity.addAttribute("name", identityName);
        this.accessTest(role, perm, req);
    }

    public void DeleteSignature(Role role, Perm perm) throws Exception {
        String signatureName = "signature-delete-" + this.random();
        Signature signature = this.mProvAdmin.createSignature(this.mProvAdmin.get(Provisioning.AccountBy.id, this.ACCT_1_ID), signatureName, new HashMap<String, Object>());
        Element.XMLElement req = new Element.XMLElement(AccountConstants.DELETE_SIGNATURE_REQUEST);
        Element identity = req.addElement("signature");
        identity.addAttribute("id", signature.getId());
        this.accessTest(role, perm, req);
    }

    public void GetAccountInfo(Role role, Perm perm) throws Exception {
        Element.XMLElement req = new Element.XMLElement(AccountConstants.GET_ACCOUNT_INFO_REQUEST);
        Element a = req.addElement("account");
        a.addAttribute("by", "name");
        if (role == Role.R_USER || role == Role.R_USER_TARGET_SELF) {
            a.setText(this.ACCT_1_EMAIL);
        } else {
            a.setText(this.ACCT_2_EMAIL);
        }
        this.accessTest(role, perm, req);
    }

    public void GetAllLocales(Role role, Perm perm) throws Exception {
        Element.XMLElement req = new Element.XMLElement(AccountConstants.GET_ALL_LOCALES_REQUEST);
        this.accessTest(role, perm, req);
    }

    public void GetAvailableLocales(Role role, Perm perm) throws Exception {
        Element.XMLElement req = new Element.XMLElement(AccountConstants.GET_AVAILABLE_LOCALES_REQUEST);
        this.accessTest(role, perm, req);
    }

    public void GetAvailableSkins(Role role, Perm perm) throws Exception {
        Element.XMLElement req = new Element.XMLElement(AccountConstants.GET_AVAILABLE_SKINS_REQUEST);
        this.accessTest(role, perm, req);
    }

    public void GetDataSourcess(Role role, Perm perm) throws Exception {
        Element.XMLElement req = new Element.XMLElement(MailConstants.GET_DATA_SOURCES_REQUEST);
        this.accessTest(role, perm, req);
    }

    public void GetIdentities(Role role, Perm perm) throws Exception {
        Element.XMLElement req = new Element.XMLElement(AccountConstants.GET_IDENTITIES_REQUEST);
        this.accessTest(role, perm, req);
    }

    public void GetInfo(Role role, Perm perm) throws Exception {
        Element.XMLElement req = new Element.XMLElement(AccountConstants.GET_INFO_REQUEST);
        this.accessTest(role, perm, req);
    }

    public void GetPrefs(Role role, Perm perm) throws Exception {
        Element.XMLElement req = new Element.XMLElement(AccountConstants.GET_PREFS_REQUEST);
        this.accessTest(role, perm, req);
    }

    public void GetSignatures(Role role, Perm perm) throws Exception {
        Element.XMLElement req = new Element.XMLElement(AccountConstants.GET_SIGNATURES_REQUEST);
        this.accessTest(role, perm, req);
    }

    public void ModifyDataSource(Role role, Perm perm) throws Exception {
        String dateSourceName = "datasource-modify-" + this.random();
        DataSource ds = this.mProvAdmin.setup_createDataSource(this.ACCT_1_EMAIL, dateSourceName);
        Element.XMLElement req = new Element.XMLElement(MailConstants.MODIFY_DATA_SOURCE_REQUEST);
        Element dataSource = req.addElement("pop3");
        dataSource.addAttribute("id", ds.getId());
        dataSource.addAttribute("isEnabled", "false");
        this.accessTest(role, perm, req);
    }

    public void ModifyIdentity(Role role, Perm perm) throws Exception {
        String identityName = "identity-modify-" + this.random();
        this.mProvAdmin.createIdentity(this.mProvAdmin.get(Provisioning.AccountBy.id, this.ACCT_1_ID), identityName, new HashMap<String, Object>());
        Element.XMLElement req = new Element.XMLElement(AccountConstants.MODIFY_IDENTITY_REQUEST);
        Element identity = req.addElement("identity");
        identity.addAttribute("name", identityName);
        this.accessTest(role, perm, req);
    }

    public void ModifyPrefs(Role role, Perm perm) throws Exception {
        Element.XMLElement req = new Element.XMLElement(AccountConstants.MODIFY_PREFS_REQUEST);
        Element p = req.addElement("pref");
        p.addAttribute("name", "zimbraPrefSkin");
        p.setText("beach");
        this.accessTest(role, perm, req);
    }

    public void ModifyProperties(Role role, Perm perm) throws Exception {
        Element.XMLElement req = new Element.XMLElement(AccountConstants.MODIFY_PROPERTIES_REQUEST);
        this.accessTest(role, perm, req);
    }

    public void ModifySignature(Role role, Perm perm) throws Exception {
        String signatureName = "signature-modify-" + this.random();
        Signature signature = this.mProvAdmin.createSignature(this.mProvAdmin.get(Provisioning.AccountBy.id, this.ACCT_1_ID), signatureName, new HashMap<String, Object>());
        Element.XMLElement req = new Element.XMLElement(AccountConstants.MODIFY_SIGNATURE_REQUEST);
        Element identity = req.addElement("signature");
        identity.addAttribute("id", signature.getId());
        this.accessTest(role, perm, req);
    }

    public void SearchCalendarResources(Role role, Perm perm) throws Exception {
        Element.XMLElement req = new Element.XMLElement(AccountConstants.SEARCH_CALENDAR_RESOURCES_REQUEST);
        Element sf = req.addElement("searchFilter");
        Element cond = sf.addElement("cond");
        cond.addAttribute("attr", "zimbraCalResType");
        cond.addAttribute("op", "eq");
        cond.addAttribute("value", "Equipment");
        this.accessTest(role, perm, req);
    }

    public void SearchGal(Role role, Perm perm) throws Exception {
        Element.XMLElement req = new Element.XMLElement(AccountConstants.SEARCH_GAL_REQUEST);
        req.addElement("name").setText("phoebe");
        req.addAttribute("type", "all");
        this.accessTest(role, perm, req);
    }

    public void SyncGal(Role role, Perm perm) throws Exception {
        Element.XMLElement req = new Element.XMLElement(AccountConstants.SYNC_GAL_REQUEST);
        this.accessTest(role, perm, req);
    }

    public void TestDataSource(Role role, Perm perm) throws Exception {
        String dateSourceName = "datasource-test-" + this.random();
        DataSource ds = this.mProvAdmin.setup_createDataSource(this.ACCT_1_EMAIL, dateSourceName);
        Element.XMLElement req = new Element.XMLElement(MailConstants.TEST_DATA_SOURCE_REQUEST);
        Element dataSource = req.addElement("pop3");
        dataSource.addAttribute("id", ds.getId());
        this.accessTest(role, perm, req);
    }

    public void testAccess() throws Exception {
        for (Role role : Role.values()) {
            this.Auth(role, Perm.Perm_2);
            this.AutoCompleteGal(role, Perm.Perm_1);
            this.ChangePassword(role, Perm.Perm_2);
            this.CreateDataSource(role, Perm.Perm_1);
            this.CreateIdentity(role, Perm.Perm_1);
            this.CreateSignature(role, Perm.Perm_1);
            this.DeleteDataSource(role, Perm.Perm_1);
            this.DeleteIdentity(role, Perm.Perm_1);
            this.DeleteSignature(role, Perm.Perm_1);
            this.GetAccountInfo(role, Perm.Perm_2);
            this.GetAllLocales(role, Perm.Perm_2);
            this.GetAvailableLocales(role, Perm.Perm_1);
            this.GetAvailableSkins(role, Perm.Perm_1);
            this.GetDataSourcess(role, Perm.Perm_1);
            this.GetIdentities(role, Perm.Perm_1);
            this.GetInfo(role, Perm.Perm_1);
            this.GetPrefs(role, Perm.Perm_1);
            this.GetSignatures(role, Perm.Perm_1);
            this.ModifyDataSource(role, Perm.Perm_1);
            this.ModifyIdentity(role, Perm.Perm_1);
            this.ModifyPrefs(role, Perm.Perm_1);
            this.ModifyProperties(role, Perm.Perm_1);
            this.ModifySignature(role, Perm.Perm_1);
            this.SearchCalendarResources(role, Perm.Perm_1);
            this.SearchGal(role, Perm.Perm_1);
            this.SyncGal(role, Perm.Perm_1);
            this.TestDataSource(role, Perm.Perm_1);
        }
        System.out.println("\nTest " + this.TEST_ID + " done, all is well\n");
    }

    public static void main(String[] args) throws Exception {
        TestUtil.cliSetup();
        TestUtil.runTest(TestAccess.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Role {
        R_USER,
        R_USER_TARGET_SELF,
        R_USER_TARGET_OTEHRUSER;

    }

    private static class Perm {
        static final String OK = "OK";
        static final Perm Perm_1 = new Perm("OK", "OK", "service.PERM_DENIED");
        static final Perm Perm_2 = new Perm("OK", "OK", "OK");
        String[] mPerms = new String[Role.values().length];

        Perm(String user, String userTargetSelf, String userTargetOtherUser) {
            this.mPerms[Role.R_USER.ordinal()] = user;
            this.mPerms[Role.R_USER_TARGET_SELF.ordinal()] = userTargetSelf;
            this.mPerms[Role.R_USER_TARGET_OTEHRUSER.ordinal()] = userTargetOtherUser;
        }

        String getByRole(Role role) {
            return this.mPerms[role.ordinal()];
        }
    }

    private static class SoapAdminUser
    extends SoapUser {
        SoapAdminUser(String name) {
            super(name, null);
        }

        void setURL() {
            this.soapSetURI(TestUtil.getAdminSoapUrl());
        }

        void auth() throws ServiceException {
            this.soapAdminAuthenticate(this.mName, PASSWORD);
        }

        DataSource setup_createDataSource(String acctName, String dataSourceName) {
            DataSource dataSource = null;
            try {
                HashMap<String, Object> attrs = new HashMap<String, Object>();
                attrs.put("zimbraDataSourceEnabled", "TRUE");
                attrs.put("zimbraDataSourceConnectionType", "ssl");
                attrs.put("zimbraDataSourceFolderId", "1");
                attrs.put("zimbraDataSourceHost", "pop3.google.com");
                attrs.put("zimbraDataSourcePassword", "my-pop3-password");
                attrs.put("zimbraDataSourcePort", "8888");
                attrs.put("zimbraDataSourceUsername", "my-pop3-name");
                attrs.put("zimbraDataSourceLeaveOnServer", "TRUE");
                dataSource = this.createDataSource(this.get(Provisioning.AccountBy.name, acctName), DataSource.Type.pop3, dataSourceName, attrs);
            }
            catch (ServiceException e) {
                e.printStackTrace();
                Assert.fail();
            }
            return dataSource;
        }
    }

    private static class SoapUser
    extends SoapProvisioning {
        String mName;
        String mId;

        SoapUser(String name, String id) {
            this.mName = name;
            this.mId = id;
            this.setURL();
        }

        void setURL() {
            this.soapSetURI(TestUtil.getSoapUrl());
        }

        void auth() throws ServiceException {
            Element.XMLElement req = new Element.XMLElement(AccountConstants.AUTH_REQUEST);
            Element a = req.addElement("account");
            a.addAttribute("by", "name");
            a.setText(this.mName);
            req.addElement("password").setText(PASSWORD);
            Element response = this.invoke(req);
            String authToken = response.getElement("authToken").getText();
            this.setAuthToken(new ZAuthToken(authToken));
        }

        protected Element invokeOnTargetAccount(Element request, String targetId) throws ServiceException {
            return super.invokeOnTargetAccount(request, targetId);
        }
    }
}

