/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.qa.unittest;

import com.zimbra.common.util.CliUtil;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.CalendarResource;
import com.zimbra.cs.account.Config;
import com.zimbra.cs.account.Cos;
import com.zimbra.cs.account.DistributionList;
import com.zimbra.cs.account.Domain;
import com.zimbra.cs.account.Entry;
import com.zimbra.cs.account.GlobalGrant;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.Server;
import com.zimbra.cs.account.Zimlet;
import com.zimbra.cs.account.accesscontrol.GranteeType;
import com.zimbra.cs.account.accesscontrol.Right;
import com.zimbra.cs.account.accesscontrol.TargetType;
import com.zimbra.qa.unittest.TestACL;
import com.zimbra.qa.unittest.TestUtil;
import java.util.HashMap;
import java.util.List;

public class TestACLTarget
extends TestACL {
    public void testTargetAccount() throws Exception {
        String testName = this.getName();
        Account authedAcct = this.getSystemAdminAccount(TestACLTarget.getEmailAddr(testName, "authed"));
        Account grantee = this.createAdminAccount(TestACLTarget.getEmailAddr(testName, "grantee"));
        Right right = ADMIN_RIGHT_ACCOUNT;
        Account target = mProv.createAccount(TestACLTarget.getEmailAddr(testName, "target"), "test123", null);
        this.grantRight(authedAcct, TargetType.account, target, GranteeType.GT_USER, grantee, right, ALLOW);
        TestACL.TestViaGrant via = new TestACL.TestViaGrant(TargetType.account, target, GranteeType.GT_USER, grantee.getName(), right, false);
        this.verify(grantee, (Entry)target, right, ALLOW, via);
        this.revokeRight(authedAcct, TargetType.account, target, GranteeType.GT_USER, grantee, right, ALLOW);
        DistributionList group1 = mProv.createDistributionList(TestACLTarget.getEmailAddr(testName, "group1"), new HashMap<String, Object>());
        DistributionList group2 = mProv.createDistributionList(TestACLTarget.getEmailAddr(testName, "group2"), new HashMap<String, Object>());
        mProv.addMembers(group1, new String[]{group2.getName()});
        mProv.addMembers(group2, new String[]{target.getName()});
        this.grantRight(authedAcct, TargetType.dl, group1, GranteeType.GT_USER, grantee, right, ALLOW);
        via = new TestACL.TestViaGrant(TargetType.dl, group1, GranteeType.GT_USER, grantee.getName(), right, false);
        this.verify(grantee, (Entry)target, right, ALLOW, via);
        this.revokeRight(authedAcct, TargetType.dl, group1, GranteeType.GT_USER, grantee, right, ALLOW);
        Domain domain = mProv.getDomain(target);
        this.grantRight(authedAcct, TargetType.domain, domain, GranteeType.GT_USER, grantee, right, ALLOW);
        via = new TestACL.TestViaGrant(TargetType.domain, domain, GranteeType.GT_USER, grantee.getName(), right, false);
        this.verify(grantee, (Entry)target, right, ALLOW, via);
        this.revokeRight(authedAcct, TargetType.domain, domain, GranteeType.GT_USER, grantee, right, ALLOW);
        GlobalGrant globalGrant = mProv.getGlobalGrant();
        this.grantRight(authedAcct, TargetType.global, null, GranteeType.GT_USER, grantee, right, ALLOW);
        via = new TestACL.TestViaGrant(TargetType.global, globalGrant, GranteeType.GT_USER, grantee.getName(), right, false);
        this.verify(grantee, (Entry)target, right, ALLOW, via);
        this.revokeRight(authedAcct, TargetType.global, null, GranteeType.GT_USER, grantee, right, ALLOW);
    }

    public void testTargetCalendarResource() throws Exception {
        String testName = this.getName();
        Account authedAcct = this.getSystemAdminAccount(TestACLTarget.getEmailAddr(testName, "authed"));
        Account grantee = this.createAdminAccount(TestACLTarget.getEmailAddr(testName, "grantee"));
        Right right = ADMIN_RIGHT_CALENDAR_RESOURCE;
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        attrs.put("displayName", "foo");
        attrs.put("zimbraCalResType", "Equipment");
        CalendarResource target = mProv.createCalendarResource(TestACLTarget.getEmailAddr(testName, "target"), "test123", attrs);
        this.grantRight(authedAcct, TargetType.calresource, target, GranteeType.GT_USER, grantee, right, ALLOW);
        TestACL.TestViaGrant via = new TestACL.TestViaGrant(TargetType.calresource, target, GranteeType.GT_USER, grantee.getName(), right, false);
        this.verify(grantee, (Entry)target, right, ALLOW, via);
        this.revokeRight(authedAcct, TargetType.calresource, target, GranteeType.GT_USER, grantee, right, ALLOW);
        DistributionList group1 = mProv.createDistributionList(TestACLTarget.getEmailAddr(testName, "group1"), new HashMap<String, Object>());
        DistributionList group2 = mProv.createDistributionList(TestACLTarget.getEmailAddr(testName, "group2"), new HashMap<String, Object>());
        mProv.addMembers(group1, new String[]{group2.getName()});
        mProv.addMembers(group2, new String[]{target.getName()});
        this.grantRight(authedAcct, TargetType.dl, group1, GranteeType.GT_USER, grantee, right, ALLOW);
        via = new TestACL.TestViaGrant(TargetType.dl, group1, GranteeType.GT_USER, grantee.getName(), right, false);
        this.verify(grantee, (Entry)target, right, ALLOW, via);
        this.revokeRight(authedAcct, TargetType.dl, group1, GranteeType.GT_USER, grantee, right, ALLOW);
        Domain domain = mProv.getDomain(target);
        this.grantRight(authedAcct, TargetType.domain, domain, GranteeType.GT_USER, grantee, right, ALLOW);
        via = new TestACL.TestViaGrant(TargetType.domain, domain, GranteeType.GT_USER, grantee.getName(), right, false);
        this.verify(grantee, (Entry)target, right, ALLOW, via);
        this.revokeRight(authedAcct, TargetType.domain, domain, GranteeType.GT_USER, grantee, right, ALLOW);
        GlobalGrant globalGrant = mProv.getGlobalGrant();
        this.grantRight(authedAcct, TargetType.global, null, GranteeType.GT_USER, grantee, right, ALLOW);
        via = new TestACL.TestViaGrant(TargetType.global, globalGrant, GranteeType.GT_USER, grantee.getName(), right, false);
        this.verify(grantee, (Entry)target, right, ALLOW, via);
        this.revokeRight(authedAcct, TargetType.global, null, GranteeType.GT_USER, grantee, right, ALLOW);
    }

    public void testTargetGroup() throws Exception {
        String testName = this.getName();
        Account authedAcct = this.getSystemAdminAccount(TestACLTarget.getEmailAddr(testName, "authed"));
        Account grantee = this.createAdminAccount(TestACLTarget.getEmailAddr(testName, "grantee"));
        Right right = ADMIN_RIGHT_DISTRIBUTION_LIST;
        DistributionList target = mProv.createDistributionList(TestACLTarget.getEmailAddr(testName, "target"), new HashMap<String, Object>());
        this.grantRight(authedAcct, TargetType.dl, target, GranteeType.GT_USER, grantee, right, ALLOW);
        TestACL.TestViaGrant via = new TestACL.TestViaGrant(TargetType.dl, target, GranteeType.GT_USER, grantee.getName(), right, false);
        this.verify(grantee, (Entry)target, right, ALLOW, via);
        this.revokeRight(authedAcct, TargetType.dl, target, GranteeType.GT_USER, grantee, right, ALLOW);
        DistributionList group1 = mProv.createDistributionList(TestACLTarget.getEmailAddr(testName, "group1"), new HashMap<String, Object>());
        DistributionList group2 = mProv.createDistributionList(TestACLTarget.getEmailAddr(testName, "group2"), new HashMap<String, Object>());
        mProv.addMembers(group1, new String[]{group2.getName()});
        mProv.addMembers(group2, new String[]{target.getName()});
        this.grantRight(authedAcct, TargetType.dl, group1, GranteeType.GT_USER, grantee, right, ALLOW);
        via = new TestACL.TestViaGrant(TargetType.dl, group1, GranteeType.GT_USER, grantee.getName(), right, false);
        this.verify(grantee, (Entry)target, right, ALLOW, via);
        this.revokeRight(authedAcct, TargetType.dl, group1, GranteeType.GT_USER, grantee, right, ALLOW);
        Domain domain = mProv.getDomain(target);
        this.grantRight(authedAcct, TargetType.domain, domain, GranteeType.GT_USER, grantee, right, ALLOW);
        via = new TestACL.TestViaGrant(TargetType.domain, domain, GranteeType.GT_USER, grantee.getName(), right, false);
        this.verify(grantee, (Entry)target, right, ALLOW, via);
        this.revokeRight(authedAcct, TargetType.domain, domain, GranteeType.GT_USER, grantee, right, ALLOW);
        GlobalGrant globalGrant = mProv.getGlobalGrant();
        this.grantRight(authedAcct, TargetType.global, null, GranteeType.GT_USER, grantee, right, ALLOW);
        via = new TestACL.TestViaGrant(TargetType.global, globalGrant, GranteeType.GT_USER, grantee.getName(), right, false);
        this.verify(grantee, (Entry)target, right, ALLOW, via);
        this.revokeRight(authedAcct, TargetType.global, null, GranteeType.GT_USER, grantee, right, ALLOW);
    }

    public void testTargetDomain() throws Exception {
        String testName = this.getName();
        Account authedAcct = this.getSystemAdminAccount(TestACLTarget.getEmailAddr(testName, "authed"));
        Account grantee = this.createAdminAccount(TestACLTarget.getEmailAddr(testName, "grantee"));
        Right right = ADMIN_RIGHT_DOMAIN;
        Domain target = mProv.get(Provisioning.DomainBy.name, DOMAIN_NAME);
        this.grantRight(authedAcct, TargetType.domain, target, GranteeType.GT_USER, grantee, right, ALLOW);
        TestACL.TestViaGrant via = new TestACL.TestViaGrant(TargetType.domain, target, GranteeType.GT_USER, grantee.getName(), right, false);
        this.verify(grantee, (Entry)target, right, ALLOW, via);
        this.revokeRight(authedAcct, TargetType.domain, target, GranteeType.GT_USER, grantee, right, ALLOW);
        GlobalGrant globalGrant = mProv.getGlobalGrant();
        this.grantRight(authedAcct, TargetType.global, null, GranteeType.GT_USER, grantee, right, ALLOW);
        via = new TestACL.TestViaGrant(TargetType.global, globalGrant, GranteeType.GT_USER, grantee.getName(), right, false);
        this.verify(grantee, (Entry)target, right, ALLOW, via);
        this.revokeRight(authedAcct, TargetType.global, null, GranteeType.GT_USER, grantee, right, ALLOW);
    }

    public void testTargetCos() throws Exception {
        String testName = this.getName();
        Account authedAcct = this.getSystemAdminAccount(TestACLTarget.getEmailAddr(testName, "authed"));
        Account grantee = this.createAdminAccount(TestACLTarget.getEmailAddr(testName, "grantee"));
        Right right = ADMIN_RIGHT_COS;
        Cos target = mProv.get(Provisioning.CosBy.name, "default");
        this.grantRight(authedAcct, TargetType.cos, target, GranteeType.GT_USER, grantee, right, ALLOW);
        TestACL.TestViaGrant via = new TestACL.TestViaGrant(TargetType.cos, target, GranteeType.GT_USER, grantee.getName(), right, false);
        this.verify(grantee, (Entry)target, right, ALLOW, via);
        this.revokeRight(authedAcct, TargetType.cos, target, GranteeType.GT_USER, grantee, right, ALLOW);
        GlobalGrant globalGrant = mProv.getGlobalGrant();
        this.grantRight(authedAcct, TargetType.global, null, GranteeType.GT_USER, grantee, right, ALLOW);
        via = new TestACL.TestViaGrant(TargetType.global, globalGrant, GranteeType.GT_USER, grantee.getName(), right, false);
        this.verify(grantee, (Entry)target, right, ALLOW, via);
        this.revokeRight(authedAcct, TargetType.global, null, GranteeType.GT_USER, grantee, right, ALLOW);
    }

    public void testTargetServer() throws Exception {
        String testName = this.getName();
        Account authedAcct = this.getSystemAdminAccount(TestACLTarget.getEmailAddr(testName, "authed"));
        Account grantee = this.createAdminAccount(TestACLTarget.getEmailAddr(testName, "grantee"));
        Right right = ADMIN_RIGHT_SERVER;
        Server target = mProv.getLocalServer();
        this.grantRight(authedAcct, TargetType.server, target, GranteeType.GT_USER, grantee, right, ALLOW);
        TestACL.TestViaGrant via = new TestACL.TestViaGrant(TargetType.server, target, GranteeType.GT_USER, grantee.getName(), right, false);
        this.verify(grantee, (Entry)target, right, ALLOW, via);
        this.revokeRight(authedAcct, TargetType.server, target, GranteeType.GT_USER, grantee, right, ALLOW);
        GlobalGrant globalGrant = mProv.getGlobalGrant();
        this.grantRight(authedAcct, TargetType.global, null, GranteeType.GT_USER, grantee, right, ALLOW);
        via = new TestACL.TestViaGrant(TargetType.global, globalGrant, GranteeType.GT_USER, grantee.getName(), right, false);
        this.verify(grantee, (Entry)target, right, ALLOW, via);
        this.revokeRight(authedAcct, TargetType.global, null, GranteeType.GT_USER, grantee, right, ALLOW);
    }

    public void testTargetZimlet() throws Exception {
        String testName = this.getName();
        Account authedAcct = this.getSystemAdminAccount(TestACLTarget.getEmailAddr(testName, "authed"));
        Account grantee = this.createAdminAccount(TestACLTarget.getEmailAddr(testName, "grantee"));
        Right right = ADMIN_RIGHT_ZIMLET;
        Zimlet target = mProv.getZimlet("com_zimbra_date");
        this.grantRight(authedAcct, TargetType.zimlet, target, GranteeType.GT_USER, grantee, right, ALLOW);
        TestACL.TestViaGrant via = new TestACL.TestViaGrant(TargetType.zimlet, target, GranteeType.GT_USER, grantee.getName(), right, false);
        this.verify(grantee, (Entry)target, right, ALLOW, via);
        this.revokeRight(authedAcct, TargetType.zimlet, target, GranteeType.GT_USER, grantee, right, ALLOW);
        GlobalGrant globalGrant = mProv.getGlobalGrant();
        this.grantRight(authedAcct, TargetType.global, null, GranteeType.GT_USER, grantee, right, ALLOW);
        via = new TestACL.TestViaGrant(TargetType.global, globalGrant, GranteeType.GT_USER, grantee.getName(), right, false);
        this.verify(grantee, (Entry)target, right, ALLOW, via);
        this.revokeRight(authedAcct, TargetType.global, null, GranteeType.GT_USER, grantee, right, ALLOW);
    }

    public void testTargetConfig() throws Exception {
        String testName = this.getName();
        Account authedAcct = this.getSystemAdminAccount(TestACLTarget.getEmailAddr(testName, "authed"));
        Account grantee = this.createAdminAccount(TestACLTarget.getEmailAddr(testName, "grantee"));
        Right right = ADMIN_RIGHT_CONFIG;
        Config target = mProv.getConfig();
        this.grantRight(authedAcct, TargetType.config, null, GranteeType.GT_USER, grantee, right, ALLOW);
        TestACL.TestViaGrant via = new TestACL.TestViaGrant(TargetType.config, target, GranteeType.GT_USER, grantee.getName(), right, false);
        this.verify(grantee, (Entry)target, right, ALLOW, via);
        this.revokeRight(authedAcct, TargetType.config, null, GranteeType.GT_USER, grantee, right, ALLOW);
        GlobalGrant globalGrant = mProv.getGlobalGrant();
        this.grantRight(authedAcct, TargetType.global, null, GranteeType.GT_USER, grantee, right, ALLOW);
        via = new TestACL.TestViaGrant(TargetType.global, globalGrant, GranteeType.GT_USER, grantee.getName(), right, false);
        this.verify(grantee, (Entry)target, right, ALLOW, via);
        this.revokeRight(authedAcct, TargetType.global, null, GranteeType.GT_USER, grantee, right, ALLOW);
    }

    public void testTargetGlobalGrant() throws Exception {
        String testName = this.getName();
        Account authedAcct = this.getSystemAdminAccount(TestACLTarget.getEmailAddr(testName, "authed"));
        Account grantee = this.createAdminAccount(TestACLTarget.getEmailAddr(testName, "grantee"));
        Right right = ADMIN_RIGHT_GLOBALGRANT;
        GlobalGrant target = mProv.getGlobalGrant();
        this.grantRight(authedAcct, TargetType.global, null, GranteeType.GT_USER, grantee, right, ALLOW);
        TestACL.TestViaGrant via = new TestACL.TestViaGrant(TargetType.global, target, GranteeType.GT_USER, grantee.getName(), right, false);
        this.verify(grantee, (Entry)target, right, ALLOW, via);
        this.revokeRight(authedAcct, TargetType.global, null, GranteeType.GT_USER, grantee, right, ALLOW);
    }

    public void testTargetPrecedence() throws Exception {
        String testName = this.getName();
        Account authedAcct = this.getSystemAdminAccount(TestACLTarget.getEmailAddr(testName, "authed"));
        Account grantee = this.createAdminAccount(TestACLTarget.getEmailAddr(testName, "grantee"));
        Right right = ADMIN_RIGHT_ACCOUNT;
        Account target = mProv.createAccount(TestACLTarget.getEmailAddr(testName, "target"), "test123", null);
        this.grantRight(authedAcct, TargetType.account, target, GranteeType.GT_USER, grantee, right, ALLOW);
        DistributionList group1 = mProv.createDistributionList(TestACLTarget.getEmailAddr(testName, "group1"), new HashMap<String, Object>());
        DistributionList group2 = mProv.createDistributionList(TestACLTarget.getEmailAddr(testName, "group2"), new HashMap<String, Object>());
        mProv.addMembers(group1, new String[]{group2.getName()});
        mProv.addMembers(group2, new String[]{target.getName()});
        this.grantRight(authedAcct, TargetType.dl, group2, GranteeType.GT_USER, grantee, right, DENY);
        this.grantRight(authedAcct, TargetType.dl, group1, GranteeType.GT_USER, grantee, right, ALLOW);
        Domain domain = mProv.getDomain(target);
        this.grantRight(authedAcct, TargetType.domain, domain, GranteeType.GT_USER, grantee, right, DENY);
        GlobalGrant globalGrant = mProv.getGlobalGrant();
        this.grantRight(authedAcct, TargetType.global, null, GranteeType.GT_USER, grantee, right, ALLOW);
        TestACL.TestViaGrant via = new TestACL.TestViaGrant(TargetType.account, target, GranteeType.GT_USER, grantee.getName(), right, false);
        this.verify(grantee, (Entry)target, right, ALLOW, via);
        this.revokeRight(authedAcct, TargetType.account, target, GranteeType.GT_USER, grantee, right, ALLOW);
        via = new TestACL.TestViaGrant(TargetType.dl, group2, GranteeType.GT_USER, grantee.getName(), right, true);
        this.verify(grantee, (Entry)target, right, DENY, via);
        this.revokeRight(authedAcct, TargetType.dl, group2, GranteeType.GT_USER, grantee, right, DENY);
        via = new TestACL.TestViaGrant(TargetType.dl, group1, GranteeType.GT_USER, grantee.getName(), right, false);
        this.verify(grantee, (Entry)target, right, ALLOW, via);
        this.revokeRight(authedAcct, TargetType.dl, group1, GranteeType.GT_USER, grantee, right, ALLOW);
        via = new TestACL.TestViaGrant(TargetType.domain, domain, GranteeType.GT_USER, grantee.getName(), right, true);
        this.verify(grantee, (Entry)target, right, DENY, via);
        this.revokeRight(authedAcct, TargetType.domain, domain, GranteeType.GT_USER, grantee, right, DENY);
        via = new TestACL.TestViaGrant(TargetType.global, globalGrant, GranteeType.GT_USER, grantee.getName(), right, false);
        this.verify(grantee, (Entry)target, right, ALLOW, via);
        this.revokeRight(authedAcct, TargetType.global, null, GranteeType.GT_USER, grantee, right, ALLOW);
        this.verifyDefault(grantee, target, right);
    }

    public void testGroupExpansion() throws Exception {
        String testName = this.getName();
        Account acct = mProv.createAccount(TestACLTarget.getEmailAddr(testName, "account"), "test123", null);
        DistributionList A = mProv.createDistributionList(TestACLTarget.getEmailAddr(testName, "A"), new HashMap<String, Object>());
        DistributionList B = mProv.createDistributionList(TestACLTarget.getEmailAddr(testName, "B"), new HashMap<String, Object>());
        DistributionList C = mProv.createDistributionList(TestACLTarget.getEmailAddr(testName, "C"), new HashMap<String, Object>());
        DistributionList D = mProv.createDistributionList(TestACLTarget.getEmailAddr(testName, "D"), new HashMap<String, Object>());
        DistributionList E = mProv.createDistributionList(TestACLTarget.getEmailAddr(testName, "E"), new HashMap<String, Object>());
        DistributionList F = mProv.createDistributionList(TestACLTarget.getEmailAddr(testName, "F"), new HashMap<String, Object>());
        DistributionList G = mProv.createDistributionList(TestACLTarget.getEmailAddr(testName, "G"), new HashMap<String, Object>());
        DistributionList H2 = mProv.createDistributionList(TestACLTarget.getEmailAddr(testName, "H"), new HashMap<String, Object>());
        mProv.addMembers(A, new String[]{acct.getName()});
        mProv.addMembers(B, new String[]{acct.getName()});
        mProv.addMembers(C, new String[]{A.getName()});
        mProv.addMembers(D, new String[]{acct.getName(), B.getName()});
        mProv.addMembers(E, new String[]{acct.getName(), D.getName()});
        mProv.addMembers(F, new String[]{D.getName()});
        mProv.addMembers(G, new String[]{E.getName()});
        mProv.addMembers(H2, new String[]{F.getName()});
        HashMap<String, String> via = new HashMap<String, String>();
        List<DistributionList> dls = mProv.getDistributionLists(acct, false, via);
        for (DistributionList dl : dls) {
            String dlName;
            int dist = 0;
            String viaName = dlName = dl.getName();
            do {
                viaName = (String)via.get(viaName);
                ++dist;
            } while (viaName != null);
            if (dlName.equals(A.getName())) {
                TestACLTarget.assertEquals((int)1, (int)dist);
                continue;
            }
            if (dlName.equals(B.getName())) {
                TestACLTarget.assertEquals((int)1, (int)dist);
                continue;
            }
            if (dlName.equals(C.getName())) {
                TestACLTarget.assertEquals((int)2, (int)dist);
                continue;
            }
            if (dlName.equals(D.getName())) {
                TestACLTarget.assertEquals((int)1, (int)dist);
                continue;
            }
            if (dlName.equals(E.getName())) {
                TestACLTarget.assertEquals((int)1, (int)dist);
                continue;
            }
            if (dlName.equals(F.getName())) {
                TestACLTarget.assertEquals((int)2, (int)dist);
                continue;
            }
            if (dlName.equals(G.getName())) {
                TestACLTarget.assertEquals((int)2, (int)dist);
                continue;
            }
            if (!dlName.equals(H2.getName())) continue;
            TestACLTarget.assertEquals((int)3, (int)dist);
        }
    }

    public static void main(String[] args) throws Exception {
        CliUtil.toolSetup("INFO");
        TestUtil.runTest(TestACLTarget.class);
    }
}

