/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.qa.unittest;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.CliUtil;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.Cos;
import com.zimbra.cs.account.Domain;
import com.zimbra.cs.account.Entry;
import com.zimbra.cs.account.accesscontrol.AllowedAttrs;
import com.zimbra.cs.account.accesscontrol.GranteeType;
import com.zimbra.cs.account.accesscontrol.Right;
import com.zimbra.cs.account.accesscontrol.RightManager;
import com.zimbra.cs.account.accesscontrol.TargetType;
import com.zimbra.qa.unittest.TestACL;
import com.zimbra.qa.unittest.TestUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class TestACLRight
extends TestACL {
    private static Map<String, Object> ATTRS_IN_SET_SOME_ATTRS_RIGHT;
    private static Map<String, Object> ATTRS_IN_SET_SOME_ATTRS_RIGHT_VIOLATE_CONSTRAINT;
    private static Map<String, Object> ATTRS_NOT_IN_SET_SOME_ATTRS_RIGHT;
    private static Right GET_SOME_ATTRS_RIGHT;
    private static Right SET_SOME_ATTRS_RIGHT;
    private static Right GET_ALL_ATTRS_RIGHT;
    private static Right SET_ALL_ATTRS_RIGHT;
    private static Right CONFIGURE_CONSTRAINT_RIGHT;
    private static Right PRESET_RIGHT;
    private static Right COMBO_RIGHT;
    static int zimbraMailQuota_constraint_max;

    public void testGetSomeAttrs() throws Exception {
        String testName = this.getTestName();
        Account authedAcct = this.getSystemAdminAccount(TestACLRight.getEmailAddr(testName, "authed"));
        Account GA = this.createAdminAccount(TestACLRight.getEmailAddr(testName, "GA"));
        Right right = GET_SOME_ATTRS_RIGHT;
        Account TA = mProv.createAccount(TestACLRight.getEmailAddr(testName, "TA"), "test123", null);
        this.grantRight(authedAcct, TargetType.account, TA, GranteeType.GT_USER, GA, right, ALLOW);
        this.verify(GA, (Entry)TA, GET_SOME_ATTRS_RIGHT, null, ALLOW);
        this.verify(GA, (Entry)TA, GET_ALL_ATTRS_RIGHT, null, DENY);
    }

    public void testGetAllAttrs() throws Exception {
        String testName = this.getTestName();
        Account authedAcct = this.getSystemAdminAccount(TestACLRight.getEmailAddr(testName, "authed"));
        Account GA = this.createAdminAccount(TestACLRight.getEmailAddr(testName, "GA"));
        Right right = SET_SOME_ATTRS_RIGHT;
        Account TA = mProv.createAccount(TestACLRight.getEmailAddr(testName, "TA"), "test123", null);
        this.grantRight(authedAcct, TargetType.account, TA, GranteeType.GT_USER, GA, right, ALLOW);
        this.verify(GA, (Entry)TA, GET_SOME_ATTRS_RIGHT, null, ALLOW);
        this.verify(GA, (Entry)TA, GET_ALL_ATTRS_RIGHT, null, DENY);
    }

    public void testSetSomeAttrs() throws Exception {
        String testName = this.getTestName();
        Account authedAcct = this.getSystemAdminAccount(TestACLRight.getEmailAddr(testName, "authed"));
        Account GA = this.createAdminAccount(TestACLRight.getEmailAddr(testName, "GA"));
        Right right = SET_SOME_ATTRS_RIGHT;
        Account TA = mProv.createAccount(TestACLRight.getEmailAddr(testName, "TA"), "test123", null);
        this.grantRight(authedAcct, TargetType.account, TA, GranteeType.GT_USER, GA, right, ALLOW);
        Cos cos = mProv.getCOS(TA);
        cos.unsetConstraint();
        HashMap<String, Object> cosConstraints = new HashMap<String, Object>();
        cos.addConstraint("zimbraMailQuota:max=" + zimbraMailQuota_constraint_max, cosConstraints);
        mProv.modifyAttrs(cos, cosConstraints);
        this.verify(GA, (Entry)TA, SET_SOME_ATTRS_RIGHT, ATTRS_IN_SET_SOME_ATTRS_RIGHT, ALLOW);
        this.verify(GA, (Entry)TA, SET_SOME_ATTRS_RIGHT, null, ALLOW);
        this.verify(GA, (Entry)TA, SET_SOME_ATTRS_RIGHT, ATTRS_NOT_IN_SET_SOME_ATTRS_RIGHT, DENY);
        this.verify(GA, (Entry)TA, SET_SOME_ATTRS_RIGHT, ATTRS_IN_SET_SOME_ATTRS_RIGHT_VIOLATE_CONSTRAINT, DENY);
        this.verify(GA, (Entry)TA, GET_SOME_ATTRS_RIGHT, null, ALLOW);
        this.verify(GA, (Entry)TA, GET_ALL_ATTRS_RIGHT, null, DENY);
        this.grantRight(authedAcct, TargetType.cos, cos, GranteeType.GT_USER, GA, CONFIGURE_CONSTRAINT_RIGHT, ALLOW);
        this.verify(GA, (Entry)TA, SET_SOME_ATTRS_RIGHT, ATTRS_IN_SET_SOME_ATTRS_RIGHT_VIOLATE_CONSTRAINT, ALLOW);
    }

    public void testSetAllAttrs() throws Exception {
        String testName = this.getTestName();
        Account authedAcct = this.getSystemAdminAccount(TestACLRight.getEmailAddr(testName, "authed"));
        Account GA = this.createAdminAccount(TestACLRight.getEmailAddr(testName, "GA"));
        Right right = SET_ALL_ATTRS_RIGHT;
        Account TA = mProv.createAccount(TestACLRight.getEmailAddr(testName, "TA"), "test123", null);
        this.grantRight(authedAcct, TargetType.account, TA, GranteeType.GT_USER, GA, right, ALLOW);
        Cos cos = mProv.getCOS(TA);
        cos.unsetConstraint();
        HashMap<String, Object> cosConstraints = new HashMap<String, Object>();
        cos.addConstraint("zimbraMailQuota:max=" + zimbraMailQuota_constraint_max, cosConstraints);
        mProv.modifyAttrs(cos, cosConstraints);
        this.verify(GA, (Entry)TA, SET_ALL_ATTRS_RIGHT, ATTRS_IN_SET_SOME_ATTRS_RIGHT, ALLOW);
        this.verify(GA, (Entry)TA, SET_ALL_ATTRS_RIGHT, null, ALLOW);
        this.verify(GA, (Entry)TA, SET_ALL_ATTRS_RIGHT, ATTRS_NOT_IN_SET_SOME_ATTRS_RIGHT, ALLOW);
        this.verify(GA, (Entry)TA, SET_ALL_ATTRS_RIGHT, ATTRS_IN_SET_SOME_ATTRS_RIGHT_VIOLATE_CONSTRAINT, DENY);
        this.verify(GA, (Entry)TA, GET_SOME_ATTRS_RIGHT, null, ALLOW);
        this.verify(GA, (Entry)TA, GET_ALL_ATTRS_RIGHT, null, ALLOW);
    }

    public void testCheckComboRight() throws Exception {
        String testName = this.getTestName();
        Account authedAcct = this.getSystemAdminAccount(TestACLRight.getEmailAddr(testName, "authed"));
        Account GA = this.createAdminAccount(TestACLRight.getEmailAddr(testName, "GA"));
        Right right = TestACLRight.getRight("test-combo-account-domain");
        String domainName = TestACLRight.getSubDomainName(testName);
        Domain TD = mProv.createDomain(domainName, new HashMap<String, Object>());
        this.grantRight(authedAcct, TargetType.domain, TD, GranteeType.GT_USER, GA, right, ALLOW);
        Account TA = mProv.createAccount("user1@" + domainName, "test123", null);
        TestACL.TestViaGrant via = new TestACL.TestViaGrant(TargetType.account, TD, GranteeType.GT_USER, GA.getName(), right, false);
        this.verify(GA, (Entry)TD, TestACLRight.getRight("test-preset-account"), null, DENY);
        this.verify(GA, (Entry)TA, TestACLRight.getRight("test-preset-account"), null, ALLOW);
        this.verify(GA, (Entry)TD, TestACLRight.getRight("test-preset-domain"), null, ALLOW);
        this.verify(GA, (Entry)TA, TestACLRight.getRight("test-preset-domain"), null, DENY);
        this.verify(GA, (Entry)TD, TestACLRight.getRight("test-preset-cos"), null, DENY);
        this.verify(GA, (Entry)TD, TestACLRight.getRight("test-setAttrs-account"), null, DENY);
        this.verify(GA, (Entry)TA, TestACLRight.getRight("test-setAttrs-account"), null, ALLOW);
        this.verify(GA, (Entry)TD, TestACLRight.getRight("test-setAttrs-distributionlist"), null, DENY);
        this.verify(GA, (Entry)TA, TestACLRight.getRight("test-setAttrs-distributionlist"), null, DENY);
        this.verify(GA, (Entry)TD, TestACLRight.getRight("test-setAttrs-domain"), null, ALLOW);
        this.verify(GA, (Entry)TA, TestACLRight.getRight("test-setAttrs-domain"), null, DENY);
        this.verify(GA, (Entry)TD, TestACLRight.getRight("test-setAttrs-accountDomain"), null, ALLOW);
        this.verify(GA, (Entry)TA, TestACLRight.getRight("test-setAttrs-accountDomain"), null, ALLOW);
        this.verify(GA, (Entry)TD, TestACLRight.getRight("modifyServer"), null, DENY);
        HashSet<String> expectedAttrs = new HashSet<String>();
        expectedAttrs.add("zimbraMailStatus");
        expectedAttrs.add("zimbraMailQuota");
        expectedAttrs.add("zimbraQuotaWarnPercent");
        expectedAttrs.add("zimbraQuotaWarnInterval");
        expectedAttrs.add("zimbraQuotaWarnMessage");
        expectedAttrs.add("displayName");
        expectedAttrs.add("description");
        AllowedAttrs expected = AllowedAttrs.ALLOW_SOME_ATTRS(expectedAttrs);
        this.verify(GA, TA, SET, expected);
        expectedAttrs = new HashSet();
        expectedAttrs.add("description");
        expectedAttrs.add("zimbraMailStatus");
        expectedAttrs.add("zimbraGalMode");
        expected = AllowedAttrs.ALLOW_SOME_ATTRS(expectedAttrs);
        this.verify(GA, TD, SET, expected);
    }

    public static void main(String[] args) throws Exception {
        CliUtil.toolSetup("INFO");
        TestUtil.runTest(TestACLRight.class);
    }

    static {
        zimbraMailQuota_constraint_max = 1000;
        try {
            GET_SOME_ATTRS_RIGHT = TestACL.getRight("test-getAttrs-account-2");
            SET_SOME_ATTRS_RIGHT = TestACL.getRight("test-setAttrs-account-2");
            GET_ALL_ATTRS_RIGHT = TestACL.getRight("getAccount");
            SET_ALL_ATTRS_RIGHT = TestACL.getRight("modifyAccount");
            CONFIGURE_CONSTRAINT_RIGHT = RightManager.getInstance().getRight("configureCosConstraint");
            PRESET_RIGHT = TestACL.getRight("modifyAccount");
            COMBO_RIGHT = TestACL.getRight("test-combo-MultiTargetTypes-top");
            ATTRS_IN_SET_SOME_ATTRS_RIGHT = new HashMap<String, Object>();
            ATTRS_IN_SET_SOME_ATTRS_RIGHT.put("zimbraMailQuota", "" + (zimbraMailQuota_constraint_max - 1));
            ATTRS_IN_SET_SOME_ATTRS_RIGHT.put("zimbraQuotaWarnPercent", "20");
            ATTRS_IN_SET_SOME_ATTRS_RIGHT.put("zimbraQuotaWarnInterval", "1d");
            ATTRS_IN_SET_SOME_ATTRS_RIGHT.put("zimbraQuotaWarnMessage", "foo");
            ATTRS_IN_SET_SOME_ATTRS_RIGHT_VIOLATE_CONSTRAINT = new HashMap<String, Object>();
            ATTRS_IN_SET_SOME_ATTRS_RIGHT_VIOLATE_CONSTRAINT.put("zimbraMailQuota", "" + (zimbraMailQuota_constraint_max + 1));
            ATTRS_NOT_IN_SET_SOME_ATTRS_RIGHT = new HashMap<String, Object>();
            ATTRS_NOT_IN_SET_SOME_ATTRS_RIGHT.put("zimbraMailQuota", "100");
            ATTRS_NOT_IN_SET_SOME_ATTRS_RIGHT.put("zimbraQuotaWarnPercent", "20");
            ATTRS_NOT_IN_SET_SOME_ATTRS_RIGHT.put("zimbraQuotaWarnInterval", "1d");
            ATTRS_NOT_IN_SET_SOME_ATTRS_RIGHT.put("zimbraQuotaWarnMessage", "foo");
            ATTRS_NOT_IN_SET_SOME_ATTRS_RIGHT.put("zimbraId", "blahblah");
        }
        catch (ServiceException e) {
            System.exit(1);
        }
    }
}

