/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.qa.unittest;

import com.zimbra.common.util.CliUtil;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.DistributionList;
import com.zimbra.cs.account.Entry;
import com.zimbra.cs.account.accesscontrol.ACLUtil;
import com.zimbra.cs.account.accesscontrol.GranteeType;
import com.zimbra.cs.account.accesscontrol.Right;
import com.zimbra.cs.account.accesscontrol.Rights;
import com.zimbra.cs.account.accesscontrol.TargetType;
import com.zimbra.cs.account.accesscontrol.UserRight;
import com.zimbra.cs.account.accesscontrol.ZimbraACE;
import com.zimbra.qa.unittest.TestACL;
import com.zimbra.qa.unittest.TestUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class TestACLPrecedence
extends TestACL {
    public void test1() throws Exception {
        String testName = this.getName();
        Account GA = mProv.createAccount(TestACLPrecedence.getEmailAddr(testName, "GA"), "test123", null);
        Account TA = mProv.createAccount(TestACLPrecedence.getEmailAddr(testName, "TA"), "test123", null);
        HashSet<ZimbraACE> aces = new HashSet<ZimbraACE>();
        aces.add(this.newUsrACE(GA, USER_RIGHT, ALLOW));
        aces.add(this.newUsrACE(GA, USER_RIGHT, DENY));
        HashMap attrs = new HashMap();
        ArrayList<String> values = new ArrayList<String>();
        for (ZimbraACE ace : aces) {
            values.add(ace.serialize());
        }
        attrs.put("zimbraACE", values);
        mProv.modifyAttrs(TA, attrs);
        List<ZimbraACE> acl = ACLUtil.getAllACEs(TA);
        TestACLPrecedence.assertEquals((int)2, (int)acl.size());
        TestACL.TestViaGrant via = new TestACL.TestViaGrant(TargetType.account, TA, GranteeType.GT_USER, GA.getName(), USER_RIGHT, true);
        this.verify(GA, (Entry)TA, USER_RIGHT, DENY, via);
    }

    public void test2() throws Exception {
        String testName = this.getName();
        Account A = mProv.createAccount(TestACLPrecedence.getEmailAddr(testName, "A"), "test123", null);
        DistributionList GG = mProv.createDistributionList(TestACLPrecedence.getEmailAddr(testName, "GG"), new HashMap<String, Object>());
        mProv.addMembers(GG, new String[]{A.getName()});
        Account TA = mProv.createAccount(TestACLPrecedence.getEmailAddr(testName, "TA"), "test123", null);
        HashSet<ZimbraACE> aces = new HashSet<ZimbraACE>();
        aces.add(this.newGrpACE(GG, USER_RIGHT, ALLOW));
        aces.add(this.newGrpACE(GG, USER_RIGHT, DENY));
        HashMap attrs = new HashMap();
        ArrayList<String> values = new ArrayList<String>();
        for (ZimbraACE ace : aces) {
            values.add(ace.serialize());
        }
        attrs.put("zimbraACE", values);
        mProv.modifyAttrs(TA, attrs);
        List<ZimbraACE> acl = ACLUtil.getAllACEs(TA);
        TestACLPrecedence.assertEquals((int)2, (int)acl.size());
        TestACL.TestViaGrant via = new TestACL.TestViaGrant(TargetType.account, TA, GranteeType.GT_GROUP, GG.getName(), USER_RIGHT, true);
        this.verify(A, (Entry)TA, USER_RIGHT, DENY, via);
    }

    public void test3() throws Exception {
        String testName = this.getName();
        Account A = mProv.createAccount(TestACLPrecedence.getEmailAddr(testName, "A"), "test123", null);
        DistributionList GG1 = mProv.createDistributionList(TestACLPrecedence.getEmailAddr(testName, "GG1"), new HashMap<String, Object>());
        DistributionList GG2 = mProv.createDistributionList(TestACLPrecedence.getEmailAddr(testName, "GG2"), new HashMap<String, Object>());
        mProv.addMembers(GG1, new String[]{A.getName()});
        mProv.addMembers(GG2, new String[]{A.getName()});
        Account TA = mProv.createAccount(TestACLPrecedence.getEmailAddr(testName, "TA"), "test123", null);
        HashSet<ZimbraACE> aces = new HashSet<ZimbraACE>();
        aces.add(this.newGrpACE(GG1, USER_RIGHT, ALLOW));
        aces.add(this.newGrpACE(GG2, USER_RIGHT, DENY));
        this.grantRight(TargetType.account, TA, aces);
        TestACL.TestViaGrant via = new TestACL.TestViaGrant(TargetType.account, TA, GranteeType.GT_GROUP, GG1.getName(), USER_RIGHT, true);
        via.addCanAlsoVia(new TestACL.TestViaGrant(TargetType.account, TA, GranteeType.GT_GROUP, GG2.getName(), USER_RIGHT, true));
        this.verify(A, (Entry)TA, USER_RIGHT, DENY, via);
    }

    public void test4() throws Exception {
        String testName = this.getName();
        Account A = mProv.createAccount(TestACLPrecedence.getEmailAddr(testName, "A"), "test123", null);
        DistributionList GG1 = mProv.createDistributionList(TestACLPrecedence.getEmailAddr(testName, "GG1"), new HashMap<String, Object>());
        DistributionList GG2 = mProv.createDistributionList(TestACLPrecedence.getEmailAddr(testName, "GG2"), new HashMap<String, Object>());
        DistributionList GG3 = mProv.createDistributionList(TestACLPrecedence.getEmailAddr(testName, "GG3"), new HashMap<String, Object>());
        DistributionList GG4 = mProv.createDistributionList(TestACLPrecedence.getEmailAddr(testName, "GG4"), new HashMap<String, Object>());
        DistributionList GG5 = mProv.createDistributionList(TestACLPrecedence.getEmailAddr(testName, "GG5"), new HashMap<String, Object>());
        DistributionList GG6 = mProv.createDistributionList(TestACLPrecedence.getEmailAddr(testName, "GG6"), new HashMap<String, Object>());
        mProv.addMembers(GG1, new String[]{A.getName(), GG2.getName()});
        mProv.addMembers(GG2, new String[]{A.getName(), GG3.getName()});
        mProv.addMembers(GG3, new String[]{A.getName()});
        mProv.addMembers(GG4, new String[]{A.getName(), GG5.getName()});
        mProv.addMembers(GG5, new String[]{A.getName(), GG6.getName()});
        mProv.addMembers(GG6, new String[]{A.getName()});
        Account target = mProv.createAccount(TestACLPrecedence.getEmailAddr(testName, "target"), "test123", null);
        HashSet<ZimbraACE> aces = new HashSet<ZimbraACE>();
        aces.add(this.newGrpACE(GG1, USER_RIGHT, ALLOW));
        aces.add(this.newGrpACE(GG2, USER_RIGHT, DENY));
        aces.add(this.newGrpACE(GG3, USER_RIGHT, ALLOW));
        aces.add(this.newGrpACE(GG4, USER_RIGHT, DENY));
        aces.add(this.newGrpACE(GG5, USER_RIGHT, ALLOW));
        aces.add(this.newGrpACE(GG6, USER_RIGHT, DENY));
        this.grantRight(TargetType.account, target, aces);
        TestACL.TestViaGrant via = new TestACL.TestViaGrant(TargetType.account, target, GranteeType.GT_GROUP, GG2.getName(), USER_RIGHT, true);
        via.addCanAlsoVia(new TestACL.TestViaGrant(TargetType.account, target, GranteeType.GT_GROUP, GG4.getName(), USER_RIGHT, true));
        via.addCanAlsoVia(new TestACL.TestViaGrant(TargetType.account, target, GranteeType.GT_GROUP, GG6.getName(), USER_RIGHT, true));
        this.verify(A, (Entry)target, USER_RIGHT, DENY, via);
    }

    public void test5() throws Exception {
        String testName = this.getName();
        Account grantee = mProv.createAccount(TestACLPrecedence.getEmailAddr(testName, "grantee"), "test123", null);
        DistributionList GA = mProv.createDistributionList(TestACLPrecedence.getEmailAddr(testName, "GA"), new HashMap<String, Object>());
        DistributionList GB = mProv.createDistributionList(TestACLPrecedence.getEmailAddr(testName, "GB"), new HashMap<String, Object>());
        DistributionList GC = mProv.createDistributionList(TestACLPrecedence.getEmailAddr(testName, "GC"), new HashMap<String, Object>());
        mProv.addMembers(GA, new String[]{GB.getName()});
        mProv.addMembers(GB, new String[]{GC.getName()});
        mProv.addMembers(GC, new String[]{grantee.getName()});
        Account target = mProv.createAccount(TestACLPrecedence.getEmailAddr(testName, "target"), "test123", null);
        DistributionList G1 = mProv.createDistributionList(TestACLPrecedence.getEmailAddr(testName, "G1"), new HashMap<String, Object>());
        DistributionList G2 = mProv.createDistributionList(TestACLPrecedence.getEmailAddr(testName, "G2"), new HashMap<String, Object>());
        DistributionList G3 = mProv.createDistributionList(TestACLPrecedence.getEmailAddr(testName, "G3"), new HashMap<String, Object>());
        mProv.addMembers(G1, new String[]{G2.getName()});
        mProv.addMembers(G2, new String[]{G3.getName()});
        mProv.addMembers(G3, new String[]{target.getName()});
        UserRight right = Rights.User.R_viewFreeBusy;
        HashSet<ZimbraACE> aces = new HashSet<ZimbraACE>();
        aces.add(this.newGrpACE(GC, right, ALLOW));
        this.grantRight(TargetType.dl, G1, aces);
        aces.clear();
        aces.add(this.newGrpACE(GB, right, DENY));
        this.grantRight(TargetType.dl, G2, aces);
        aces.clear();
        aces.add(this.newGrpACE(GA, right, DENY));
        this.grantRight(TargetType.dl, G3, aces);
        TestACL.TestViaGrant via = new TestACL.TestViaGrant(TargetType.dl, G2, GranteeType.GT_GROUP, GB.getName(), right, true);
        via.addCanAlsoVia(new TestACL.TestViaGrant(TargetType.dl, G3, GranteeType.GT_GROUP, GA.getName(), right, true));
        this.verify(grantee, (Entry)target, (Right)right, DENY, via);
    }

    public static void main(String[] args) throws Exception {
        CliUtil.toolSetup("INFO");
        TestUtil.runTest(TestACLPrecedence.class);
    }
}

