/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.qa.unittest;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.CliUtil;
import com.zimbra.common.util.Pair;
import com.zimbra.cs.account.AccessManager;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.CalendarResource;
import com.zimbra.cs.account.DistributionList;
import com.zimbra.cs.account.Entry;
import com.zimbra.cs.account.accesscontrol.ACLAccessManager;
import com.zimbra.cs.account.accesscontrol.ACLUtil;
import com.zimbra.cs.account.accesscontrol.GranteeType;
import com.zimbra.cs.account.accesscontrol.Right;
import com.zimbra.cs.account.accesscontrol.RightManager;
import com.zimbra.cs.account.accesscontrol.Rights;
import com.zimbra.cs.account.accesscontrol.TargetType;
import com.zimbra.cs.account.accesscontrol.UserRight;
import com.zimbra.cs.account.accesscontrol.ZimbraACE;
import com.zimbra.qa.unittest.TestACL;
import com.zimbra.qa.unittest.TestUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestACLGrantee
extends TestACL {
    CalendarResource createCalendarResource(String name) throws Exception {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        attrs.put("displayName", name);
        attrs.put("zimbraCalResType", "Equipment");
        return mProv.createCalendarResource(name, "test123", attrs);
    }

    Pair<TargetType, Account> createTarget(TargetType tt, String name) throws Exception {
        if (TargetType.account == tt) {
            return new Pair<TargetType, Account>(TargetType.account, this.createAccount(name));
        }
        if (TargetType.calresource == tt) {
            return new Pair<TargetType, Account>(TargetType.calresource, this.createCalendarResource(name));
        }
        TestACLGrantee.fail();
        return null;
    }

    public void doTestGranteeUser(TargetType tt) throws Exception {
        String testName = this.getName() + "-" + tt.getCode();
        System.out.println("    Testing " + testName);
        Account goodguy = mProv.createAccount(TestACLGrantee.getEmailAddr(testName, "goodguy"), "test123", null);
        Account badguy = mProv.createAccount(TestACLGrantee.getEmailAddr(testName, "badguy"), "test123", null);
        Account nobody = mProv.createAccount(TestACLGrantee.getEmailAddr(testName, "nobody"), "test123", null);
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        attrs.put("zimbraIsDomainAdminAccount", "TRUE");
        attrs.put("zimbraIsDelegatedAdminAccount", "TRUE");
        Account admin = mProv.createAccount(TestACLGrantee.getEmailAddr(testName, "admin"), "test123", attrs);
        Pair<TargetType, Account> tgt = this.createTarget(tt, TestACLGrantee.getEmailAddr(testName, "target"));
        TargetType targetType = tgt.getFirst();
        Account target = tgt.getSecond();
        HashSet<ZimbraACE> aces = new HashSet<ZimbraACE>();
        aces.add(this.newUsrACE(goodguy, Rights.User.R_viewFreeBusy, ALLOW));
        aces.add(this.newUsrACE(goodguy, Rights.User.R_invite, ALLOW));
        aces.add(this.newUsrACE(badguy, Rights.User.R_viewFreeBusy, DENY));
        aces.add(this.newPubACE(Rights.User.R_viewFreeBusy, ALLOW));
        this.grantRight(TargetType.account, target, aces);
        this.verify(target, (Entry)target, (Right)Rights.User.R_invite, ALLOW, null);
        if (AccessManager.getInstance() instanceof ACLAccessManager) {
            this.verify(admin, target, Rights.User.R_invite, AS_ADMIN, DENY, null);
        } else {
            this.verify(admin, target, Rights.User.R_invite, AS_ADMIN, ALLOW, null);
        }
        this.verify(admin, target, Rights.User.R_invite, AS_USER, DENY, null);
        TestACL.TestViaGrant via = new TestACL.TestViaGrant(targetType, target, GranteeType.GT_USER, goodguy.getName(), Rights.User.R_viewFreeBusy, false);
        this.verify(goodguy, (Entry)target, (Right)Rights.User.R_viewFreeBusy, ALLOW, via);
        via = new TestACL.TestViaGrant(targetType, target, GranteeType.GT_USER, goodguy.getName(), Rights.User.R_invite, false);
        this.verify(goodguy, (Entry)target, (Right)Rights.User.R_invite, ALLOW, via);
        via = new TestACL.TestViaGrant(targetType, target, GranteeType.GT_USER, badguy.getName(), Rights.User.R_viewFreeBusy, true);
        this.verify(badguy, (Entry)target, (Right)Rights.User.R_viewFreeBusy, DENY, via);
        this.verify(nobody, (Entry)target, (Right)Rights.User.R_viewFreeBusy, ALLOW, null);
        this.verify(nobody, (Entry)target, (Right)Rights.User.R_invite, DENY, null);
    }

    public void testGranteeUser() throws Exception {
        this.doTestGranteeUser(TargetType.account);
        this.doTestGranteeUser(TargetType.calresource);
    }

    public void doTestGranteeAllAuthUser(TargetType tt) throws Exception {
        String testName = this.getName() + "-" + tt.getCode();
        System.out.println("    Testing " + testName);
        Account guest = this.guestAccount("guest@external.com", "whocares");
        Account zimbra = mProv.createAccount(TestACLGrantee.getEmailAddr(testName, "zimbra"), "test123", null);
        Pair<TargetType, Account> tgt = this.createTarget(tt, TestACLGrantee.getEmailAddr(testName, "target"));
        TargetType targetType = tgt.getFirst();
        Account target = tgt.getSecond();
        HashSet<ZimbraACE> aces = new HashSet<ZimbraACE>();
        aces.add(this.newAllACE(Rights.User.R_viewFreeBusy, ALLOW));
        this.grantRight(TargetType.account, target, aces);
        TestACL.AuthUserViaGrant via = new TestACL.AuthUserViaGrant(targetType, target, Rights.User.R_viewFreeBusy, false);
        this.verify(zimbra, (Entry)target, (Right)Rights.User.R_viewFreeBusy, ALLOW, via);
        this.verify(guest, (Entry)target, (Right)Rights.User.R_viewFreeBusy, DENY, null);
        this.verifyDefinedDefault(zimbra, target, Rights.User.R_invite);
        this.verifyDefinedDefault(guest, target, Rights.User.R_invite);
        this.verifyDefinedDefault(zimbra, target, Rights.User.R_sendAs);
        this.verifyDefinedDefault(guest, target, Rights.User.R_sendAs);
    }

    public void testGranteeAllAuthUser() throws Exception {
        this.doTestGranteeAllAuthUser(TargetType.account);
        this.doTestGranteeAllAuthUser(TargetType.calresource);
    }

    public void doTestGranteeGuest(TargetType tt) throws Exception {
        String testName = this.getName() + "-" + tt.getCode();
        System.out.println("    Testing " + testName);
        Account guest = this.guestAccount("guest@external.com", "whocares");
        Pair<TargetType, Account> tgt = this.createTarget(tt, TestACLGrantee.getEmailAddr(testName, "target"));
        TargetType targetType = tgt.getFirst();
        Account target = tgt.getSecond();
        HashSet<ZimbraACE> aces = new HashSet<ZimbraACE>();
        aces.add(this.newPubACE(Rights.User.R_viewFreeBusy, ALLOW));
        this.grantRight(TargetType.account, target, aces);
        TestACL.PubViaGrant via = new TestACL.PubViaGrant(targetType, target, Rights.User.R_viewFreeBusy, false);
        this.verify(guest, (Entry)target, (Right)Rights.User.R_viewFreeBusy, ALLOW, via);
        this.verifyDefault(guest, target, Rights.User.R_invite);
    }

    public void testGranteeGuest() throws Exception {
        this.doTestGranteeGuest(TargetType.account);
        this.doTestGranteeGuest(TargetType.calresource);
    }

    public void doTestGranteeKey(TargetType tt) throws Exception {
        String testName = this.getName() + "-" + tt.getCode();
        System.out.println("    Testing " + testName);
        String GRANTEE_NAME_ALLOWED_KEY_KEY_PROVIDED = "allowedKeyProvided with space";
        String KEY_FOR_GRANTEE_NAME_ALLOWED_KEY_KEY_PROVIDED = "allowed my access key";
        String GRANTEE_NAME_ALLOWED_KEY_KEY_GENERATED = "allowedKeyGenerated@external.com";
        String KEY_FOR_GRANTEE_NAME_ALLOWED_KEY_KEY_GENERATED = null;
        String GRANTEE_NAME_DENIED_KEY_KEY_PROVIDED = "deniedKeyProvided with space";
        String KEY_FOR_GRANTEE_NAME_DENIED_KEY_KEY_PROVIDED = "denied my access key";
        String GRANTEE_NAME_DENIED_KEY_KEY_GENERATED = "deniedKeyGenerated@external.com";
        String KEY_FOR_GRANTEE_NAME_DENIED_KEY_KEY_GENERATED = null;
        Pair<TargetType, Account> tgt = this.createTarget(tt, TestACLGrantee.getEmailAddr(testName, "target"));
        TargetType targetType = tgt.getFirst();
        Account target = tgt.getSecond();
        HashSet<ZimbraACE> aces = new HashSet<ZimbraACE>();
        aces.add(this.newKeyACE("allowedKeyProvided with space", "allowed my access key", Rights.User.R_viewFreeBusy, ALLOW));
        aces.add(this.newKeyACE("allowedKeyGenerated@external.com", null, Rights.User.R_viewFreeBusy, ALLOW));
        aces.add(this.newKeyACE("deniedKeyProvided with space", "denied my access key", Rights.User.R_viewFreeBusy, DENY));
        aces.add(this.newKeyACE("deniedKeyGenerated@external.com", null, Rights.User.R_viewFreeBusy, DENY));
        List<ZimbraACE> grantedAces = this.grantRight(TargetType.account, target, aces);
        for (ZimbraACE ace : grantedAces) {
            if (ace.getGrantee().equals("allowedKeyGenerated@external.com")) {
                KEY_FOR_GRANTEE_NAME_ALLOWED_KEY_KEY_GENERATED = ace.getSecret();
            }
            if (!ace.getGrantee().equals("deniedKeyGenerated@external.com")) continue;
            KEY_FOR_GRANTEE_NAME_DENIED_KEY_KEY_GENERATED = ace.getSecret();
        }
        Account allowedKeyProvided = this.keyAccount("allowedKeyProvided with space", "allowed my access key");
        Account allowedKeyGenerated = this.keyAccount("allowedKeyGenerated@external.com", KEY_FOR_GRANTEE_NAME_ALLOWED_KEY_KEY_GENERATED);
        Account allowedKeyGeneratedWrongAccessKey = this.keyAccount("allowedKeyGenerated@external.com", KEY_FOR_GRANTEE_NAME_ALLOWED_KEY_KEY_GENERATED + "bogus");
        Account deniedKeyProvided = this.keyAccount("deniedKeyProvided with space", "denied my access key");
        Account deniedKeyGenerated = this.keyAccount("deniedKeyGenerated@external.com", KEY_FOR_GRANTEE_NAME_DENIED_KEY_KEY_GENERATED);
        TestACL.TestViaGrant via = new TestACL.TestViaGrant(targetType, target, GranteeType.GT_KEY, allowedKeyProvided.getName(), Rights.User.R_viewFreeBusy, false);
        this.verify(allowedKeyProvided, (Entry)target, (Right)Rights.User.R_viewFreeBusy, ALLOW, via);
        via = new TestACL.TestViaGrant(targetType, target, GranteeType.GT_KEY, allowedKeyGenerated.getName(), Rights.User.R_viewFreeBusy, false);
        this.verify(allowedKeyGenerated, (Entry)target, (Right)Rights.User.R_viewFreeBusy, ALLOW, via);
        this.verify(allowedKeyGeneratedWrongAccessKey, (Entry)target, (Right)Rights.User.R_viewFreeBusy, DENY, null);
        via = new TestACL.TestViaGrant(targetType, target, GranteeType.GT_KEY, deniedKeyProvided.getName(), Rights.User.R_viewFreeBusy, true);
        this.verify(deniedKeyProvided, (Entry)target, (Right)Rights.User.R_viewFreeBusy, DENY, via);
        via = new TestACL.TestViaGrant(targetType, target, GranteeType.GT_KEY, deniedKeyGenerated.getName(), Rights.User.R_viewFreeBusy, true);
        this.verify(deniedKeyGenerated, (Entry)target, (Right)Rights.User.R_viewFreeBusy, DENY, via);
        aces.add(this.newPubACE(Rights.User.R_viewFreeBusy, ALLOW));
        this.grantRight(TargetType.account, target, aces);
        via = new TestACL.TestViaGrant(targetType, target, GranteeType.GT_KEY, allowedKeyProvided.getName(), Rights.User.R_viewFreeBusy, false);
        this.verify(allowedKeyProvided, (Entry)target, (Right)Rights.User.R_viewFreeBusy, ALLOW, via);
        via = new TestACL.TestViaGrant(targetType, target, GranteeType.GT_KEY, allowedKeyGenerated.getName(), Rights.User.R_viewFreeBusy, false);
        this.verify(allowedKeyGenerated, (Entry)target, (Right)Rights.User.R_viewFreeBusy, ALLOW, via);
        via = new TestACL.PubViaGrant(targetType, target, Rights.User.R_viewFreeBusy, false);
        this.verify(allowedKeyGeneratedWrongAccessKey, (Entry)target, (Right)Rights.User.R_viewFreeBusy, ALLOW, via);
        via = new TestACL.TestViaGrant(targetType, target, GranteeType.GT_KEY, deniedKeyProvided.getName(), Rights.User.R_viewFreeBusy, true);
        this.verify(deniedKeyProvided, (Entry)target, (Right)Rights.User.R_viewFreeBusy, DENY, via);
        via = new TestACL.TestViaGrant(targetType, target, GranteeType.GT_KEY, deniedKeyGenerated.getName(), Rights.User.R_viewFreeBusy, true);
        this.verify(deniedKeyGenerated, (Entry)target, (Right)Rights.User.R_viewFreeBusy, DENY, via);
        aces.clear();
        aces.add(this.newKeyACE("deniedKeyProvided with space", "doesn't matter", Rights.User.R_viewFreeBusy, DENY));
        aces.add(this.newKeyACE("deniedKeyGenerated@external.com", null, Rights.User.R_viewFreeBusy, DENY));
        this.revokeRight(targetType, target, aces);
        via = new TestACL.TestViaGrant(targetType, target, GranteeType.GT_KEY, allowedKeyProvided.getName(), Rights.User.R_viewFreeBusy, false);
        this.verify(allowedKeyProvided, (Entry)target, (Right)Rights.User.R_viewFreeBusy, ALLOW, via);
        via = new TestACL.TestViaGrant(targetType, target, GranteeType.GT_KEY, allowedKeyGenerated.getName(), Rights.User.R_viewFreeBusy, false);
        this.verify(allowedKeyGenerated, (Entry)target, (Right)Rights.User.R_viewFreeBusy, ALLOW, via);
        via = new TestACL.PubViaGrant(targetType, target, Rights.User.R_viewFreeBusy, false);
        this.verify(allowedKeyGeneratedWrongAccessKey, (Entry)target, (Right)Rights.User.R_viewFreeBusy, ALLOW, via);
        via = new TestACL.PubViaGrant(targetType, target, Rights.User.R_viewFreeBusy, false);
        this.verify(deniedKeyProvided, (Entry)target, (Right)Rights.User.R_viewFreeBusy, ALLOW, via);
        via = new TestACL.PubViaGrant(targetType, target, Rights.User.R_viewFreeBusy, false);
        this.verify(deniedKeyGenerated, (Entry)target, (Right)Rights.User.R_viewFreeBusy, ALLOW, via);
        this.verifyDefault(allowedKeyGenerated, target, Rights.User.R_invite);
    }

    public void testGranteeKey() throws Exception {
        this.doTestGranteeKey(TargetType.account);
        this.doTestGranteeKey(TargetType.calresource);
    }

    public void testGranteeKeyInvalidParams() throws Exception {
        block2: {
            String testName = this.getName();
            Account user1 = mProv.createAccount(TestACLGrantee.getEmailAddr(testName, "user1"), "test123", null);
            Account target = mProv.createAccount(TestACLGrantee.getEmailAddr(testName, "target"), "test123", null);
            HashSet<ZimbraACE> aces = new HashSet<ZimbraACE>();
            aces.add(this.newKeyACE("good", "abc", Rights.User.R_viewFreeBusy, ALLOW));
            aces.add(this.newKeyACE("bad:aaa:bbb", "xxx:yyy", Rights.User.R_viewFreeBusy, ALLOW));
            aces.add(this.newUsrACE(user1, Rights.User.R_viewFreeBusy, ALLOW));
            try {
                List<ZimbraACE> grantedAces = this.grantRight(TargetType.account, target, aces);
            }
            catch (ServiceException e) {
                if (!e.getCode().equals("service.INVALID_REQUEST") || ACLUtil.getAllACEs(target) != null) break block2;
                return;
            }
        }
        TestACLGrantee.fail();
    }

    public void doTestGranteeAnon(TargetType tt) throws Exception {
        String testName = this.getName() + "-" + tt.getCode();
        System.out.println("    Testing " + testName);
        Account anon = this.anonAccount();
        Pair<TargetType, Account> tgt = this.createTarget(tt, TestACLGrantee.getEmailAddr(testName, "target"));
        TargetType targetType = tgt.getFirst();
        Account target = tgt.getSecond();
        HashSet<ZimbraACE> aces = new HashSet<ZimbraACE>();
        aces.add(this.newPubACE(Rights.User.R_viewFreeBusy, ALLOW));
        this.grantRight(TargetType.account, target, aces);
        TestACL.PubViaGrant via = new TestACL.PubViaGrant(targetType, target, Rights.User.R_viewFreeBusy, false);
        this.verify(anon, (Entry)target, (Right)Rights.User.R_viewFreeBusy, ALLOW, via);
        this.verifyDefault(anon, target, Rights.User.R_invite);
        via = new TestACL.PubViaGrant(targetType, target, Rights.User.R_viewFreeBusy, false);
        this.verify(null, (Entry)target, (Right)Rights.User.R_viewFreeBusy, ALLOW, via);
        this.verifyDefault(null, target, Rights.User.R_invite);
    }

    public void testGranteeAnon() throws Exception {
        this.doTestGranteeAnon(TargetType.account);
        this.doTestGranteeAnon(TargetType.calresource);
    }

    public void doTestGranteeGroupSimple(TargetType tt) throws Exception {
        String testName = this.getName() + "-" + tt.getCode();
        System.out.println("    Testing " + testName);
        Account user1 = mProv.createAccount(TestACLGrantee.getEmailAddr(testName, "user1"), "test123", null);
        Account user2 = mProv.createAccount(TestACLGrantee.getEmailAddr(testName, "user2"), "test123", null);
        Account user3 = mProv.createAccount(TestACLGrantee.getEmailAddr(testName, "user3"), "test123", null);
        DistributionList groupA = mProv.createDistributionList(TestACLGrantee.getEmailAddr(testName, "groupA"), new HashMap<String, Object>());
        mProv.addMembers(groupA, new String[]{user1.getName(), user2.getName()});
        Pair<TargetType, Account> tgt = this.createTarget(tt, TestACLGrantee.getEmailAddr(testName, "testGroup-target"));
        TargetType targetType = tgt.getFirst();
        Account target = tgt.getSecond();
        HashSet<ZimbraACE> aces = new HashSet<ZimbraACE>();
        aces.add(this.newUsrACE(user1, Rights.User.R_viewFreeBusy, DENY));
        aces.add(this.newGrpACE(groupA, Rights.User.R_viewFreeBusy, ALLOW));
        this.grantRight(TargetType.account, target, aces);
        TestACL.TestViaGrant via = new TestACL.TestViaGrant(targetType, target, GranteeType.GT_USER, user1.getName(), Rights.User.R_viewFreeBusy, true);
        this.verify(user1, (Entry)target, (Right)Rights.User.R_viewFreeBusy, DENY, via);
        via = new TestACL.TestViaGrant(targetType, target, GranteeType.GT_GROUP, groupA.getName(), Rights.User.R_viewFreeBusy, false);
        this.verify(user2, (Entry)target, (Right)Rights.User.R_viewFreeBusy, ALLOW, via);
        this.verify(user3, (Entry)target, (Right)Rights.User.R_viewFreeBusy, DENY, null);
    }

    public void testGranteeGroupSimple() throws Exception {
        this.doTestGranteeGroupSimple(TargetType.account);
        this.doTestGranteeGroupSimple(TargetType.calresource);
    }

    public void doTestNoACL(TargetType tt) throws Exception {
        String testName = this.getName() + "-" + tt.getCode();
        System.out.println("    Testing " + testName);
        Account zimbraUser = mProv.createAccount(TestACLGrantee.getEmailAddr(testName, "user"), "test123", null);
        Account guest = this.guestAccount("guest@external.com", "whocares");
        Account anon = this.anonAccount();
        Pair<TargetType, Account> tgt = this.createTarget(tt, TestACLGrantee.getEmailAddr(testName, "target"));
        TargetType targetType = tgt.getFirst();
        Account target = tgt.getSecond();
        for (UserRight right : RightManager.getInstance().getAllUserRights().values()) {
            this.verifyDefault(zimbraUser, target, right);
            this.verifyDefault(guest, target, right);
            this.verifyDefault(anon, target, right);
        }
    }

    public void testNoACL() throws Exception {
        this.doTestNoACL(TargetType.account);
        this.doTestNoACL(TargetType.calresource);
    }

    public void doTestDefaultWithNonEmptyACL(TargetType tt) throws Exception {
        String testName = this.getName() + "-" + tt.getCode();
        System.out.println("    Testing " + testName);
        Account zimbraUser = mProv.createAccount(TestACLGrantee.getEmailAddr(testName, "user"), "test123", null);
        Account guest = this.guestAccount("guest@external.com", "whocares");
        Account anon = this.anonAccount();
        UserRight rightGranted = Rights.User.R_viewFreeBusy;
        UserRight rightNotGrantedDefaultAllowed = Rights.User.R_invite;
        UserRight rightNotGrantedDefaultDenied = Rights.User.R_sendAs;
        Pair<TargetType, Account> tgt = this.createTarget(tt, TestACLGrantee.getEmailAddr(testName, "target"));
        TargetType targetType = tgt.getFirst();
        Account target = tgt.getSecond();
        HashSet<ZimbraACE> aces = new HashSet<ZimbraACE>();
        aces.add(this.newUsrACE(zimbraUser, rightGranted, ALLOW));
        this.grantRight(TargetType.account, target, aces);
        this.verifyDefinedDefault(zimbraUser, target, rightNotGrantedDefaultAllowed);
        this.verifyDefinedDefault(guest, target, rightNotGrantedDefaultAllowed);
        this.verifyDefinedDefault(anon, target, rightNotGrantedDefaultAllowed);
        this.verifyDefinedDefault(zimbraUser, target, rightNotGrantedDefaultDenied);
        this.verifyDefinedDefault(guest, target, rightNotGrantedDefaultDenied);
        this.verifyDefinedDefault(anon, target, rightNotGrantedDefaultDenied);
        TestACL.TestViaGrant via = new TestACL.TestViaGrant(targetType, target, GranteeType.GT_USER, zimbraUser.getName(), rightGranted, false);
        this.verify(zimbraUser, (Entry)target, (Right)rightGranted, ALLOW, via);
        this.verify(guest, (Entry)target, (Right)rightGranted, DENY, null);
        this.verify(anon, (Entry)target, (Right)rightGranted, DENY, null);
    }

    public void testDefaultWithNonEmptyACL() throws Exception {
        this.doTestDefaultWithNonEmptyACL(TargetType.account);
        this.doTestDefaultWithNonEmptyACL(TargetType.calresource);
    }

    public void testGrantConflict() throws Exception {
        String testName = this.getName();
        Account grantee = mProv.createAccount(TestACLGrantee.getEmailAddr(testName, "grantee"), "test123", null);
        Account target = mProv.createAccount(TestACLGrantee.getEmailAddr(testName, "target"), "test123", null);
        HashSet<ZimbraACE> aces = new HashSet<ZimbraACE>();
        aces.add(this.newUsrACE(grantee, Rights.User.R_viewFreeBusy, ALLOW));
        aces.add(this.newUsrACE(grantee, Rights.User.R_viewFreeBusy, DENY));
        this.grantRight(TargetType.account, target, aces);
        List<ZimbraACE> acl = ACLUtil.getAllACEs(target);
        TestACLGrantee.assertEquals((int)1, (int)acl.size());
    }

    public void testGrantDuplicate() throws Exception {
        String testName = this.getName();
        Account duplicate = mProv.createAccount(TestACLGrantee.getEmailAddr(testName, "duplicate"), "test123", null);
        Account target = mProv.createAccount(TestACLGrantee.getEmailAddr(testName, "target"), "test123", null);
        HashSet<ZimbraACE> aces = new HashSet<ZimbraACE>();
        aces.add(this.newUsrACE(duplicate, Rights.User.R_viewFreeBusy, DENY));
        aces.add(this.newUsrACE(duplicate, Rights.User.R_viewFreeBusy, DENY));
        this.grantRight(TargetType.account, target, aces);
        List<ZimbraACE> acl = ACLUtil.getAllACEs(target);
        TestACLGrantee.assertEquals((int)1, (int)acl.size());
    }

    public void testGrant() throws Exception {
        String testName = this.getName();
        Account user = mProv.createAccount(TestACLGrantee.getEmailAddr(testName, "user"), "test123", null);
        DistributionList group = mProv.createDistributionList(TestACLGrantee.getEmailAddr(testName, "group"), new HashMap<String, Object>());
        Account target = mProv.createAccount(TestACLGrantee.getEmailAddr(testName, "target"), "test123", null);
        HashSet<ZimbraACE> aces = new HashSet<ZimbraACE>();
        aces.add(this.newUsrACE(user, Rights.User.R_viewFreeBusy, DENY));
        aces.add(this.newGrpACE(group, Rights.User.R_viewFreeBusy, DENY));
        this.grantRight(TargetType.account, target, aces);
        List<ZimbraACE> acl = ACLUtil.getAllACEs(target);
        TestACLGrantee.assertEquals((int)2, (int)acl.size());
        aces.clear();
        aces.add(this.newPubACE(Rights.User.R_viewFreeBusy, ALLOW));
        this.grantRight(TargetType.account, target, aces);
        acl = ACLUtil.getAllACEs(target);
        TestACLGrantee.assertEquals((int)3, (int)acl.size());
        aces.clear();
        aces.add(this.newAllACE(Rights.User.R_viewFreeBusy, ALLOW));
        this.grantRight(TargetType.account, target, aces);
        acl = ACLUtil.getAllACEs(target);
        TestACLGrantee.assertEquals((int)4, (int)acl.size());
    }

    public void doTestLoginAsRight(TargetType tt) throws Exception {
        String testName = this.getName() + "-" + tt.getCode();
        System.out.println("    Testing " + testName);
        Account user = mProv.createAccount(TestACLGrantee.getEmailAddr(testName, "user"), "test123", null);
        Pair<TargetType, Account> tgt = this.createTarget(tt, TestACLGrantee.getEmailAddr(testName, "target"));
        TargetType targetType = tgt.getFirst();
        Account target = tgt.getSecond();
        HashSet<ZimbraACE> aces = new HashSet<ZimbraACE>();
        aces.add(this.newUsrACE(user, Rights.User.R_loginAs, ALLOW));
        this.grantRight(TargetType.account, target, aces);
        List<ZimbraACE> acl = ACLUtil.getAllACEs(target);
        TestACLGrantee.assertEquals((int)1, (int)acl.size());
        TestACL.TestViaGrant via = new TestACL.TestViaGrant(targetType, target, GranteeType.GT_USER, user.getName(), Rights.User.R_loginAs, false);
        this.verify(user, (Entry)target, (Right)Rights.User.R_loginAs, ALLOW, via);
        boolean canAccessAccount = mAM.canAccessAccount(user, target, false);
        TestACLGrantee.assertTrue((boolean)canAccessAccount);
    }

    public void testLoginAsRight() throws Exception {
        this.doTestLoginAsRight(TargetType.account);
        this.doTestLoginAsRight(TargetType.calresource);
    }

    public void testRevoke() throws Exception {
        String testName = this.getName();
        Account user = mProv.createAccount(TestACLGrantee.getEmailAddr(testName, "user"), "test123", null);
        Account target = mProv.createAccount(TestACLGrantee.getEmailAddr(testName, "target"), "test123", null);
        HashSet<ZimbraACE> aces = new HashSet<ZimbraACE>();
        aces.add(this.newUsrACE(user, Rights.User.R_invite, ALLOW));
        aces.add(this.newUsrACE(user, Rights.User.R_viewFreeBusy, ALLOW));
        this.grantRight(TargetType.account, target, aces);
        List<ZimbraACE> acl = ACLUtil.getAllACEs(target);
        TestACLGrantee.assertEquals((int)2, (int)acl.size());
        TestACL.TestViaGrant via = new TestACL.TestViaGrant(TargetType.account, target, GranteeType.GT_USER, user.getName(), Rights.User.R_invite, false);
        this.verify(user, (Entry)target, (Right)Rights.User.R_invite, ALLOW, via);
        HashSet<ZimbraACE> acesToRevoke = new HashSet<ZimbraACE>();
        acesToRevoke.add(this.newUsrACE(user, Rights.User.R_invite, ALLOW));
        this.revokeRight(TargetType.account, target, acesToRevoke);
        acl = ACLUtil.getAllACEs(target);
        TestACLGrantee.assertEquals((int)1, (int)acl.size());
        this.verifyDefault(user, target, Rights.User.R_invite);
        via = new TestACL.TestViaGrant(TargetType.account, target, GranteeType.GT_USER, user.getName(), Rights.User.R_viewFreeBusy, false);
        this.verify(user, (Entry)target, (Right)Rights.User.R_viewFreeBusy, ALLOW, via);
        acesToRevoke = new HashSet();
        acesToRevoke.add(this.newUsrACE(user, Rights.User.R_viewFreeBusy, ALLOW));
        this.revokeRight(TargetType.account, target, acesToRevoke);
        this.verifyDefault(user, target, Rights.User.R_invite);
        this.verifyDefault(user, target, Rights.User.R_viewFreeBusy);
        acl = ACLUtil.getAllACEs(target);
        TestACLGrantee.assertNull(acl);
        acesToRevoke = new HashSet();
        acesToRevoke.add(this.newUsrACE(user, Rights.User.R_invite, ALLOW));
        this.revokeRight(TargetType.account, target, acesToRevoke);
    }

    public static void main(String[] args) throws Exception {
        CliUtil.toolSetup("INFO");
        TestUtil.runTest(TestACLGrantee.class);
    }
}

