/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.qa.unittest;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.CliUtil;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.CalendarResource;
import com.zimbra.cs.account.Cos;
import com.zimbra.cs.account.DistributionList;
import com.zimbra.cs.account.Domain;
import com.zimbra.cs.account.Entry;
import com.zimbra.cs.account.NamedEntry;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.Server;
import com.zimbra.cs.account.XMPPComponent;
import com.zimbra.cs.account.Zimlet;
import com.zimbra.cs.account.accesscontrol.GranteeType;
import com.zimbra.cs.account.accesscontrol.Right;
import com.zimbra.cs.account.accesscontrol.TargetType;
import com.zimbra.qa.unittest.TestACL;
import com.zimbra.qa.unittest.TestUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestACLGrant
extends TestACL {
    private static String TEST_CASE_NAME = "TestACLGrant-";
    private static String ACCOUNT_NAME = TestACLGrant.getEmailAddr(TEST_CASE_NAME + "account").toLowerCase();
    private static String CALENDAR_RESOURCE_NAME = TestACLGrant.getEmailAddr(TEST_CASE_NAME + "cr").toLowerCase();
    private static String COS_NAME = TEST_CASE_NAME + "cos".toLowerCase();
    private static String DISTRIBUTION_LIST_NAME = TestACLGrant.getEmailAddr(TEST_CASE_NAME + "dl").toLowerCase();
    private static String SUBDOMAIN_NAME = TestACLGrant.getSubDomainName(TEST_CASE_NAME + "domain").toLowerCase();
    private static String SERVER_NAME = TEST_CASE_NAME + "server".toLowerCase();
    private static String XMPP_COMPONENT_NAME = TEST_CASE_NAME + "xmppcomponent".toLowerCase();
    private static String ZIMLET_NAME = TEST_CASE_NAME + "zimlet".toLowerCase();

    private Account getAccount() throws ServiceException {
        Account acct = mProv.get(Provisioning.AccountBy.name, ACCOUNT_NAME);
        if (acct == null) {
            acct = mProv.createAccount(ACCOUNT_NAME, "test123", null);
        }
        return acct;
    }

    private CalendarResource getCalendarResource() throws ServiceException {
        CalendarResource cr = mProv.get(Provisioning.CalendarResourceBy.name, CALENDAR_RESOURCE_NAME);
        if (cr == null) {
            HashMap<String, Object> attrs = new HashMap<String, Object>();
            attrs.put("displayName", "CALENDAR_RESOURCE_NAME");
            attrs.put("zimbraCalResType", "Equipment");
            cr = mProv.createCalendarResource(CALENDAR_RESOURCE_NAME, "test123", attrs);
        }
        return cr;
    }

    private Cos getCos() throws ServiceException {
        Cos cos = mProv.get(Provisioning.CosBy.name, COS_NAME);
        if (cos == null) {
            cos = mProv.createCos(COS_NAME, null);
        }
        return cos;
    }

    private DistributionList getDistributionList() throws ServiceException {
        DistributionList dl = mProv.get(Provisioning.DistributionListBy.name, DISTRIBUTION_LIST_NAME);
        if (dl == null) {
            dl = mProv.createDistributionList(DISTRIBUTION_LIST_NAME, new HashMap<String, Object>());
        }
        return dl;
    }

    private Domain getDomain() throws ServiceException {
        Domain domain = mProv.get(Provisioning.DomainBy.name, SUBDOMAIN_NAME);
        if (domain == null) {
            domain = mProv.createDomain(SUBDOMAIN_NAME, new HashMap<String, Object>());
        }
        return domain;
    }

    private Server getServer() throws ServiceException {
        Server server = mProv.get(Provisioning.ServerBy.name, SERVER_NAME);
        if (server == null) {
            server = mProv.createServer(SERVER_NAME, new HashMap<String, Object>());
        }
        return server;
    }

    private XMPPComponent getXMPPComponent() throws ServiceException {
        XMPPComponent xmppCpnt = mProv.get(Provisioning.XMPPComponentBy.name, XMPP_COMPONENT_NAME);
        if (xmppCpnt == null) {
            HashMap<String, Object> attrs = new HashMap<String, Object>();
            attrs.put("zimbraXMPPComponentCategory", "whatever");
            attrs.put("zimbraXMPPComponentClassName", "whatever");
            attrs.put("zimbraXMPPComponentType", "whatever");
            xmppCpnt = mProv.createXMPPComponent(XMPP_COMPONENT_NAME, this.getDomain(), this.getServer(), attrs);
        }
        return xmppCpnt;
    }

    private Zimlet getZimlet() throws ServiceException {
        Zimlet zimlet = mProv.getZimlet(ZIMLET_NAME);
        if (zimlet == null) {
            HashMap<String, Object> attrs = new HashMap<String, Object>();
            attrs.put("zimbraZimletVersion", "1.0");
            zimlet = mProv.createZimlet(ZIMLET_NAME, attrs);
        }
        return zimlet;
    }

    private void doTargetTest(Account authedAcct, Account grantee, TargetType targetType, NamedEntry target, Right right, Set<TargetType> expected) throws ServiceException {
        Boolean good = null;
        try {
            this.grantRight(authedAcct, targetType, target, GranteeType.GT_USER, grantee, right, ALLOW);
            this.revokeRight(authedAcct, targetType, target, GranteeType.GT_USER, grantee, right, ALLOW);
            good = Boolean.TRUE;
        }
        catch (ServiceException e) {
            if (e.getCode().equals("service.INVALID_REQUEST")) {
                good = Boolean.FALSE;
            }
            throw e;
        }
        if (expected.contains((Object)targetType)) {
            TestACLGrant.assertEquals((Object)Boolean.TRUE, (Object)good);
        } else {
            TestACLGrant.assertEquals((Object)Boolean.FALSE, (Object)good);
        }
    }

    private void doTargetTest(Account authedAcct, Account grantee, Right right, Set<TargetType> expected) throws ServiceException {
        this.doTargetTest(authedAcct, grantee, TargetType.account, this.getAccount(), right, expected);
        this.doTargetTest(authedAcct, grantee, TargetType.calresource, this.getCalendarResource(), right, expected);
        this.doTargetTest(authedAcct, grantee, TargetType.cos, this.getCos(), right, expected);
        this.doTargetTest(authedAcct, grantee, TargetType.dl, this.getDistributionList(), right, expected);
        this.doTargetTest(authedAcct, grantee, TargetType.domain, this.getDomain(), right, expected);
        this.doTargetTest(authedAcct, grantee, TargetType.server, this.getServer(), right, expected);
        this.doTargetTest(authedAcct, grantee, TargetType.xmppcomponent, this.getXMPPComponent(), right, expected);
        this.doTargetTest(authedAcct, grantee, TargetType.zimlet, this.getZimlet(), right, expected);
        this.doTargetTest(authedAcct, grantee, TargetType.config, null, right, expected);
        this.doTargetTest(authedAcct, grantee, TargetType.global, null, right, expected);
    }

    public void testAccountRight() throws Exception {
        String testName = this.getTestName();
        Account authedAcct = this.getSystemAdminAccount(TestACLGrant.getEmailAddr(testName, "authed"));
        Account GA = this.createAdminAccount(TestACLGrant.getEmailAddr(testName, "GA"));
        HashSet<TargetType> expected = new HashSet<TargetType>();
        expected.add(TargetType.account);
        expected.add(TargetType.calresource);
        expected.add(TargetType.dl);
        expected.add(TargetType.domain);
        expected.add(TargetType.global);
        this.doTargetTest(authedAcct, GA, TestACLGrant.getRight("test-preset-account"), expected);
        this.doTargetTest(authedAcct, GA, TestACLGrant.getRight("test-getAttrs-account"), expected);
        this.doTargetTest(authedAcct, GA, TestACLGrant.getRight(TestACLGrant.inlineRightGet(TargetType.account, "description")), expected);
        this.doTargetTest(authedAcct, GA, TestACLGrant.getRight("test-setAttrs-account"), expected);
        this.doTargetTest(authedAcct, GA, TestACLGrant.getRight(TestACLGrant.inlineRightSet(TargetType.account, "description")), expected);
        this.doTargetTest(authedAcct, GA, TestACLGrant.getRight("test-combo-account"), expected);
        expected.clear();
        expected.add(TargetType.account);
        expected.add(TargetType.cos);
        expected.add(TargetType.calresource);
        expected.add(TargetType.dl);
        expected.add(TargetType.domain);
        expected.add(TargetType.global);
        this.doTargetTest(authedAcct, GA, TestACLGrant.getRight("test-getAttrs-accountCos"), expected);
        this.doTargetTest(authedAcct, GA, TestACLGrant.getRight("test-setAttrs-accountCos"), expected);
        expected.clear();
        expected.add(TargetType.global);
        this.doTargetTest(authedAcct, GA, TestACLGrant.getRight("test-combo-account-cos-accountCos"), expected);
    }

    private void doTestGrant(Account delegator, TargetType targetType, NamedEntry target, GranteeType delegateeType, NamedEntry delegatee, Right right, TestACL.AllowOrDeny allowOrDeny, Result expected) throws ServiceException {
        Result actual = null;
        try {
            this.grantRight(delegator, targetType, target, delegateeType, delegatee, right, allowOrDeny);
            actual = Result.GOOD;
        }
        catch (ServiceException e) {
            if (e.getCode().equals("service.INVALID_REQUEST")) {
                actual = Result.INVALID_REQUEST;
            }
            if (e.getCode().equals("service.PERM_DENIED")) {
                actual = Result.PERM_DENIED;
            }
            throw e;
        }
        TestACLGrant.assertEquals((Object)((Object)expected), (Object)((Object)actual));
    }

    private void doTestRevoke(Account delegator, TargetType targetType, NamedEntry target, GranteeType delegateeType, NamedEntry delegatee, Right right, TestACL.AllowOrDeny allowOrDeny, Result expected) throws ServiceException {
        Result actual = null;
        actual = null;
        try {
            this.revokeRight(delegator, targetType, target, delegateeType, delegatee, right, allowOrDeny);
            actual = Result.GOOD;
        }
        catch (ServiceException e) {
            if (e.getCode().equals("service.INVALID_REQUEST")) {
                actual = Result.INVALID_REQUEST;
            }
            if (e.getCode().equals("service.PERM_DENIED")) {
                actual = Result.PERM_DENIED;
            }
            throw e;
        }
        TestACLGrant.assertEquals((Object)((Object)expected), (Object)((Object)actual));
    }

    private void doTestDelegate(Account delegator, TargetType targetType, NamedEntry target, GranteeType delegateeType, NamedEntry delegatee, Right right, TestACL.AllowOrDeny allowOrDeny, Result expected) throws ServiceException {
        this.doTestGrant(delegator, targetType, target, delegateeType, delegatee, right, allowOrDeny, expected);
        this.doTestRevoke(delegator, targetType, target, delegateeType, delegatee, right, allowOrDeny, expected);
    }

    private void doTestDelegate(Account delegator, TargetType targetType, NamedEntry target, GranteeType delegateeType, NamedEntry delegatee, Right right, Result expected) throws ServiceException {
        this.doTestDelegate(delegator, targetType, target, delegateeType, delegatee, right, ALLOW, expected);
        this.doTestDelegate(delegator, targetType, target, delegateeType, delegatee, right, DENY, expected);
    }

    private void doDelegatePartialRight(Account delegator, TargetType targetType, NamedEntry target, GranteeType delegateeType, NamedEntry delegatee, Result expectedHasDelegateRight) throws ServiceException {
        this.doTestDelegate(delegator, targetType, target, delegateeType, delegatee, TestACLGrant.getRight("test-preset-account"), ALLOW, expectedHasDelegateRight);
        this.doTestDelegate(delegator, targetType, target, delegateeType, delegatee, TestACLGrant.getRight("test-getAttrs-account"), ALLOW, expectedHasDelegateRight);
        this.doTestDelegate(delegator, targetType, target, delegateeType, delegatee, TestACLGrant.getRight("test-setAttrs-account"), ALLOW, expectedHasDelegateRight);
        this.doTestDelegate(delegator, targetType, target, delegateeType, delegatee, TestACLGrant.getRight(TestACLGrant.inlineRightGet(TargetType.account, "description")), ALLOW, expectedHasDelegateRight);
        this.doTestDelegate(delegator, targetType, target, delegateeType, delegatee, TestACLGrant.getRight(TestACLGrant.inlineRightSet(TargetType.account, "description")), ALLOW, expectedHasDelegateRight);
        Result expected = targetType == TargetType.domain || targetType == TargetType.global ? expectedHasDelegateRight : Result.INVALID_REQUEST;
        this.doTestDelegate(delegator, targetType, target, delegateeType, delegatee, TestACLGrant.getRight("test-preset-domain"), ALLOW, expected);
    }

    public void testDelegate() throws Exception {
        String testName = this.getTestName();
        Account sysAdmin = this.getSystemAdminAccount(TestACLGrant.getEmailAddr(testName, "authed"));
        Account GA_DELEGATOR = this.createAdminAccount(TestACLGrant.getEmailAddr(testName, "GA_DELEGATOR"));
        Account GA_DELEGATEE = this.createAdminAccount(TestACLGrant.getEmailAddr(testName, "GA_DELEGATEE"));
        DistributionList GG_DELEGATEE = this.createAdminGroup(TestACLGrant.getEmailAddr(testName, "GG_DELEGATEE"));
        String domainName = TestACLGrant.getSubDomainName(testName).toLowerCase();
        Domain TD = mProv.createDomain(domainName, new HashMap<String, Object>());
        Right right = TestACLGrant.getRight("test-combo-account-domain");
        this.grantDelegableRight(sysAdmin, TargetType.domain, TD, GranteeType.GT_USER, GA_DELEGATOR, right);
        DistributionList subTargetDl = this.createGroup("dl@" + domainName);
        Account subTargetAcct = this.createAccount("acct@" + domainName);
        Domain otherDomain = mProv.createDomain("other." + domainName, new HashMap<String, Object>());
        this.doTestDelegate(GA_DELEGATOR, TargetType.domain, TD, GranteeType.GT_USER, GA_DELEGATEE, right, Result.GOOD);
        this.doTestDelegate(GA_DELEGATOR, TargetType.domain, TD, GranteeType.GT_GROUP, GG_DELEGATEE, right, Result.GOOD);
        this.doTestDelegate(GA_DELEGATOR, TargetType.dl, subTargetDl, GranteeType.GT_USER, GA_DELEGATEE, right, Result.INVALID_REQUEST);
        this.doTestDelegate(GA_DELEGATOR, TargetType.dl, subTargetDl, GranteeType.GT_GROUP, GG_DELEGATEE, right, Result.INVALID_REQUEST);
        this.doTestDelegate(GA_DELEGATOR, TargetType.account, subTargetAcct, GranteeType.GT_USER, GA_DELEGATEE, right, Result.INVALID_REQUEST);
        this.doTestDelegate(GA_DELEGATOR, TargetType.account, subTargetAcct, GranteeType.GT_GROUP, GG_DELEGATEE, right, Result.INVALID_REQUEST);
        this.doTestDelegate(GA_DELEGATOR, TargetType.domain, otherDomain, GranteeType.GT_USER, GA_DELEGATEE, right, Result.PERM_DENIED);
        this.doTestDelegate(GA_DELEGATOR, TargetType.domain, otherDomain, GranteeType.GT_GROUP, GG_DELEGATEE, right, Result.PERM_DENIED);
        this.doTestDelegate(GA_DELEGATOR, TargetType.global, null, GranteeType.GT_USER, GA_DELEGATEE, right, Result.PERM_DENIED);
        this.doTestDelegate(GA_DELEGATOR, TargetType.global, null, GranteeType.GT_GROUP, GG_DELEGATEE, right, Result.PERM_DENIED);
        this.doDelegatePartialRight(GA_DELEGATOR, TargetType.domain, TD, GranteeType.GT_USER, GA_DELEGATEE, Result.GOOD);
        this.doDelegatePartialRight(GA_DELEGATOR, TargetType.domain, TD, GranteeType.GT_GROUP, GG_DELEGATEE, Result.GOOD);
        this.doDelegatePartialRight(GA_DELEGATOR, TargetType.dl, subTargetDl, GranteeType.GT_USER, GA_DELEGATEE, Result.GOOD);
        this.doDelegatePartialRight(GA_DELEGATOR, TargetType.dl, subTargetDl, GranteeType.GT_GROUP, GG_DELEGATEE, Result.GOOD);
        this.doDelegatePartialRight(GA_DELEGATOR, TargetType.account, subTargetAcct, GranteeType.GT_USER, GA_DELEGATEE, Result.GOOD);
        this.doDelegatePartialRight(GA_DELEGATOR, TargetType.account, subTargetAcct, GranteeType.GT_GROUP, GG_DELEGATEE, Result.GOOD);
        this.doDelegatePartialRight(GA_DELEGATOR, TargetType.domain, otherDomain, GranteeType.GT_USER, GA_DELEGATEE, Result.PERM_DENIED);
        this.doDelegatePartialRight(GA_DELEGATOR, TargetType.domain, otherDomain, GranteeType.GT_GROUP, GG_DELEGATEE, Result.PERM_DENIED);
        this.doDelegatePartialRight(GA_DELEGATOR, TargetType.global, otherDomain, GranteeType.GT_USER, GA_DELEGATEE, Result.PERM_DENIED);
        this.doDelegatePartialRight(GA_DELEGATOR, TargetType.global, otherDomain, GranteeType.GT_GROUP, GG_DELEGATEE, Result.PERM_DENIED);
    }

    public void testDelegateNonDelegableRight() throws Exception {
        String testName = this.getTestName();
        Account sysAdmin = this.getSystemAdminAccount(TestACLGrant.getEmailAddr(testName, "authed"));
        Account GA_DELEGATOR = this.createAdminAccount(TestACLGrant.getEmailAddr(testName, "GA_DELEGATOR"));
        Account GA_DELEGATEE = this.createAdminAccount(TestACLGrant.getEmailAddr(testName, "GA_DELEGATEE"));
        String domainName = TestACLGrant.getSubDomainName(testName).toLowerCase();
        Domain TD = mProv.createDomain(domainName, new HashMap<String, Object>());
        Right right = TestACLGrant.getRight("test-combo-account-domain");
        Right subRight = TestACLGrant.getRight("test-preset-account");
        Right anotherRight = TestACLGrant.getRight("test-preset-distributionlist");
        this.grantDelegableRight(sysAdmin, TargetType.domain, TD, GranteeType.GT_USER, GA_DELEGATOR, right);
        this.grantRight(sysAdmin, TargetType.domain, TD, GranteeType.GT_USER, GA_DELEGATOR, subRight, ALLOW);
        this.grantRight(sysAdmin, TargetType.domain, TD, GranteeType.GT_USER, GA_DELEGATOR, anotherRight, ALLOW);
        this.doTestDelegate(GA_DELEGATOR, TargetType.domain, TD, GranteeType.GT_USER, GA_DELEGATEE, right, Result.PERM_DENIED);
        this.doTestDelegate(GA_DELEGATOR, TargetType.domain, TD, GranteeType.GT_USER, GA_DELEGATEE, subRight, Result.PERM_DENIED);
        this.doTestDelegate(GA_DELEGATOR, TargetType.domain, TD, GranteeType.GT_USER, GA_DELEGATEE, anotherRight, Result.PERM_DENIED);
        this.doTestDelegate(GA_DELEGATOR, TargetType.domain, TD, GranteeType.GT_USER, GA_DELEGATEE, TestACLGrant.getRight("test-preset-domain"), Result.GOOD);
        this.doTestDelegate(GA_DELEGATOR, TargetType.domain, TD, GranteeType.GT_USER, GA_DELEGATEE, TestACLGrant.getRight(TestACLGrant.inlineRightGet(TargetType.account, "description")), Result.GOOD);
    }

    public void testDelegateToNonAdmin() throws Exception {
        String testName = this.getTestName();
        Account sysAdmin = this.getSystemAdminAccount(TestACLGrant.getEmailAddr(testName, "authed"));
        Account GA = this.createAccount(TestACLGrant.getEmailAddr(testName, "GA"));
        DistributionList GG = this.createGroup(TestACLGrant.getEmailAddr(testName, "GG"));
        Account member = this.createAccount(TestACLGrant.getEmailAddr(testName, "member"));
        mProv.addMembers(GG, new String[]{member.getName()});
        String domainName = TestACLGrant.getSubDomainName(testName).toLowerCase();
        Domain TD = mProv.createDomain(domainName, new HashMap<String, Object>());
        Account TA = this.createAccount("acct@" + domainName);
        Right right = TestACLGrant.getRight("test-combo-account-domain");
        this.doTestGrant(sysAdmin, TargetType.domain, TD, GranteeType.GT_USER, GA, right, DELEGABLE, Result.INVALID_REQUEST);
        this.doTestGrant(sysAdmin, TargetType.domain, TD, GranteeType.GT_GROUP, GG, right, DELEGABLE, Result.INVALID_REQUEST);
        this.doTestRevoke(sysAdmin, TargetType.domain, TD, GranteeType.GT_USER, GA, right, DELEGABLE, Result.GOOD);
        this.doTestRevoke(sysAdmin, TargetType.domain, TD, GranteeType.GT_GROUP, GG, right, DELEGABLE, Result.GOOD);
        this.makeAccountAdmin(GA);
        this.makeGroupAdmin(GG);
        this.grantDelegableRight(sysAdmin, TargetType.domain, TD, GranteeType.GT_USER, GA, right);
        this.grantDelegableRight(sysAdmin, TargetType.domain, TD, GranteeType.GT_GROUP, GG, right);
        this.verify(GA, (Entry)TA, TestACLGrant.getRight("test-preset-account"), null, ALLOW);
        this.verify(member, (Entry)TA, TestACLGrant.getRight("test-preset-account"), null, DENY);
        this.makeAccountAdmin(member);
        this.verify(member, (Entry)TA, TestACLGrant.getRight("test-preset-account"), null, ALLOW);
        this.makeGroupNonAdmin(GG);
        this.flushAccountCache(member);
        this.verify(member, (Entry)TA, TestACLGrant.getRight("test-preset-account"), null, DENY);
        this.makeGroupAdmin(GG);
        this.flushAccountCache(member);
        this.verify(member, (Entry)TA, TestACLGrant.getRight("test-preset-account"), null, ALLOW);
    }

    public static void main(String[] args) throws Exception {
        CliUtil.toolSetup("INFO");
        TestUtil.runTest(TestACLGrant.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Result {
        GOOD,
        INVALID_REQUEST,
        PERM_DENIED;

    }
}

