/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.qa.unittest;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.CliUtil;
import com.zimbra.common.util.SetUtil;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.AttributeClass;
import com.zimbra.cs.account.AttributeManager;
import com.zimbra.cs.account.DistributionList;
import com.zimbra.cs.account.accesscontrol.AllowedAttrs;
import com.zimbra.cs.account.accesscontrol.GranteeType;
import com.zimbra.cs.account.accesscontrol.Right;
import com.zimbra.cs.account.accesscontrol.TargetType;
import com.zimbra.qa.unittest.TestACL;
import com.zimbra.qa.unittest.TestUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class TestACLAttrRight
extends TestACL {
    static Right ATTR_RIGHT_GET_ALL;
    static Right ATTR_RIGHT_GET_SOME;
    static Right ATTR_RIGHT_SET_ALL;
    static Right ATTR_RIGHT_SET_SOME;
    static final Map<String, Object> ATTRS_SOME;
    static final AllowedAttrs EXPECTED_SOME;
    static final AllowedAttrs EXPECTED_SOME_EMPTY;
    static final AllowedAttrs EXPECTED_ALL_MINUS_SOME;
    static final Map<String, Object> ATTRS_SOME_MORE;

    public void oneGrantSome(TestACL.AllowOrDeny grant, TestACL.GetOrSet getOrSet, AllowedAttrs expected) throws Exception {
        String testName = "oneGrantSome-" + grant.name() + "-" + getOrSet.name();
        System.out.println("Testing " + testName);
        Account authedAcct = this.getSystemAdminAccount(TestACLAttrRight.getEmailAddr(testName, "authed"));
        Account GA = this.createAdminAccount(TestACLAttrRight.getEmailAddr(testName, "GA"));
        Right someRight = getOrSet.isGet() ? ATTR_RIGHT_GET_SOME : ATTR_RIGHT_SET_SOME;
        Account TA = mProv.createAccount(TestACLAttrRight.getEmailAddr(testName, "TA"), "test123", null);
        this.grantRight(authedAcct, TargetType.account, TA, GranteeType.GT_USER, GA, someRight, grant);
        this.verify(GA, TA, getOrSet, expected);
    }

    public void oneGrantAll(TestACL.AllowOrDeny grant, TestACL.GetOrSet getOrSet, AllowedAttrs expected) throws Exception {
        String testName = "oneGrantAll-" + grant.name() + "-" + getOrSet.name();
        System.out.println("Testing " + testName);
        Account authedAcct = this.getSystemAdminAccount(TestACLAttrRight.getEmailAddr(testName, "authed"));
        Account GA = this.createAdminAccount(TestACLAttrRight.getEmailAddr(testName, "GA"));
        Right allRight = getOrSet.isGet() ? ATTR_RIGHT_GET_ALL : ATTR_RIGHT_SET_ALL;
        Account TA = mProv.createAccount(TestACLAttrRight.getEmailAddr(testName, "TA"), "test123", null);
        this.grantRight(authedAcct, TargetType.account, TA, GranteeType.GT_USER, GA, allRight, grant);
        this.verify(GA, TA, getOrSet, expected);
    }

    private void someAllSameLevel(TestACL.AllowOrDeny some, TestACL.AllowOrDeny all, TestACL.GetOrSet getOrSet, AllowedAttrs expected) throws ServiceException {
        Right allRight;
        Right someRight;
        String testName = "someAllSameLevel-" + some.name() + "-some-" + all.name() + "-all-" + getOrSet.name();
        System.out.println("Testing " + testName);
        Account authedAcct = this.getSystemAdminAccount(TestACLAttrRight.getEmailAddr(testName, "authed"));
        Account GA = this.createAdminAccount(TestACLAttrRight.getEmailAddr(testName, "GA"));
        if (getOrSet.isGet()) {
            someRight = ATTR_RIGHT_GET_SOME;
            allRight = ATTR_RIGHT_GET_ALL;
        } else {
            someRight = ATTR_RIGHT_SET_SOME;
            allRight = ATTR_RIGHT_SET_ALL;
        }
        Account TA = mProv.createAccount(TestACLAttrRight.getEmailAddr(testName, "TA"), "test123", null);
        this.grantRight(authedAcct, TargetType.account, TA, GranteeType.GT_USER, GA, someRight, some);
        this.grantRight(authedAcct, TargetType.account, TA, GranteeType.GT_USER, GA, allRight, all);
        this.verify(GA, TA, getOrSet, expected);
    }

    public void someAllDiffLevel(TestACL.AllowOrDeny some, TestACL.AllowOrDeny all, boolean someIsCloser, TestACL.GetOrSet getOrSet, AllowedAttrs expected) throws Exception {
        Right allRight;
        Right someRight;
        String testName = "someAllDiffLevel-" + some.name() + "-some-" + all.name() + "-all-" + (someIsCloser ? "someIsCloser" : "allIsCloser") + "-" + getOrSet.name();
        System.out.println("Testing " + testName);
        Account authedAcct = this.getSystemAdminAccount(TestACLAttrRight.getEmailAddr(testName, "authed"));
        Account GA = this.createAdminAccount(TestACLAttrRight.getEmailAddr(testName, "GA"));
        DistributionList GG = this.createAdminGroup(TestACLAttrRight.getEmailAddr(testName, "GG"));
        mProv.addMembers(GG, new String[]{GA.getName()});
        if (getOrSet.isGet()) {
            someRight = ATTR_RIGHT_GET_SOME;
            allRight = ATTR_RIGHT_GET_ALL;
        } else {
            someRight = ATTR_RIGHT_SET_SOME;
            allRight = ATTR_RIGHT_SET_ALL;
        }
        Account TA = mProv.createAccount(TestACLAttrRight.getEmailAddr(testName, "TA"), "test123", null);
        if (someIsCloser) {
            this.grantRight(authedAcct, TargetType.account, TA, GranteeType.GT_USER, GA, someRight, some);
            this.grantRight(authedAcct, TargetType.account, TA, GranteeType.GT_GROUP, GG, allRight, all);
        } else {
            this.grantRight(authedAcct, TargetType.account, TA, GranteeType.GT_USER, GA, allRight, all);
            this.grantRight(authedAcct, TargetType.account, TA, GranteeType.GT_GROUP, GG, someRight, some);
        }
        this.verify(GA, TA, getOrSet, expected);
    }

    public void testOneGrantSome() throws Exception {
        this.oneGrantSome(ALLOW, SET, EXPECTED_SOME);
        this.oneGrantSome(DENY, SET, EXPECTED_SOME_EMPTY);
        this.oneGrantSome(ALLOW, GET, EXPECTED_SOME);
        this.oneGrantSome(DENY, GET, EXPECTED_SOME_EMPTY);
    }

    public void testOneGrantAll() throws Exception {
        this.oneGrantAll(ALLOW, SET, AllowedAttrs.ALLOW_ALL_ATTRS());
        this.oneGrantAll(DENY, SET, AllowedAttrs.DENY_ALL_ATTRS());
        this.oneGrantAll(ALLOW, GET, AllowedAttrs.ALLOW_ALL_ATTRS());
        this.oneGrantAll(DENY, GET, AllowedAttrs.DENY_ALL_ATTRS());
    }

    public void testTwoGrantsSameLevel() throws Exception {
        this.someAllSameLevel(ALLOW, ALLOW, SET, AllowedAttrs.ALLOW_ALL_ATTRS());
        this.someAllSameLevel(DENY, ALLOW, SET, EXPECTED_ALL_MINUS_SOME);
        this.someAllSameLevel(ALLOW, DENY, SET, AllowedAttrs.DENY_ALL_ATTRS());
        this.someAllSameLevel(DENY, DENY, SET, AllowedAttrs.DENY_ALL_ATTRS());
        this.someAllSameLevel(ALLOW, ALLOW, GET, AllowedAttrs.ALLOW_ALL_ATTRS());
        this.someAllSameLevel(DENY, ALLOW, GET, EXPECTED_ALL_MINUS_SOME);
        this.someAllSameLevel(ALLOW, DENY, GET, AllowedAttrs.DENY_ALL_ATTRS());
        this.someAllSameLevel(DENY, DENY, GET, AllowedAttrs.DENY_ALL_ATTRS());
    }

    public void testTwoGrantsDiffLevel() throws Exception {
        this.someAllDiffLevel(ALLOW, ALLOW, true, SET, AllowedAttrs.ALLOW_ALL_ATTRS());
        this.someAllDiffLevel(DENY, ALLOW, true, SET, EXPECTED_ALL_MINUS_SOME);
        this.someAllDiffLevel(ALLOW, DENY, true, SET, EXPECTED_SOME);
        this.someAllDiffLevel(DENY, DENY, true, SET, AllowedAttrs.DENY_ALL_ATTRS());
        this.someAllDiffLevel(ALLOW, ALLOW, false, SET, AllowedAttrs.ALLOW_ALL_ATTRS());
        this.someAllDiffLevel(DENY, ALLOW, false, SET, AllowedAttrs.ALLOW_ALL_ATTRS());
        this.someAllDiffLevel(ALLOW, DENY, false, SET, AllowedAttrs.DENY_ALL_ATTRS());
        this.someAllDiffLevel(DENY, DENY, false, SET, AllowedAttrs.DENY_ALL_ATTRS());
        this.someAllDiffLevel(ALLOW, ALLOW, true, GET, AllowedAttrs.ALLOW_ALL_ATTRS());
        this.someAllDiffLevel(DENY, ALLOW, true, GET, EXPECTED_ALL_MINUS_SOME);
        this.someAllDiffLevel(ALLOW, DENY, true, GET, EXPECTED_SOME);
        this.someAllDiffLevel(DENY, DENY, true, GET, AllowedAttrs.DENY_ALL_ATTRS());
        this.someAllDiffLevel(ALLOW, ALLOW, false, GET, AllowedAttrs.ALLOW_ALL_ATTRS());
        this.someAllDiffLevel(DENY, ALLOW, false, GET, AllowedAttrs.ALLOW_ALL_ATTRS());
        this.someAllDiffLevel(ALLOW, DENY, false, GET, AllowedAttrs.DENY_ALL_ATTRS());
        this.someAllDiffLevel(DENY, DENY, false, GET, AllowedAttrs.DENY_ALL_ATTRS());
    }

    public static void main(String[] args) throws Exception {
        CliUtil.toolSetup("INFO");
        TestUtil.runTest(TestACLAttrRight.class);
    }

    static {
        HashSet<String> EMPTY_SET = new HashSet<String>();
        ATTRS_SOME = new HashMap<String, Object>();
        ATTRS_SOME.put("zimbraMailQuota", "123");
        ATTRS_SOME.put("zimbraQuotaWarnPercent", "123");
        ATTRS_SOME.put("zimbraQuotaWarnInterval", "123");
        ATTRS_SOME.put("zimbraQuotaWarnMessage", "123");
        ATTRS_SOME_MORE = new HashMap<String, Object>(ATTRS_SOME);
        ATTRS_SOME_MORE.put("zimbraFeatureMailEnabled", "TRUE");
        ATTRS_SOME_MORE.put("zimbraFeatureCalendarEnabled", "TRUE");
        ATTRS_SOME_MORE.put("zimbraPrefLocale", "en-us");
        Set<String> ALL_ACCOUNT_ATTRS = null;
        try {
            ALL_ACCOUNT_ATTRS = AttributeManager.getInstance().getAllAttrsInClass(AttributeClass.account);
            ATTR_RIGHT_GET_ALL = TestACL.getRight("getAccount");
            ATTR_RIGHT_GET_SOME = TestACL.getRight("test-getAttrs-account-2");
            ATTR_RIGHT_SET_ALL = TestACL.getRight("modifyAccount");
            ATTR_RIGHT_SET_SOME = TestACL.getRight("test-setAttrs-account-2");
        }
        catch (ServiceException e) {
            System.exit(1);
        }
        Set<String> ALL_ACCOUNT_ATTRS_MINUS_SOME = SetUtil.subtract(ALL_ACCOUNT_ATTRS, ATTRS_SOME.keySet());
        EXPECTED_SOME = AllowedAttrs.ALLOW_SOME_ATTRS(ATTRS_SOME.keySet());
        EXPECTED_SOME_EMPTY = AllowedAttrs.ALLOW_SOME_ATTRS(EMPTY_SET);
        EXPECTED_ALL_MINUS_SOME = AllowedAttrs.ALLOW_SOME_ATTRS(ALL_ACCOUNT_ATTRS_MINUS_SOME);
    }
}

