/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.qa.unittest;

import com.zimbra.common.auth.ZAuthToken;
import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.common.util.CliUtil;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.AccessManager;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.AuthToken;
import com.zimbra.cs.account.AuthTokenException;
import com.zimbra.cs.account.DistributionList;
import com.zimbra.cs.account.Domain;
import com.zimbra.cs.account.Entry;
import com.zimbra.cs.account.NamedEntry;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.Zimlet;
import com.zimbra.cs.account.accesscontrol.ACLAccessManager;
import com.zimbra.cs.account.accesscontrol.ACLUtil;
import com.zimbra.cs.account.accesscontrol.AdminRight;
import com.zimbra.cs.account.accesscontrol.AllowedAttrs;
import com.zimbra.cs.account.accesscontrol.GranteeType;
import com.zimbra.cs.account.accesscontrol.Right;
import com.zimbra.cs.account.accesscontrol.RightBearer;
import com.zimbra.cs.account.accesscontrol.RightChecker;
import com.zimbra.cs.account.accesscontrol.RightCommand;
import com.zimbra.cs.account.accesscontrol.RightManager;
import com.zimbra.cs.account.accesscontrol.RightModifier;
import com.zimbra.cs.account.accesscontrol.Rights;
import com.zimbra.cs.account.accesscontrol.TargetType;
import com.zimbra.cs.account.accesscontrol.ZimbraACE;
import com.zimbra.cs.mailbox.ACL;
import com.zimbra.cs.service.AuthProvider;
import com.zimbra.qa.unittest.TestACLAttrRight;
import com.zimbra.qa.unittest.TestACLGrant;
import com.zimbra.qa.unittest.TestACLGrantee;
import com.zimbra.qa.unittest.TestACLPrecedence;
import com.zimbra.qa.unittest.TestACLRight;
import com.zimbra.qa.unittest.TestACLTarget;
import com.zimbra.qa.unittest.TestProvisioningUtil;
import com.zimbra.qa.unittest.TestUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletResponse;
import junit.framework.Assert;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TestACL
extends TestCase {
    protected static boolean CHECK_LIMIT = false;
    protected static final AccessManager mAM = AccessManager.getInstance();
    protected static final Provisioning mProv = Provisioning.getInstance();
    protected static final String TEST_ID = TestProvisioningUtil.genTestId();
    protected static final String DOMAIN_NAME = TestProvisioningUtil.baseDomainName("test-ACL", TEST_ID);
    protected static final String PASSWORD = "test123";
    protected static final Right USER_RIGHT = Rights.User.R_viewFreeBusy;
    protected static Right ADMIN_RIGHT_ACCOUNT;
    protected static Right ADMIN_RIGHT_CALENDAR_RESOURCE;
    protected static Right ADMIN_RIGHT_CONFIG;
    protected static Right ADMIN_RIGHT_COS;
    protected static Right ADMIN_RIGHT_DISTRIBUTION_LIST;
    protected static Right ADMIN_RIGHT_DOMAIN;
    protected static Right ADMIN_RIGHT_GLOBALGRANT;
    protected static Right ADMIN_RIGHT_SERVER;
    protected static Right ADMIN_RIGHT_ZIMLET;
    protected static Account mSysAdminAcct;
    protected static final AllowOrDeny ALLOW;
    protected static final AllowOrDeny DELEGABLE;
    protected static final AllowOrDeny DENY;
    protected static final AsAdmin AS_ADMIN;
    protected static final AsAdmin AS_USER;
    protected static final LimitOrNoLimit LIMIT;
    protected static final LimitOrNoLimit NOLIMIT;
    protected static final LimitOrNoLimit NULLLIMIT;
    protected static final GetOrSet GET;
    protected static final GetOrSet SET;
    static final boolean POSITIVE = false;
    static final boolean NEGATIVE = true;

    String getTestName() {
        String testName = this.getName();
        if (testName == null) {
            return "unknownTest";
        }
        return this.getName().substring(4);
    }

    static void logToConsole(String level) {
        ZimbraLog.toolSetupLog4j(level, "/Users/pshao/sandbox/conf/log4j.properties.phoebe");
    }

    protected static String getEmailAddr(String localPart) {
        return localPart + "@" + DOMAIN_NAME;
    }

    protected static String getEmailAddr(String testCaseName, String localPartPostfix) {
        if (testCaseName == null) {
            return localPartPostfix + "@" + DOMAIN_NAME;
        }
        return testCaseName + "-" + localPartPostfix + "@" + DOMAIN_NAME;
    }

    protected static String getSubDomainName(String testCaseName) {
        return testCaseName + "." + DOMAIN_NAME;
    }

    protected Account guestAccount(String email, String password) {
        return new ACL.GuestAccount(email, password);
    }

    protected Account keyAccount(String name, String accesKey) {
        KeyAuthToken authToken = new KeyAuthToken(name, accesKey);
        return new ACL.GuestAccount(authToken);
    }

    protected Account anonAccount() {
        return ACL.ANONYMOUS_ACCT;
    }

    protected Account createAccount(String email) throws ServiceException {
        return mProv.createAccount(email, PASSWORD, null);
    }

    protected DistributionList createGroup(String email) throws ServiceException {
        return mProv.createDistributionList(email, new HashMap<String, Object>());
    }

    protected Account createAdminAccount(String email) throws ServiceException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        attrs.put("zimbraIsAdminAccount", "TRUE");
        return mProv.createAccount(email, PASSWORD, attrs);
    }

    protected DistributionList createAdminGroup(String email) throws ServiceException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        attrs.put("zimbraIsAdminGroup", "TRUE");
        return mProv.createDistributionList(email, attrs);
    }

    protected void flushAccountCache(Account acct) throws ServiceException {
        mProv.flushCache(Provisioning.CacheEntryType.account, new Provisioning.CacheEntry[]{new Provisioning.CacheEntry(Provisioning.CacheEntryBy.id, acct.getId())});
    }

    protected void makeAccountAdmin(Account acct) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraIsAdminAccount", "TRUE");
        mProv.modifyAttrs(acct, attrs);
        this.flushAccountCache(acct);
    }

    protected void makeGroupAdmin(DistributionList group) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraIsAdminGroup", "TRUE");
        mProv.modifyAttrs(group, attrs);
        mProv.flushCache(Provisioning.CacheEntryType.group, null);
    }

    protected void makeGroupNonAdmin(DistributionList group) throws ServiceException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("zimbraIsAdminGroup", "FALSE");
        mProv.modifyAttrs(group, attrs);
        mProv.flushCache(Provisioning.CacheEntryType.group, null);
    }

    protected Account getSystemAdminAccount(String email) throws ServiceException {
        return this.getSystemAdminAccount();
    }

    protected Account getSystemAdminAccount() throws ServiceException {
        return mSysAdminAcct;
    }

    protected ZimbraACE newPubACE(Right right, AllowOrDeny allowDeny) throws ServiceException {
        return new ZimbraACE("99999999-9999-9999-9999-999999999999", GranteeType.GT_PUBLIC, right, allowDeny.toRightModifier(), null);
    }

    protected ZimbraACE newAllACE(Right right, AllowOrDeny allowDeny) throws ServiceException {
        return new ZimbraACE("00000000-0000-0000-0000-000000000000", GranteeType.GT_AUTHUSER, right, allowDeny.toRightModifier(), null);
    }

    protected ZimbraACE newUsrACE(Account acct, Right right, AllowOrDeny allowDeny) throws ServiceException {
        return new ZimbraACE(acct.getId(), GranteeType.GT_USER, right, allowDeny.toRightModifier(), null);
    }

    protected ZimbraACE newGrpACE(DistributionList dl, Right right, AllowOrDeny allowDeny) throws ServiceException {
        return new ZimbraACE(dl.getId(), GranteeType.GT_GROUP, right, allowDeny.toRightModifier(), null);
    }

    protected ZimbraACE newKeyACE(String nameOrEmail, String accessKey, Right right, AllowOrDeny allowDeny) throws ServiceException {
        return new ZimbraACE(nameOrEmail, GranteeType.GT_KEY, right, allowDeny.toRightModifier(), accessKey);
    }

    Set<ZimbraACE> makeUsrGrant(Account grantee, Right right, AllowOrDeny alloworDeny) throws ServiceException {
        HashSet<ZimbraACE> aces = new HashSet<ZimbraACE>();
        aces.add(this.newUsrACE(grantee, right, alloworDeny));
        return aces;
    }

    Set<ZimbraACE> makeGrpGrant(DistributionList grantee, Right right, AllowOrDeny alloworDeny) throws ServiceException {
        HashSet<ZimbraACE> aces = new HashSet<ZimbraACE>();
        aces.add(this.newGrpACE(grantee, right, alloworDeny));
        return aces;
    }

    protected void verify(Account grantee, Entry target, Right right, AllowOrDeny expected, AccessManager.ViaGrant expectedVia) throws Exception {
        this.verify(grantee, target, right, AS_USER, expected, expectedVia);
    }

    protected void verifyDefinedDefault(Account grantee, Entry target, Right right) throws Exception {
        if (right == Rights.User.R_invite || right == Rights.User.R_viewFreeBusy) {
            this.verify(grantee, target, right, AS_USER, ALLOW, null);
        } else {
            this.verify(grantee, target, right, AS_USER, DENY, null);
        }
    }

    protected void verifyDefault(Account grantee, Entry target, Right right) throws Exception {
    }

    void assertEquals(AccessManager.ViaGrant expected, AccessManager.ViaGrant actual) {
        if (expected == null && actual == null) {
            return;
        }
        if (!(AccessManager.getInstance() instanceof ACLAccessManager)) {
            return;
        }
        if (expected instanceof TodoViaGrant) {
            return;
        }
        ((TestViaGrant)expected).verify(actual);
    }

    protected void verify(Account grantee, Entry target, Right right, AsAdmin asAdmin, AllowOrDeny expected, AccessManager.ViaGrant expectedVia) throws Exception {
        AccessManager.ViaGrant via = expectedVia == null ? null : new AccessManager.ViaGrant();
        boolean result = mAM.canDo(grantee == null ? null : grantee, target, right, asAdmin.yes(), via);
        TestACL.assertEquals((boolean)expected.allow(), (boolean)result);
        this.assertEquals(expectedVia, via);
        via = expectedVia == null ? null : new AccessManager.ViaGrant();
        result = mAM.canDo(grantee == null ? null : AuthProvider.getAuthToken(grantee), target, right, asAdmin.yes(), via);
        TestACL.assertEquals((boolean)expected.allow(), (boolean)result);
        this.assertEquals(expectedVia, via);
        via = expectedVia == null ? null : new AccessManager.ViaGrant();
        result = mAM.canDo(grantee == null ? null : grantee.getName(), target, right, asAdmin.yes(), via);
        if (grantee instanceof ACL.GuestAccount && ((ACL.GuestAccount)grantee).getAccessKey() != null) {
            return;
        }
        TestACL.assertEquals((boolean)expected.allow(), (boolean)result);
        this.assertEquals(expectedVia, via);
    }

    void assertEquals(Set<String> expected, Set<String> actual) {
        TestACL.assertEquals((int)expected.size(), (int)actual.size());
        for (String s : expected) {
            TestACL.assertTrue((boolean)actual.contains(s));
        }
    }

    void assertEquals(AllowedAttrs expected, AllowedAttrs actual) {
        TestACL.assertEquals((Object)((Object)expected.getResult()), (Object)((Object)actual.getResult()));
        if (actual.getResult() == AllowedAttrs.Result.ALLOW_SOME) {
            this.assertEquals(expected.getAllowed(), actual.getAllowed());
        }
    }

    protected void verify(Account grantee, Entry target, GetOrSet getOrSet, AllowedAttrs expected) {
        try {
            AllowedAttrs allowedAttrs = getOrSet.isGet() ? RightChecker.accessibleAttrs(new RightBearer.Grantee(grantee), target, AdminRight.PR_GET_ATTRS, false) : RightChecker.accessibleAttrs(new RightBearer.Grantee(grantee), target, AdminRight.PR_SET_ATTRS, false);
            this.assertEquals(expected, allowedAttrs);
        }
        catch (ServiceException e) {
            TestACL.fail();
        }
    }

    protected void verify(Account grantee, Entry target, Right right, Map<String, Object> attrs, AllowOrDeny expected) throws ServiceException {
        boolean actual = mAM.canPerform(grantee, target, right, false, attrs, true, null);
        TestACL.assertEquals((boolean)expected.allow(), (boolean)actual);
    }

    protected List<ZimbraACE> grantRight(TargetType targetType, Entry target, Set<ZimbraACE> aces) throws ServiceException {
        Entry targetEntry;
        for (ZimbraACE ace : aces) {
            TestACL.assertTrue((boolean)ace.getRight().isUserRight());
        }
        if (target instanceof Zimlet) {
            String targetName = ((Zimlet)target).getName();
            targetEntry = TargetType.lookupTarget(mProv, targetType, Provisioning.TargetBy.name, targetName);
        } else {
            String targetId = target instanceof NamedEntry ? ((NamedEntry)target).getId() : null;
            targetEntry = TargetType.lookupTarget(mProv, targetType, Provisioning.TargetBy.id, targetId);
        }
        return ACLUtil.grantRight(mProv, targetEntry, aces);
    }

    protected void grantRight(Account authedAcct, TargetType targetType, NamedEntry target, GranteeType granteeType, NamedEntry grantee, Right right, AllowOrDeny grant) throws ServiceException {
        RightCommand.grantRight(mProv, authedAcct, targetType.getCode(), Provisioning.TargetBy.name, target == null ? null : target.getName(), granteeType.getCode(), Provisioning.GranteeBy.name, grantee.getName(), right.getName(), grant.toRightModifier());
    }

    protected void grantDelegableRight(Account authedAcct, TargetType targetType, NamedEntry target, GranteeType granteeType, NamedEntry grantee, Right right) throws ServiceException {
        RightCommand.grantRight(mProv, authedAcct, targetType.getCode(), Provisioning.TargetBy.name, target == null ? null : target.getName(), granteeType.getCode(), Provisioning.GranteeBy.name, grantee.getName(), right.getName(), RightModifier.RM_CAN_DELEGATE);
    }

    protected List<ZimbraACE> revokeRight(TargetType targetType, Entry target, Set<ZimbraACE> aces) throws ServiceException {
        Entry targetEntry;
        if (target instanceof Zimlet) {
            String targetName = ((Zimlet)target).getName();
            targetEntry = TargetType.lookupTarget(mProv, targetType, Provisioning.TargetBy.name, targetName);
        } else {
            String targetId = target instanceof NamedEntry ? ((NamedEntry)target).getId() : null;
            targetEntry = TargetType.lookupTarget(mProv, targetType, Provisioning.TargetBy.id, targetId);
        }
        return ACLUtil.revokeRight(mProv, targetEntry, aces);
    }

    protected void revokeRight(Account authedAcct, TargetType targetType, NamedEntry target, GranteeType granteeType, NamedEntry grantee, Right right, AllowOrDeny grant) throws ServiceException {
        RightCommand.revokeRight(mProv, authedAcct, targetType.getCode(), Provisioning.TargetBy.name, target == null ? null : target.getName(), granteeType.getCode(), Provisioning.GranteeBy.name, grantee.getName(), right.getName(), grant.toRightModifier());
    }

    protected void revokeDelegableRight(Account authedAcct, TargetType targetType, NamedEntry target, GranteeType granteeType, NamedEntry grantee, Right right) throws ServiceException {
        RightCommand.revokeRight(mProv, authedAcct, targetType.getCode(), Provisioning.TargetBy.name, target == null ? null : target.getName(), granteeType.getCode(), Provisioning.GranteeBy.name, grantee.getName(), right.getName(), RightModifier.RM_CAN_DELEGATE);
    }

    static Right getRight(String right) throws ServiceException {
        return RightManager.getInstance().getRight(right);
    }

    static String inlineRightGet(TargetType targetType, String attrName) {
        return "get." + targetType.getCode() + "." + attrName;
    }

    static String inlineRightSet(TargetType targetType, String attrName) {
        return "set." + targetType.getCode() + "." + attrName;
    }

    protected void cleanupGrants() throws ServiceException {
        Account sysAdmin = this.getSystemAdminAccount();
    }

    public static void main(String[] args) throws Exception {
        CliUtil.toolSetup("INFO");
        TestUtil.runTest(TestACLGrantee.class);
        TestUtil.runTest(TestACLPrecedence.class);
        if (mAM instanceof ACLAccessManager) {
            TestUtil.runTest(TestACLTarget.class);
            TestUtil.runTest(TestACLAttrRight.class);
            TestUtil.runTest(TestACLRight.class);
            TestUtil.runTest(TestACLGrant.class);
        }
    }

    static {
        System.out.println();
        System.out.println("AccessManager: " + mAM.getClass().getName());
        System.out.println();
        try {
            Domain domain = mProv.createDomain(DOMAIN_NAME, new HashMap<String, Object>());
            HashMap<String, Object> attrs = new HashMap<String, Object>();
            attrs.put("zimbraIsAdminAccount", "TRUE");
            String sysAdminEmail = TestACL.getEmailAddr("sysadmin");
            mSysAdminAcct = mProv.createAccount(sysAdminEmail, PASSWORD, attrs);
            ADMIN_RIGHT_ACCOUNT = TestACL.getRight("test-preset-account");
            ADMIN_RIGHT_CALENDAR_RESOURCE = TestACL.getRight("test-preset-calendarresource");
            ADMIN_RIGHT_CONFIG = TestACL.getRight("test-preset-globalconfig");
            ADMIN_RIGHT_COS = TestACL.getRight("test-preset-cos");
            ADMIN_RIGHT_DISTRIBUTION_LIST = TestACL.getRight("test-preset-distributionlist");
            ADMIN_RIGHT_DOMAIN = TestACL.getRight("test-preset-domain");
            ADMIN_RIGHT_GLOBALGRANT = TestACL.getRight("test-preset-globalgrant");
            ADMIN_RIGHT_SERVER = TestACL.getRight("test-preset-server");
            ADMIN_RIGHT_ZIMLET = TestACL.getRight("test-preset-zimlet");
        }
        catch (ServiceException e) {
            e.printStackTrace();
            TestACL.fail();
        }
        ALLOW = AllowOrDeny.ALLOW;
        DELEGABLE = AllowOrDeny.DELEGABLE;
        DENY = AllowOrDeny.DENY;
        AS_ADMIN = AsAdmin.AS_ADMIN;
        AS_USER = AsAdmin.AS_USER;
        LIMIT = LimitOrNoLimit.LIMIT;
        NOLIMIT = LimitOrNoLimit.NOLIMIT;
        NULLLIMIT = LimitOrNoLimit.NULLLIMIT;
        GET = GetOrSet.GET;
        SET = GetOrSet.SET;
    }

    static class TodoViaGrant
    extends AccessManager.ViaGrant {
        TodoViaGrant() {
        }
    }

    static class PubViaGrant
    extends TestViaGrant {
        PubViaGrant(TargetType targetType, Entry target, Right right, boolean isNegativeGrant) {
            super(targetType, target, GranteeType.GT_PUBLIC, null, right, isNegativeGrant);
        }
    }

    static class AuthUserViaGrant
    extends TestViaGrant {
        AuthUserViaGrant(TargetType targetType, Entry target, Right right, boolean isNegativeGrant) {
            super(targetType, target, GranteeType.GT_AUTHUSER, null, right, isNegativeGrant);
        }
    }

    static class TestViaGrant
    extends AccessManager.ViaGrant {
        String mTargetType;
        String mTargetName;
        String mGranteeType;
        String mGranteeName;
        String mRight;
        boolean mIsNegativeGrant;
        Set<TestViaGrant> mCanAlsoVia;

        TestViaGrant(TargetType targetType, Entry target, GranteeType granteeType, String granteeName, Right right, boolean isNegativeGrant) {
            this.mTargetType = targetType.getCode();
            this.mTargetName = target.getLabel();
            this.mGranteeType = granteeType.getCode();
            this.mGranteeName = granteeName;
            this.mRight = right.getName();
            this.mIsNegativeGrant = isNegativeGrant;
        }

        public String getTargetType() {
            return this.mTargetType;
        }

        public String getTargetName() {
            return this.mTargetName;
        }

        public String getGranteeType() {
            return this.mGranteeType;
        }

        public String getGranteeName() {
            return this.mGranteeName;
        }

        public String getRight() {
            return this.mRight;
        }

        public boolean isNegativeGrant() {
            return this.mIsNegativeGrant;
        }

        public void addCanAlsoVia(TestViaGrant canAlsoVia) {
            if (this.mCanAlsoVia == null) {
                this.mCanAlsoVia = new HashSet<TestViaGrant>();
            }
            this.mCanAlsoVia.add(canAlsoVia);
        }

        public void verify(AccessManager.ViaGrant actual) {
            try {
                Assert.assertEquals((String)this.getTargetType(), (String)actual.getTargetType());
                Assert.assertEquals((String)this.getTargetName(), (String)actual.getTargetName());
                Assert.assertEquals((String)this.getGranteeType(), (String)actual.getGranteeType());
                Assert.assertEquals((String)this.getGranteeName(), (String)actual.getGranteeName());
                Assert.assertEquals((String)this.getRight(), (String)actual.getRight());
                Assert.assertEquals((boolean)this.isNegativeGrant(), (boolean)actual.isNegativeGrant());
            }
            catch (AssertionFailedError e) {
                if (this.mCanAlsoVia == null) {
                    throw e;
                }
                for (TestViaGrant canAlsoVia : this.mCanAlsoVia) {
                    try {
                        canAlsoVia.verify(actual);
                        return;
                    }
                    catch (AssertionFailedError eAlso) {
                    }
                }
                throw e;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum GetOrSet {
        GET(true),
        SET(false);

        boolean mGet;

        private GetOrSet(boolean get) {
            this.mGet = get;
        }

        boolean isGet() {
            return this.mGet;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum LimitOrNoLimit {
        LIMIT(true),
        NOLIMIT(false),
        NULLLIMIT(false);

        boolean mLimit;

        private LimitOrNoLimit(boolean limit) {
            this.mLimit = limit;
        }

        boolean limit() {
            if (!CHECK_LIMIT) {
                return false;
            }
            if (this == NULLLIMIT) {
                Assert.fail();
            }
            return this.mLimit;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum AsAdmin {
        AS_ADMIN(true),
        AS_USER(false);

        boolean mAsAdmin;

        private AsAdmin(boolean asAdmin) {
            this.mAsAdmin = asAdmin;
        }

        boolean yes() {
            return this.mAsAdmin;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum AllowOrDeny {
        ALLOW(true, false),
        DELEGABLE(true, true),
        DENY(false, false);

        boolean mAllow;
        boolean mDelegable;

        private AllowOrDeny(boolean allow, boolean delegable) {
            this.mAllow = allow;
            this.mDelegable = delegable;
        }

        boolean deny() {
            return !this.mAllow;
        }

        boolean allow() {
            return this.mAllow;
        }

        boolean delegable() {
            return this.mDelegable;
        }

        RightModifier toRightModifier() {
            if (this.deny()) {
                return RightModifier.RM_DENY;
            }
            if (this.delegable()) {
                return RightModifier.RM_CAN_DELEGATE;
            }
            return null;
        }
    }

    protected class KeyAuthToken
    extends AuthToken {
        private String mName;
        private String mAccessKey;

        KeyAuthToken(String name, String accessKey) {
            this.mName = name;
            this.mAccessKey = accessKey;
        }

        public void encode(HttpClient client, HttpMethod method, boolean isAdminReq, String cookieDomain) throws ServiceException {
        }

        public void encode(HttpState state, boolean isAdminReq, String cookieDomain) throws ServiceException {
        }

        public void encode(HttpServletResponse resp, boolean isAdminReq, boolean secureCookie) throws ServiceException {
        }

        public void encodeAuthResp(Element parent, boolean isAdmin) throws ServiceException {
        }

        public String getAccountId() {
            return null;
        }

        public String getAdminAccountId() {
            return null;
        }

        public String getCrumb() throws AuthTokenException {
            return null;
        }

        public String getDigest() {
            return null;
        }

        public String getEncoded() throws AuthTokenException {
            return null;
        }

        public long getExpires() {
            return 0L;
        }

        public String getExternalUserEmail() {
            return this.mName;
        }

        public boolean isAdmin() {
            return false;
        }

        public boolean isDomainAdmin() {
            return false;
        }

        public boolean isDelegatedAdmin() {
            return false;
        }

        public boolean isExpired() {
            return false;
        }

        public boolean isZimbraUser() {
            return false;
        }

        public String toString() {
            return null;
        }

        public ZAuthToken toZAuthToken() throws ServiceException {
            return null;
        }

        public String getAccessKey() {
            return this.mAccessKey;
        }
    }
}

