/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.qa.unittest;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.StringUtil;
import com.zimbra.cs.util.JMSession;
import com.zimbra.qa.unittest.TestUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Date;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.util.ByteArrayDataSource;

public class MessageBuilder {
    private String mSubject;
    private String mSender;
    private String mRecipient;
    private String mBody;
    private Date mDate;
    private String mContentType;
    private Object mAttachment;
    private String mAttachmentFilename;
    private String mAttachmentContentType;
    static String DEFAULT_MESSAGE_BODY = "Dude,\r\n\r\nAll I need are some tasty waves, a cool buzz, and I'm fine.\r\n\r\nJeff";

    public MessageBuilder withSubject(String subject) {
        this.mSubject = subject;
        return this;
    }

    public MessageBuilder withSender(String sender) {
        this.mSender = sender;
        return this;
    }

    public MessageBuilder withRecipient(String recipient) {
        this.mRecipient = recipient;
        return this;
    }

    public MessageBuilder withBody(String body) {
        this.mBody = body;
        return this;
    }

    public MessageBuilder withDate(Date date) {
        this.mDate = date;
        return this;
    }

    public MessageBuilder withContentType(String contentType) {
        this.mContentType = contentType;
        return this;
    }

    public MessageBuilder withAttachment(Object content, String filename, String contentType) {
        if (content == null) {
            throw new IllegalArgumentException("content cannot be null");
        }
        if (StringUtil.isNullOrEmpty(contentType)) {
            throw new IllegalArgumentException("contentType cannot be null or empty");
        }
        if (StringUtil.isNullOrEmpty(filename)) {
            throw new IllegalArgumentException("filename cannot be null or empty");
        }
        this.mAttachment = content;
        this.mAttachmentFilename = filename;
        this.mAttachmentContentType = contentType;
        return this;
    }

    public String create() throws MessagingException, ServiceException, IOException {
        if (this.mRecipient == null) {
            this.mRecipient = "user1";
        }
        if (this.mSender == null) {
            this.mSender = "jspiccoli";
        }
        if (this.mDate == null) {
            this.mDate = new Date();
        }
        if (this.mContentType == null) {
            this.mContentType = "text/plain";
        }
        if (this.mBody == null) {
            this.mBody = DEFAULT_MESSAGE_BODY;
        }
        this.mSender = TestUtil.addDomainIfNecessary(this.mSender);
        this.mRecipient = TestUtil.addDomainIfNecessary(this.mRecipient);
        MimeMessageWithNoId msg = new MimeMessageWithNoId();
        msg.setRecipient(MimeMessage.RecipientType.TO, (Address)new InternetAddress(this.mRecipient));
        msg.setFrom((Address)new InternetAddress(this.mSender));
        msg.setSentDate(this.mDate);
        msg.setSubject(this.mSubject);
        if (this.mAttachment == null) {
            msg.setDataHandler(new DataHandler((DataSource)new ByteArrayDataSource(this.mBody.getBytes(), this.mContentType)));
        } else {
            MimeMultipart multi = new MimeMultipart("mixed");
            MimeBodyPart body = new MimeBodyPart();
            body.setDataHandler(new DataHandler((DataSource)new ByteArrayDataSource(this.mBody.getBytes(), this.mContentType)));
            multi.addBodyPart((BodyPart)body);
            MimeBodyPart attachment = new MimeBodyPart();
            attachment.setContent(this.mAttachment, this.mAttachmentContentType);
            attachment.setDisposition("attachment; filename=" + this.mAttachmentFilename);
            multi.addBodyPart((BodyPart)attachment);
            msg.setContent((Multipart)multi);
        }
        msg.removeHeader("Message-ID");
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        msg.writeTo(out);
        return new String(out.toByteArray());
    }

    public static void main(String[] args) throws Exception {
        TestUtil.cliSetup();
        System.out.println(new MessageBuilder().withSubject("attachment test").withAttachment("attachment", "test.txt", "text/plain").create());
    }

    private class MimeMessageWithNoId
    extends MimeMessage {
        private MimeMessageWithNoId() throws MessagingException {
            super(JMSession.getSession());
        }

        protected void updateMessageID() throws MessagingException {
            this.removeHeader("Message-ID");
        }
    }
}

