/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.perf.chart;

import com.zimbra.common.soap.Element;
import com.zimbra.perf.chart.ChartSettings;
import com.zimbra.perf.chart.GroupPlotSettings;
import com.zimbra.perf.chart.PlotSettings;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.io.SAXReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLChartConfig {
    public static final String E_CHARTS = "charts";
    public static final String E_CHART = "chart";
    public static final String E_PLOT = "plot";
    public static final String E_GROUP_PLOT = "groupplot";
    public static final String A_CHART_TITLE = "title";
    public static final String A_CHART_CATEGORY = "category";
    public static final String A_CHART_OUTFILE = "outfile";
    public static final String A_CHART_XAXIS = "xAxis";
    public static final String A_CHART_YAXIS = "yAxis";
    public static final String A_CHART_ALLOW_LOG_SCALE = "allowLogScale";
    public static final String A_CHART_PLOT_ZERO = "plotZero";
    public static final String A_CHART_WIDTH = "width";
    public static final String A_CHART_HEIGHT = "height";
    public static final String A_CHART_DOCUMENT = "outDocument";
    public static final String A_CHART_TOP_PLOTS = "topPlots";
    public static final String A_CHART_TOP_PLOTS_TYPE = "topPlotsType";
    public static final String A_PLOT_LEGEND = "legend";
    public static final String A_PLOT_INFILE = "infile";
    public static final String A_PLOT_DATA_COLUMN = "data";
    public static final String A_PLOT_SHOW_RAW = "showRaw";
    public static final String A_PLOT_SHOW_MOVING_AVG = "showMovingAvg";
    public static final String A_PLOT_MOVING_AVG_POINTS = "movingAvgPoints";
    public static final String A_PLOT_MULTIPLIER = "multiplier";
    public static final String A_PLOT_DIVISOR = "divisor";
    public static final String A_PLOT_NON_NEGATIVE = "nonNegative";
    public static final String A_PLOT_PERCENT_TIME = "percentTime";
    public static final String A_PLOT_DATA_FUNCTION = "dataFunction";
    public static final String A_PLOT_AGGREGATE_FUNCTION = "aggregateFunction";
    public static final String A_PLOT_OPTIONAL = "optional";
    public static final String A_PLOT_RATIO_TOP = "ratioTop";
    public static final String A_PLOT_RATIO_BOTTOM = "ratioBottom";
    public static final String A_PLOT_GROUP_BY = "groupBy";
    public static final String A_PLOT_IGNORE = "ignore";

    private static String getAttr(org.dom4j.Element elem, String name) throws DocumentException {
        String val = elem.attributeValue(name, null);
        if (val != null) {
            return val;
        }
        throw new DocumentException("Missing required attribute " + name + " in element " + elem.getName());
    }

    private static String getAttr(org.dom4j.Element elem, String name, String defaultValue) {
        String val = elem.attributeValue(name, null);
        if (val != null) {
            return val;
        }
        return defaultValue;
    }

    private static String getInheritedAttr(org.dom4j.Element elem, String name, String defaultValue) {
        String val = null;
        for (org.dom4j.Element e = elem; val == null && e != null; e = e.getParent()) {
            val = e.attributeValue(name, null);
        }
        return val != null ? val : defaultValue;
    }

    private static Boolean getInheritedAttrBoolean(org.dom4j.Element elem, String name, boolean defaultValue) {
        String val = XMLChartConfig.getInheritedAttr(elem, name, null);
        if (val != null) {
            return (val = val.toLowerCase()).equalsIgnoreCase("true") || val.equals("1");
        }
        return defaultValue;
    }

    private static int getInheritedAttrInt(org.dom4j.Element elem, String name, int defaultValue) throws DocumentException {
        String val = XMLChartConfig.getInheritedAttr(elem, name, null);
        if (val != null) {
            try {
                int i = Integer.parseInt(val);
                return i;
            }
            catch (NumberFormatException ex) {
                throw new DocumentException("Invalid integer value " + val + " for attribute " + name + " in element " + elem.getName());
            }
        }
        return defaultValue;
    }

    private static double getInheritedAttrDouble(org.dom4j.Element elem, String name, double defaultValue) throws DocumentException {
        String val = XMLChartConfig.getInheritedAttr(elem, name, null);
        if (val != null) {
            int len = val.length();
            if (len == 0) {
                return defaultValue;
            }
            char unit = val.toLowerCase().charAt(len - 1);
            int multiplier = 1;
            if (unit == 'k') {
                multiplier = 1024;
            } else if (unit == 'm') {
                multiplier = 0x100000;
            } else if (unit == 'g') {
                multiplier = 0x40000000;
            }
            String digits = multiplier == 1 ? val : val.substring(0, len - 1);
            try {
                double d = Double.parseDouble(digits);
                return d * (double)multiplier;
            }
            catch (NumberFormatException ex) {
                throw new DocumentException("Invalid double value " + val + " for attribute " + name + " in element " + elem.getName());
            }
        }
        return defaultValue;
    }

    public static List<ChartSettings> load(File xmlFile) throws IOException, DocumentException {
        ArrayList<ChartSettings> charts = new ArrayList<ChartSettings>();
        SAXReader reader = Element.getSAXReader();
        Document document = reader.read(xmlFile);
        org.dom4j.Element chartsElem = document.getRootElement();
        if (!chartsElem.getName().equals(E_CHARTS)) {
            throw new DocumentException("Missing <charts> root element");
        }
        Iterator iter = chartsElem.elementIterator(E_CHART);
        while (iter.hasNext()) {
            String dataCol;
            org.dom4j.Element plotElem;
            org.dom4j.Element chartElem = (org.dom4j.Element)iter.next();
            String chartTitle = XMLChartConfig.getAttr(chartElem, A_CHART_TITLE);
            String category = XMLChartConfig.getAttr(chartElem, A_CHART_CATEGORY, "unknown");
            String outfile = XMLChartConfig.getAttr(chartElem, A_CHART_OUTFILE);
            String xAxis = XMLChartConfig.getInheritedAttr(chartElem, A_CHART_XAXIS, "Time");
            String yAxis = XMLChartConfig.getInheritedAttr(chartElem, A_CHART_YAXIS, "");
            boolean allowLogScale = XMLChartConfig.getInheritedAttrBoolean(chartElem, A_CHART_ALLOW_LOG_SCALE, true);
            boolean plotZero = XMLChartConfig.getInheritedAttrBoolean(chartElem, A_CHART_PLOT_ZERO, false);
            if (!allowLogScale) {
                plotZero = true;
            }
            int width = XMLChartConfig.getInheritedAttrInt(chartElem, A_CHART_WIDTH, 1200);
            int height = XMLChartConfig.getInheritedAttrInt(chartElem, A_CHART_HEIGHT, 200);
            String outDoc = XMLChartConfig.getAttr(chartElem, A_CHART_DOCUMENT, null);
            String topPlotStr = XMLChartConfig.getAttr(chartElem, A_CHART_TOP_PLOTS, null);
            int topPlots = -1;
            if (topPlotStr != null) {
                topPlots = Integer.parseInt(topPlotStr);
            }
            topPlotStr = XMLChartConfig.getAttr(chartElem, A_CHART_TOP_PLOTS_TYPE, "max");
            ChartSettings.TopPlotsType topPlotsType = ChartSettings.TopPlotsType.valueOf(topPlotStr.toUpperCase());
            ChartSettings chart = new ChartSettings(chartTitle, category, outfile, xAxis, yAxis, allowLogScale, plotZero, width, height, outDoc, topPlots, topPlotsType);
            Iterator plotIter = chartElem.elementIterator(E_PLOT);
            while (plotIter.hasNext()) {
                plotElem = (org.dom4j.Element)plotIter.next();
                dataCol = XMLChartConfig.getAttr(plotElem, A_PLOT_DATA_COLUMN, null);
                String legend = XMLChartConfig.getInheritedAttr(plotElem, A_PLOT_LEGEND, null);
                String infile = XMLChartConfig.getInheritedAttr(plotElem, A_PLOT_INFILE, null);
                boolean showRaw = XMLChartConfig.getInheritedAttrBoolean(plotElem, A_PLOT_SHOW_RAW, true);
                boolean showMovingAvg = XMLChartConfig.getInheritedAttrBoolean(plotElem, A_PLOT_SHOW_MOVING_AVG, false);
                int movingAvgPoints = XMLChartConfig.getInheritedAttrInt(plotElem, A_PLOT_MOVING_AVG_POINTS, -1);
                double multiplier = XMLChartConfig.getInheritedAttrDouble(plotElem, A_PLOT_MULTIPLIER, 1.0);
                double divisor = XMLChartConfig.getInheritedAttrDouble(plotElem, A_PLOT_DIVISOR, 1.0);
                boolean nonNegative = XMLChartConfig.getInheritedAttrBoolean(plotElem, A_PLOT_NON_NEGATIVE, false);
                boolean percentTime = XMLChartConfig.getInheritedAttrBoolean(plotElem, A_PLOT_PERCENT_TIME, false);
                String dataFunction = XMLChartConfig.getAttr(plotElem, A_PLOT_DATA_FUNCTION, "identity");
                String aggFunction = XMLChartConfig.getAttr(plotElem, A_PLOT_AGGREGATE_FUNCTION, "avg");
                String ratioTop = XMLChartConfig.getAttr(plotElem, A_PLOT_RATIO_TOP, null);
                String ratioBottom = XMLChartConfig.getAttr(plotElem, A_PLOT_RATIO_BOTTOM, null);
                if (ratioTop == null && ratioBottom != null || ratioTop != null && ratioBottom == null) {
                    throw new DocumentException("Both ratioTop/ratioBottom need to be specified");
                }
                if (ratioTop == null && dataCol == null || ratioTop != null && dataCol != null) {
                    throw new DocumentException("Specify either ratio or data");
                }
                boolean optional = XMLChartConfig.getInheritedAttrBoolean(plotElem, A_PLOT_OPTIONAL, false);
                PlotSettings plot = new PlotSettings(legend, infile, dataCol, showRaw, showMovingAvg, movingAvgPoints, multiplier, divisor, nonNegative, percentTime, dataFunction, aggFunction, optional, ratioTop, ratioBottom);
                chart.addPlot(plot);
            }
            plotIter = chartElem.elementIterator(E_GROUP_PLOT);
            while (plotIter.hasNext()) {
                plotElem = (org.dom4j.Element)plotIter.next();
                dataCol = XMLChartConfig.getAttr(plotElem, A_PLOT_DATA_COLUMN);
                String infile = XMLChartConfig.getInheritedAttr(plotElem, A_PLOT_INFILE, null);
                boolean showRaw = XMLChartConfig.getInheritedAttrBoolean(plotElem, A_PLOT_SHOW_RAW, true);
                boolean showMovingAvg = XMLChartConfig.getInheritedAttrBoolean(plotElem, A_PLOT_SHOW_MOVING_AVG, false);
                int movingAvgPoints = XMLChartConfig.getInheritedAttrInt(plotElem, A_PLOT_MOVING_AVG_POINTS, -1);
                double multiplier = XMLChartConfig.getInheritedAttrDouble(plotElem, A_PLOT_MULTIPLIER, 1.0);
                double divisor = XMLChartConfig.getInheritedAttrDouble(plotElem, A_PLOT_DIVISOR, 1.0);
                boolean nonNegative = XMLChartConfig.getInheritedAttrBoolean(plotElem, A_PLOT_NON_NEGATIVE, false);
                boolean percentTime = XMLChartConfig.getInheritedAttrBoolean(plotElem, A_PLOT_PERCENT_TIME, false);
                String dataFunction = XMLChartConfig.getAttr(plotElem, A_PLOT_DATA_FUNCTION, "identity");
                String aggFunction = XMLChartConfig.getAttr(plotElem, A_PLOT_AGGREGATE_FUNCTION, "avg");
                String groupBy = XMLChartConfig.getAttr(plotElem, A_PLOT_GROUP_BY);
                String ignore = XMLChartConfig.getAttr(plotElem, A_PLOT_IGNORE, null);
                boolean optional = XMLChartConfig.getInheritedAttrBoolean(plotElem, A_PLOT_OPTIONAL, false);
                GroupPlotSettings plot = new GroupPlotSettings(groupBy, ignore, infile, dataCol, showRaw, showMovingAvg, movingAvgPoints, multiplier, divisor, nonNegative, percentTime, dataFunction, aggFunction, optional);
                chart.addPlot(plot);
            }
            charts.add(chart);
        }
        return charts;
    }
}

