/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.perf.chart;

import com.zimbra.common.util.CsvReader;
import com.zimbra.perf.chart.ChartSettings;
import com.zimbra.perf.chart.PlotSettings;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SummaryAnalyzer {
    private Map<String, List<PlotSettings>> mOutfilePlotsMap = null;
    private List<ReportEntry> mEntryList = new ArrayList<ReportEntry>();

    public SummaryAnalyzer(List<ChartSettings> chartSettings) {
        this.mOutfilePlotsMap = new HashMap<String, List<PlotSettings>>(chartSettings.size());
        for (ChartSettings cs : chartSettings) {
            this.mOutfilePlotsMap.put(cs.getOutfile(), cs.getPlots());
        }
    }

    private static String buildKey(String infile, String data, String aggregateFun) {
        return infile + ":" + data + ":" + aggregateFun;
    }

    private static String getVolume(String dataColumn) {
        return dataColumn.split(":")[0];
    }

    private void buildSingleVolume(String volumeName, String name) {
        String key = SummaryAnalyzer.buildKey("io-x.csv", volumeName + ":" + "%util", "avg");
        this.mEntryList.add(new ReportEntry(name + " Disk Util", key));
        key = SummaryAnalyzer.buildKey("io-x.csv", volumeName + ":" + "rkB/s", "avg");
        this.mEntryList.add(new ReportEntry(name + " Read Throughput", key));
        key = SummaryAnalyzer.buildKey("io-x.csv", volumeName + ":" + "wkB/s", "avg");
        this.mEntryList.add(new ReportEntry(name + " Write Throughput", key));
        key = SummaryAnalyzer.buildKey("io-x.csv", volumeName + ":" + "r/s", "avg");
        this.mEntryList.add(new ReportEntry(name + " Read IOPS", key));
        key = SummaryAnalyzer.buildKey("io-x.csv", volumeName + ":" + "w/s", "avg");
        this.mEntryList.add(new ReportEntry(name + " write IOPS", key));
    }

    private List<PlotSettings> getIOPlotSettings() {
        Iterator<String> it = this.mOutfilePlotsMap.keySet().iterator();
        List<PlotSettings> settings = null;
        while (it.hasNext()) {
            String key = it.next();
            if (key.indexOf("disk_util.png") == -1) continue;
            settings = this.mOutfilePlotsMap.get(key);
            break;
        }
        return settings;
    }

    private void buildIOKeys() {
        List<PlotSettings> settings = this.getIOPlotSettings();
        for (PlotSettings ps : settings) {
            String legend = ps.getLegend();
            String volume = SummaryAnalyzer.getVolume(ps.getDataColumn());
            this.buildSingleVolume(volume, legend);
        }
    }

    private void buildCPUKeys() {
        String key = SummaryAnalyzer.buildKey("proc.csv", "sys", "avg");
        this.mEntryList.add(new ReportEntry("Mail Server CPU Sys ", key));
        key = SummaryAnalyzer.buildKey("proc.csv", "user", "avg");
        this.mEntryList.add(new ReportEntry("Mail Server CPU User ", key));
        key = SummaryAnalyzer.buildKey("proc.csv", "idle", "avg");
        this.mEntryList.add(new ReportEntry("Mail Server CPU Idle ", key));
        key = SummaryAnalyzer.buildKey("proc.csv", "iowait", "avg");
        this.mEntryList.add(new ReportEntry("Mail Server CPU Iowait ", key));
    }

    private void buildMemKeys() {
        String key = SummaryAnalyzer.buildKey("gc.csv", "FULLGC%", "avg");
        this.mEntryList.add(new ReportEntry("Full GC% ", key));
        key = SummaryAnalyzer.buildKey("gc.csv", "YGC%", "avg");
        this.mEntryList.add(new ReportEntry("Young GC% ", key));
    }

    private void buildServerResponseKeys() {
        String key = SummaryAnalyzer.buildKey("zimbrastats.csv", "mbox_add_msg_count", "avg");
        this.mEntryList.add(new ReportEntry("Mailbox add rate ", key));
        key = SummaryAnalyzer.buildKey("zimbrastats.csv", "mbox_add_msg_ms_avg", "avg");
        this.mEntryList.add(new ReportEntry("Mailbox add latency ", key));
        key = SummaryAnalyzer.buildKey("zimbrastats.csv", "mbox_get_ms_avg", "avg");
        this.mEntryList.add(new ReportEntry("Mailbox get latency ", key));
        key = SummaryAnalyzer.buildKey("zimbrastats.csv", "soap_ms_avg", "avg");
        this.mEntryList.add(new ReportEntry("Soap response time", key));
        key = SummaryAnalyzer.buildKey("zimbrastats.csv", "pop_ms_avg", "avg");
        this.mEntryList.add(new ReportEntry("Pop response time", key));
        key = SummaryAnalyzer.buildKey("zimbrastats.csv", "imap_ms_avg", "avg");
        this.mEntryList.add(new ReportEntry("Imap response time", key));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeReport(File summaryCsv) throws IOException {
        this.buildIOKeys();
        this.buildCPUKeys();
        this.buildMemKeys();
        this.buildServerResponseKeys();
        FileReader reader = null;
        CsvReader csv = null;
        OutputStreamWriter writer = null;
        try {
            reader = new FileReader(summaryCsv);
            csv = new CsvReader(reader);
            File summaryTxt = new File(summaryCsv.getParentFile(), "summary.txt");
            writer = new FileWriter(summaryTxt);
            writer.write("===========================================\n");
            writer.write("#            Perf Stats                   #\n");
            writer.write("===========================================\n");
            if (csv.hasNext()) {
                for (ReportEntry entry : this.mEntryList) {
                    if (csv.columnExists(entry.entryKey)) {
                        writer.write(entry.entryName + ":" + csv.getValue(entry.entryKey));
                    } else {
                        writer.write(entry.entryName + ":");
                    }
                    writer.write("\n");
                }
            }
        }
        finally {
            if (writer != null) {
                writer.close();
            }
            if (csv != null) {
                csv.close();
            } else if (reader != null) {
                reader.close();
            }
        }
    }

    public class ReportEntry {
        String entryName;
        String entryKey;

        public ReportEntry(String keyName, String keyVal) {
            this.entryName = keyName;
            this.entryKey = keyVal;
        }

        public String getEntryKey() {
            return this.entryKey;
        }

        public void setEntryKey(String entryKey) {
            this.entryKey = entryKey;
        }

        public String getEntryName() {
            return this.entryName;
        }

        public void setEntryName(String entryName) {
            this.entryName = entryName;
        }
    }
}

