/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.perf.chart;

public class PlotSettings {
    public static final String DATA_FUNCTION_IDENTITY = "identity";
    public static final String DATA_FUNCTION_DIFF = "diff";
    public static final String DATA_FUNCTION_SUM = "sum";
    public static final String AGG_FUNCTION_AVG = "avg";
    public static final String AGG_FUNCTION_LAST = "last";
    public static final String AGG_FUNCTION_MAX = "max";
    public static final String AGG_FUNCTION_MAX_PERCENTAGE = "maxPercentage";
    public static final String TSTAMP_COLUMN = "timestamp";
    public static final boolean DEFAULT_PLOT_SHOW_RAW = true;
    public static final boolean DEFAULT_PLOT_SHOW_MOVING_AVG = false;
    public static final int DEFAULT_PLOT_MOVING_AVG_POINTS = -1;
    public static final double DEFAULT_PLOT_MULTIPLIER = 1.0;
    public static final double DEFAULT_PLOT_DIVISOR = 1.0;
    public static final boolean DEFAULT_PLOT_NON_NEGATIVE = false;
    public static final boolean DEFAULT_PLOT_PERCENT_TIME = false;
    public static final String DEFAULT_PLOT_DATA_FUNCTION = "identity";
    public static final String DEFAULT_PLOT_AGGREGATE_FUNCTION = "avg";
    public static final boolean DEFAULT_PLOT_OPTIONAL = false;
    private String mLegend;
    private String mInfile;
    private String mDataColumn;
    private boolean mShowRaw;
    private boolean mShowMovingAvg;
    private int mMovingAvgPoints;
    private double mMultiplier;
    private double mDivisor;
    private boolean mNonNegative;
    private boolean mPercentTime;
    private String mDataFunction;
    private String mAggregateFunction;
    private boolean mOptional;
    private String mRatioTop;
    private String mRatioBottom;

    public PlotSettings(String legend, String infile, String dataCol, boolean showRaw, boolean showMovingAvg, int movingAvgPoints, double multiplier, double divisor, boolean nonNegative, boolean percentTime, String dataFunction, String aggFunction, boolean optional, String ratioTop, String ratioBottom) {
        this.mLegend = legend;
        this.mInfile = infile;
        this.mDataColumn = dataCol;
        this.mShowRaw = showRaw;
        this.mShowMovingAvg = showMovingAvg;
        this.mMovingAvgPoints = movingAvgPoints;
        this.mMultiplier = multiplier;
        this.mDivisor = divisor;
        this.mNonNegative = nonNegative;
        this.mPercentTime = percentTime;
        if (this.mPercentTime) {
            this.mNonNegative = true;
        }
        this.mDataFunction = dataFunction;
        this.mAggregateFunction = aggFunction;
        this.mOptional = optional;
        this.mRatioTop = ratioTop;
        this.mRatioBottom = ratioBottom;
        if (this.mLegend == null || this.mLegend.length() < 1) {
            this.mLegend = this.mDataColumn;
        }
        if (this.mLegend == null) {
            this.mLegend = "(" + this.mRatioTop + ")" + " / " + "(" + this.mRatioBottom + ")";
        }
        if (this.mInfile == null || this.mInfile.length() < 1) {
            throw new IllegalArgumentException("Missing infile attribute on plot " + this.mLegend);
        }
        if (!this.mShowRaw && !this.mShowMovingAvg) {
            throw new IllegalArgumentException("At least one of showRaw, showSum and showMovingAvg must be true in plot " + this.mLegend);
        }
        if (this.mDivisor == 0.0) {
            throw new IllegalArgumentException("Divisor of 0 is not allowed in plot " + this.mLegend);
        }
    }

    public String getLegend() {
        return this.mLegend;
    }

    public String getInfile() {
        return this.mInfile;
    }

    public String getDataColumn() {
        return this.mDataColumn;
    }

    public void setDataColumn(String c) {
        this.mDataColumn = c;
    }

    public boolean getShowRaw() {
        return this.mShowRaw;
    }

    public boolean getShowMovingAvg() {
        return this.mShowMovingAvg;
    }

    public int getMovingAvgPoints() {
        return this.mMovingAvgPoints;
    }

    public double getMultiplier() {
        return this.mMultiplier;
    }

    public double getDivisor() {
        return this.mDivisor;
    }

    public boolean getNonNegative() {
        return this.mNonNegative;
    }

    public boolean getPercentTime() {
        return this.mPercentTime;
    }

    public String getDataFunction() {
        return this.mDataFunction;
    }

    public String getAggregateFunction() {
        return this.mAggregateFunction;
    }

    public boolean getOptional() {
        return this.mOptional;
    }

    public String getRatioTop() {
        return this.mRatioTop;
    }

    public String getRatioBottom() {
        return this.mRatioBottom;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("<plot\n");
        sb.append("  ").append("legend=\"").append(this.mLegend).append("\"\n");
        sb.append("  ").append("infile=\"").append(this.mInfile).append("\"\n");
        sb.append("  ").append("data=\"").append(this.mDataColumn).append("\"\n");
        sb.append("  ").append("showRaw=\"").append(this.mShowRaw).append("\"\n");
        sb.append("  ").append("showMovingAvg=\"").append(this.mShowMovingAvg).append("\"\n");
        sb.append("  ").append("movingAvgPoints=\"").append(this.mMovingAvgPoints).append("\"\n");
        sb.append("  ").append("multiplier=\"").append(this.mMultiplier).append("\"\n");
        sb.append("  ").append("divisor=\"").append(this.mDivisor).append("\"\n");
        sb.append("  ").append("nonNegative=\"").append(this.mNonNegative).append("\"\n");
        sb.append("  ").append("percentTime=\"").append(this.mPercentTime).append("\"\n");
        sb.append("  ").append("dataFunction=\"").append(this.mDataFunction).append("\"\n");
        sb.append("  ").append("aggregateFunction=\"").append(this.mAggregateFunction).append("\"\n");
        sb.append("  ").append("optional=\"").append(this.mOptional).append("\"\n");
        sb.append("/>\n");
        return sb.toString();
    }
}

