/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.perf.chart;

import com.zimbra.perf.chart.PlotSettings;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupPlotSettings
extends PlotSettings {
    private final String mGroupBy;
    private final String mIgnore;
    private final Set<String> mIgnoreSet;

    public GroupPlotSettings(String groupBy, String ignore, String infile, String dataCol, boolean showRaw, boolean showMovingAvg, int movingAvgPoints, double multiplier, double divisor, boolean nonNegative, boolean percentTime, String dataFunction, String aggFunction, boolean optional) {
        super(groupBy, infile, dataCol, showRaw, showMovingAvg, movingAvgPoints, multiplier, divisor, nonNegative, percentTime, dataFunction, aggFunction, optional, null, null);
        String[] ignores;
        this.mGroupBy = groupBy;
        this.mIgnore = ignore;
        this.mIgnoreSet = new HashSet<String>();
        if (this.mIgnore != null && (ignores = this.mIgnore.split("\\s*,\\s*")).length > 0) {
            this.mIgnoreSet.addAll(Arrays.asList(ignores));
        }
    }

    public String getGroupBy() {
        return this.mGroupBy;
    }

    public String getIgnore() {
        return this.mIgnore;
    }

    public Set<String> getIgnoreSet() {
        return this.mIgnoreSet;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("<groupplot\n");
        sb.append("  ").append("legend=\"").append(this.getLegend()).append("\"\n");
        sb.append("  ").append("infile=\"").append(this.getInfile()).append("\"\n");
        sb.append("  ").append("data=\"").append(this.getDataColumn()).append("\"\n");
        sb.append("  ").append("showRaw=\"").append(this.getShowRaw()).append("\"\n");
        sb.append("  ").append("showMovingAvg=\"").append(this.getShowMovingAvg()).append("\"\n");
        sb.append("  ").append("movingAvgPoints=\"").append(this.getMovingAvgPoints()).append("\"\n");
        sb.append("  ").append("multiplier=\"").append(this.getMultiplier()).append("\"\n");
        sb.append("  ").append("divisor=\"").append(this.getDivisor()).append("\"\n");
        sb.append("  ").append("nonNegative=\"").append(this.getNonNegative()).append("\"\n");
        sb.append("  ").append("percentTime=\"").append(this.getPercentTime()).append("\"\n");
        sb.append("  ").append("dataFunction=\"").append(this.getDataFunction()).append("\"\n");
        sb.append("  ").append("aggregateFunction=\"").append(this.getAggregateFunction()).append("\"\n");
        sb.append("  ").append("optional=\"").append(this.getOptional()).append("\"\n");
        sb.append("  ").append("groupBy=\"").append(this.mGroupBy).append("\"\n");
        sb.append("  ").append("ignore=\"").append(this.mIgnore).append("\"\n");
        sb.append("/>\n");
        return sb.toString();
    }
}

