/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.perf.chart;

import com.zimbra.perf.chart.GroupPlotSettings;
import com.zimbra.perf.chart.PlotSettings;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ChartSettings {
    public static final String DEFAULT_CHART_XAXIS = "Time";
    public static final boolean DEFAULT_CHART_ALLOW_LOG_SCALE = true;
    public static final boolean DEFAULT_CHART_PLOT_ZERO = false;
    public static final int DEFAULT_CHART_WIDTH = 1200;
    public static final int DEFAULT_CHART_HEIGHT = 200;
    public static final int MINIMUM_CHART_HEIGHT = 200;
    private String mDocument;
    private String mTitle;
    private String mCategory;
    private String mOutfile;
    private String mXAxis;
    private String mYAxis;
    private int mTopPlots;
    private TopPlotsType mTopPlotsType;
    private boolean mAllowLogScale;
    private int mWidth = 1200;
    private int mHeight = 200;
    private ImageType mImageType;
    private List<PlotSettings> mPlots;
    private List<GroupPlotSettings> mGroupPlots;
    private boolean mPlotZero = false;

    public ChartSettings(String title, String category, String outfile, String xAxis, String yAxis, boolean allowLogScale, boolean plotZero, int width, int height, String outDoc, int topPlots, TopPlotsType topType) {
        this.mTitle = title;
        this.mCategory = category;
        this.mOutfile = outfile;
        String lower = this.mOutfile.toLowerCase();
        if (lower.endsWith(".png")) {
            this.mImageType = ImageType.PNG;
        } else if (lower.endsWith(".jpg")) {
            this.mImageType = ImageType.JPG;
        } else {
            throw new IllegalArgumentException(String.format("Unexpected file type '%s' for outfile in chart %s.  Only .jpg and .png are supported.", this.mOutfile, title));
        }
        this.mXAxis = xAxis;
        this.mYAxis = yAxis;
        this.mAllowLogScale = allowLogScale;
        this.mPlotZero = plotZero;
        this.mWidth = width;
        this.mHeight = height;
        this.mPlots = new ArrayList<PlotSettings>();
        this.mGroupPlots = new ArrayList<GroupPlotSettings>();
        this.mDocument = outDoc;
        this.mTopPlots = topPlots;
        this.mTopPlotsType = topType;
    }

    public void addPlot(PlotSettings p) {
        this.mPlots.add(p);
    }

    public void addPlot(GroupPlotSettings p) {
        this.mGroupPlots.add(p);
    }

    public String getTitle() {
        return this.mTitle;
    }

    public String getCategory() {
        return this.mCategory;
    }

    public String getOutfile() {
        return this.mOutfile;
    }

    public String getXAxis() {
        return this.mXAxis;
    }

    public String getYAxis() {
        return this.mYAxis;
    }

    public boolean getAllowLogScale() {
        return this.mAllowLogScale;
    }

    public boolean getPlotZero() {
        return this.mPlotZero;
    }

    public int getWidth() {
        return this.mWidth;
    }

    public ImageType getImageType() {
        return this.mImageType;
    }

    public List<PlotSettings> getPlots() {
        return this.mPlots;
    }

    public List<GroupPlotSettings> getGroupPlots() {
        return this.mGroupPlots;
    }

    public int getTopPlots() {
        return this.mTopPlots;
    }

    public TopPlotsType getTopPlotsType() {
        return this.mTopPlotsType;
    }

    public int getHeight() {
        int h = Math.max(this.mHeight, 200);
        if (this.mPlots.size() <= 1) {
            h -= 40;
        }
        return h;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("<chart\n");
        sb.append("  ").append("title=\"").append(this.mTitle).append("\"\n");
        sb.append("  ").append("outfile=\"").append(this.mOutfile).append("\"\n");
        sb.append("  ").append("xAxis=\"").append(this.mXAxis).append("\"\n");
        sb.append("  ").append("yAxis=\"").append(this.mYAxis).append("\"\n");
        sb.append("  ").append("allowLogScale=\"").append(this.mAllowLogScale).append("\"\n");
        sb.append("  ").append("plotZero=\"").append(this.mPlotZero).append("\"\n");
        sb.append("  ").append("width=\"").append(this.mWidth).append("\"\n");
        sb.append("  ").append("height=\"").append(this.mHeight).append("\"\n");
        sb.append("  ").append("outDocument=\"").append(this.mDocument).append("\"\n");
        sb.append(">\n");
        for (PlotSettings plot : this.mPlots) {
            sb.append(plot.toString());
        }
        sb.append("</chart>\n");
        return sb.toString();
    }

    public String getOutDocument() {
        return this.mDocument;
    }

    public void setOutDocument(String doc) {
        this.mDocument = doc;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TopPlotsType {
        AVG,
        MAX;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ImageType {
        JPG,
        PNG;

    }
}

