/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.zimlet.handler;

import com.zimbra.cs.zimlet.ZimletConf;
import com.zimbra.cs.zimlet.ZimletException;
import com.zimbra.cs.zimlet.ZimletHandler;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RegexHandler
implements ZimletHandler {
    private Pattern mPattern;

    public String[] match(String text, ZimletConf config) throws ZimletException {
        if (this.mPattern == null) {
            String handlerConfig = config.getGlobalConf("ZIMLET_CONFIG_REGEX_VALUE");
            if (handlerConfig == null) {
                throw ZimletException.ZIMLET_HANDLER_ERROR("null regex value");
            }
            this.mPattern = Pattern.compile(handlerConfig);
        }
        Matcher m = this.mPattern.matcher(text);
        ArrayList<String> l = new ArrayList<String>();
        while (m.find()) {
            l.add(text.substring(m.start(), m.end()));
        }
        return l.toArray(new String[0]);
    }
}

