/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.zimlet;

import com.zimbra.common.auth.ZAuthToken;
import com.zimbra.common.localconfig.LC;
import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.AdminConstants;
import com.zimbra.common.soap.Element;
import com.zimbra.common.soap.SoapHttpTransport;
import com.zimbra.common.soap.SoapTransport;
import com.zimbra.common.util.ByteUtil;
import com.zimbra.common.util.CliUtil;
import com.zimbra.common.util.Pair;
import com.zimbra.common.util.SetUtil;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.AccountServiceException;
import com.zimbra.cs.account.Cos;
import com.zimbra.cs.account.Domain;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.Server;
import com.zimbra.cs.account.Zimlet;
import com.zimbra.cs.account.soap.SoapProvisioning;
import com.zimbra.cs.httpclient.URLUtil;
import com.zimbra.cs.util.BuildInfo;
import com.zimbra.cs.zimlet.Version;
import com.zimbra.cs.zimlet.ZimletConfig;
import com.zimbra.cs.zimlet.ZimletDescription;
import com.zimbra.cs.zimlet.ZimletException;
import com.zimbra.cs.zimlet.ZimletFile;
import com.zimbra.cs.zimlet.ZimletHandler;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.methods.multipart.PartBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZimletUtil {
    public static final String ZIMLET_BASE = "/service/zimlet";
    public static final String ZIMLET_DEV_DIR = "_dev";
    public static final String ZIMLET_ALLOWED_DOMAINS = "allowedDomains";
    public static final String ZIMLET_DEFAULT_COS = "default";
    private static int P_MAX = Integer.MAX_VALUE;
    private static boolean sZimletsLoaded = false;
    private static Map<String, ZimletFile> sZimlets = new HashMap<String, ZimletFile>();
    private static Map<String, Class> sZimletHandlers = new HashMap<String, Class>();
    private static final int INSTALL_ZIMLET = 10;
    private static final int UNINSTALL_ZIMLET = 11;
    private static final int LIST_ZIMLETS = 12;
    private static final int ACL_ZIMLET = 13;
    private static final int LIST_ACLS = 14;
    private static final int DUMP_CONFIG = 15;
    private static final int INSTALL_CONFIG = 16;
    private static final int LDAP_DEPLOY = 17;
    private static final int DEPLOY_ZIMLET = 18;
    private static final int ENABLE_ZIMLET = 19;
    private static final int DISABLE_ZIMLET = 20;
    private static final int LIST_PRIORITY = 21;
    private static final int SET_PRIORITY = 22;
    private static final int INFO = 23;
    private static final int CREATE_ZIP = 24;
    private static final int TEST = 99;
    private static final String INSTALL_CMD = "install";
    private static final String UNINSTALL_CMD = "uninstall";
    private static final String UNDEPLOY_CMD = "undeploy";
    private static final String LIST_CMD = "listzimlets";
    private static final String ACL_CMD = "acl";
    private static final String LIST_ACLS_CMD = "listacls";
    private static final String DUMP_CONFIG_CMD = "getconfigtemplate";
    private static final String INSTALL_CONFIG_CMD = "configure";
    private static final String LDAP_DEPLOY_CMD = "ldapdeploy";
    private static final String DEPLOY_CMD = "deploy";
    private static final String ENABLE_CMD = "enable";
    private static final String DISABLE_CMD = "disable";
    private static final String LIST_PRIORITY_CMD = "listpriority";
    private static final String SET_PRIORITY_CMD = "setpriority";
    private static final String INFO_CMD = "info";
    private static final String CREATE_ZIP_CMD = "createzip";
    private static final String TEST_CMD = "test";
    private static Map<String, Integer> mCommands;
    private static boolean sQuietMode;
    private static int argPos;

    public static String[] getZimlets(Account acct) throws ServiceException {
        String[] zimlets = acct.getMultiAttr("zimbraZimletAvailableZimlets");
        Domain domain = Provisioning.getInstance().getDomain(acct);
        if (domain != null) {
            Set<String> domainZimlets = domain.getMultiAttrSet("zimbraZimletDomainAvailableZimlets");
            HashSet<String> availZimlets = new HashSet<String>(Arrays.asList(zimlets));
            return SetUtil.union(availZimlets, domainZimlets).toArray(new String[0]);
        }
        return zimlets;
    }

    public static String[] getZimlets(Cos cos) {
        String[] zimlets = cos.getMultiAttr("zimbraZimletAvailableZimlets");
        return zimlets;
    }

    public static String[] listZimletNames() {
        Object[] zimlets = sZimlets.keySet().toArray(new String[0]);
        Arrays.sort(zimlets);
        return zimlets;
    }

    public static String[] listDevZimletNames() {
        Object[] zimlets = ZimletUtil.loadDevZimlets().keySet().toArray(new String[0]);
        Arrays.sort(zimlets);
        return zimlets;
    }

    /*
     * WARNING - void declaration
     */
    public static List<Zimlet> orderZimletsByPriority(List<Zimlet> zimlets) {
        ArrayList<Pair<Version, Zimlet>> plist = new ArrayList<Pair<Version, Zimlet>>();
        for (Zimlet z : zimlets) {
            void var4_4;
            String string = z.getPriority();
            if (string == null) {
                String string2 = Integer.toString(Integer.MAX_VALUE);
            }
            Version v = new Version((String)var4_4);
            plist.add(new Pair<Version, Zimlet>(v, z));
        }
        Collections.sort(plist, new Comparator<Pair<Version, Zimlet>>(){

            @Override
            public int compare(Pair<Version, Zimlet> first, Pair<Version, Zimlet> second) {
                return first.getFirst().compareTo(second.getFirst());
            }
        });
        ArrayList<Zimlet> ret = new ArrayList<Zimlet>();
        for (Pair pair : plist) {
            ret.add((Zimlet)pair.getSecond());
        }
        return ret;
    }

    public static List<Zimlet> orderZimletsByPriority(String[] zimlets) {
        Provisioning prov = Provisioning.getInstance();
        ArrayList<Zimlet> zlist = new ArrayList<Zimlet>();
        for (int i = 0; i < zimlets.length; ++i) {
            try {
                Zimlet z = prov.getZimlet(zimlets[i]);
                if (z == null) continue;
                zlist.add(z);
                continue;
            }
            catch (ServiceException se) {
                // empty catch block
            }
        }
        return ZimletUtil.orderZimletsByPriority(zlist);
    }

    public static List<Zimlet> orderZimletsByPriority() throws ServiceException {
        Provisioning prov = Provisioning.getInstance();
        List<Zimlet> allzimlets = prov.listAllZimlets();
        return ZimletUtil.orderZimletsByPriority(allzimlets);
    }

    public static void updateZimletConfig(String zimlet, String config) throws ServiceException {
        Provisioning prov = Provisioning.getInstance();
        Zimlet zim = prov.getZimlet(zimlet);
        if (zim == null) {
            throw AccountServiceException.NO_SUCH_ZIMLET(zimlet);
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("zimbraZimletHandlerConfig", config);
        prov.modifyAttrs(zim, map);
    }

    public static ZimletConfig getZimletConfig(String zimlet) throws ServiceException {
        Provisioning prov = Provisioning.getInstance();
        Zimlet z = prov.getZimlet(zimlet);
        if (z == null) {
            throw AccountServiceException.NO_SUCH_ZIMLET(zimlet);
        }
        String cf = z.getAttr("zimbraZimletHandlerConfig");
        if (cf == null) {
            return null;
        }
        try {
            return new ZimletConfig(cf);
        }
        catch (ZimletException e) {
            ZimbraLog.zimlet.warn((Object)("Unable to load zimlet config for " + z.getName()), e);
            return null;
        }
    }

    public static ZimletHandler getHandler(String name) {
        ZimletUtil.loadZimlets();
        Class<?> zh = sZimletHandlers.get(name);
        if (zh == null) {
            ZimletFile zf = sZimlets.get(name);
            if (zf == null) {
                return null;
            }
            try {
                String clazz = zf.getZimletDescription().getServerExtensionClass();
                if (clazz != null) {
                    URL[] urls = new URL[]{zf.toURL()};
                    URLClassLoader cl = new URLClassLoader(urls, ZimletUtil.class.getClassLoader());
                    zh = cl.loadClass(clazz);
                    ZimbraLog.zimlet.info("Loaded class " + zh.getName());
                    sZimletHandlers.put(name, zh);
                }
            }
            catch (Exception e) {
                ZimbraLog.zimlet.warn((Object)("Unable to load zimlet handler for " + name), e);
                return null;
            }
        }
        try {
            if (zh != null) {
                return (ZimletHandler)zh.newInstance();
            }
        }
        catch (Exception e) {
            ZimbraLog.zimlet.warn((Object)("Unable to instantiate zimlet handler for " + name), e);
        }
        return null;
    }

    public static ZimletFile getZimlet(String zimlet) {
        ZimletFile zf = null;
        ZimletUtil.loadZimlets();
        zf = sZimlets.get(zimlet);
        if (zf != null) {
            return zf;
        }
        return ZimletUtil.loadDevZimlets().get(zimlet);
    }

    public static synchronized Map<String, ZimletFile> loadZimlets() {
        if (!sZimletsLoaded) {
            ZimletUtil.loadZimletsFromDir(sZimlets, LC.zimlet_directory.value());
            sZimletsLoaded = true;
        }
        return sZimlets;
    }

    public static Map<String, ZimletFile> loadDevZimlets() {
        HashMap<String, ZimletFile> zimletMap = new HashMap<String, ZimletFile>();
        ZimletUtil.loadZimletsFromDir(zimletMap, LC.zimlet_directory.value() + File.separator + ZIMLET_DEV_DIR);
        return zimletMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reloadZimlet(String zimlet) throws ZimletException {
        ZimletFile zf;
        try {
            zf = new ZimletFile(LC.zimlet_directory.value() + File.separator + zimlet);
        }
        catch (IOException ioe) {
            ZimbraLog.zimlet.warn(ioe.getMessage());
            return;
        }
        Map<String, ZimletFile> map = sZimlets;
        synchronized (map) {
            sZimlets.remove(zimlet);
            sZimlets.put(zimlet, zf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadZimletsFromDir(Map<String, ZimletFile> zimlets, String dir) {
        File zimletRootDir = new File(dir);
        if (zimletRootDir == null || !zimletRootDir.exists() || !zimletRootDir.isDirectory()) {
            return;
        }
        ZimbraLog.zimlet.debug("Loading zimlets from " + zimletRootDir.getPath());
        Map<String, ZimletFile> map = zimlets;
        synchronized (map) {
            zimlets.clear();
            String[] zimletNames = zimletRootDir.list();
            assert (zimletNames != null);
            for (int i = 0; i < zimletNames.length; ++i) {
                if (zimletNames[i].equals(ZIMLET_DEV_DIR)) continue;
                try {
                    zimlets.put(zimletNames[i], new ZimletFile(zimletRootDir, zimletNames[i]));
                    continue;
                }
                catch (Exception e) {
                    ZimbraLog.zimlet.warn((Object)("error loading zimlet " + zimletNames[i]), e);
                }
            }
        }
    }

    public static void listZimlet(Element elem, Zimlet zimlet, int priority) {
        ZimletUtil.loadZimlets();
        ZimletFile zf = sZimlets.get(zimlet.getName());
        if (zf == null) {
            ZimbraLog.zimlet.warn("cannot find zimlet " + zimlet.getName());
            return;
        }
        String zimletBase = "/service/zimlet/" + zimlet.getName() + "/";
        Element entry = elem.addElement("zimlet");
        Element zimletContext = entry.addElement("zimletContext");
        zimletContext.addAttribute("baseUrl", zimletBase);
        if (priority >= 0) {
            zimletContext.addAttribute("priority", priority);
        }
        try {
            zf.getZimletDescription().addToElement(entry);
            String config = zimlet.getHandlerConfig();
            if (config != null) {
                entry.addElement(Element.parseXML(config, elem.getFactory()));
            }
        }
        catch (Exception e) {
            ZimbraLog.zimlet.warn((Object)("error loading zimlet " + zimlet), e);
        }
    }

    public static void listDevZimlets(Element elem) {
        for (ZimletFile zim : ZimletUtil.loadDevZimlets().values()) {
            String zimletBase = "/service/zimlet/_dev/" + zim.getZimletName() + "/";
            Element entry = elem.addElement("zimlet");
            Element zimletContext = entry.addElement("zimletContext");
            zimletContext.addAttribute("baseUrl", zimletBase);
            try {
                zim.getZimletDescription().addToElement(entry);
                if (!zim.hasZimletConfig()) continue;
                zim.getZimletConfig().addToElement(entry);
            }
            catch (Exception e) {
                ZimbraLog.zimlet.warn((Object)("error loading dev zimlet: " + zim.getName()), e);
            }
        }
    }

    private static Map<String, Object> descToMap(ZimletDescription zd) throws ZimletException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        attrs.put("zimbraZimletKeyword", zd.getServerExtensionKeyword());
        attrs.put("zimbraZimletVersion", zd.getVersion().toString());
        attrs.put("zimbraZimletDescription", zd.getDescription());
        attrs.put("zimbraZimletHandlerClass", zd.getServerExtensionClass());
        attrs.put("zimbraZimletServerIndexRegex", zd.getRegexString());
        return attrs;
    }

    private static String getZimletDir() {
        return LC.zimlet_directory.value();
    }

    public static void flushCache() throws ZimletException {
        try {
            Provisioning.getInstance().flushCache(Provisioning.CacheEntryType.zimlet, null);
        }
        catch (ServiceException e) {
            throw ZimletException.CANNOT_FLUSH_CACHE(e);
        }
    }

    public static void deployZimlet(ZimletFile zf, DeployListener listener, ZAuthToken auth) throws IOException, ZimletException, ServiceException {
        ZimletUtil.deployZimlet(zf, listener, auth, false);
    }

    public static void deployZimlet(ZimletFile zf, DeployListener listener, ZAuthToken auth, boolean flushCache) throws IOException, ZimletException, ServiceException {
        block4: {
            Server localServer = Provisioning.getInstance().getLocalServer();
            try {
                ZimletUtil.deployZimlet(zf);
                if (listener != null) {
                    listener.markFinished(localServer);
                }
            }
            catch (Exception e) {
                ZimbraLog.zimlet.info((Object)DEPLOY_CMD, e);
                if (listener == null) break block4;
                listener.markFailed(localServer);
            }
        }
        if (auth == null) {
            return;
        }
        byte[] data = zf.toByteArray();
        ZimletSoapUtil soapUtil = new ZimletSoapUtil(auth);
        soapUtil.deployZimlet(zf.getName(), data, listener, flushCache);
    }

    public static void deployZimlet(ZimletFile zf) throws IOException, ZimletException, ServiceException {
        Provisioning prov = Provisioning.getInstance();
        String zimletName = zf.getZimletName();
        ZimletDescription zd = zf.getZimletDescription();
        Action action = Action.INSTALL;
        String priority = null;
        boolean enable = true;
        Zimlet z = prov.getZimlet(zimletName);
        if (z != null) {
            Version ver = new Version(z.getAttr("zimbraZimletVersion"));
            if (zd.getVersion().compareTo(ver) < 0) {
                ZimbraLog.zimlet.info("Zimlet " + zimletName + " being installed is of an older version.");
                return;
            }
            action = zd.getVersion().compareTo(ver) == 0 ? Action.REPAIR : Action.UPGRADE;
            priority = z.getPriority();
            enable = z.isEnabled();
        }
        z = ZimletUtil.ldapDeploy(zf);
        ZimletUtil.installZimlet(zf);
        if (action == Action.REPAIR) {
            return;
        }
        ZimbraLog.zimlet.info("Upgrading Zimlet " + zimletName + " to " + zd.getVersion().toString());
        if (priority == null) {
            ZimletUtil.setPriority(zimletName, P_MAX);
        }
        if (zf.hasZimletConfig()) {
            ZimletUtil.installConfig(zf.getZimletConfig());
        }
        if (!zd.isExtension()) {
            ZimletUtil.activateZimlet(zimletName, ZIMLET_DEFAULT_COS);
        }
        if (!enable) {
            return;
        }
        ZimletUtil.enableZimlet(zimletName);
    }

    public static void installZimlet(ZimletFile zf) throws IOException, ZimletException {
        ZimletDescription zd = zf.getZimletDescription();
        String zimletName = zd.getName();
        ZimbraLog.zimlet.info("Installing Zimlet " + zimletName + " on this host.");
        File libDir = new File(LC.mailboxd_directory.value() + File.separator + "webapps" + File.separator + "zimlet" + File.separator + "WEB-INF" + File.separator + "lib");
        File propsDir = new File(LC.zimlet_properties_directory.value() + File.separator + zimletName);
        File zimlet = new File(ZimletUtil.getZimletDir() + File.separatorChar + zimletName);
        zimlet.getParentFile().mkdirs();
        if (zimlet.exists()) {
            ZimletUtil.deleteFile(zimlet);
        }
        for (ZimletFile.ZimletEntry entry : zf.getAllEntries()) {
            File file;
            String fname = entry.getName();
            if (fname.endsWith(".jar")) {
                file = new File(libDir, fname);
                file.getParentFile().mkdirs();
                ZimletUtil.writeFile(entry.getContents(), file);
                continue;
            }
            if (fname.endsWith(".properties")) {
                file = new File(propsDir, fname);
                file.getParentFile().mkdirs();
                ZimletUtil.writeFile(entry.getContents(), file);
                continue;
            }
            file = new File(zimlet, fname);
            file.getParentFile().mkdirs();
            ZimletUtil.writeFile(entry.getContents(), file);
        }
        ZimletUtil.flushCache();
    }

    public static void ldapDeploy(String zimlet) throws ServiceException, IOException, ZimletException {
        String zimletRoot = ZimletUtil.getZimletDir();
        ZimletFile zf = new ZimletFile(zimletRoot + File.separator + zimlet);
        ZimletUtil.ldapDeploy(zf);
    }

    public static Zimlet ldapDeploy(ZimletFile zf) throws ServiceException, IOException, ZimletException {
        String disableZimletUndeploy;
        ZimletDescription zd = zf.getZimletDescription();
        String zimletName = zd.getName();
        Map<String, Object> attrs = ZimletUtil.descToMap(zd);
        List<String> targets = zd.getTargets();
        if (targets != null && targets.size() > 0) {
            attrs.put("zimbraZimletTarget", targets);
        }
        if ((disableZimletUndeploy = zd.getDisableUIUndeploy()) != null && disableZimletUndeploy.equalsIgnoreCase("true")) {
            attrs.put("zimbraAdminExtDisableUIUndeploy", "TRUE");
        }
        if (zd.isExtension()) {
            attrs.put("zimbraZimletIsExtension", "TRUE");
        }
        ZimbraLog.zimlet.info("Deploying Zimlet " + zimletName + " in LDAP.");
        Provisioning prov = Provisioning.getInstance();
        Zimlet zim = prov.getZimlet(zimletName);
        if (zim == null) {
            zim = prov.createZimlet(zimletName, attrs);
        } else {
            prov.modifyAttrs(zim, attrs);
        }
        return zim;
    }

    private static void writeFile(byte[] src, File dest) throws IOException {
        dest.createNewFile();
        ByteArrayInputStream bais = new ByteArrayInputStream(src);
        FileOutputStream fos = new FileOutputStream(dest);
        ByteUtil.copy(bais, true, fos, true);
    }

    private static void deleteFile(File f) {
        if (f.isDirectory()) {
            for (File sub : f.listFiles()) {
                ZimletUtil.deleteFile(sub);
            }
        }
        f.delete();
    }

    public static void uninstallZimlet(String zimlet, ZAuthToken auth) throws ServiceException {
        File propsDir;
        ZimbraLog.zimlet.info("Uninstalling Zimlet " + zimlet + " from LDAP.");
        Provisioning prov = Provisioning.getInstance();
        List<Cos> cos = prov.getAllCos();
        for (Cos c : cos) {
            try {
                ZimletUtil.deactivateZimlet(zimlet, c.getName());
            }
            catch (Exception e) {
                ZimbraLog.zimlet.warn((Object)("Error deactiving Zimlet " + zimlet + " in LDAP."), e);
            }
        }
        try {
            prov.deleteZimlet(zimlet);
        }
        catch (ServiceException se) {
            ZimbraLog.zimlet.warn((Object)("Error deleting Zimlet " + zimlet + " in LDAP."), se);
        }
        ZimletFile zf = sZimlets.get(zimlet);
        if (zf != null) {
            ZimbraLog.zimlet.info("Deleting Zimlet file " + zf.getFile().getAbsolutePath());
            ZimletUtil.deleteFile(zf.getFile());
            sZimlets.remove(zimlet);
        }
        if ((propsDir = new File(LC.zimlet_properties_directory.value() + File.separator + zimlet)).exists()) {
            ZimbraLog.zimlet.info("Deleting Zimlet property files " + propsDir.getAbsolutePath());
            ZimletUtil.deleteFile(propsDir);
        }
        if (auth == null) {
            return;
        }
        ZimletSoapUtil soapUtil = new ZimletSoapUtil(auth);
        soapUtil.undeployZimlet(zimlet);
    }

    public static void activateZimlet(String zimlet, String cos) throws ServiceException, ZimletException {
        ZimbraLog.zimlet.info("Adding Zimlet " + zimlet + " to COS " + cos);
        Provisioning prov = Provisioning.getInstance();
        Cos c = prov.get(Provisioning.CosBy.name, cos);
        if (c == null) {
            throw ZimletException.CANNOT_ACTIVATE("no such cos " + cos, null);
        }
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("+zimbraZimletAvailableZimlets", zimlet);
        prov.modifyAttrs(c, attrs);
        ZimletConfig zc = ZimletUtil.getZimletConfig(zimlet);
        if (zc == null) {
            return;
        }
        String allowedDomains = zc.getConfigValue(ZIMLET_ALLOWED_DOMAINS);
        if (allowedDomains != null) {
            ZimletUtil.addAllowedDomains(allowedDomains, cos);
        }
    }

    public static void deactivateZimlet(String zimlet, String cos) throws ServiceException, ZimletException {
        String[] zimlets;
        ZimbraLog.zimlet.info("Removing Zimlet " + zimlet + " from COS " + cos);
        Provisioning prov = Provisioning.getInstance();
        Cos c = prov.get(Provisioning.CosBy.name, cos);
        if (c == null) {
            throw ZimletException.CANNOT_DEACTIVATE("no such cos " + cos, null);
        }
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("-zimbraZimletAvailableZimlets", zimlet);
        prov.modifyAttrs(c, attrs);
        ZimletConfig zc = ZimletUtil.getZimletConfig(zimlet);
        if (zc == null) {
            return;
        }
        String domains = zc.getConfigValue(ZIMLET_ALLOWED_DOMAINS);
        if (domains == null) {
            return;
        }
        String[] domainArray = domains.toLowerCase().split(",");
        HashSet<String> domainsToRemove = new HashSet<String>();
        for (String d : domainArray) {
            domainsToRemove.add(d);
        }
        for (String z : zimlets = c.getMultiAttr("zimbraZimletAvailableZimlets")) {
            if (z.equals(zimlet) || (zc = ZimletUtil.getZimletConfig(z)) == null || (domains = zc.getConfigValue(ZIMLET_ALLOWED_DOMAINS)) == null) continue;
            for (String d : domainArray = domains.toLowerCase().split(",")) {
                domainsToRemove.remove(d);
            }
        }
        if (!domainsToRemove.isEmpty()) {
            ZimletUtil.removeAllowedDomains(domainsToRemove, cos);
        }
    }

    public static void setZimletEnable(String zimlet, boolean enabled) throws ZimletException {
        Provisioning prov = Provisioning.getInstance();
        try {
            Zimlet z = prov.getZimlet(zimlet);
            if (z == null) {
                throw AccountServiceException.NO_SUCH_ZIMLET(zimlet);
            }
            HashMap<String, String> attr = new HashMap<String, String>();
            attr.put("zimbraZimletEnabled", enabled ? "TRUE" : "FALSE");
            prov.modifyAttrs(z, attr);
        }
        catch (Exception e) {
            if (enabled) {
                throw ZimletException.CANNOT_ENABLE(zimlet, e);
            }
            throw ZimletException.CANNOT_DISABLE(zimlet, e);
        }
    }

    public static void enableZimlet(String zimlet) throws ZimletException {
        ZimbraLog.zimlet.info("Enabling Zimlet " + zimlet);
        ZimletUtil.setZimletEnable(zimlet, true);
    }

    public static void disableZimlet(String zimlet) throws ZimletException {
        ZimbraLog.zimlet.info("Disabling Zimlet " + zimlet);
        ZimletUtil.setZimletEnable(zimlet, false);
    }

    public static void aclZimlet(String zimlet, String[] args) throws ServiceException, ZimletException {
        for (int i = 2; i < args.length; i += 2) {
            String cos = args[i];
            String action = args[i + 1].toLowerCase();
            if (action.equals("grant")) {
                ZimletUtil.activateZimlet(zimlet, cos);
                continue;
            }
            if (action.equals("deny")) {
                ZimletUtil.deactivateZimlet(zimlet, cos);
                continue;
            }
            throw ZimletException.ZIMLET_HANDLER_ERROR("invalid acl command " + args[i + 1]);
        }
    }

    public static void listAcls(String zimlet) throws ServiceException, ZimletException {
        System.out.println("Listing COS entries for Zimlet " + zimlet + "...");
        Provisioning prov = Provisioning.getInstance();
        block0: for (Cos cos : prov.getAllCos()) {
            String[] zimlets = cos.getMultiAttr("zimbraZimletAvailableZimlets");
            for (int i = 0; i < zimlets.length; ++i) {
                if (!zimlets[i].equals(zimlet)) continue;
                System.out.println("\t" + cos.getName());
                continue block0;
            }
        }
    }

    public static void listInstalledZimletsOnHost(boolean everything) {
        ZimletUtil.loadZimlets();
        Object[] zimlets = sZimlets.values().toArray(new ZimletFile[0]);
        Arrays.sort(zimlets);
        for (int i = 0; i < zimlets.length; ++i) {
            System.out.print("\t" + ((ZimletFile)zimlets[i]).getZimletName());
            try {
                boolean isExtension;
                ZimletDescription zd = ((ZimletFile)zimlets[i]).getZimletDescription();
                boolean bl = isExtension = zd != null && zd.isExtension();
                if (isExtension && everything) {
                    System.out.print(" (ext)");
                }
            }
            catch (Exception e) {
                ZimbraLog.zimlet.warn((Object)("error reading zimlet : " + ((ZimletFile)zimlets[i]).getName()), e);
            }
            System.out.println();
        }
    }

    public static void listInstalledZimletsInLdap(boolean everything) throws ServiceException, ZimletException {
        Provisioning prov = Provisioning.getInstance();
        for (Zimlet z : prov.listAllZimlets()) {
            boolean isExtension = z.isExtension();
            if (!everything && isExtension) continue;
            System.out.print("\t" + z.getName());
            if (!z.isEnabled()) {
                System.out.print(" (disabled)");
            }
            if (isExtension) {
                System.out.print(" (ext)");
            }
            System.out.println();
        }
    }

    public static void listZimletsInCos() throws ServiceException, ZimletException {
        Provisioning prov = Provisioning.getInstance();
        for (Cos cos : prov.getAllCos()) {
            System.out.println("  " + cos.getName() + ":");
            Object[] zimlets = cos.getMultiAttr("zimbraZimletAvailableZimlets");
            Arrays.sort(zimlets);
            for (int i = 0; i < zimlets.length; ++i) {
                System.out.println("\t" + (String)zimlets[i]);
            }
        }
    }

    public static void listAllZimlets(boolean everything) throws ServiceException, ZimletException {
        System.out.println("Installed Zimlet files on this host:");
        ZimletUtil.listInstalledZimletsOnHost(everything);
        System.out.println("Installed Zimlets in LDAP:");
        ZimletUtil.listInstalledZimletsInLdap(everything);
        System.out.println("Available Zimlets in COS:");
        ZimletUtil.listZimletsInCos();
    }

    public static void dumpConfig(String zimlet) throws IOException, ZimletException {
        ZimletFile zf = new ZimletFile(zimlet);
        String config = zf.getZimletConfigString();
        System.out.println(config);
    }

    public static void installConfig(ZimletConfig zc) throws ServiceException, IOException, ZimletException {
        String zimletName = zc.getName();
        ZimbraLog.zimlet.info("Installing Zimlet config for " + zimletName);
        String configString = zc.toXMLString();
        ZimletUtil.updateZimletConfig(zimletName, configString);
        String allowedDomains = zc.getConfigValue(ZIMLET_ALLOWED_DOMAINS);
        if (allowedDomains != null) {
            ZimletUtil.addAllowedDomains(allowedDomains, ZIMLET_DEFAULT_COS);
        }
    }

    public static void addAllowedDomains(String domains, String cosName) throws ServiceException {
        Provisioning prov = Provisioning.getInstance();
        Cos cos = prov.get(Provisioning.CosBy.name, cosName);
        Set<String> domainSet = cos.getMultiAttrSet("zimbraProxyAllowedDomains");
        String[] domainArray = domains.toLowerCase().split(",");
        for (int i = 0; i < domainArray.length; ++i) {
            domainSet.add(domainArray[i]);
        }
        HashMap<String, String[]> newlist = new HashMap<String, String[]>();
        newlist.put("zimbraProxyAllowedDomains", domainSet.toArray(new String[0]));
        prov.modifyAttrs(cos, newlist);
    }

    public static void removeAllowedDomains(Set<String> domains, String cosName) throws ServiceException {
        Provisioning prov = Provisioning.getInstance();
        Cos cos = prov.get(Provisioning.CosBy.name, cosName);
        Set<String> domainSet = cos.getMultiAttrSet("zimbraProxyAllowedDomains");
        String[] domainArray = domains.toArray(new String[0]);
        for (int i = 0; i < domainArray.length; ++i) {
            domainSet.remove(domainArray[i]);
        }
        HashMap<String, String[]> newlist = new HashMap<String, String[]>();
        newlist.put("zimbraProxyAllowedDomains", domainSet.toArray(new String[0]));
        prov.modifyAttrs(cos, newlist);
    }

    public static void installConfig(String config) throws ServiceException, IOException, ZimletException {
        ZimletUtil.installConfig(new ZimletConfig(config));
    }

    public static void listPriority() throws ServiceException {
        List<Zimlet> plist = ZimletUtil.orderZimletsByPriority();
        System.out.println("Pri\tZimlet");
        for (int i = 0; i < plist.size(); ++i) {
            System.out.println(i + "\t" + plist.get(i).getName());
        }
    }

    public static void setPriority(String zimlet, int priority) throws ServiceException {
        List<Zimlet> plist = ZimletUtil.orderZimletsByPriority();
        Provisioning prov = Provisioning.getInstance();
        Zimlet z = prov.getZimlet(zimlet);
        if (z == null) {
            throw AccountServiceException.NO_SUCH_ZIMLET(zimlet);
        }
        ZimletUtil.setPriority(z, priority, plist);
    }

    private static void setPriority(Zimlet zimlet, String priority) throws ServiceException {
        Provisioning prov = Provisioning.getInstance();
        HashMap<String, String> attr = new HashMap<String, String>();
        attr.put("zimbraZimletPriority", priority);
        prov.modifyAttrs(zimlet, attr);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void setPriority(Zimlet z, int priority, List<Zimlet> plist) throws ServiceException {
        Version newPriority;
        for (Zimlet zim : plist) {
            if (zim.compareTo(z) != 0) continue;
            plist.remove(zim);
            break;
        }
        if (priority == P_MAX) {
            priority = plist.size();
        }
        if (priority == 0) {
            newPriority = new Version("0");
            ZimletUtil.setPriority(z, newPriority.toString());
            plist.add(0, z);
            if (plist.size() > 1) {
                Zimlet p0zimlet = plist.get(1);
                ZimletUtil.setPriority(p0zimlet, 1, plist);
            }
        } else {
            Zimlet oneAbove = plist.get(priority - 1);
            String pString = oneAbove.getPriority();
            if (pString == null) {
                pString = Integer.toString(priority);
            }
            newPriority = new Version(pString);
            if (priority < plist.size()) {
                Version nextPriority;
                Zimlet oneBelow = plist.get(priority);
                pString = oneBelow.getPriority();
                if (pString == null) {
                    pString = Integer.toString(priority + 2);
                }
                if (newPriority.compareTo(nextPriority = new Version(pString)) >= 0) {
                    newPriority.increment();
                    ZimletUtil.setPriority(z, newPriority.toString());
                    plist.add(priority, z);
                    ZimletUtil.setPriority(oneBelow, priority + 1, plist);
                    return;
                }
                newPriority.increment(nextPriority);
            } else {
                newPriority.increment();
            }
            ZimletUtil.setPriority(z, newPriority.toString());
        }
        try {
            ZimletUtil.flushCache();
            return;
        }
        catch (Exception e) {
            Throwable t = e.getCause();
            if (t instanceof ServiceException) {
                throw (ServiceException)t;
            }
            if (!(e instanceof IOException)) throw ServiceException.FAILURE("unable to set priority", t);
            t = e;
            throw ServiceException.FAILURE("unable to set priority", t);
        }
    }

    public static void deployZimletBySoap(String zimletFile, String adminURL, String uploadURL) throws ServiceException, IOException {
        ZimletUtil.deployZimletBySoap(zimletFile, adminURL, uploadURL, null, null);
    }

    public static void deployZimletBySoap(String zimletFile, String adminURL, String uploadURL, String username, String password) throws ServiceException, IOException {
        File zf = new File(zimletFile);
        if (adminURL != null && uploadURL != null) {
            ZimletSoapUtil soapUtil = new ZimletSoapUtil(adminURL, uploadURL, username, password);
            soapUtil.deployZimletOnServer(zf.getName(), ByteUtil.getContent(zf));
        } else {
            ZimletSoapUtil soapUtil = new ZimletSoapUtil();
            soapUtil.deployZimlet(zf.getName(), ByteUtil.getContent(zf), null);
        }
    }

    public static void showInfo(String zimlet) throws ServiceException, ZimletException, IOException {
        Provisioning prov = Provisioning.getInstance();
        Zimlet z = prov.getZimlet(zimlet);
        if (z == null) {
            throw AccountServiceException.NO_SUCH_ZIMLET(zimlet);
        }
        List<Zimlet> plist = ZimletUtil.orderZimletsByPriority();
        int pri = 0;
        for (Zimlet zp : plist) {
            if (zp.compareTo(z) == 0) break;
            ++pri;
        }
        System.out.println("Zimlet " + z.getName());
        System.out.println("         Version: " + z.getAttr("zimbraZimletVersion"));
        System.out.println("     Description: " + z.getDescription());
        System.out.println("        Priority: " + pri);
        System.out.println("         Enabled: " + (z.isEnabled() ? "true" : "false"));
        System.out.println("Indexing Enabled: " + (z.isIndexingEnabled() ? "true" : "false"));
        if (z.isExtension()) {
            System.out.println("       Extension: true");
        }
        String cosList = null;
        block1: for (Cos cos : prov.getAllCos()) {
            for (String zc : cos.getZimletAvailableZimlets()) {
                if (zc.compareTo(zimlet) != 0) continue;
                if (cosList == null) {
                    cosList = cos.getName();
                    continue block1;
                }
                cosList = cosList + ", " + cos.getName();
                continue block1;
            }
        }
        System.out.println("Activated in COS: " + cosList);
        System.out.println("          Config: " + z.getHandlerConfig());
        ZimletFile zf = ZimletUtil.getZimlet(zimlet);
        if (zf == null) {
            System.out.println("*** Zimlet file is missing on this machine");
        } else {
            ZimletDescription desc = zf.getZimletDescription();
            String val = desc.getRegexString();
            if (val != null) {
                System.out.println("           RegEx: " + val);
            }
            if ((val = desc.getContentObjectAsXML()) != null) {
                System.out.println("  Content Object: " + val);
            }
            if ((val = desc.getPanelItemAsXML()) != null) {
                System.out.println("      Panel Item: " + val);
            }
            val = null;
            for (String script : desc.getScripts()) {
                val = val == null ? script : val + ", " + script;
            }
            if (val != null) {
                System.out.println("         Scripts: " + val);
            }
            val = null;
            for (String css : desc.getStyleSheets()) {
                val = val == null ? css : val + ", " + css;
            }
            if (val != null) {
                System.out.println("             CSS: " + val);
            }
            val = null;
            for (String target : desc.getTargets()) {
                if (val == null) {
                    val = target;
                    continue;
                }
                val = val + ", " + target;
            }
            if (val != null) {
                System.out.println("         Targets: " + val);
            }
        }
    }

    public static void createZip(String dirName, String descFile) throws IOException {
        File dir = new File(dirName);
        if (!dir.exists() || !dir.isDirectory()) {
            throw new IOException("directory does not exist: " + dirName);
        }
        String target = descFile;
        boolean found = false;
        for (String f : dir.list()) {
            if (target != null) {
                if (target.compareTo(f) != 0) continue;
                found = true;
                break;
            }
            if (!f.endsWith(".xml") || f.substring(0, f.length() - 4).compareTo(dir.getName()) != 0) continue;
            target = f;
            found = true;
            break;
        }
        if (!found) {
            throw new IOException("Zimlet description not found, or not named correctly.");
        }
        String manifest = "Manifest-Version: 1.0\nZimlet-Description-File: " + target + "\n";
        JarOutputStream out = new JarOutputStream((OutputStream)new FileOutputStream(target.substring(0, target.length() - 4) + ".zip"), new Manifest(new ByteArrayInputStream(manifest.getBytes("UTF-8"))));
        for (File f : dir.listFiles()) {
            ZimletUtil.addZipEntry(out, f, null);
        }
        out.close();
    }

    private static void addZipEntry(ZipOutputStream out, File file, String path) throws IOException {
        String name;
        String string = name = path == null ? file.getName() : path + "/" + file.getName();
        if (file.isDirectory()) {
            for (File f : file.listFiles()) {
                ZimletUtil.addZipEntry(out, f, name);
            }
            return;
        }
        ZipEntry entry = new ZipEntry(name);
        entry.setMethod(0);
        entry.setSize(file.length());
        entry.setCompressedSize(file.length());
        entry.setCrc(ZimletUtil.computeCRC32(file));
        out.putNextEntry(entry);
        ByteUtil.copy(new FileInputStream(file), true, out, false);
        out.closeEntry();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long computeCRC32(File file) throws IOException {
        long l;
        block6: {
            byte[] buf = new byte[32768];
            CRC32 crc = new CRC32();
            crc.reset();
            FileInputStream fis = null;
            try {
                int bytesRead;
                fis = new FileInputStream(file);
                while ((bytesRead = fis.read(buf)) != -1) {
                    crc.update(buf, 0, bytesRead);
                }
                l = crc.getValue();
                Object var8_6 = null;
                if (fis == null) break block6;
            }
            catch (Throwable throwable) {
                block7: {
                    Object var8_7 = null;
                    if (fis == null) break block7;
                    try {
                        fis.close();
                    }
                    catch (IOException e) {}
                }
                throw throwable;
            }
            try {
                fis.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return l;
    }

    private static void test() {
        String ZIMLET_URL = "^/service/zimlet/([^/\\?]+)[/\\?]?.*$";
        String t1 = "/service/zimlet/po";
        String t2 = "/service/zimlet/foo?123";
        Pattern mPattern = Pattern.compile(ZIMLET_URL);
        Matcher matcher = mPattern.matcher(t1);
        if (matcher.matches()) {
            System.out.println(matcher.group(1));
        }
        if ((matcher = mPattern.matcher(t2)).matches()) {
            System.out.println(matcher.group(1));
        }
    }

    private static void addCommand(String cmd, int cmdId) {
        mCommands.put(cmd, new Integer(cmdId));
    }

    private static void setup() {
        mCommands = new HashMap<String, Integer>();
        ZimletUtil.addCommand(DEPLOY_CMD, 18);
        ZimletUtil.addCommand(UNDEPLOY_CMD, 11);
        ZimletUtil.addCommand(INSTALL_CMD, 10);
        ZimletUtil.addCommand(UNINSTALL_CMD, 11);
        ZimletUtil.addCommand(LIST_CMD, 12);
        ZimletUtil.addCommand(ACL_CMD, 13);
        ZimletUtil.addCommand(LIST_ACLS_CMD, 14);
        ZimletUtil.addCommand(DUMP_CONFIG_CMD, 15);
        ZimletUtil.addCommand(INSTALL_CONFIG_CMD, 16);
        ZimletUtil.addCommand(LDAP_DEPLOY_CMD, 17);
        ZimletUtil.addCommand(ENABLE_CMD, 19);
        ZimletUtil.addCommand(DISABLE_CMD, 20);
        ZimletUtil.addCommand(LIST_PRIORITY_CMD, 21);
        ZimletUtil.addCommand(SET_PRIORITY_CMD, 22);
        ZimletUtil.addCommand(INFO_CMD, 23);
        ZimletUtil.addCommand(CREATE_ZIP_CMD, 24);
        ZimletUtil.addCommand(TEST_CMD, 99);
    }

    private static void usage() {
        System.out.println("zmzimletctl: [-l] [-a <admin url> -u <upload url>] [command] [ zimlet.zip | config.xml | zimlet ]");
        System.out.println("\tdeploy {zimlet.zip} - install, ldapDeploy, grant ACL on default COS, then enable Zimlet");
        System.out.println("\tundeploy {zimlet} - remove the Zimlet from the system");
        System.out.println("\tinstall {zimlet.zip} - installs the Zimlet files on this host");
        System.out.println("\tldapDeploy {zimlet} - add the Zimlet entry to the system");
        System.out.println("\tenable {zimlet} - enables the Zimlet");
        System.out.println("\tdisable {zimlet} - disables the Zimlet");
        System.out.println("\tacl {zimlet} {cos1} grant|deny [{cos2} grant|deny...] - change the ACL for the Zimlet on a COS");
        System.out.println("\tlistAcls {zimlet} - list ACLs for the Zimlet");
        System.out.println("\tlistZimlets - show status of all the Zimlets in the system.");
        System.out.println("\tgetConfigTemplate {zimlet.zip} - dumps the configuration");
        System.out.println("\tconfigure {config.xml} - installs the configuration");
        System.out.println("\tlistPriority - show the current Zimlet priorities (0 high, 9 low)");
        System.out.println("\tsetPriority {zimlet} {priority} - set Zimlet priority");
        System.out.println("\tinfo {zimlet} - show information about zimlet");
        System.out.println("\tcreateZip {zimlet directory} [description-file] - creates zimlet.zip from the contents in the directory");
        System.exit(1);
    }

    private static int lookupCmd(String cmd) {
        Integer i = mCommands.get(cmd.toLowerCase());
        if (i == null) {
            ZimletUtil.usage();
        }
        return i;
    }

    private static void dispatch(String[] args) {
        boolean localInstall = false;
        if (args[argPos].equals("-l")) {
            localInstall = true;
            ++argPos;
        }
        String adminURL = null;
        String uploadURL = null;
        if (args[argPos].equals("-a")) {
            adminURL = args[++argPos];
            ++argPos;
        }
        if (args[argPos].equals("-u")) {
            uploadURL = args[++argPos];
            ++argPos;
        }
        if (argPos >= args.length) {
            ZimletUtil.usage();
        }
        int cmd = ZimletUtil.lookupCmd(args[argPos++]);
        try {
            switch (cmd) {
                case 12: {
                    boolean everything = false;
                    if (args.length > argPos && args[argPos].equals("all")) {
                        everything = true;
                    }
                    ZimletUtil.listAllZimlets(everything);
                    System.exit(0);
                }
                case 21: {
                    ZimletUtil.listPriority();
                    System.exit(0);
                }
                case 99: {
                    ZimletUtil.test();
                    System.exit(0);
                }
            }
            if (args.length < argPos + 1) {
                ZimletUtil.usage();
            }
            String zimlet = args[argPos++];
            switch (cmd) {
                case 18: {
                    if (localInstall) {
                        ZimletUtil.deployZimlet(new ZimletFile(zimlet));
                        break;
                    }
                    ZimletUtil.deployZimletBySoap(zimlet, adminURL, uploadURL);
                    break;
                }
                case 10: {
                    ZimletUtil.installZimlet(new ZimletFile(zimlet));
                    break;
                }
                case 11: {
                    ZimletSoapUtil su = new ZimletSoapUtil();
                    if (localInstall) {
                        Server localServer = Provisioning.getInstance().getLocalServer();
                        su.undeployZimletOnServer(zimlet, localServer);
                        break;
                    }
                    su.undeployZimlet(zimlet);
                    break;
                }
                case 17: {
                    ZimletUtil.ldapDeploy(zimlet);
                    break;
                }
                case 13: {
                    if (args.length < argPos + 2 || args.length % 2 != 0) {
                        ZimletUtil.usage();
                    }
                    ZimletUtil.aclZimlet(zimlet, args);
                    break;
                }
                case 22: {
                    if (args.length < argPos + 1) {
                        ZimletUtil.usage();
                    }
                    ZimletUtil.setPriority(zimlet, Integer.parseInt(args[argPos]));
                    ZimletUtil.listPriority();
                    break;
                }
                case 14: {
                    ZimletUtil.listAcls(zimlet);
                    break;
                }
                case 19: {
                    ZimletUtil.enableZimlet(zimlet);
                    break;
                }
                case 20: {
                    ZimletUtil.disableZimlet(zimlet);
                    break;
                }
                case 15: {
                    ZimletUtil.dumpConfig(zimlet);
                    break;
                }
                case 16: {
                    ZimletSoapUtil soapUtil = new ZimletSoapUtil();
                    soapUtil.configureZimlet(ByteUtil.getContent(new File(zimlet)), localInstall);
                    break;
                }
                case 23: {
                    ZimletUtil.showInfo(zimlet);
                    break;
                }
                case 24: {
                    ZimletUtil.createZip(zimlet, args.length == argPos ? null : args[argPos]);
                    break;
                }
                default: {
                    ZimletUtil.usage();
                    break;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            if (sQuietMode) {
                ZimbraLog.zimlet.error("Error " + e.getMessage());
            } else {
                ZimbraLog.zimlet.error((Object)"Error", e);
            }
            System.exit(1);
        }
    }

    private static void getOpt(String[] args) {
        int index;
        if (args.length < 1) {
            ZimletUtil.usage();
        }
        for (index = 0; index < args.length && args[index].equals("-q"); ++index) {
            sQuietMode = true;
        }
        argPos = index;
    }

    public static void main(String[] args) throws IOException {
        ZimletUtil.getOpt(args);
        if (sQuietMode) {
            CliUtil.toolSetup("WARN");
        } else {
            CliUtil.toolSetup();
        }
        SoapTransport.setDefaultUserAgent("zmzimletctl", BuildInfo.VERSION);
        ZimletUtil.setup();
        ZimletUtil.dispatch(args);
    }

    static {
        sQuietMode = false;
        argPos = 0;
    }

    private static class ZimletSoapUtil {
        private String mUsername;
        private String mPassword;
        private String mAttachmentId;
        private String mAdminURL;
        private String mUploadURL;
        private ZAuthToken mAuth;
        private SoapHttpTransport mTransport;
        private boolean mRunningInServer;
        private Provisioning mProv;

        public ZimletSoapUtil() throws ServiceException {
            this.initZimletSoapUtil(null, null);
        }

        public ZimletSoapUtil(String adminURL, String uploadURL) throws ServiceException {
            this(adminURL, uploadURL, null, null);
        }

        public ZimletSoapUtil(String adminURL, String uploadURL, String username, String password) throws ServiceException {
            this.mAdminURL = adminURL;
            this.mUploadURL = uploadURL;
            this.initZimletSoapUtil(username, password);
        }

        private void initZimletSoapUtil(String username, String password) throws ServiceException {
            this.mUsername = username != null ? username : LC.zimbra_ldap_user.value();
            this.mPassword = password != null ? password : LC.zimbra_ldap_password.value();
            this.mAuth = null;
            this.mRunningInServer = false;
            String adminURL = this.mAdminURL;
            if (adminURL == null) {
                String server = LC.zimbra_zmprov_default_soap_server.value();
                adminURL = URLUtil.getAdminURL(server);
            }
            SoapProvisioning sp = new SoapProvisioning();
            sp.soapSetURI(adminURL);
            sp.soapAdminAuthenticate(this.mUsername, this.mPassword);
            this.mProv = sp;
        }

        public ZimletSoapUtil(ZAuthToken auth) {
            this.mAuth = auth;
            this.mRunningInServer = true;
            this.mProv = Provisioning.getInstance();
        }

        public void deployZimlet(String zimlet, byte[] data, DeployListener listener) throws ServiceException {
            this.deployZimlet(zimlet, data, listener, false);
        }

        public void deployZimlet(String zimlet, byte[] data, DeployListener listener, boolean flushCache) throws ServiceException {
            List<Server> allServers = this.mProv.getAllServers();
            for (Server server : allServers) {
                boolean hasMailboxService = server.getMultiAttrSet("zimbraServiceEnabled").contains("mailbox");
                if (this.mRunningInServer && this.mProv.getLocalServer().compareTo(server) == 0 || !hasMailboxService) {
                    ZimbraLog.zimlet.info("Skipping on " + server.getName());
                    continue;
                }
                ZimbraLog.zimlet.info("Deploying on " + server.getName());
                this.deployZimletOnServer(zimlet, data, server, listener, flushCache);
            }
        }

        public void undeployZimlet(String zimlet) throws ServiceException {
            List<Server> allServers = this.mProv.getAllServers();
            for (Server server : allServers) {
                boolean hasMailboxService = server.getMultiAttrSet("zimbraServiceEnabled").contains("mailbox");
                if (this.mRunningInServer && this.mProv.getLocalServer().compareTo(server) == 0 || !hasMailboxService) continue;
                ZimbraLog.zimlet.info("Undeploying on " + server.getName());
                this.undeployZimletOnServer(zimlet, server);
            }
        }

        public void configureZimlet(byte[] config, boolean localInstall) throws ServiceException {
            if (localInstall) {
                ZimbraLog.zimlet.info("Configure zimlet on " + this.mProv.getLocalServer().getName());
                this.configureZimletOnServer(config, this.mProv.getLocalServer());
            } else {
                List<Server> allServers = this.mProv.getAllServers();
                for (Server server : allServers) {
                    boolean hasMailboxService = server.getMultiAttrSet("zimbraServiceEnabled").contains("mailbox");
                    if (this.mRunningInServer && this.mProv.getLocalServer().compareTo(server) == 0 || !hasMailboxService) continue;
                    ZimbraLog.zimlet.info("Configure zimlet on " + server.getName());
                    this.configureZimletOnServer(config, server);
                }
            }
        }

        public void deployZimletOnServer(String zimlet, byte[] data) throws ServiceException {
            this.deployZimletOnServer(zimlet, data, false);
        }

        public void deployZimletOnServer(String zimlet, byte[] data, boolean flushCache) throws ServiceException {
            this.mTransport = null;
            try {
                try {
                    this.mTransport = new SoapHttpTransport(this.mAdminURL);
                    this.auth();
                    this.mTransport.setAuthToken(this.mAuth);
                    URL url = new URL(this.mUploadURL);
                    this.mAttachmentId = this.postAttachment(this.mUploadURL, zimlet, data, url.getHost());
                    this.soapDeployZimlet(flushCache);
                    ZimbraLog.zimlet.info("Deploy initiated.  Check the server's mailbox.log for the status.");
                }
                catch (Exception e) {
                    ZimbraLog.zimlet.info((Object)("deploy failed on " + this.mAdminURL), e);
                    if (e instanceof ServiceException) {
                        throw (ServiceException)e;
                    }
                    throw ServiceException.FAILURE("Unable to deploy Zimlet " + zimlet + " on " + this.mAdminURL, e);
                }
                Object var6_6 = null;
                if (this.mTransport != null) {
                    this.mTransport.shutdown();
                }
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                if (this.mTransport != null) {
                    this.mTransport.shutdown();
                }
                throw throwable;
            }
        }

        public void deployZimletOnServer(String zimlet, byte[] data, Server server, DeployListener listener) throws ServiceException {
            this.deployZimletOnServer(zimlet, data, server, listener, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void deployZimletOnServer(String zimlet, byte[] data, Server server, DeployListener listener, boolean flushCache) throws ServiceException {
            this.mTransport = null;
            try {
                block10: {
                    try {
                        String adminUrl = URLUtil.getAdminURL(server, "/service/admin/soap/");
                        this.mTransport = new SoapHttpTransport(adminUrl);
                        if (this.mAuth == null) {
                            this.auth();
                        }
                        this.mTransport.setAuthToken(this.mAuth);
                        String uploadUrl = URLUtil.getAdminURL(server, "/service/upload?fmt=raw");
                        this.mAttachmentId = this.postAttachment(uploadUrl, zimlet, data, server.getName());
                        this.soapDeployZimlet(flushCache);
                        ZimbraLog.zimlet.info("Deploy initiated.  (check the servers mailbox.log for the status)");
                        if (listener == null) break block10;
                        listener.markFinished(server);
                    }
                    catch (Exception e) {
                        ZimbraLog.zimlet.info((Object)("deploy failed on " + server.getName()), e);
                        if (listener == null) {
                            if (e instanceof ServiceException) {
                                throw (ServiceException)e;
                            }
                            throw ServiceException.FAILURE("Unable to deploy Zimlet " + zimlet + " on " + server.getName(), e);
                        }
                        listener.markFailed(server);
                        Object var9_10 = null;
                        if (this.mTransport != null) {
                            this.mTransport.shutdown();
                        }
                    }
                }
                Object var9_9 = null;
                if (this.mTransport != null) {
                    this.mTransport.shutdown();
                }
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                if (this.mTransport != null) {
                    this.mTransport.shutdown();
                }
                throw throwable;
            }
        }

        private void soapDeployZimlet(boolean flushCache) throws ServiceException, IOException {
            Element.XMLElement req = new Element.XMLElement(AdminConstants.DEPLOY_ZIMLET_REQUEST);
            req.addAttribute("action", "deploylocal");
            req.addAttribute("flush", flushCache);
            req.addElement("content").addAttribute("aid", this.mAttachmentId);
            this.mTransport.invoke(req);
        }

        public void undeployZimletOnServer(String zimlet, Server server) throws ServiceException {
            this.mTransport = null;
            try {
                try {
                    String adminUrl = URLUtil.getAdminURL(server, "/service/admin/soap/");
                    this.mTransport = new SoapHttpTransport(adminUrl);
                    if (this.mAuth == null) {
                        this.auth();
                    }
                    this.mTransport.setAuthToken(this.mAuth);
                    this.soapUndeployZimlet(zimlet);
                    ZimbraLog.zimlet.info("Undeploy initiated.  (check the servers mailbox.log for the status)");
                }
                catch (Exception e) {
                    if (e instanceof ServiceException) {
                        throw (ServiceException)e;
                    }
                    throw ServiceException.FAILURE("Unable to undeploy Zimlet " + zimlet + " on " + server.getName(), e);
                }
                Object var5_5 = null;
                if (this.mTransport != null) {
                    this.mTransport.shutdown();
                }
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                if (this.mTransport != null) {
                    this.mTransport.shutdown();
                }
                throw throwable;
            }
        }

        private void soapUndeployZimlet(String name) throws ServiceException, IOException {
            Element.XMLElement req = new Element.XMLElement(AdminConstants.UNDEPLOY_ZIMLET_REQUEST);
            req.addAttribute("action", "deploylocal");
            req.addAttribute("name", name);
            this.mTransport.invoke(req);
        }

        public void configureZimletOnServer(byte[] config, Server server) throws ServiceException {
            this.mTransport = null;
            try {
                try {
                    String adminUrl = URLUtil.getAdminURL(server, "/service/admin/soap/");
                    this.mTransport = new SoapHttpTransport(adminUrl);
                    if (this.mAuth == null) {
                        this.auth();
                    }
                    this.mTransport.setAuthToken(this.mAuth);
                    String uploadUrl = URLUtil.getAdminURL(server, "/service/upload?fmt=raw");
                    this.mAttachmentId = this.postAttachment(uploadUrl, "config.xml", config, server.getName());
                    this.soapConfigureZimlet();
                    ZimbraLog.zimlet.info("Configure initiated.  (check the servers mailbox.log for the status)");
                }
                catch (Exception e) {
                    if (e instanceof ServiceException) {
                        throw (ServiceException)e;
                    }
                    throw ServiceException.FAILURE("Unable to configure Zimlet on " + server.getName(), e);
                }
                Object var6_6 = null;
                if (this.mTransport != null) {
                    this.mTransport.shutdown();
                }
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                if (this.mTransport != null) {
                    this.mTransport.shutdown();
                }
                throw throwable;
            }
        }

        private void soapConfigureZimlet() throws ServiceException, IOException {
            Element.XMLElement req = new Element.XMLElement(AdminConstants.CONFIGURE_ZIMLET_REQUEST);
            req.addElement("content").addAttribute("aid", this.mAttachmentId);
            this.mTransport.invoke(req);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String postAttachment(String uploadURL, String name, byte[] data, String domain) throws IOException, ZimletException {
            String aid = null;
            HttpClient client = new HttpClient();
            Map<String, String> cookieMap = this.mAuth.cookieMap(true);
            if (cookieMap != null) {
                HttpState state = new HttpState();
                for (Map.Entry<String, String> ck : cookieMap.entrySet()) {
                    state.addCookie(new Cookie(domain, ck.getKey(), ck.getValue(), "/", -1, false));
                }
                client.setState(state);
                client.getParams().setCookiePolicy("compatibility");
            }
            PostMethod post = new PostMethod(uploadURL);
            post.getParams().setSoTimeout(10000);
            int statusCode = -1;
            try {
                String contentType = URLConnection.getFileNameMap().getContentTypeFor(name);
                Part[] parts = new Part[]{new ByteArrayPart(data, name, contentType)};
                post.setRequestEntity(new MultipartRequestEntity(parts, post.getParams()));
                statusCode = client.executeMethod(post);
                if (statusCode == 200) {
                    String response = post.getResponseBodyAsString();
                    String[] responseParts = response.split(",", 3);
                    if (responseParts.length == 3) {
                        aid = responseParts[2].trim();
                        if (aid.startsWith("'") || aid.startsWith("\"")) {
                            aid = aid.substring(1);
                        }
                        if (aid.endsWith("'") || aid.endsWith("\"")) {
                            aid = aid.substring(0, aid.length() - 1);
                        }
                    }
                    if (aid == null) {
                        throw ZimletException.CANNOT_DEPLOY("Attachment post failed, unexpected response: " + response, null);
                    }
                } else {
                    throw ZimletException.CANNOT_DEPLOY("Attachment post failed, status=" + statusCode, null);
                }
                Object var15_15 = null;
            }
            catch (Throwable throwable) {
                Object var15_16 = null;
                post.releaseConnection();
                throw throwable;
            }
            post.releaseConnection();
            return aid;
        }

        private void auth() throws ServiceException, IOException {
            Element.XMLElement req = new Element.XMLElement(AdminConstants.AUTH_REQUEST);
            req.addElement("name").setText(this.mUsername);
            req.addElement("password").setText(this.mPassword);
            Element resp = this.mTransport.invoke(req);
            this.mAuth = new ZAuthToken(resp.getElement("authToken"), true);
        }

        private static class ByteArrayPart
        extends PartBase {
            private byte[] mData;
            private String mName;

            public ByteArrayPart(byte[] data, String name, String type) throws IOException {
                super(name, type, "UTF-8", "binary");
                this.mName = name;
                this.mData = data;
            }

            protected void sendData(OutputStream out) throws IOException {
                out.write(this.mData);
            }

            protected long lengthOfData() throws IOException {
                return this.mData.length;
            }

            protected void sendDispositionHeader(OutputStream out) throws IOException {
                super.sendDispositionHeader(out);
                StringBuilder buf = new StringBuilder();
                buf.append("; filename=\"").append(this.mName).append("\"");
                out.write(buf.toString().getBytes());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Action {
        INSTALL,
        UPGRADE,
        REPAIR;

    }

    public static interface DeployListener {
        public void markFinished(Server var1);

        public void markFailed(Server var1);
    }
}

