/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.zimlet;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.zimlet.ZimletProperty;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.collections.map.LRUMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZimletUserProperties {
    private static final String SEPARATOR = ":";
    private static final long TTL = 1800000L;
    private long mCreateTime;
    private static LRUMap sUserPropMap = new LRUMap(1024);
    private Set<ZimletProp> mPropSet;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ZimletUserProperties getProperties(Account ac) {
        ZimletUserProperties prop;
        String id = ac.getId();
        LRUMap lRUMap = sUserPropMap;
        synchronized (lRUMap) {
            prop = (ZimletUserProperties)sUserPropMap.get((Object)id);
            if (prop != null && prop.mCreateTime + 1800000L < System.currentTimeMillis()) {
                prop = null;
                sUserPropMap.remove((Object)id);
            }
            if (prop == null) {
                prop = new ZimletUserProperties(ac);
                sUserPropMap.put((Object)id, (Object)prop);
            }
        }
        return prop;
    }

    private ZimletUserProperties(Account ac) {
        String[] props = ac.getMultiAttr("zimbraZimletUserProperties");
        this.mPropSet = new HashSet<ZimletProp>();
        for (int i = 0; i < props.length; ++i) {
            try {
                ZimletProp zp = new ZimletProp(props[i]);
                this.mPropSet.add(zp);
                continue;
            }
            catch (IllegalArgumentException iae) {
                ZimbraLog.zimlet.warn("invalid property: " + iae.getMessage());
            }
        }
        this.mCreateTime = System.currentTimeMillis();
    }

    public void setProperty(String zimlet, String key, String value) {
        ZimletProp newProp = new ZimletProp(zimlet, key, value);
        for (ZimletProp zp : this.mPropSet) {
            if (!zp.matches(newProp)) continue;
            zp.replace(newProp);
            return;
        }
        this.mPropSet.add(newProp);
    }

    public Set<ZimletProp> getAllProperties() {
        return this.mPropSet;
    }

    public void saveProperties(Account ac) throws ServiceException {
        String[] props = new String[this.mPropSet.size()];
        Iterator<ZimletProp> iter = this.mPropSet.iterator();
        int index = 0;
        while (iter.hasNext()) {
            ZimletProp zp = iter.next();
            props[index++] = zp.prop;
        }
        HashMap<String, String[]> propMap = new HashMap<String, String[]>();
        propMap.put("zimbraZimletUserProperties", props);
        Provisioning.getInstance().modifyAttrs(ac, propMap);
    }

    public static void main(String[] args) throws Exception {
        Provisioning prov = Provisioning.getInstance();
        Account acct = prov.get(Provisioning.AccountBy.name, "user1");
        ZimletUserProperties prop = new ZimletUserProperties(acct);
        prop.setProperty("phone", "123123", "aaaaaaaaaaaa");
        prop.setProperty("phone", "number", "bar");
        prop.saveProperties(acct);
    }

    public static class ZimletProp
    implements ZimletProperty {
        public String zimlet;
        public String key;
        public String value;
        public String prop;

        public ZimletProp(String zimlet, String key, String value) {
            this.zimlet = zimlet;
            this.key = key;
            this.value = value;
            this.prop = zimlet + ZimletUserProperties.SEPARATOR + key + ZimletUserProperties.SEPARATOR + value;
        }

        public ZimletProp(String prop) throws IllegalArgumentException {
            this.prop = prop;
            int sep1 = prop.indexOf(ZimletUserProperties.SEPARATOR);
            int sep2 = prop.indexOf(ZimletUserProperties.SEPARATOR, sep1 + 1);
            if (sep1 < 0 || sep2 < 0) {
                throw new IllegalArgumentException(prop);
            }
            this.zimlet = prop.substring(0, sep1);
            this.key = prop.substring(sep1 + 1, sep2);
            this.value = prop.substring(sep2 + 1);
        }

        public boolean matches(ZimletProp other) {
            return this.zimlet.equals(other.zimlet) && this.key.equals(other.key);
        }

        public void replace(ZimletProp other) {
            this.zimlet = other.zimlet;
            this.key = other.key;
            this.value = other.value;
            this.prop = other.prop;
        }

        public String getZimletName() {
            return this.zimlet;
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }
    }
}

