/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.zimlet;

import com.yahoo.platform.yui.compressor.CssCompressor;
import com.yahoo.platform.yui.compressor.JavaScriptCompressor;
import com.zimbra.common.localconfig.LC;
import com.zimbra.common.util.ByteUtil;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.servlet.DiskCacheServlet;
import com.zimbra.cs.zimlet.ZimletException;
import com.zimbra.cs.zimlet.ZimletFile;
import com.zimbra.cs.zimlet.ZimletUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.activation.MimetypesFileTypeMap;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.mozilla.javascript.ErrorReporter;
import org.mozilla.javascript.EvaluatorException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZimletResources
extends DiskCacheServlet {
    private static final String COMPRESSED_EXT = ".zgz";
    public static final String RESOURCE_PATH = "/res/";
    private static final String P_DEBUG = "debug";
    private static final String T_CSS = "css";
    private static final String T_JAVASCRIPT = "javascript";
    private static final String T_PLAIN = "plain";
    private static final Map<String, String> TYPES = new HashMap<String, String>();
    private static final Pattern RE_REMOTE = Pattern.compile("^((https?|ftps?)://|/)");
    private static final Pattern RE_CSS_URL = Pattern.compile("(url\\(['\"]?)([^'\"\\)]*)", 2);
    private static MimetypesFileTypeMap sFileTypeMap;

    public ZimletResources() {
        super("zimletres");
    }

    @Override
    public void service(ServletRequest request, ServletResponse response) throws IOException, ServletException {
        if (this.flushCache(request)) {
            return;
        }
        ZimbraLog.clearContext();
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse resp = (HttpServletResponse)response;
        String uri = req.getRequestURI();
        String pathInfo = req.getPathInfo();
        if (pathInfo == null) {
            resp.setStatus(400);
            return;
        }
        Set zimletNames = (Set)req.getAttribute("com.zimbra.cs.zimlet.Allowed");
        if (!pathInfo.startsWith(RESOURCE_PATH)) {
            ServletContext targetContext = this.getServletConfig().getServletContext().getContext("/zimlet");
            RequestDispatcher dispatcher = targetContext.getRequestDispatcher(pathInfo);
            dispatcher.forward((ServletRequest)req, (ServletResponse)resp);
            return;
        }
        String contentType = ZimletResources.getContentType(uri);
        String type = contentType.replaceAll("^.*/", "");
        boolean debug = req.getParameter(P_DEBUG) != null;
        String cacheId = this.getCacheId(req, type, zimletNames);
        if (ZimbraLog.zimlet.isDebugEnabled()) {
            ZimbraLog.zimlet.debug("DEBUG: uri=" + uri);
            ZimbraLog.zimlet.debug("DEBUG: cacheId=" + cacheId);
            ZimbraLog.zimlet.debug("DEBUG: contentType=" + contentType);
            ZimbraLog.zimlet.debug("DEBUG: type=" + type);
        }
        File file = !debug ? this.getCacheFile(cacheId) : null;
        String text = null;
        if (file == null || !file.exists()) {
            StringWriter out;
            CssCompressor compressor;
            StringWriter writer = new StringWriter();
            PrintWriter printer = new PrintWriter(writer);
            if (type.equals(T_JAVASCRIPT)) {
                String mailUrl = "/zimbra";
                try {
                    mailUrl = Provisioning.getInstance().getLocalServer().getMailURL();
                }
                catch (Exception e) {
                    ZimbraLog.zimlet.warn((Object)"can't get mailUrl", e);
                }
                ServletConfig config = this.getServletConfig();
                ServletContext baseContext = config.getServletContext();
                ServletContext clientContext = baseContext.getContext(mailUrl);
                RequestDispatcher dispatcher = clientContext.getRequestDispatcher(RESOURCE_PATH);
                for (String zimletName : zimletNames) {
                    RequestWrapper wrappedReq = new RequestWrapper(req, RESOURCE_PATH + zimletName);
                    ResponseWrapper wrappedResp = new ResponseWrapper(resp, printer);
                    dispatcher.include((ServletRequest)wrappedReq, (ServletResponse)wrappedResp);
                }
            }
            if (ZimbraLog.zimlet.isDebugEnabled()) {
                ZimbraLog.zimlet.debug("DEBUG: generating buffer");
            }
            this.generate(zimletNames, type, printer);
            text = writer.toString();
            if (type.equals(T_CSS) && !debug) {
                compressor = new CssCompressor((Reader)new StringReader(text));
                out = new StringWriter();
                compressor.compress((Writer)out, 0);
                text = out.toString();
            }
            if (type.equals(T_JAVASCRIPT) && !debug) {
                text = text.replaceAll("(^|\n)\\s*DBG\\.\\w+\\(.*\\);\\s*(\n|$)", "\n");
                compressor = new JavaScriptCompressor((Reader)new StringReader(text), new ErrorReporter(){

                    public void warning(String message, String sourceName, int line, String lineSource, int lineOffset) {
                        if (line < 0) {
                            ZimbraLog.zimlet.warn("\n" + message);
                        } else {
                            ZimbraLog.zimlet.warn("\n" + line + ':' + lineOffset + ':' + message);
                        }
                    }

                    public void error(String message, String sourceName, int line, String lineSource, int lineOffset) {
                        if (line < 0) {
                            ZimbraLog.zimlet.error("\n" + message);
                        } else {
                            ZimbraLog.zimlet.error("\n" + line + ':' + lineOffset + ':' + message);
                        }
                    }

                    public EvaluatorException runtimeError(String message, String sourceName, int line, String lineSource, int lineOffset) {
                        this.error(message, sourceName, line, lineSource, lineOffset);
                        return new EvaluatorException(message);
                    }
                });
                out = new StringWriter();
                compressor.compress((Writer)out, 0, true, false, false, false);
                String mintext = out.toString();
                if (mintext == null) {
                    ZimbraLog.zimlet.info("unable to minimize zimlet JS source");
                } else {
                    text = mintext;
                }
            }
            if (!debug) {
                file = File.createTempFile("res-", "." + type, this.getCacheDir());
                if (ZimbraLog.zimlet.isDebugEnabled()) {
                    ZimbraLog.zimlet.debug("DEBUG: buffer file: " + file);
                }
                this.copy(text, file);
                if (LC.zimbra_web_generate_gzip.booleanValue()) {
                    this.compress(file);
                }
                this.putCacheFile(cacheId, file);
            }
        } else if (ZimbraLog.zimlet.isDebugEnabled()) {
            ZimbraLog.zimlet.debug("DEBUG: using previous buffer");
        }
        boolean compress = !debug && uri.endsWith(COMPRESSED_EXT);
        try {
            resp.addHeader("Vary", "User-Agent");
            if (file == null || req.getProtocol().endsWith("1.0")) {
                resp.setHeader("Expires", "Tue, 24 Jan 2000 17:46:50 GMT");
                resp.setHeader("Cache-Control", "no-store, no-cache, must-revalidate, max-age=0");
                resp.setHeader("Pragma", "no-cache");
            } else {
                resp.setHeader("Cache-Control", "must-revalidate, max-age=0");
                if (file.lastModified() <= req.getDateHeader("If-Modified-Since")) {
                    resp.setStatus(304);
                    return;
                }
                resp.setDateHeader("Last-Modified", file.lastModified());
            }
            resp.setContentType(contentType);
            resp.setContentLength(file != null ? (int)file.length() : text.getBytes("UTF-8").length);
        }
        catch (IllegalStateException e) {
            ZimbraLog.zimlet.debug("zimletres: " + cacheId);
            ZimbraLog.zimlet.debug("zimletres: " + e.getMessage());
        }
        if (file != null) {
            this.copy(file, resp, compress);
        } else {
            this.copy(text, resp, compress);
        }
    }

    private void printFile(HttpServletResponse resp, String zimletName, String file) throws IOException, ZimletException {
        ZimletFile zf = ZimletUtil.getZimlet(zimletName);
        if (zf == null) {
            ZimbraLog.zimlet.warn("zimlet file not found for: %s", zimletName);
            resp.setStatus(404);
            return;
        }
        ZimletFile.ZimletEntry entry = zf.getEntry(file);
        if (entry == null) {
            ZimbraLog.zimlet.warn("requested file not found for zimlet: %s (%s)", zimletName, file);
            resp.setStatus(404);
            return;
        }
        resp.setStatus(200);
        resp.setHeader("Expires", "Tue, 24 Jan 2000 17:46:50 GMT");
        resp.setHeader("Cache-Control", "no-store, no-cache, must-revalidate, max-age=0");
        resp.setHeader("Pragma", "no-cache");
        String contentType = null;
        int dot = file.lastIndexOf(46);
        if (dot > 0) {
            contentType = TYPES.get(file.substring(dot + 1));
        }
        if (contentType == null) {
            contentType = sFileTypeMap.getContentType(file);
        }
        ZimbraLog.zimlet.debug("%s: %s", file, contentType);
        if (contentType != null) {
            resp.setContentType(contentType);
        }
        ByteUtil.copy(entry.getContentStream(), true, (OutputStream)resp.getOutputStream(), false);
    }

    private void generate(Set<String> zimletNames, String type, PrintWriter out) throws IOException {
        boolean isCSS = type.equals(T_CSS);
        String commentStart = "/* ";
        String commentContinue = " * ";
        String commentEnd = " */";
        for (String zimlet : zimletNames) {
            ZimletFile file = ZimletUtil.getZimlet(zimlet);
            if (file == null) {
                ZimbraLog.zimlet.warn("error loading " + zimlet + ": zimlet not found ");
                continue;
            }
            try {
                String[] files;
                for (String f : files = isCSS ? file.getZimletDescription().getStyleSheets() : file.getZimletDescription().getScripts()) {
                    ZimletFile.ZimletEntry entry;
                    if (RE_REMOTE.matcher(f).matches() || (entry = file.getEntry(f)) == null) continue;
                    out.println(commentStart);
                    out.print(commentContinue);
                    out.print("Zimlet: " + zimlet + "File: " + f);
                    out.println(commentEnd);
                    out.println();
                    this.printFile(out, new BufferedReader(new InputStreamReader(entry.getContentStream())), zimlet, isCSS);
                    out.println();
                }
            }
            catch (ZimletException e) {
                ZimbraLog.zimlet.error((Object)("error loading " + zimlet + ": "), e);
            }
        }
        out.flush();
    }

    private void printFile(PrintWriter out, BufferedReader in, String zimletName, boolean isCSS) throws IOException {
        String line;
        while ((line = in.readLine()) != null) {
            Matcher url;
            if (isCSS && (url = RE_CSS_URL.matcher(line)).find()) {
                int offset = 0;
                do {
                    int start;
                    if ((start = url.start()) > offset) {
                        out.print(line.substring(offset, start));
                    }
                    out.print(url.group(1));
                    String s = url.group(2);
                    Matcher remote = RE_REMOTE.matcher(s);
                    if (!remote.find()) {
                        out.print("/service/zimlet/" + zimletName + "/");
                    }
                    out.print(s);
                    offset = url.end();
                } while (url.find());
                if (offset >= line.length()) continue;
                out.println(line.substring(offset));
                continue;
            }
            out.println(line);
        }
        in.close();
    }

    private static String getContentType(String uri) {
        String contentType;
        int index = uri.indexOf(46);
        String type = T_PLAIN;
        if (index != -1 && (index = (type = uri.substring(index + 1)).indexOf(46)) != -1) {
            type = type.substring(0, index);
        }
        return (contentType = TYPES.get(type)) != null ? contentType : TYPES.get(T_PLAIN);
    }

    private String getCacheId(HttpServletRequest req, String type, Set<String> zimletNames) {
        StringBuilder str = new StringBuilder();
        str.append(ZimletResources.getLocale(req).toString());
        str.append(":");
        str.append(type);
        if (req.getRequestURI().endsWith(COMPRESSED_EXT)) {
            str.append(COMPRESSED_EXT);
        }
        str.append(":");
        Iterator<String> iter = zimletNames.iterator();
        int i = 0;
        while (iter.hasNext()) {
            if (i > 0) {
                str.append(",");
            }
            str.append(iter.next());
            ++i;
        }
        return str.toString();
    }

    private static Locale getLocale(HttpServletRequest req) {
        String language = req.getParameter("language");
        if (language != null) {
            String country = req.getParameter("country");
            if (country != null) {
                String variant = req.getParameter("variant");
                if (variant != null) {
                    return new Locale(language, country, variant);
                }
                return new Locale(language, country);
            }
            return new Locale(language);
        }
        return req.getLocale();
    }

    static {
        TYPES.put(T_CSS, "text/css");
        TYPES.put("js", "text/javascript");
        TYPES.put("xsl", "application/xslt+xml");
        TYPES.put(T_PLAIN, "text/plain");
        sFileTypeMap = new MimetypesFileTypeMap();
    }

    static class ServletStream
    extends ServletOutputStream {
        private PrintWriter out;

        public ServletStream(PrintWriter out) {
            this.out = out;
        }

        public void write(int i) throws IOException {
            this.out.write(i);
        }

        public void print(boolean b) throws IOException {
            this.out.print(b);
        }

        public void print(char c) throws IOException {
            this.out.print(c);
        }

        public void print(float f) throws IOException {
            this.out.print(f);
        }

        public void print(int i) throws IOException {
            this.out.print(i);
        }

        public void print(long l) throws IOException {
            this.out.print(l);
        }

        public void print(String s) throws IOException {
            this.out.print(s);
        }

        public void println() throws IOException {
            this.out.println();
        }

        public void println(boolean b) throws IOException {
            this.out.println(b);
        }

        public void println(char c) throws IOException {
            this.out.println(c);
        }

        public void println(float f) throws IOException {
            this.out.println(f);
        }

        public void println(int i) throws IOException {
            this.out.println(i);
        }

        public void println(long l) throws IOException {
            this.out.println(l);
        }

        public void println(String s) throws IOException {
            this.out.println(s);
        }
    }

    static class ResponseWrapper
    extends HttpServletResponseWrapper {
        private PrintWriter out;

        public ResponseWrapper(HttpServletResponse resp, PrintWriter out) {
            super(resp);
            this.out = out;
        }

        public void setHeader(String name, String value) {
        }

        public void addHeader(String name, String value) {
        }

        public ServletOutputStream getOutputStream() throws IOException {
            return new ServletStream(this.getWriter());
        }

        public PrintWriter getWriter() throws IOException {
            return this.out;
        }
    }

    static class RequestWrapper
    extends HttpServletRequestWrapper {
        private String filename;

        public RequestWrapper(HttpServletRequest req, String filename) {
            super(req);
            this.filename = filename;
        }

        public String getRequestURI() {
            return this.filename + ".js";
        }
    }
}

