/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.zimlet;

import com.zimbra.common.soap.Element;
import com.zimbra.common.util.ByteUtil;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.zimlet.Version;
import com.zimbra.cs.zimlet.ZimletException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Iterator;
import org.dom4j.DocumentException;

public abstract class ZimletMeta {
    public static final String ZIMLET_TAG_ZIMLET = "zimlet";
    public static final String ZIMLET_ATTR_VERSION = "version";
    public static final String ZIMLET_ATTR_DESCRIPTION = "description";
    public static final String ZIMLET_ATTR_NAME = "name";
    public static final String ZIMLET_ATTR_EXTENSION = "extension";
    public static final String ZIMLET_TAG_SCRIPT = "include";
    public static final String ZIMLET_TAG_CSS = "includeCSS";
    public static final String ZIMLET_TAG_CONTENT_OBJECT = "contentObject";
    public static final String ZIMLET_TAG_PANEL_ITEM = "panelItem";
    public static final String ZIMLET_TAG_SERVER_EXTENSION = "serverExtension";
    public static final String ZIMLET_ATTR_HAS_KEYWORD = "hasKeyword";
    public static final String ZIMLET_ATTR_MATCH_ON = "matchOn";
    public static final String ZIMLET_ATTR_EXTENSION_CLASS = "extensionClass";
    public static final String ZIMLET_ATTR_REGEX = "regex";
    public static final String ZIMLET_TAG_CONFIG = "zimletConfig";
    public static final String ZIMLET_TAG_GLOBAL = "global";
    public static final String ZIMLET_TAG_HOST = "host";
    public static final String ZIMLET_TAG_PROPERTY = "property";
    public static final String ZIMLET_TAG_TARGET = "target";
    public static final String ZIMLET_DISABLE_UI_UNDEPLOY = "disableUIUndeploy";
    protected Element mTopElement;
    protected String mName;
    protected Version mVersion;
    protected String mDescription;
    protected boolean mIsExtension;
    protected String mRawXML;
    protected String mGeneratedXML;

    protected ZimletMeta() {
    }

    public ZimletMeta(File f) throws ZimletException {
        this(ZimletMeta.readFile(f));
    }

    public ZimletMeta(String meta) throws ZimletException {
        this.initialize();
        if (meta == null) {
            return;
        }
        try {
            this.mTopElement = Element.parseXML(meta);
            this.mRawXML = meta;
        }
        catch (DocumentException de) {
            throw ZimletException.INVALID_ZIMLET_DESCRIPTION("Cannot parse Zimlet description: " + de.getMessage());
        }
        this.validate();
    }

    private static String readFile(File f) throws ZimletException {
        try {
            return new String(ByteUtil.getContent(new FileInputStream(f), -1));
        }
        catch (IOException ie) {
            throw ZimletException.INVALID_ZIMLET_DESCRIPTION("Cannot find Zimlet description file: " + f.getName());
        }
    }

    protected void validate() throws ZimletException {
        if (this.mTopElement == null) {
            throw ZimletException.INVALID_ZIMLET_DESCRIPTION("Null DOM element");
        }
        String name = this.mTopElement.getName();
        if (!name.equals(ZIMLET_TAG_ZIMLET) && !name.equals(ZIMLET_TAG_CONFIG)) {
            throw ZimletException.INVALID_ZIMLET_DESCRIPTION("Top level tag not recognized " + name);
        }
        this.mName = this.mTopElement.getAttribute(ZIMLET_ATTR_NAME, "");
        this.mVersion = new Version(this.mTopElement.getAttribute(ZIMLET_ATTR_VERSION, ""));
        this.mDescription = this.mTopElement.getAttribute(ZIMLET_ATTR_DESCRIPTION, "");
        try {
            this.mIsExtension = this.mTopElement.getAttributeBool(ZIMLET_ATTR_EXTENSION, false);
        }
        catch (Exception se) {
            this.mIsExtension = false;
        }
        Iterator<Element> iter = this.mTopElement.listElements().iterator();
        while (iter.hasNext()) {
            this.validateElement(iter.next());
        }
    }

    public String getName() {
        assert (this.mTopElement != null);
        return this.mName;
    }

    public Version getVersion() {
        assert (this.mTopElement != null);
        return this.mVersion;
    }

    public String getDescription() {
        assert (this.mTopElement != null);
        return this.mDescription;
    }

    public boolean isExtension() {
        assert (this.mTopElement != null);
        return this.mIsExtension;
    }

    public String toJSONString() {
        return this.toString(Element.JSONElement.mFactory);
    }

    public String toXMLString() {
        return this.toString(Element.XMLElement.mFactory);
    }

    public String getRawXML() {
        return this.mRawXML;
    }

    public String toString(Element.ElementFactory f) {
        try {
            if (this.mGeneratedXML == null) {
                this.mGeneratedXML = this.mTopElement.toString();
            }
            return Element.parseXML(this.mGeneratedXML, f).toString();
        }
        catch (Exception e) {
            ZimbraLog.zimlet.warn("error parsing the Zimlet file " + this.mName);
            return "";
        }
    }

    public void addToElement(Element elem) throws ZimletException {
        try {
            Element newElem = Element.parseXML(this.toXMLString(), elem.getFactory());
            elem.addElement(newElem);
        }
        catch (DocumentException de) {
            throw ZimletException.ZIMLET_HANDLER_ERROR("cannot parse the dom tree");
        }
    }

    protected abstract void initialize() throws ZimletException;

    protected abstract void validateElement(Element var1) throws ZimletException;
}

