/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.zimlet;

import com.zimbra.common.localconfig.LC;
import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.TemplateCompiler;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.AuthToken;
import com.zimbra.cs.account.Config;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.Zimlet;
import com.zimbra.cs.service.admin.AdminAccessControl;
import com.zimbra.cs.servlet.ZimbraServlet;
import com.zimbra.cs.zimlet.ZimletUtil;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ZimletFilter
extends ZimbraServlet
implements Filter {
    public static final String ALLOWED_ZIMLETS = "com.zimbra.cs.zimlet.Allowed";
    private static final String ZIMLET_URL = "^/service/zimlet/(?:_dev/)?([^/\\?]+)([/\\?]?)(.*)$";
    private static final String ZIMLET_RES_URL_PREFIX = "/service/zimlet/res/";
    private Pattern mPattern;

    public void init(FilterConfig config) throws ServletException {
        this.mPattern = Pattern.compile(ZIMLET_URL);
    }

    private boolean isHttpReq(ServletRequest req, ServletResponse res) {
        return req instanceof HttpServletRequest && res instanceof HttpServletResponse;
    }

    private AuthToken getAuthTokenForApp(HttpServletRequest req, HttpServletResponse resp) throws IOException, ServiceException {
        Config config = Provisioning.getInstance().getConfig();
        int adminPort = config.getIntAttr("zimbraAdminPort", 0);
        if (adminPort == req.getLocalPort()) {
            return ZimletFilter.getAdminAuthTokenFromCookie(req, resp);
        }
        return ZimletFilter.getAuthTokenFromCookie(req, resp, true);
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String zimletName;
        Matcher matcher;
        AuthToken authToken;
        if (!this.isHttpReq(request, response)) {
            return;
        }
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse resp = (HttpServletResponse)response;
        try {
            authToken = this.getAuthTokenForApp(req, resp);
        }
        catch (ServiceException se) {
            ZimbraLog.zimlet.info("can't get authToken: " + se.getMessage());
            resp.setStatus(403);
            return;
        }
        if (authToken == null) {
            return;
        }
        boolean isAdminAuth = false;
        Provisioning prov = Provisioning.getInstance();
        LinkedList<Zimlet> allowedZimlets = new LinkedList<Zimlet>();
        try {
            isAdminAuth = AdminAccessControl.getAdminAccessControl(authToken).isSufficientAdminForZimletFilterServlet();
            if (!isAdminAuth) {
                Account account = prov.get(Provisioning.AccountBy.id, authToken.getAccountId(), authToken);
                for (String zimletName2 : ZimletUtil.getZimlets(account)) {
                    Zimlet zimlet = prov.getZimlet(zimletName2);
                    if (zimlet == null || !zimlet.isEnabled()) continue;
                    allowedZimlets.add(zimlet);
                }
            } else {
                List<Zimlet> allZimlets = prov.listAllZimlets();
                for (Zimlet zimlet : allZimlets) {
                    if (!zimlet.isExtension() || !zimlet.isEnabled()) continue;
                    allowedZimlets.add(zimlet);
                }
            }
        }
        catch (ServiceException e) {
            ZimbraLog.zimlet.info("unable to get list of zimlets");
            resp.setStatus(403);
            return;
        }
        List<Zimlet> zimletList = ZimletUtil.orderZimletsByPriority(allowedZimlets);
        LinkedHashSet<String> allowedZimletNames = new LinkedHashSet<String>();
        for (Zimlet zimlet : zimletList) {
            allowedZimletNames.add(zimlet.getName());
        }
        LinkedHashSet<String> zimletNames = new LinkedHashSet<String>();
        String uri = req.getRequestURI();
        boolean isZimletRes = uri.startsWith(ZIMLET_RES_URL_PREFIX);
        if (isZimletRes) {
            zimletNames.addAll(allowedZimletNames);
        } else {
            Matcher matcher2 = this.mPattern.matcher(uri);
            if (!matcher2.matches()) {
                ZimbraLog.zimlet.info("no zimlet specified in request");
                resp.setStatus(403);
                return;
            }
            zimletNames.add(matcher2.group(1));
        }
        File basedir = new File(LC.zimlet_directory.value());
        File devdir = new File(basedir, "_dev");
        Iterator iter = zimletNames.iterator();
        while (iter.hasNext()) {
            String zimletName3 = (String)iter.next();
            try {
                File devfile = new File(devdir, zimletName3);
                if (devfile.exists()) continue;
                Zimlet zimlet = prov.getZimlet(zimletName3);
                if (zimlet == null) {
                    ZimbraLog.zimlet.info("no such zimlet: " + zimletName3);
                    iter.remove();
                    continue;
                }
                if (!allowedZimletNames.contains(zimletName3)) {
                    ZimbraLog.zimlet.info("unauthorized request to zimlet " + zimletName3 + " from user " + authToken.getAccountId());
                    iter.remove();
                    continue;
                }
                if (!zimlet.isExtension() || isAdminAuth) continue;
                iter.remove();
            }
            catch (ServiceException se) {
                ZimbraLog.zimlet.info("service exception to zimlet " + zimletName3 + " from user " + authToken.getAccountId() + ": " + se.getMessage());
                iter.remove();
            }
        }
        if (!isZimletRes && (matcher = this.mPattern.matcher(uri)).matches() && !zimletNames.contains(zimletName = matcher.group(1))) {
            resp.setStatus(403);
            return;
        }
        if (uri.endsWith(".template.js") && (matcher = this.mPattern.matcher(uri)).matches()) {
            zimletName = matcher.group(1);
            String opath = matcher.group(3);
            String ipath = opath.replaceAll(".js$", "");
            boolean isDevZimlet = uri.indexOf("_dev") != -1;
            File zimletDir = new File(isDevZimlet ? devdir : basedir, zimletName);
            File ifile = new File(zimletDir, ipath);
            File ofile = new File(zimletDir, opath);
            if (!ofile.exists() || ifile.exists() && ifile.lastModified() > ofile.lastModified()) {
                String prefix = zimletName + ".";
                try {
                    TemplateCompiler.compile(zimletDir, zimletDir, prefix, new String[]{ipath}, true, true);
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
        }
        req.setAttribute(ALLOWED_ZIMLETS, zimletNames);
        chain.doFilter((ServletRequest)req, (ServletResponse)resp);
    }

    public void destroy() {
    }
}

