/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.zimlet;

import com.zimbra.common.util.ByteUtil;
import com.zimbra.common.util.TemplateCompiler;
import com.zimbra.cs.zimlet.ZimletConfig;
import com.zimbra.cs.zimlet.ZimletDescription;
import com.zimbra.cs.zimlet.ZimletException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZimletFile
implements Comparable<ZimletFile> {
    private File mBase;
    private InputStream mBaseStream;
    private byte[] mCopy;
    private static final String XML_SUFFIX = ".xml";
    private static final String ZIP_SUFFIX = ".zip";
    private static final String CONFIG_TMPL = "config_template.xml";
    private String mDescFile;
    private Map<String, ZimletEntry> mEntries;
    private ZimletDescription mDesc;
    private String mDescString;
    private ZimletConfig mConfig;
    private String mConfigString;
    private String mZimletName;

    @Override
    public int compareTo(ZimletFile obj) {
        return this.getZimletName().compareTo(obj.getZimletName());
    }

    public ZimletFile(String zimlet) throws IOException, ZimletException {
        this.mBase = new File(ZimletFile.findZimlet(zimlet));
        this.initialize();
    }

    public ZimletFile(File parent, String zimlet) throws IOException, ZimletException {
        this.mBase = new File(parent, zimlet);
        this.initialize();
    }

    public ZimletFile(String name, InputStream is) throws IOException, ZimletException {
        this.mBaseStream = is;
        this.initialize(name);
    }

    private void initialize() throws IOException, ZimletException {
        String name = this.mBase.getName().toLowerCase();
        int index = name.lastIndexOf(File.separatorChar);
        if (index > 0) {
            name = name.substring(index + 1);
        }
        this.initialize(name);
    }

    private void initialize(String name) throws IOException, ZimletException {
        if (name.endsWith(ZIP_SUFFIX)) {
            name = name.substring(0, name.length() - 4);
        }
        this.mDescFile = name + XML_SUFFIX;
        this.mEntries = new HashMap<String, ZimletEntry>();
        if (this.mBaseStream != null) {
            this.mCopy = ByteUtil.getContent(this.mBaseStream, 0);
            JarInputStream zis = new JarInputStream(new ByteArrayInputStream(this.mCopy));
            Manifest mf = zis.getManifest();
            if (mf != null) {
                this.mDescFile = mf.getMainAttributes().getValue("Zimlet-Description-File");
            }
            ZipEntry entry = zis.getNextEntry();
            while (entry != null) {
                if (entry.getSize() > 0L) {
                    this.mEntries.put(entry.getName().toLowerCase(), new ZimletRawEntry(zis, entry.getName(), (int)entry.getSize()));
                }
                zis.closeEntry();
                entry = zis.getNextEntry();
            }
            zis.close();
        } else if (this.mBase.isDirectory()) {
            this.addFileEntry(this.mBase, "");
        } else {
            JarFile jar = new JarFile(this.mBase);
            Manifest mf = jar.getManifest();
            if (mf != null) {
                this.mDescFile = mf.getMainAttributes().getValue("Zimlet-Description-File");
            }
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (entry.getSize() <= 0L) continue;
                this.mEntries.put(entry.getName().toLowerCase(), new ZimletZipEntry(jar, entry));
            }
        }
        this.initZimletDescription();
        this.mZimletName = this.mDesc.getName();
    }

    private void addFileEntry(File f, String dir) throws IOException {
        this.addFileEntry(f, dir, f);
    }

    private void addFileEntry(File f, String dir, File base) throws IOException {
        File[] files = f.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            String name = (dir.length() == 0 ? "" : dir + "/") + file.getName().toLowerCase();
            if (file.isDirectory()) {
                this.addFileEntry(file, name, base);
                continue;
            }
            if (!name.endsWith(".template.js")) {
                this.mEntries.put(name, new ZimletDirEntry(file));
            }
            if (!name.endsWith(".template")) continue;
            this.addTemplateFileEntry(file, dir, base);
        }
    }

    private void addTemplateFileEntry(File ifile, String dir, File base) throws IOException {
        File ofile = new File(ifile.getParentFile(), ifile.getName() + ".js");
        if (!ofile.exists() || ifile.lastModified() > ofile.lastModified()) {
            String prefix = base.getName() + ".";
            String dirname = base.getAbsolutePath();
            if (!dirname.endsWith(File.separator)) {
                dirname = dirname + File.separatorChar;
            }
            String filename = ifile.getAbsolutePath().substring(dirname.length());
            String pkg = prefix + filename.replaceAll("\\.[^\\.]+$", "").replace(File.separatorChar, '.');
            TemplateCompiler.compile(ifile, ofile, pkg, true, true);
        }
        String name = (dir.length() == 0 ? "" : dir + "/") + ofile.getName().toLowerCase();
        this.mEntries.put(name, new ZimletDirEntry(ofile));
    }

    private void initZimletDescription() throws IOException, ZimletException {
        if (this.mDesc == null) {
            ZimletEntry entry = this.mEntries.get(this.mDescFile);
            if (entry == null) {
                throw new FileNotFoundException("zimlet description not found: " + this.mDescFile);
            }
            this.mDescString = new String(entry.getContents(), "UTF-8");
            this.mDesc = new ZimletDescription(this.mDescString);
        }
    }

    public String getZimletDescString() throws IOException, ZimletException {
        this.initZimletDescription();
        return this.mDescString;
    }

    public ZimletDescription getZimletDescription() throws IOException, ZimletException {
        this.initZimletDescription();
        return this.mDesc;
    }

    public boolean hasZimletConfig() {
        return this.mEntries.containsKey(CONFIG_TMPL);
    }

    private void initZimletConfig() throws IOException, ZimletException {
        if (this.mConfig == null) {
            ZimletEntry entry = this.mEntries.get(CONFIG_TMPL);
            if (entry == null) {
                throw new FileNotFoundException("zimlet config not found: config_template.xml");
            }
            this.mConfigString = new String(entry.getContents());
            this.mConfig = new ZimletConfig(this.mConfigString);
        }
    }

    public String getZimletConfigString() throws IOException, ZimletException {
        this.initZimletConfig();
        return this.mConfigString;
    }

    public ZimletConfig getZimletConfig() throws IOException, ZimletException {
        this.initZimletConfig();
        return this.mConfig;
    }

    public ZimletEntry getEntry(String name) {
        return this.mEntries.get(name.toLowerCase());
    }

    public Collection<ZimletEntry> getAllEntries() {
        return this.mEntries.values();
    }

    public String getZimletName() {
        return this.mZimletName;
    }

    public String getName() {
        return this.getZimletName() + ZIP_SUFFIX;
    }

    public URL toURL() throws MalformedURLException {
        return this.mBase.toURL();
    }

    public File getFile() {
        return this.mBase;
    }

    private static String findZimlet(String zimlet) throws FileNotFoundException {
        File zimletFile = new File(zimlet);
        if (!zimletFile.exists() && !(zimletFile = new File(zimlet + ZIP_SUFFIX)).exists()) {
            throw new FileNotFoundException("Zimlet not found: " + zimlet);
        }
        if (zimletFile.isDirectory()) {
            String[] files = zimletFile.list();
            String zimletTargetName = zimletFile.getName() + ZIP_SUFFIX;
            for (int i = 0; i < files.length; ++i) {
                if (!files[i].equals(zimletTargetName)) continue;
                return zimlet + File.separator + files[i];
            }
        }
        return zimlet;
    }

    public byte[] toByteArray() {
        return this.mCopy;
    }

    public static class ZimletRawEntry
    extends ZimletEntry {
        private byte[] mData;

        public ZimletRawEntry(InputStream is, String name, int size) throws IOException {
            super(name);
            int num;
            this.mData = new byte[size];
            int offset = 0;
            for (int len = size; len > 0 && (num = is.read(this.mData, offset, len)) != -1; len -= num) {
                offset += num;
            }
        }

        public byte[] getContents() throws IOException {
            return this.mData;
        }

        public InputStream getContentStream() throws IOException {
            return new ByteArrayInputStream(this.mData);
        }
    }

    public static class ZimletDirEntry
    extends ZimletEntry {
        private File mFile;

        public ZimletDirEntry(File f) {
            super(f.getName());
            this.mFile = f;
        }

        public byte[] getContents() throws IOException {
            FileInputStream is = new FileInputStream(this.mFile);
            byte[] ret = ByteUtil.getContent(is, (int)this.mFile.length());
            ((InputStream)is).close();
            return ret;
        }

        public InputStream getContentStream() throws IOException {
            return new FileInputStream(this.mFile);
        }
    }

    public static class ZimletZipEntry
    extends ZimletEntry {
        private ZipFile mContainer;
        private ZipEntry mEntry;

        public ZimletZipEntry(ZipFile f, ZipEntry e) {
            super(e.getName());
            this.mContainer = f;
            this.mEntry = e;
        }

        public byte[] getContents() throws IOException {
            InputStream is = this.mContainer.getInputStream(this.mEntry);
            byte[] ret = ByteUtil.getContent(is, (int)this.mEntry.getSize());
            is.close();
            return ret;
        }

        public InputStream getContentStream() throws IOException {
            return this.mContainer.getInputStream(this.mEntry);
        }
    }

    public static abstract class ZimletEntry {
        protected String mName;

        protected ZimletEntry(String name) {
            this.mName = name;
        }

        public String getName() {
            return this.mName;
        }

        public abstract byte[] getContents() throws IOException;

        public abstract InputStream getContentStream() throws IOException;
    }
}

