/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.zimlet;

import com.zimbra.common.soap.Element;
import com.zimbra.cs.zimlet.ZimletException;
import com.zimbra.cs.zimlet.ZimletMeta;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZimletDescription
extends ZimletMeta {
    public static final String ZIMLET_REGEX_EXTENSION_CLASS = "com.zimbra.cs.zimlet.handler.RegexHandler";
    private List<String> mScripts;
    private List<String> mStyleSheets;
    private String mContentObject;
    private String mPanelItem;
    private String mExtensionClass;
    private String mKeyword;
    private String mRegexString;
    private List<String> mTargets;
    private String mDisableUIUndeploy;

    public ZimletDescription(File desc) throws ZimletException {
        super(desc);
    }

    public ZimletDescription(String desc) throws ZimletException {
        super(desc);
    }

    @Override
    protected void initialize() {
        this.mScripts = new ArrayList<String>();
        this.mStyleSheets = new ArrayList<String>();
        this.mTargets = new ArrayList<String>();
    }

    @Override
    protected void validateElement(Element elem) throws ZimletException {
        if (elem.getName().equals("contentObject")) {
            this.mContentObject = elem.toString();
        } else if (elem.getName().equals("panelItem")) {
            this.mPanelItem = elem.toString();
        } else if (elem.getName().equals("serverExtension")) {
            this.parseServerExtension(elem);
        } else if (elem.getName().equals("include")) {
            this.parseResource(elem);
        } else if (elem.getName().equals("includeCSS")) {
            this.parseCss(elem);
        } else if (elem.getName().equals("target")) {
            this.mTargets.add(elem.getText());
        } else if (elem.getName().equals("disableUIUndeploy")) {
            this.mDisableUIUndeploy = elem.getText();
        }
    }

    private void parseResource(Element resource) throws ZimletException {
        this.mScripts.add(resource.getText());
    }

    private void parseCss(Element css) throws ZimletException {
        this.mStyleSheets.add(css.getText());
    }

    private void parseServerExtension(Element serverExt) throws ZimletException {
        assert (serverExt.getName().equals("serverExtension"));
        String val = serverExt.getAttribute("hasKeyword", "");
        if (val.length() > 0) {
            this.mKeyword = val;
        }
        if ((val = serverExt.getAttribute("extensionClass", "")).length() > 0) {
            this.mExtensionClass = val;
        }
        if ((val = serverExt.getAttribute("regex", "")).length() > 0) {
            this.mExtensionClass = ZIMLET_REGEX_EXTENSION_CLASS;
            this.mRegexString = val;
        }
    }

    public String getContentObjectAsXML() {
        assert (this.mTopElement != null);
        return this.mContentObject;
    }

    public String getPanelItemAsXML() {
        assert (this.mTopElement != null);
        return this.mPanelItem;
    }

    public String getContentObjectAsJSON() {
        assert (this.mTopElement != null);
        return null;
    }

    public String getPanelItemAsJSON() {
        assert (this.mTopElement != null);
        return null;
    }

    public String[] getScripts() {
        if (this.mScripts.isEmpty()) {
            return new String[0];
        }
        return this.mScripts.toArray(new String[0]);
    }

    public String[] getStyleSheets() {
        if (this.mStyleSheets.isEmpty()) {
            return new String[0];
        }
        return this.mStyleSheets.toArray(new String[0]);
    }

    public String getServerExtensionClass() {
        return this.mExtensionClass;
    }

    public String getServerExtensionKeyword() {
        return this.mKeyword;
    }

    public boolean getServerExtensionHasKeyword() {
        return this.mKeyword != null;
    }

    public String getRegexString() {
        return this.mRegexString;
    }

    public boolean checkTarget(String target) {
        return this.mTargets.contains(target);
    }

    public List<String> getTargets() {
        return this.mTargets;
    }

    public String getDisableUIUndeploy() {
        return this.mDisableUIUndeploy;
    }
}

