/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.zimlet;

import com.zimbra.common.soap.Element;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.zimlet.ZimletConf;
import com.zimbra.cs.zimlet.ZimletException;
import com.zimbra.cs.zimlet.ZimletMeta;
import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;

public class ZimletConfig
extends ZimletMeta
implements ZimletConf {
    public static final String CONFIG_REGEX_VALUE = "ZIMLET_CONFIG_REGEX_VALUE";
    private Map mGlobalConfig;
    private Map mSiteConfig;
    private String mLocalHost;

    public ZimletConfig(String c) throws ZimletException {
        super(c);
    }

    public ZimletConfig(File f) throws ZimletException {
        super(f);
    }

    protected void initialize() throws ZimletException {
        this.mGlobalConfig = new HashMap();
        this.mSiteConfig = new HashMap();
        try {
            this.mLocalHost = InetAddress.getLocalHost().getHostName().toLowerCase();
        }
        catch (UnknownHostException uhe) {
            throw ZimletException.INVALID_ZIMLET_CONFIG("cannot figure out hostname on localhost");
        }
    }

    protected void validateElement(Element elem) throws ZimletException {
        if (elem.getName().equals("global")) {
            this.parseConfig(elem, this.mGlobalConfig);
        } else if (elem.getName().equals("host")) {
            String hostname = elem.getAttribute("name", "").toLowerCase();
            if (this.mLocalHost.equals(hostname)) {
                this.parseConfig(elem, this.mSiteConfig);
            } else {
                elem.detach();
            }
        } else {
            ZimbraLog.zimlet.warn("unrecognized config element " + elem.getName());
        }
    }

    private void parseConfig(Element elem, Map config) {
        for (Element e : elem.listElements()) {
            config.put(e.getAttribute("name", ""), e.getText());
        }
    }

    public String getConfigValue(String key) {
        if (this.mSiteConfig.containsKey(key)) {
            return (String)this.mSiteConfig.get(key);
        }
        return (String)this.mGlobalConfig.get(key);
    }

    public void setRegExValue(String regex) {
        this.mGlobalConfig.put(CONFIG_REGEX_VALUE, regex);
    }

    public Map getGlobalConfig() {
        return this.mGlobalConfig;
    }

    public Map getSiteConfig() {
        return this.mSiteConfig;
    }

    public String getGlobalConf(String key) {
        return (String)this.mGlobalConfig.get(key);
    }

    public String getSiteConf(String key) {
        return (String)this.mSiteConfig.get(key);
    }

    public String toXMLString() {
        return this.mTopElement.toString();
    }
}

