/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.zimlet;

import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Version
implements Comparable<Version> {
    ArrayList<Integer> mTokens;

    public Version(Version v) {
        this.mTokens = (ArrayList)v.mTokens.clone();
    }

    public Version(String str) {
        this.parse(str);
    }

    public Version(int[] v) {
        int depth = v.length;
        this.mTokens = new ArrayList();
        for (int i = 0; i < depth; ++i) {
            this.mTokens.add(v[i]);
        }
    }

    public void parse(String str) {
        String[] tokens = str.split("\\.");
        int depth = tokens.length;
        this.mTokens = new ArrayList();
        for (int i = 0; i < depth; ++i) {
            this.mTokens.add(Integer.parseInt(tokens[i]));
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Version)) {
            return false;
        }
        Version v = (Version)obj;
        if (this.mTokens.size() != v.mTokens.size()) {
            return false;
        }
        return this.compareTo(v) == 0;
    }

    @Override
    public int compareTo(Version v) {
        int d = 0;
        int myDepth = this.mTokens.size();
        int yourDepth = v.mTokens.size();
        while (myDepth != d && yourDepth != d) {
            Integer yours;
            Integer mine = this.mTokens.get(d);
            if (!mine.equals(yours = v.mTokens.get(d))) {
                return mine - yours;
            }
            ++d;
        }
        return myDepth - yourDepth;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("");
        for (int i = 0; i < this.mTokens.size(); ++i) {
            if (buf.length() > 0) {
                buf.append(".");
            }
            buf.append(this.mTokens.get(i));
        }
        return buf.toString();
    }

    public void set(Version v) {
        this.mTokens = (ArrayList)v.mTokens.clone();
    }

    public void decrement() {
        int lastToken = this.mTokens.size() - 1;
        if (lastToken >= 0) {
            int tok = this.mTokens.remove(lastToken);
            this.mTokens.add(lastToken, --tok);
        }
    }

    public void increment() {
        int lastToken = this.mTokens.size() - 1;
        if (lastToken >= 0) {
            int tok = this.mTokens.remove(lastToken);
            this.mTokens.add(lastToken, ++tok);
        }
    }

    public void incrementMinor() {
        this.mTokens.add(1);
    }

    public void increment(Version before) {
        if (this.compareTo(before) >= 0) {
            throw new IllegalArgumentException(this.toString() + " >= " + before.toString());
        }
        Version v = new Version(this);
        v.increment();
        if (v.compareTo(before) > 0) {
            v.set(before);
            v.decrement();
            v.incrementMinor();
            this.set(v);
        } else if (v.equals(before)) {
            this.incrementMinor();
        } else {
            this.set(v);
        }
    }

    public Version createNext() {
        Version instance = new Version(this);
        instance.increment();
        return instance;
    }

    public Version createNext(Version before) {
        Version instance = new Version(this);
        instance.increment(before);
        return instance;
    }
}

