/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.zimlet;

import com.zimbra.common.mime.ContentDisposition;
import com.zimbra.common.mime.ContentType;
import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.ByteUtil;
import com.zimbra.common.util.ZimbraHttpConnectionManager;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.AuthToken;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.httpclient.HttpProxyUtil;
import com.zimbra.cs.service.FileUploadServlet;
import com.zimbra.cs.servlet.ZimbraServlet;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.ByteArrayRequestEntity;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProxyServlet
extends ZimbraServlet {
    private static final String TARGET_PARAM = "target";
    private static final String UPLOAD_PARAM = "upload";
    private static final String USER_PARAM = "user";
    private static final String PASS_PARAM = "pass";
    private static final String FORMAT_PARAM = "fmt";
    private static final String FILENAME_PARAM = "filename";
    private static final String AUTH_PARAM = "auth";
    private static final String AUTH_BASIC = "basic";
    private static final String DEFAULT_CTYPE = "text/xml";

    private Set<String> getAllowedDomains(AuthToken auth) throws ServiceException {
        Provisioning prov = Provisioning.getInstance();
        Account acct = prov.get(Provisioning.AccountBy.id, auth.getAccountId(), auth);
        return prov.getCOS(acct).getMultiAttrSet("zimbraProxyAllowedDomains");
    }

    private boolean checkPermissionOnTarget(HttpServletRequest req, URL target, AuthToken auth) {
        Set<String> domains;
        String host = target.getHost().toLowerCase();
        try {
            domains = this.getAllowedDomains(auth);
        }
        catch (ServiceException se) {
            ZimbraLog.zimlet.info("error getting allowedDomains: " + se.getMessage());
            return false;
        }
        for (String domain : domains) {
            if (domain.equals("*")) {
                return true;
            }
            if (domain.charAt(0) == '*') {
                domain = domain.substring(1);
            }
            if (!host.endsWith(domain)) continue;
            return true;
        }
        return false;
    }

    private boolean canProxyHeader(String header) {
        if (header == null) {
            return false;
        }
        return !(header = header.toLowerCase()).startsWith("accept") && !header.equals("content-length") && !header.equals("connection") && !header.equals("keep-alive") && !header.equals("pragma") && !header.equals("host") && !header.equals("cache-control") && !header.equals("cookie") && !header.equals("transfer-encoding");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] copyPostedData(HttpServletRequest req) throws IOException {
        byte[] byArray;
        int size = req.getContentLength();
        if (req.getMethod().equalsIgnoreCase("GET") || size <= 0) {
            return null;
        }
        ServletInputStream is = req.getInputStream();
        ByteArrayOutputStream baos = null;
        try {
            int num;
            if (size < 0) {
                size = 0;
            }
            baos = new ByteArrayOutputStream(size);
            byte[] buffer = new byte[8192];
            while ((num = is.read(buffer)) != -1) {
                baos.write(buffer, 0, num);
            }
            byArray = baos.toByteArray();
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            ByteUtil.closeStream(baos);
            throw throwable;
        }
        ByteUtil.closeStream(baos);
        return byArray;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        this.doProxy(req, resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        this.doProxy(req, resp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doProxy(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        HttpMethod method;
        block25: {
            block24: {
                ZimbraLog.clearContext();
                AuthToken authToken = ProxyServlet.getAuthTokenFromCookie(req, resp);
                if (authToken == null) {
                    return;
                }
                byte[] body = this.copyPostedData(req);
                String target = req.getParameter(TARGET_PARAM);
                if (target == null) {
                    resp.sendError(400);
                    return;
                }
                URL url = new URL(target);
                if (!this.checkPermissionOnTarget(req, url, authToken)) {
                    resp.sendError(403);
                    return;
                }
                String uploadParam = req.getParameter(UPLOAD_PARAM);
                boolean asUpload = uploadParam != null && (uploadParam.equals("1") || uploadParam.equalsIgnoreCase("true"));
                method = null;
                try {
                    HttpClient client = ZimbraHttpConnectionManager.getInternalHttpConnMgr().newHttpClient();
                    HttpProxyUtil.configureProxy(client);
                    String reqMethod = req.getMethod();
                    if (reqMethod.equalsIgnoreCase("GET")) {
                        method = new GetMethod(target);
                    } else {
                        if (!reqMethod.equalsIgnoreCase("POST")) {
                            ZimbraLog.zimlet.info("unsupported request method: " + reqMethod);
                            resp.sendError(405);
                            Object var25_13 = null;
                            if (method == null) return;
                            method.releaseConnection();
                            return;
                        }
                        PostMethod post = new PostMethod(target);
                        if (body != null) {
                            post.setRequestEntity(new ByteArrayRequestEntity(body, req.getContentType()));
                        }
                        method = post;
                    }
                    String auth = req.getParameter(AUTH_PARAM);
                    String user = req.getParameter(USER_PARAM);
                    String pass = req.getParameter(PASS_PARAM);
                    if (auth != null && user != null && pass != null) {
                        if (!auth.equals(AUTH_BASIC)) {
                            ZimbraLog.zimlet.info("unsupported auth type: " + auth);
                            resp.sendError(400);
                            break block24;
                        }
                        HttpState state = new HttpState();
                        state.setCredentials(AuthScope.ANY, new UsernamePasswordCredentials(user, pass));
                        client.setState(state);
                        method.setDoAuthentication(true);
                    }
                    Enumeration headers = req.getHeaderNames();
                    while (headers.hasMoreElements()) {
                        String hdr = (String)headers.nextElement();
                        ZimbraLog.zimlet.debug("incoming: " + hdr + ": " + req.getHeader(hdr));
                        if (!this.canProxyHeader(hdr)) continue;
                        ZimbraLog.zimlet.debug("outgoing: " + hdr + ": " + req.getHeader(hdr));
                        if (hdr.equalsIgnoreCase("x-host")) {
                            method.getParams().setVirtualHost(req.getHeader(hdr));
                            continue;
                        }
                        method.addRequestHeader(hdr, req.getHeader(hdr));
                    }
                    try {
                        client.executeMethod(method);
                    }
                    catch (HttpException ex) {
                        ZimbraLog.zimlet.info((Object)("exception while proxying " + target), ex);
                        resp.sendError(404);
                        Object var25_15 = null;
                        if (method == null) return;
                        method.releaseConnection();
                        return;
                    }
                    int status = method.getStatusLine() == null ? 500 : method.getStatusCode();
                    Header ctHeader = method.getResponseHeader("Content-Type");
                    String contentType = ctHeader == null || ctHeader.getValue() == null ? DEFAULT_CTYPE : ctHeader.getValue();
                    InputStream targetResponseBody = method.getResponseBodyAsStream();
                    if (asUpload) {
                        String filename = req.getParameter(FILENAME_PARAM);
                        if (filename == null || filename.equals("")) {
                            filename = new ContentType(contentType).getParameter("name");
                        }
                        if ((filename == null || filename.equals("")) && method.getResponseHeader("Content-Disposition") != null) {
                            filename = new ContentDisposition(method.getResponseHeader("Content-Disposition").getValue()).getParameter(FILENAME_PARAM);
                        }
                        if (filename == null || filename.equals("")) {
                            filename = "unknown";
                        }
                        List<FileUploadServlet.Upload> uploads = null;
                        if (targetResponseBody != null) {
                            try {
                                FileUploadServlet.Upload up = FileUploadServlet.saveUpload(targetResponseBody, filename, contentType, authToken.getAccountId());
                                uploads = Arrays.asList(up);
                            }
                            catch (ServiceException e) {
                                status = e.getCode().equals("mail.UPLOAD_REJECTED") ? 413 : 500;
                            }
                        }
                        resp.setStatus(status);
                        FileUploadServlet.sendResponse(resp, status, req.getParameter(FORMAT_PARAM), null, uploads, null);
                        break block25;
                    }
                    resp.setStatus(status);
                    resp.setContentType(contentType);
                    for (Header h : method.getResponseHeaders()) {
                        if (!this.canProxyHeader(h.getName())) continue;
                        resp.addHeader(h.getName(), h.getValue());
                    }
                    if (targetResponseBody != null) {
                        ByteUtil.copy(targetResponseBody, true, (OutputStream)resp.getOutputStream(), true);
                    }
                    break block25;
                }
                catch (Throwable throwable) {
                    Object var25_17 = null;
                    if (method == null) throw throwable;
                    method.releaseConnection();
                    throw throwable;
                }
            }
            Object var25_14 = null;
            if (method == null) return;
            method.releaseConnection();
            return;
        }
        Object var25_16 = null;
        if (method == null) return;
        method.releaseConnection();
    }
}

