/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.zclient.event;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.cs.zclient.ToZJSONObject;
import com.zimbra.cs.zclient.ZJSONObject;
import com.zimbra.cs.zclient.ZTag;
import com.zimbra.cs.zclient.event.ZModifyItemEvent;
import org.json.JSONException;

public class ZModifyTagEvent
implements ZModifyItemEvent,
ToZJSONObject {
    protected Element mTagEl;

    public ZModifyTagEvent(Element e) throws ServiceException {
        this.mTagEl = e;
    }

    public String getId() throws ServiceException {
        return this.mTagEl.getAttribute("id");
    }

    public String getName(String defaultValue) {
        return this.mTagEl.getAttribute("name", defaultValue);
    }

    public ZTag.Color getColor(ZTag.Color defaultValue) {
        String newColor = this.mTagEl.getAttribute("color", null);
        if (newColor != null) {
            try {
                return ZTag.Color.fromString(newColor);
            }
            catch (ServiceException se) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    public int getUnreadCount(int defaultValue) throws ServiceException {
        return (int)this.mTagEl.getAttributeLong("u", defaultValue);
    }

    public ZJSONObject toZJSONObject() throws JSONException {
        try {
            ZJSONObject zjo = new ZJSONObject();
            zjo.put("id", this.getId());
            String name = this.getName(null);
            if (name != null) {
                zjo.put("name", name);
            }
            if (this.getColor(null) != null) {
                zjo.put("color", this.getColor(null).name());
            }
            if (this.getUnreadCount(-1) != -1) {
                zjo.put("unreadCount", this.getUnreadCount(-1));
            }
            return zjo;
        }
        catch (ServiceException se) {
            throw new JSONException(se);
        }
    }

    public String toString() {
        try {
            return String.format("[ZModifyTagEvent %s]", this.getId());
        }
        catch (ServiceException e) {
            throw new RuntimeException(e);
        }
    }

    public String dump() {
        return ZJSONObject.toString(this);
    }
}

