/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.zclient.event;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.cs.zclient.ToZJSONObject;
import com.zimbra.cs.zclient.ZJSONObject;
import com.zimbra.cs.zclient.event.ZModifyItemEvent;
import com.zimbra.cs.zclient.event.ZModifyItemFolderEvent;
import org.json.JSONException;

public class ZModifyMessageEvent
implements ZModifyItemEvent,
ZModifyItemFolderEvent,
ToZJSONObject {
    protected Element mMessageEl;

    public ZModifyMessageEvent(Element e) throws ServiceException {
        this.mMessageEl = e;
    }

    public String getId() throws ServiceException {
        return this.mMessageEl.getAttribute("id");
    }

    public String getFlags(String defaultValue) {
        return this.mMessageEl.getAttribute("f", defaultValue);
    }

    public String getTagIds(String defaultValue) {
        return this.mMessageEl.getAttribute("t", defaultValue);
    }

    public String getFolderId(String defaultValue) {
        return this.mMessageEl.getAttribute("l", defaultValue);
    }

    public String getConversationId(String defaultValue) {
        return this.mMessageEl.getAttribute("cid", defaultValue);
    }

    public ZJSONObject toZJSONObject() throws JSONException {
        try {
            ZJSONObject zjo = new ZJSONObject();
            zjo.put("id", this.getId());
            if (this.getConversationId(null) != null) {
                zjo.put("conversationId", this.getConversationId(null));
            }
            if (this.getFlags(null) != null) {
                zjo.put("flags", this.getFlags(null));
            }
            if (this.getTagIds(null) != null) {
                zjo.put("tags", this.getTagIds(null));
            }
            if (this.getFolderId(null) != null) {
                zjo.put("folderId", this.getFolderId(null));
            }
            return zjo;
        }
        catch (ServiceException se) {
            throw new JSONException(se);
        }
    }

    public String toString() {
        try {
            return String.format("[ZModifyMessageEvent %s]", this.getId());
        }
        catch (ServiceException e) {
            throw new RuntimeException(e);
        }
    }

    public String dump() {
        return ZJSONObject.toString(this);
    }
}

