/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.zclient.event;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.cs.zclient.ToZJSONObject;
import com.zimbra.cs.zclient.ZFolder;
import com.zimbra.cs.zclient.ZGrant;
import com.zimbra.cs.zclient.ZJSONObject;
import com.zimbra.cs.zclient.event.ZModifyItemEvent;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZModifyFolderEvent
implements ZModifyItemEvent,
ToZJSONObject {
    protected Element mFolderEl;

    public ZModifyFolderEvent(Element e) {
        this.mFolderEl = e;
    }

    @Override
    public String getId() throws ServiceException {
        return this.mFolderEl.getAttribute("id");
    }

    public String getName(String defaultValue) {
        return this.mFolderEl.getAttribute("name", defaultValue);
    }

    public String getParentId(String defaultValue) {
        return this.mFolderEl.getAttribute("l", defaultValue);
    }

    public String getFlags(String defaultValue) {
        return this.mFolderEl.getAttribute("f", defaultValue);
    }

    public ZFolder.Color getColor(ZFolder.Color defaultValue) {
        String newColor = this.mFolderEl.getAttribute("color", null);
        if (newColor != null) {
            try {
                return ZFolder.Color.fromString(newColor);
            }
            catch (ServiceException se) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    public int getUnreadCount(int defaultValue) throws ServiceException {
        return (int)this.mFolderEl.getAttributeLong("u", defaultValue);
    }

    public long getSize(long defaultValue) throws ServiceException {
        return this.mFolderEl.getAttributeLong("s", defaultValue);
    }

    public int getMessageCount(int defaultValue) throws ServiceException {
        return (int)this.mFolderEl.getAttributeLong("n", defaultValue);
    }

    public ZFolder.View getDefaultView(ZFolder.View defaultValue) throws ServiceException {
        String newView = this.mFolderEl.getAttribute("view", null);
        return newView != null ? ZFolder.View.fromString(newView) : defaultValue;
    }

    public int getModifiedSequence(int defaultValue) throws ServiceException {
        return (int)this.mFolderEl.getAttributeLong("ms", defaultValue);
    }

    public int getContentSequence(int defaultValue) throws ServiceException {
        return (int)this.mFolderEl.getAttributeLong("rev", defaultValue);
    }

    public int getImapUIDNEXT(int defaultValue) throws ServiceException {
        return (int)this.mFolderEl.getAttributeLong("i4next", defaultValue);
    }

    public int getImapMODSEQ(int defaultValue) throws ServiceException {
        return (int)this.mFolderEl.getAttributeLong("i4ms", defaultValue);
    }

    public String getRemoteURL(String defaultValue) {
        return this.mFolderEl.getAttribute("url", defaultValue);
    }

    public String getEffectivePerm(String defaultValue) {
        return this.mFolderEl.getAttribute("perm", defaultValue);
    }

    public List<ZGrant> getGrants(List<ZGrant> defaultValue) throws ServiceException {
        Element aclEl = this.mFolderEl.getOptionalElement("acl");
        if (aclEl != null) {
            ArrayList<ZGrant> grants = new ArrayList<ZGrant>();
            for (Element grant : aclEl.listElements("grant")) {
                grants.add(new ZGrant(grant));
            }
            return grants;
        }
        return defaultValue;
    }

    @Override
    public ZJSONObject toZJSONObject() throws JSONException {
        try {
            List<ZGrant> grants;
            ZJSONObject zjo = new ZJSONObject();
            zjo.put("id", this.getId());
            if (this.getName(null) != null) {
                zjo.put("name", this.getName(null));
            }
            if (this.getParentId(null) != null) {
                zjo.put("parentId", this.getParentId(null));
            }
            if (this.getFlags(null) != null) {
                zjo.put("flags", this.getFlags(null));
            }
            if (this.getColor(null) != null) {
                zjo.put("color", this.getColor(null).name());
            }
            if (this.getUnreadCount(-1) != -1) {
                zjo.put("unreadCount", this.getUnreadCount(-1));
            }
            if (this.getMessageCount(-1) != -1) {
                zjo.put("messageCount", this.getMessageCount(-1));
            }
            if (this.getDefaultView(null) != null) {
                zjo.put("view", this.getDefaultView(null).name());
            }
            if (this.getImapUIDNEXT(-1) != -1) {
                zjo.put("imapUIDNEXT", this.getImapUIDNEXT(-1));
            }
            if (this.getImapMODSEQ(-1) != -1) {
                zjo.put("imapMODSEQ", this.getImapMODSEQ(-1));
            }
            if (this.getRemoteURL(null) != null) {
                zjo.put("url", this.getRemoteURL(null));
            }
            if (this.getEffectivePerm(null) != null) {
                zjo.put("effectivePermissions", this.getEffectivePerm(null));
            }
            if ((grants = this.getGrants(null)) != null) {
                zjo.put("grants", grants);
            }
            return zjo;
        }
        catch (ServiceException se) {
            throw new JSONException(se);
        }
    }

    public String toString() {
        try {
            return String.format("[ZModifyFolderEvent %s]", this.getId());
        }
        catch (ServiceException e) {
            throw new RuntimeException(e);
        }
    }

    public String dump() {
        return ZJSONObject.toString(this);
    }
}

