/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.zclient.event;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.cs.zclient.ToZJSONObject;
import com.zimbra.cs.zclient.ZEmailAddress;
import com.zimbra.cs.zclient.ZItem;
import com.zimbra.cs.zclient.ZJSONObject;
import com.zimbra.cs.zclient.event.ZCreateItemEvent;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZCreateMessageEvent
implements ZCreateItemEvent,
ToZJSONObject {
    protected Element mMessageEl;

    public ZCreateMessageEvent(Element e) throws ServiceException {
        this.mMessageEl = e;
    }

    @Override
    public String getId() throws ServiceException {
        return this.mMessageEl.getAttribute("id");
    }

    public String getFlags(String defaultValue) {
        return this.mMessageEl.getAttribute("f", defaultValue);
    }

    public String getTagIds(String defaultValue) {
        return this.mMessageEl.getAttribute("t", defaultValue);
    }

    public int getSize(int defaultValue) throws ServiceException {
        return (int)this.mMessageEl.getAttributeLong("s", defaultValue);
    }

    public String getFolderId(String defaultValue) {
        return this.mMessageEl.getAttribute("l", defaultValue);
    }

    public String getConversationId(String defaultValue) {
        return this.mMessageEl.getAttribute("cid", defaultValue);
    }

    public String getSubject(String defaultValue) {
        return this.mMessageEl.getAttribute("su", defaultValue);
    }

    public String getFragment(String defaultValue) {
        return this.mMessageEl.getAttribute("fr", defaultValue);
    }

    public long getReceivedDate(long defaultValue) throws ServiceException {
        return this.mMessageEl.getAttributeLong("d", defaultValue);
    }

    public long getSentDate(long defaultValue) throws ServiceException {
        return this.mMessageEl.getAttributeLong("sd", defaultValue);
    }

    public List<ZEmailAddress> getEmailAddresses(List<ZEmailAddress> defaultValue) throws ServiceException {
        ArrayList<ZEmailAddress> result = null;
        for (Element emailEl : this.mMessageEl.listElements("e")) {
            if (result == null) {
                result = new ArrayList<ZEmailAddress>();
            }
            result.add(new ZEmailAddress(emailEl));
        }
        return result == null ? defaultValue : result;
    }

    @Override
    public ZJSONObject toZJSONObject() throws JSONException {
        try {
            List<ZEmailAddress> addrs;
            ZJSONObject zjo = new ZJSONObject();
            zjo.put("id", this.getId());
            if (this.getFolderId(null) != null) {
                zjo.put("folderId", this.getFolderId(null));
            }
            if (this.getConversationId(null) != null) {
                zjo.put("conversationId", this.getConversationId(null));
            }
            if (this.getFlags(null) != null) {
                zjo.put("flags", this.getFlags(null));
            }
            if (this.getTagIds(null) != null) {
                zjo.put("tags", this.getTagIds(null));
            }
            if (this.getSubject(null) != null) {
                zjo.put("subject", this.getSubject(null));
            }
            if (this.getFragment(null) != null) {
                zjo.put("fragment", this.getFragment(null));
            }
            if (this.getSize(-1) != -1) {
                zjo.put("size", this.getSize(-1));
            }
            if (this.getReceivedDate(-1L) != -1L) {
                zjo.put("receivedDate", this.getReceivedDate(-1L));
            }
            if (this.getSentDate(-1L) != -1L) {
                zjo.put("sentDate", this.getSentDate(-1L));
            }
            if ((addrs = this.getEmailAddresses(null)) != null) {
                zjo.put("addresses", addrs);
            }
            return zjo;
        }
        catch (ServiceException se) {
            throw new JSONException(se);
        }
    }

    public String toString() {
        try {
            return String.format("[ZCreateMessageEvent %s]", this.getId());
        }
        catch (ServiceException e) {
            throw new RuntimeException(e);
        }
    }

    public String dump() {
        return ZJSONObject.toString(this);
    }

    @Override
    public ZItem getItem() throws ServiceException {
        return null;
    }
}

