/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.zclient.event;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.cs.zclient.ToZJSONObject;
import com.zimbra.cs.zclient.ZEmailAddress;
import com.zimbra.cs.zclient.ZJSONObject;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZConversationSummaryEvent
implements ToZJSONObject {
    protected Element mConvEl;

    public ZConversationSummaryEvent(Element e) throws ServiceException {
        this.mConvEl = e;
    }

    public String getId() throws ServiceException {
        return this.mConvEl.getAttribute("id");
    }

    public String getFlags(String defaultValue) {
        return this.mConvEl.getAttribute("f", defaultValue);
    }

    public String getTagIds(String defaultValue) {
        return this.mConvEl.getAttribute("t", defaultValue);
    }

    public int getMessageCount(int defaultValue) throws ServiceException {
        return (int)this.mConvEl.getAttributeLong("n", defaultValue);
    }

    public String getSubject(String defaultValue) {
        Element sub = this.mConvEl.getOptionalElement("su");
        return sub == null ? defaultValue : sub.getText();
    }

    public String getFragment(String defaultValue) {
        Element frag = this.mConvEl.getOptionalElement("fr");
        return frag == null ? defaultValue : frag.getText();
    }

    public long getDate(long defaultValue) throws ServiceException {
        return this.mConvEl.getAttributeLong("d", defaultValue);
    }

    public List<ZEmailAddress> getRecipients(List<ZEmailAddress> defaultValue) throws ServiceException {
        ArrayList<ZEmailAddress> result = null;
        for (Element emailEl : this.mConvEl.listElements("e")) {
            if (result == null) {
                result = new ArrayList<ZEmailAddress>();
            }
            result.add(new ZEmailAddress(emailEl));
        }
        return result == null ? defaultValue : result;
    }

    @Override
    public ZJSONObject toZJSONObject() throws JSONException {
        try {
            List<ZEmailAddress> addrs;
            ZJSONObject zjo = new ZJSONObject();
            zjo.put("id", this.getId());
            if (this.getFlags(null) != null) {
                zjo.put("flags", this.getFlags(null));
            }
            if (this.getTagIds(null) != null) {
                zjo.put("tags", this.getTagIds(null));
            }
            if (this.getSubject(null) != null) {
                zjo.put("subject", this.getSubject(null));
            }
            if (this.getFragment(null) != null) {
                zjo.put("fragment", this.getFragment(null));
            }
            if (this.getMessageCount(-1) != -1) {
                zjo.put("messageCount", this.getMessageCount(-1));
            }
            if (this.getDate(-1L) != -1L) {
                zjo.put("date", this.getDate(-1L));
            }
            if ((addrs = this.getRecipients(null)) != null) {
                zjo.put("recipients", addrs);
            }
            return zjo;
        }
        catch (ServiceException se) {
            throw new JSONException(se);
        }
    }

    public String toString() {
        try {
            return String.format("[ZConversationSummaryEvent %s]", this.getId());
        }
        catch (ServiceException e) {
            throw new RuntimeException(e);
        }
    }

    public String dump() {
        return ZJSONObject.toString(this);
    }
}

