/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.zclient;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.cs.zclient.ZCallFeature;
import java.util.HashMap;

public class ZVoiceMailPrefs
extends ZCallFeature {
    private HashMap<String, String> mMap = new HashMap();

    public ZVoiceMailPrefs(String name) {
        super(name);
    }

    public String getEmailNotificationAddress() {
        String address = this.get("vmPrefEmailNotifAddress");
        return address == null ? "" : address;
    }

    public void setEmailNotificationAddress(String address) {
        this.mMap.put("vmPrefEmailNotifAddress", address);
    }

    public String get(String key) {
        return this.mMap.get(key);
    }

    public long getLong(String name) {
        String v = this.get(name);
        try {
            return v == null ? -1L : Long.parseLong(v);
        }
        catch (NumberFormatException e) {
            return -1L;
        }
    }

    public synchronized void assignFrom(ZCallFeature that) {
        super.assignFrom(that);
        if (that instanceof ZVoiceMailPrefs) {
            HashMap<String, String> thatMap = ((ZVoiceMailPrefs)that).mMap;
            for (String name : thatMap.keySet()) {
                String value = thatMap.get(name);
                this.mMap.put(name, value);
            }
        }
    }

    synchronized void fromElement(Element element) throws ServiceException {
        super.fromElement(element);
        for (Element prefElement : element.listElements("pref")) {
            String name = prefElement.getAttribute("name");
            String value = prefElement.getText();
            this.mMap.put(name, value);
        }
    }

    void toElement(Element element) throws ServiceException {
        super.toElement(element);
        for (String name : this.mMap.keySet()) {
            String value = this.mMap.get(name);
            Element prefElement = element.addElement("pref");
            prefElement.addAttribute("name", name);
            prefElement.setText(value);
        }
    }
}

