/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.zclient;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.cs.zclient.ZJSONObject;
import com.zimbra.cs.zclient.ZMessage;
import com.zimbra.cs.zclient.ZPhone;
import com.zimbra.cs.zclient.ZSearchHit;
import com.zimbra.cs.zclient.event.ZModifyEvent;
import com.zimbra.cs.zclient.event.ZModifyVoiceMailItemEvent;
import org.json.JSONException;

public class ZVoiceMailItemHit
implements ZSearchHit {
    private String mId;
    private String mSortField;
    private float mScore;
    private String mFlags;
    private String mSoundUrl;
    private long mDate;
    private long mDuration;
    private ZPhone mCaller;

    public ZVoiceMailItemHit(Element e) throws ServiceException {
        this.mId = e.getAttribute("id");
        this.mSortField = e.getAttribute("sf", null);
        this.mScore = (float)e.getAttributeDouble("score", 0.0);
        this.mFlags = e.getAttribute("f", null);
        Element content = e.getOptionalElement("content");
        if (content != null) {
            this.mSoundUrl = content.getAttribute("url");
        }
        this.mDate = e.getAttributeLong("d");
        this.mDuration = e.getAttributeLong("du") * 1000L;
        for (Element el : e.listElements("cp")) {
            String t = el.getAttribute("t", null);
            if (!"f".equals(t)) continue;
            this.mCaller = new ZPhone(el.getAttribute("n"), el.getAttribute("p", null));
            break;
        }
    }

    private ZVoiceMailItemHit() {
    }

    public static ZVoiceMailItemHit deserialize(String value, String phone) throws ServiceException {
        ZVoiceMailItemHit result = new ZVoiceMailItemHit();
        String[] array = value.split("/");
        result.mId = array[0];
        result.mSortField = array[1];
        result.mFlags = array[2];
        result.mDate = Long.parseLong(array[3]);
        result.mDuration = Long.parseLong(array[4]);
        result.mCaller = new ZPhone(array[5], array[6]);
        result.mScore = 0.0f;
        result.mSoundUrl = "/service/extension/velodrome/voice/~/voicemail?phone=" + phone + "&id=" + result.mId;
        return result;
    }

    public String getId() {
        return this.mId;
    }

    public float getScore() {
        return this.mScore;
    }

    public String getSortField() {
        return this.mSortField;
    }

    public boolean hasFlags() {
        return this.mFlags != null && this.mFlags.length() > 0;
    }

    public boolean isFlagged() {
        return this.hasFlags() && this.mFlags.indexOf(ZMessage.Flag.highPriority.getFlagChar()) != -1;
    }

    public boolean isPrivate() {
        return this.hasFlags() && this.mFlags.indexOf("p") != -1;
    }

    public boolean isUnheard() {
        return this.hasFlags() && this.mFlags.indexOf(ZMessage.Flag.unread.getFlagChar()) != -1;
    }

    public ZPhone getCaller() {
        return this.mCaller;
    }

    public String getDisplayCaller() {
        return this.mCaller.getDisplay();
    }

    public String getSoundUrl() {
        return this.mSoundUrl;
    }

    public long getDate() {
        return this.mDate;
    }

    public long getDuration() {
        return this.mDuration;
    }

    public void modifyNotification(ZModifyEvent event) throws ServiceException {
        if (event instanceof ZModifyVoiceMailItemEvent) {
            boolean isUnheard;
            ZModifyVoiceMailItemEvent voiceEvent = (ZModifyVoiceMailItemEvent)event;
            boolean bl = isUnheard = !voiceEvent.getIsHeard();
            if (isUnheard != this.isUnheard()) {
                this.setFlag(ZMessage.Flag.unread.getFlagChar(), isUnheard);
                voiceEvent.setMadeChange();
            }
        }
    }

    public String serialize() {
        String flags = this.mFlags == null ? "" : this.mFlags;
        return this.mId + "/" + this.mSortField + "/" + flags + "/" + this.mDate + "/" + this.mDuration + "/" + this.mCaller.getName() + "/" + this.mCaller.getCallerId();
    }

    private void setFlag(char flagChar, boolean on) {
        this.mFlags = on ? this.mFlags + flagChar : this.mFlags.replace(Character.toString(flagChar), "");
    }

    public ZJSONObject toZJSONObject() throws JSONException {
        ZJSONObject zjo = new ZJSONObject();
        zjo.put("id", this.mId);
        zjo.put("sortField", this.mSortField);
        zjo.put("score", this.mScore);
        zjo.put("flags", this.mFlags);
        zjo.put("soundUrl", this.mSoundUrl);
        zjo.put("date", this.mDate);
        zjo.put("duration", this.mDuration);
        zjo.put("caller", this.mCaller);
        return zjo;
    }

    public String toString() {
        return String.format("[ZVoiceMailItemHit %s]", this.mId);
    }

    public String dump() {
        return ZJSONObject.toString(this);
    }
}

