/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.zclient;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.cs.mailbox.MailItem;
import com.zimbra.cs.zclient.ToZJSONObject;
import com.zimbra.cs.zclient.ZItem;
import com.zimbra.cs.zclient.ZJSONObject;
import com.zimbra.cs.zclient.ZMailbox;
import com.zimbra.cs.zclient.event.ZModifyEvent;
import com.zimbra.cs.zclient.event.ZModifyTagEvent;
import org.json.JSONException;

public class ZTag
implements Comparable,
ZItem,
ToZJSONObject {
    private Color mColor;
    private String mId;
    private String mName;
    private int mUnreadCount;
    private ZMailbox mMailbox;

    public ZTag(Element e, ZMailbox mailbox) throws ServiceException {
        this.mMailbox = mailbox;
        String rgb = e.getAttribute("rgb");
        this.mColor = Color.fromString(rgb != null ? rgb : e.getAttribute("color", "0"));
        this.mId = e.getAttribute("id");
        this.mName = e.getAttribute("name");
        this.mUnreadCount = (int)e.getAttributeLong("u", 0L);
    }

    public void modifyNotification(ZModifyEvent event) throws ServiceException {
        if (event instanceof ZModifyTagEvent) {
            ZModifyTagEvent tevent = (ZModifyTagEvent)event;
            this.mColor = tevent.getColor(this.mColor);
            this.mName = tevent.getName(this.mName);
            this.mUnreadCount = tevent.getUnreadCount(this.mUnreadCount);
        }
    }

    public String getId() {
        return this.mId;
    }

    public ZMailbox getMailbox() {
        return this.mMailbox;
    }

    public String getName() {
        return this.mName;
    }

    public int getUnreadCount() {
        return this.mUnreadCount;
    }

    public Color getColor() {
        return this.mColor;
    }

    public ZJSONObject toZJSONObject() throws JSONException {
        ZJSONObject zjo = new ZJSONObject();
        zjo.put("id", this.mId);
        zjo.put("name", this.mName);
        zjo.put("color", this.mColor.name());
        zjo.put("unreadCount", this.mUnreadCount);
        return zjo;
    }

    public String toString() {
        return String.format("[ZTag %s]", this.mName);
    }

    public String dump() {
        return ZJSONObject.toString(this);
    }

    public int compareTo(Object o) {
        if (!(o instanceof ZTag)) {
            return 0;
        }
        ZTag other = (ZTag)o;
        return this.getName().compareToIgnoreCase(other.getName());
    }

    public void delete() throws ServiceException {
        this.mMailbox.deleteTag(this.mId);
    }

    public void deleteItem() throws ServiceException {
        this.delete();
    }

    public void markRead() throws ServiceException {
        this.mMailbox.markTagRead(this.mId);
    }

    public void modifyColor(Color color) throws ServiceException {
        this.mMailbox.modifyTagColor(this.mId, color);
    }

    public void rename(String newName) throws ServiceException {
        this.mMailbox.renameTag(this.mId, newName);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Color {
        defaultColor(0),
        blue(1),
        cyan(2),
        green(3),
        purple(4),
        red(5),
        yellow(6),
        pink(7),
        gray(8),
        orange(9);

        private int mValue;
        private static final long[] OLD_COLORS;

        public int getValue() {
            return this.mValue;
        }

        public static Color fromString(String s) throws ServiceException {
            try {
                MailItem.Color color = s.startsWith("#") ? new MailItem.Color(s.substring(1)) : new MailItem.Color(Long.parseLong(s));
                int mapped = color.getMappedColor();
                if (!color.hasMapping()) {
                    long rgb = color.getRgb();
                    for (int i = 0; i < OLD_COLORS.length; ++i) {
                        long c = OLD_COLORS[i];
                        if (rgb != c) continue;
                        mapped = i;
                        break;
                    }
                }
                return Color.values()[mapped];
            }
            catch (NumberFormatException e) {
            }
            catch (IndexOutOfBoundsException e) {
                // empty catch block
            }
            try {
                return Color.valueOf(s);
            }
            catch (IllegalArgumentException e) {
                return orange;
            }
        }

        private Color(int value) {
            this.mValue = value;
        }

        static {
            OLD_COLORS = new long[]{0L, 255L, 33412L, 33280L, 0x840084L, 0xFF0000L, 8684032L, 16711812L, 0x848284L, 0xFF8000L};
        }
    }
}

