/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.zclient;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.zclient.ZClientException;
import com.zimbra.cs.zclient.ZDateTime;
import com.zimbra.cs.zclient.ZInvite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZSimpleRecurrence {
    private ZSimpleRecurrenceType mType;
    private ZSimpleRecurrenceEnd mEnd = ZSimpleRecurrenceEnd.NEVER;
    private long mCount;
    private ZDateTime mUntilDate;
    private int mDailyInterval;
    private ZInvite.ZWeekDay mWeeklyByDay;
    private int mWeeklyInterval;
    private List<ZInvite.ZWeekDay> mWeeklyIntervalDays;
    private int mMonthlyInterval;
    private int mMonthlyMonthDay;
    private ZInvite.ZByDayWeekDay mMonthlyRelativeDay;
    private int mYearlyByDateMonthDay;
    private int mYearlyByDateMonth;
    private ZInvite.ZByDayWeekDay mYearlyRelativeDay;
    private int mYearlyRelativeMonth;

    private boolean empty(List<?> list) {
        return list == null || list.size() == 0;
    }

    public ZSimpleRecurrence(ZInvite.ZRecurrence r) {
        if (r == null) {
            this.mType = ZSimpleRecurrenceType.NONE;
            return;
        }
        if (!(r.getRules() != null && r.getRules().size() <= 1 && this.empty(r.getDates()) && this.empty(r.getExRules()) && this.empty(r.getExDates()))) {
            this.mType = ZSimpleRecurrenceType.COMPLEX;
            return;
        }
        ZInvite.ZRecurrenceRule rr = r.getRules().get(0);
        if (rr.getWeekStart() != null) {
            this.mType = ZSimpleRecurrenceType.COMPLEX;
            return;
        }
        List<ZInvite.ZByRule> byRules = rr.getByRules();
        if (rr.getUntilDate() != null) {
            this.mEnd = ZSimpleRecurrenceEnd.UNTIL;
            this.mUntilDate = rr.getUntilDate();
        } else if (rr.getCount() > 0) {
            this.mCount = rr.getCount();
            this.mEnd = ZSimpleRecurrenceEnd.COUNT;
        } else {
            this.mEnd = ZSimpleRecurrenceEnd.NEVER;
        }
        switch (rr.getFrequency()) {
            case DAI: {
                ZInvite.ZByRule br;
                List<ZInvite.ZByDayWeekDay> weekDays;
                if (this.empty(byRules)) {
                    if (rr.getInterval() < 2) {
                        this.mType = ZSimpleRecurrenceType.DAILY;
                    } else {
                        this.mType = ZSimpleRecurrenceType.DAILY_INTERVAL;
                        this.mDailyInterval = rr.getInterval();
                    }
                    return;
                }
                if (byRules == null || byRules.size() != 1 || byRules.get(0).getType() != ZInvite.ZByType.BY_DAY || this.empty(weekDays = (br = byRules.get(0)).getByDayWeekDays())) break;
                EnumSet<ZInvite.ZWeekDay> days = EnumSet.noneOf(ZInvite.ZWeekDay.class);
                for (ZInvite.ZByDayWeekDay d : weekDays) {
                    if (d.getWeekOrd() != 0) continue;
                    days.add(d.getDay());
                }
                if (days.size() != 5 || !days.containsAll(EnumSet.of(ZInvite.ZWeekDay.MO, ZInvite.ZWeekDay.TU, ZInvite.ZWeekDay.WE, ZInvite.ZWeekDay.TH, ZInvite.ZWeekDay.FR))) break;
                this.mType = ZSimpleRecurrenceType.DAILY_WEEKDAY;
                return;
            }
            case WEE: {
                if (this.empty(byRules) && rr.getInterval() < 2 && this.mEnd == ZSimpleRecurrenceEnd.NEVER) {
                    this.mType = ZSimpleRecurrenceType.WEEKLY;
                    return;
                }
                if (byRules == null || byRules.size() != 1 || byRules.get(0).getType() != ZInvite.ZByType.BY_DAY) break;
                ZInvite.ZByRule br = byRules.get(0);
                List<ZInvite.ZByDayWeekDay> weekDays = br.getByDayWeekDays();
                if (weekDays != null && weekDays.size() == 1 && rr.getInterval() < 2) {
                    ZInvite.ZByDayWeekDay day = weekDays.get(0);
                    if (day.getWeekOrd() != 0) break;
                    this.mType = ZSimpleRecurrenceType.WEEKLY_BY_DAY;
                    this.mWeeklyByDay = day.getDay();
                    return;
                }
                if (weekDays == null) break;
                this.mWeeklyInterval = rr.getInterval();
                this.mWeeklyIntervalDays = new ArrayList<ZInvite.ZWeekDay>();
                for (ZInvite.ZByDayWeekDay day : weekDays) {
                    if (day.getWeekOrd() != 0) continue;
                    this.mWeeklyIntervalDays.add(day.getDay());
                }
                if (this.mWeeklyIntervalDays.size() != weekDays.size()) break;
                Collections.sort(this.mWeeklyIntervalDays);
                this.mType = ZSimpleRecurrenceType.WEEKLY_CUSTOM;
                return;
            }
            case MON: {
                ZInvite.ZByDayWeekDay day;
                int ord;
                ZInvite.ZByRule br;
                List<ZInvite.ZByDayWeekDay> weekDays;
                if (this.empty(byRules) && rr.getInterval() < 2 && this.mEnd == ZSimpleRecurrenceEnd.NEVER) {
                    this.mType = ZSimpleRecurrenceType.MONTHLY;
                    return;
                }
                if (byRules != null && byRules.size() == 1 && byRules.get(0).getType() == ZInvite.ZByType.BY_MONTHDAY) {
                    ZInvite.ZByRule br2 = byRules.get(0);
                    String[] days = br2.getList();
                    if (days.length != 1) break;
                    this.mMonthlyMonthDay = this.parseInt(days[0], -1);
                    if (this.mMonthlyMonthDay <= 0) break;
                    this.mType = ZSimpleRecurrenceType.MONTHLY_BY_MONTH_DAY;
                    this.mMonthlyInterval = rr.getInterval();
                    return;
                }
                if (byRules == null || byRules.size() != 1 || byRules.get(0).getType() != ZInvite.ZByType.BY_DAY || (weekDays = (br = byRules.get(0)).getByDayWeekDays()) == null || weekDays.size() != 1 || (ord = (day = weekDays.get(0)).getWeekOrd()) != -1 && (ord <= 0 || ord >= 5)) break;
                this.mType = ZSimpleRecurrenceType.MONTHLY_RELATIVE;
                this.mMonthlyRelativeDay = day;
                this.mMonthlyInterval = rr.getInterval();
                return;
            }
            case YEA: {
                if (this.empty(byRules) && rr.getInterval() < 2 && this.mEnd == ZSimpleRecurrenceEnd.NEVER) {
                    this.mType = ZSimpleRecurrenceType.YEARLY;
                    return;
                }
                if (rr.getInterval() >= 2 || byRules == null || byRules.size() != 2) break;
                ZInvite.ZByRule bymonth = this.findType(byRules, ZInvite.ZByType.BY_MONTH);
                ZInvite.ZByRule bymonthday = this.findType(byRules, ZInvite.ZByType.BY_MONTHDAY);
                ZInvite.ZByRule byday = this.findType(byRules, ZInvite.ZByType.BY_DAY);
                if (bymonthday != null && bymonth != null) {
                    String[] monthdays = bymonthday.getList();
                    String[] months = bymonth.getList();
                    if (monthdays.length != 1 || months.length != 1) break;
                    this.mYearlyByDateMonthDay = this.parseInt(monthdays[0], -1);
                    this.mYearlyByDateMonth = this.parseInt(months[0], -1);
                    if (this.mYearlyByDateMonth == -1 || this.mYearlyByDateMonthDay == -1) break;
                    this.mType = ZSimpleRecurrenceType.YEARLY_BY_DATE;
                    return;
                }
                if (byday == null || bymonth == null) break;
                String[] months = bymonth.getList();
                List<ZInvite.ZByDayWeekDay> weekDays = byday.getByDayWeekDays();
                if (weekDays == null || weekDays.size() != 1 || months.length != 1) break;
                this.mYearlyRelativeMonth = this.parseInt(months[0], -1);
                ZInvite.ZByDayWeekDay day = weekDays.get(0);
                int ord = day.getWeekOrd();
                if (this.mYearlyRelativeMonth == -1 || ord != -1 && (ord <= 0 || ord >= 5)) break;
                this.mType = ZSimpleRecurrenceType.YEARLY_RELATIVE;
                this.mYearlyRelativeDay = day;
                return;
            }
        }
        this.mType = ZSimpleRecurrenceType.COMPLEX;
    }

    private int parseInt(String value, int defaultValue) {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    private ZInvite.ZByRule findType(List<ZInvite.ZByRule> byRules, ZInvite.ZByType type) {
        for (ZInvite.ZByRule rule : byRules) {
            if (rule.getType() != type) continue;
            return rule;
        }
        return null;
    }

    public void setCount(long count) {
        this.mCount = count;
    }

    public long getCount() {
        return this.mCount;
    }

    public void setUntilDate(ZDateTime untilDate) {
        this.mUntilDate = untilDate;
    }

    public ZDateTime getUntilDate() {
        return this.mUntilDate;
    }

    public ZSimpleRecurrenceType getType() {
        return this.mType;
    }

    public void setType(ZSimpleRecurrenceType type) {
        this.mType = type;
    }

    public ZSimpleRecurrenceEnd getEnd() {
        return this.mEnd;
    }

    public void setEnd(ZSimpleRecurrenceEnd end) {
        this.mEnd = end;
    }

    public int getDailyInterval() {
        return this.mDailyInterval;
    }

    public void setDailyInterval(int dailyInterval) {
        this.mDailyInterval = dailyInterval;
    }

    public ZInvite.ZWeekDay getWeeklyByDay() {
        return this.mWeeklyByDay;
    }

    public void setWeeklyByDay(ZInvite.ZWeekDay weeklyByDay) {
        this.mWeeklyByDay = weeklyByDay;
    }

    public int getWeeklyInterval() {
        return this.mWeeklyInterval;
    }

    public void setWeeklyInterval(int weeklyInterval) {
        this.mWeeklyInterval = weeklyInterval;
    }

    public List<ZInvite.ZWeekDay> getWeeklyIntervalDays() {
        return this.mWeeklyIntervalDays;
    }

    public void setWeeklyIntervalDays(List<ZInvite.ZWeekDay> weeklyIntervalDays) {
        this.mWeeklyIntervalDays = weeklyIntervalDays;
    }

    public int getMonthlyInterval() {
        return this.mMonthlyInterval;
    }

    public void setMonthlyInterval(int monthlyInterval) {
        this.mMonthlyInterval = monthlyInterval;
    }

    public int getMonthlyMonthDay() {
        return this.mMonthlyMonthDay;
    }

    public void setMonthlyMonthDay(int monthlyMonthDay) {
        this.mMonthlyMonthDay = monthlyMonthDay;
    }

    public ZInvite.ZByDayWeekDay getMonthlyRelativeDay() {
        return this.mMonthlyRelativeDay;
    }

    public void setMonthlyRelativeDay(ZInvite.ZByDayWeekDay monthlyRelativeDay) {
        this.mMonthlyRelativeDay = monthlyRelativeDay;
    }

    public int getYearlyByDateMonthDay() {
        return this.mYearlyByDateMonthDay;
    }

    public void setYearlyByDateMonthDay(int yearlyByDateMonthDay) {
        this.mYearlyByDateMonthDay = yearlyByDateMonthDay;
    }

    public int getYearlyByDateMonth() {
        return this.mYearlyByDateMonth;
    }

    public void setYearlyByDateMonth(int yearlyByDateMonth) {
        this.mYearlyByDateMonth = yearlyByDateMonth;
    }

    public ZInvite.ZByDayWeekDay getYearlyRelativeDay() {
        return this.mYearlyRelativeDay;
    }

    public void setYearlyRelativeDay(ZInvite.ZByDayWeekDay yearlyRelativeDay) {
        this.mYearlyRelativeDay = yearlyRelativeDay;
    }

    public int getYearlyRelativeMonth() {
        return this.mYearlyRelativeMonth;
    }

    public void setYearlyRelativeMonth(int yearlyRelativeMonth) {
        this.mYearlyRelativeMonth = yearlyRelativeMonth;
    }

    public ZInvite.ZRecurrence getRecurrence() {
        ZInvite.ZRecurrence recur = new ZInvite.ZRecurrence();
        if (this.getType().isComplex() || this.getType().isNone()) {
            return recur;
        }
        ZInvite.ZRecurrenceRule rule = new ZInvite.ZRecurrenceRule();
        ArrayList<ZInvite.ZRecurrenceRule> rules = new ArrayList<ZInvite.ZRecurrenceRule>();
        rules.add(rule);
        recur.setRules(rules);
        switch (this.getType()) {
            case DAILY: {
                rule.setFrequency(ZInvite.ZFrequency.DAI);
                break;
            }
            case DAILY_INTERVAL: {
                rule.setFrequency(ZInvite.ZFrequency.DAI);
                rule.setInterval(this.getDailyInterval());
                break;
            }
            case DAILY_WEEKDAY: {
                rule.setFrequency(ZInvite.ZFrequency.DAI);
                rule.setByRules(new ArrayList<ZInvite.ZByRule>());
                rule.getByRules().add(new ZInvite.ZByRule(ZInvite.ZByType.BY_DAY, null, ZInvite.ZByDayWeekDay.getList(ZInvite.ZWeekDay.MO, ZInvite.ZWeekDay.TU, ZInvite.ZWeekDay.WE, ZInvite.ZWeekDay.TH, ZInvite.ZWeekDay.FR)));
                break;
            }
            case WEEKLY: {
                rule.setFrequency(ZInvite.ZFrequency.WEE);
                break;
            }
            case WEEKLY_BY_DAY: {
                rule.setFrequency(ZInvite.ZFrequency.WEE);
                rule.setByRules(new ArrayList<ZInvite.ZByRule>());
                rule.getByRules().add(new ZInvite.ZByRule(ZInvite.ZByType.BY_DAY, null, ZInvite.ZByDayWeekDay.getList(this.getWeeklyByDay())));
                break;
            }
            case WEEKLY_CUSTOM: {
                rule.setFrequency(ZInvite.ZFrequency.WEE);
                rule.setInterval(this.getWeeklyInterval());
                rule.setByRules(new ArrayList<ZInvite.ZByRule>());
                rule.getByRules().add(new ZInvite.ZByRule(ZInvite.ZByType.BY_DAY, null, ZInvite.ZByDayWeekDay.getList(this.getWeeklyIntervalDays())));
                break;
            }
            case MONTHLY: {
                rule.setFrequency(ZInvite.ZFrequency.MON);
                break;
            }
            case MONTHLY_BY_MONTH_DAY: {
                rule.setFrequency(ZInvite.ZFrequency.MON);
                rule.setInterval(this.getMonthlyInterval());
                rule.setByRules(new ArrayList<ZInvite.ZByRule>());
                rule.getByRules().add(new ZInvite.ZByRule(ZInvite.ZByType.BY_MONTHDAY, Integer.toString(this.getMonthlyMonthDay()), null));
                break;
            }
            case MONTHLY_RELATIVE: {
                rule.setFrequency(ZInvite.ZFrequency.MON);
                rule.setInterval(this.getMonthlyInterval());
                rule.setByRules(new ArrayList<ZInvite.ZByRule>());
                rule.getByRules().add(new ZInvite.ZByRule(ZInvite.ZByType.BY_DAY, null, Arrays.asList(this.getMonthlyRelativeDay())));
                break;
            }
            case YEARLY: {
                rule.setFrequency(ZInvite.ZFrequency.YEA);
                break;
            }
            case YEARLY_BY_DATE: {
                rule.setFrequency(ZInvite.ZFrequency.YEA);
                rule.setByRules(new ArrayList<ZInvite.ZByRule>());
                rule.getByRules().add(new ZInvite.ZByRule(ZInvite.ZByType.BY_MONTHDAY, Integer.toString(this.getYearlyByDateMonthDay()), null));
                rule.getByRules().add(new ZInvite.ZByRule(ZInvite.ZByType.BY_MONTH, Integer.toString(this.getYearlyByDateMonth()), null));
                break;
            }
            case YEARLY_RELATIVE: {
                rule.setFrequency(ZInvite.ZFrequency.YEA);
                rule.setByRules(new ArrayList<ZInvite.ZByRule>());
                rule.getByRules().add(new ZInvite.ZByRule(ZInvite.ZByType.BY_DAY, null, Arrays.asList(this.getYearlyRelativeDay())));
                rule.getByRules().add(new ZInvite.ZByRule(ZInvite.ZByType.BY_MONTH, Integer.toString(this.getYearlyRelativeMonth()), null));
            }
        }
        switch (this.getEnd()) {
            case NEVER: {
                break;
            }
            case COUNT: {
                rule.setCount((int)this.getCount());
                break;
            }
            case UNTIL: {
                rule.setUntilDate(this.getUntilDate());
            }
        }
        return recur;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ZSimpleRecurrenceEnd {
        NEVER,
        COUNT,
        UNTIL;


        public static ZSimpleRecurrenceEnd fromString(String s) throws ServiceException {
            try {
                return ZSimpleRecurrenceEnd.valueOf(s);
            }
            catch (IllegalArgumentException e) {
                throw ZClientException.CLIENT_ERROR("invalid end " + s + ", valid values: " + Arrays.asList(ZSimpleRecurrenceEnd.values()), e);
            }
        }

        public boolean isNever() {
            return this.equals((Object)NEVER);
        }

        public boolean isCount() {
            return this.equals((Object)COUNT);
        }

        public boolean isUntil() {
            return this.equals((Object)UNTIL);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ZSimpleRecurrenceType {
        NONE,
        DAILY,
        DAILY_WEEKDAY,
        DAILY_INTERVAL,
        WEEKLY,
        WEEKLY_BY_DAY,
        WEEKLY_CUSTOM,
        MONTHLY,
        MONTHLY_BY_MONTH_DAY,
        MONTHLY_RELATIVE,
        YEARLY,
        YEARLY_BY_DATE,
        YEARLY_RELATIVE,
        COMPLEX;


        public static ZSimpleRecurrenceType fromString(String s) throws ServiceException {
            try {
                return ZSimpleRecurrenceType.valueOf(s);
            }
            catch (IllegalArgumentException e) {
                throw ZClientException.CLIENT_ERROR("invalid type " + s + ", valid values: " + Arrays.asList(ZSimpleRecurrenceType.values()), e);
            }
        }

        public boolean isNone() {
            return this.equals((Object)NONE);
        }

        public boolean isDaily() {
            return this.equals((Object)DAILY);
        }

        public boolean isDailyWeekday() {
            return this.equals((Object)DAILY_WEEKDAY);
        }

        public boolean isDailyInterval() {
            return this.equals((Object)DAILY_INTERVAL);
        }

        public boolean isWeekly() {
            return this.equals((Object)WEEKLY);
        }

        public boolean isWeeklyByDay() {
            return this.equals((Object)WEEKLY_BY_DAY);
        }

        public boolean isWeeklyCustom() {
            return this.equals((Object)WEEKLY_CUSTOM);
        }

        public boolean isMonthly() {
            return this.equals((Object)MONTHLY);
        }

        public boolean isMonthlyByMonthDay() {
            return this.equals((Object)MONTHLY_BY_MONTH_DAY);
        }

        public boolean isMonthlyRelative() {
            return this.equals((Object)MONTHLY_RELATIVE);
        }

        public boolean isYearly() {
            return this.equals((Object)YEARLY);
        }

        public boolean isYearlyByDate() {
            return this.equals((Object)YEARLY_BY_DATE);
        }

        public boolean isYearlyRelative() {
            return this.equals((Object)YEARLY_RELATIVE);
        }

        public boolean isComplex() {
            return this.equals((Object)COMPLEX);
        }
    }
}

