/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.zclient;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.cs.account.Signature;
import com.zimbra.cs.zclient.ToZJSONObject;
import com.zimbra.cs.zclient.ZJSONObject;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZSignature
implements Comparable,
ToZJSONObject {
    private String mName;
    private String mId;
    private String mValue;
    private String mType = "text/plain";

    public ZSignature(Element e) throws ServiceException {
        this.mName = e.getAttribute("name");
        this.mId = e.getAttribute("id", null);
        for (Element c : e.listElements("content")) {
            String type = c.getAttribute("type", null);
            if (!type.equals("text/plain") && !type.equals("text/html")) continue;
            this.mValue = c.getText();
            this.mType = type;
        }
    }

    public ZSignature(String id, String name, String value, String type) {
        this(id, name, value);
        this.mType = type;
    }

    public ZSignature(String id, String name, String value) {
        this.mId = id;
        this.mName = name;
        this.mValue = value;
    }

    public ZSignature(String name, String value) {
        this.mName = name;
        this.mValue = value;
    }

    public String getName() {
        return this.mName;
    }

    public String getId() {
        return this.mId;
    }

    public String getValue() {
        return this.mValue;
    }

    public String getType() {
        return this.mType;
    }

    public void setType(String type) {
        this.mType = type;
    }

    public Map<String, Object> getAttrs() {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        attrs.put("zimbraSignatureId", this.mId);
        attrs.put("zimbraSignatureName", this.mName);
        attrs.put(Signature.mimeTypeToAttrName(this.mType), this.mValue);
        return attrs;
    }

    public Element toElement(Element parent) {
        Element sig = parent.addElement("signature");
        sig.addAttribute("name", this.mName);
        if (this.mId != null) {
            sig.addAttribute("id", this.mId);
        }
        if (this.mName != null) {
            sig.addAttribute("name", this.mName);
        }
        if (this.mValue != null) {
            Element content = sig.addElement("content");
            content.addAttribute("type", this.mType);
            content.setText(this.mValue);
        }
        return sig;
    }

    @Override
    public ZJSONObject toZJSONObject() throws JSONException {
        ZJSONObject zjo = new ZJSONObject();
        zjo.put("name", this.mName);
        zjo.put("id", this.mId);
        zjo.put("value", this.mValue);
        zjo.put("type", this.mType);
        return zjo;
    }

    public String toString() {
        return String.format("[ZSignature %s]", this.mName);
    }

    public String dump() {
        return ZJSONObject.toString(this);
    }

    public int compareTo(Object obj) {
        if (!(obj instanceof ZSignature)) {
            return 0;
        }
        ZSignature other = (ZSignature)obj;
        return this.getName().compareTo(other.getName());
    }
}

