/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.zclient;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.common.zclient.ZClientException;
import com.zimbra.cs.zclient.ToZJSONObject;
import com.zimbra.cs.zclient.ZFolder;
import com.zimbra.cs.zclient.ZJSONObject;
import org.dom4j.DocumentException;
import org.json.JSONException;

public class ZShare
implements ToZJSONObject {
    public static final String E_SHARE = "share";
    public static final String E_GRANTEE = "grantee";
    public static final String E_GRANTOR = "grantor";
    public static final String E_LINK = "link";
    public static final String E_NOTES = "notes";
    public static final String A_ID = "id";
    public static final String A_EMAIL = "email";
    public static final String A_NAME = "name";
    public static final String A_VIEW = "view";
    public static final String A_PERM = "perm";
    public static final String A_ACTION = "action";
    public static final String A_VERSION = "version";
    private ZGrantee mGrantee;
    private ZGrantor mGrantor;
    private ZLink mLink;
    private String mVersion;
    private ZShareAction mAction;

    public ZShare() {
    }

    public static ZShare parseXml(String xml) throws ServiceException {
        try {
            return new ZShare(Element.parseXML(xml));
        }
        catch (DocumentException e) {
            throw ZClientException.ZIMBRA_SHARE_PARSE_ERROR("can't parse share", e);
        }
    }

    public ZShare(Element e) throws ServiceException {
        Element linkEl;
        Element grantorEl;
        Element granteeEl = e.getOptionalElement(E_GRANTEE);
        if (granteeEl != null) {
            this.mGrantee = new ZGrantee(granteeEl);
        }
        if ((grantorEl = e.getOptionalElement(E_GRANTOR)) != null) {
            this.mGrantor = new ZGrantor(grantorEl);
        }
        if ((linkEl = e.getOptionalElement(E_LINK)) != null) {
            this.mLink = new ZLink(linkEl);
        }
        this.mVersion = e.getAttribute(A_VERSION);
        this.mAction = ZShareAction.fromString(e.getAttribute(A_ACTION));
    }

    public Element toElement(Element parent) {
        Element e = parent.addElement(E_SHARE);
        e.addAttribute(A_VERSION, this.mVersion);
        e.addAttribute(A_ACTION, this.mAction.toString());
        if (this.mGrantee != null) {
            this.mGrantee.toElement(e);
        }
        if (this.mGrantor != null) {
            this.mGrantor.toElement(e);
        }
        if (this.mLink != null) {
            return this.mLink.toElement(e);
        }
        return e;
    }

    public ZJSONObject toZJSONObject() throws JSONException {
        ZJSONObject zjo = new ZJSONObject();
        zjo.put(A_VERSION, this.mVersion);
        zjo.put(A_ACTION, this.mAction.name());
        zjo.put(E_GRANTEE, this.mGrantee);
        zjo.put(E_GRANTOR, this.mGrantor);
        zjo.put(E_LINK, this.mLink);
        return zjo;
    }

    public String toString() {
        return String.format("[ZShare %s]", this.mGrantor);
    }

    public String dump() {
        return ZJSONObject.toString(this);
    }

    public ZGrantee getGrantee() {
        return this.mGrantee;
    }

    public void setGrantee(ZGrantee grantee) {
        this.mGrantee = grantee;
    }

    public ZGrantor getGrantor() {
        return this.mGrantor;
    }

    public void setGrantor(ZGrantor grantor) {
        this.mGrantor = grantor;
    }

    public ZLink getLink() {
        return this.mLink;
    }

    public void setLink(ZLink link) {
        this.mLink = link;
    }

    public String getVersion() {
        return this.mVersion;
    }

    public void setVersion(String version) {
        this.mVersion = version;
    }

    public ZShareAction getAction() {
        return this.mAction;
    }

    public void setAction(ZShareAction action) {
        this.mAction = action;
    }

    public static class ZLink
    implements ToZJSONObject {
        private String mId;
        private ZFolder.View mView;
        private String mName;
        private String mPermission;

        public ZLink() {
        }

        public ZLink(Element e) throws ServiceException {
            this.mId = e.getAttribute(ZShare.A_ID);
            this.mPermission = e.getAttribute(ZShare.A_PERM);
            this.mName = e.getAttribute(ZShare.A_NAME);
            this.mView = ZFolder.View.fromString(e.getAttribute(ZShare.A_VIEW));
        }

        protected Element toElement(Element parent) {
            Element el = parent.addElement(ZShare.E_LINK);
            el.addAttribute(ZShare.A_ID, this.mId);
            el.addAttribute(ZShare.A_NAME, this.mName);
            el.addAttribute(ZShare.A_VIEW, this.mView.name());
            el.addAttribute(ZShare.A_PERM, this.mPermission);
            return el;
        }

        public ZFolder.View getView() {
            return this.mView;
        }

        public void setView(ZFolder.View view) {
            this.mView = view;
        }

        public String getId() {
            return this.mId;
        }

        public void setId(String id) {
            this.mId = id;
        }

        public String getPermission() {
            return this.mPermission;
        }

        public void setPermission(String perm) {
            this.mPermission = perm;
        }

        public String getName() {
            return this.mName;
        }

        public void setName(String name) {
            this.mName = name;
        }

        public ZJSONObject toZJSONObject() throws JSONException {
            ZJSONObject zjo = new ZJSONObject();
            zjo.put(ZShare.A_ID, this.mId);
            zjo.put(ZShare.A_PERM, this.mPermission);
            zjo.put(ZShare.A_VIEW, this.mView.name());
            zjo.put(ZShare.A_NAME, this.mName);
            return zjo;
        }

        public String toString() {
            return String.format("[ZLink id=%s name=%s]", this.mId, this.mName);
        }

        public String dump() {
            return ZJSONObject.toString(this);
        }
    }

    public static class ZGrantee
    extends ZGrantInfo {
        public ZGrantee() {
        }

        public ZGrantee(Element e) throws ServiceException {
            super(e);
        }

        public Element toElement(Element parent) {
            return super.toElement(parent, ZShare.E_GRANTEE);
        }
    }

    public static class ZGrantor
    extends ZGrantInfo {
        public ZGrantor() {
        }

        public ZGrantor(Element e) throws ServiceException {
            super(e);
        }

        public Element toElement(Element parent) {
            return super.toElement(parent, ZShare.E_GRANTOR);
        }
    }

    public static class ZGrantInfo
    implements ToZJSONObject {
        private String mId;
        private String mEmail;
        private String mName;

        public ZGrantInfo() {
        }

        public ZGrantInfo(Element e) throws ServiceException {
            this.mId = e.getAttribute(ZShare.A_ID);
            this.mEmail = e.getAttribute(ZShare.A_EMAIL);
            this.mName = e.getAttribute(ZShare.A_NAME);
        }

        protected Element toElement(Element parent, String name) {
            Element el = parent.addElement(name);
            el.addAttribute(ZShare.A_ID, this.mId);
            el.addAttribute(ZShare.A_EMAIL, this.mEmail);
            el.addAttribute(ZShare.A_NAME, this.mName);
            return el;
        }

        public String getId() {
            return this.mId;
        }

        public void setId(String id) {
            this.mId = id;
        }

        public String getEmail() {
            return this.mEmail;
        }

        public void setEmail(String email) {
            this.mEmail = email;
        }

        public String getName() {
            return this.mName;
        }

        public void setName(String name) {
            this.mName = name;
        }

        public ZJSONObject toZJSONObject() throws JSONException {
            ZJSONObject zjo = new ZJSONObject();
            zjo.put(ZShare.A_ID, this.mId);
            zjo.put(ZShare.A_EMAIL, this.mEmail);
            zjo.put(ZShare.A_NAME, this.mName);
            return zjo;
        }

        public String toString() {
            return String.format("[ZGrantInfo id=%s email=%s name=%s]", this.mId, this.mEmail, this.mName);
        }

        public String dump() {
            return ZJSONObject.toString(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ZShareAction {
        NEW,
        EDIT,
        DELETE,
        ACCEPT,
        DECLINE;


        public static ZShareAction fromString(String s) throws ServiceException {
            try {
                return ZShareAction.valueOf(s.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                throw ZClientException.CLIENT_ERROR("invalid share action " + s + ", valid values: new, edit, delete, accept, decline", e);
            }
        }

        public String toString() {
            return this.name().toLowerCase();
        }
    }
}

