/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.zclient;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.cs.zclient.ZCallFeature;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZSelectiveCallForwarding
extends ZCallFeature {
    private List<String> mForwardFrom = new ArrayList<String>();

    public ZSelectiveCallForwarding(String name) {
        super(name);
    }

    public List<String> getForwardFrom() {
        return new ArrayList<String>(this.mForwardFrom);
    }

    public synchronized void setForwardFrom(List<String> list) {
        this.mForwardFrom.clear();
        this.mForwardFrom.addAll(list);
    }

    @Override
    public synchronized void assignFrom(ZCallFeature that) {
        super.assignFrom(that);
        if (that instanceof ZSelectiveCallForwarding) {
            this.mForwardFrom = new ArrayList<String>(((ZSelectiveCallForwarding)that).mForwardFrom);
        }
    }

    @Override
    synchronized void fromElement(Element element) throws ServiceException {
        super.fromElement(element);
        this.mForwardFrom = new ArrayList<String>();
        for (Element fromEl : element.listElements("phone")) {
            this.mForwardFrom.add(fromEl.getAttribute("pn"));
        }
    }

    @Override
    void toElement(Element element) throws ServiceException {
        super.toElement(element);
        for (String name : this.mForwardFrom) {
            Element fromEl = element.addElement("phone");
            fromEl.addAttribute("pn", name);
            fromEl.addAttribute("a", "true");
        }
    }
}

