/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.zclient;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.cs.zclient.ToZJSONObject;
import com.zimbra.cs.zclient.ZAppointmentHit;
import com.zimbra.cs.zclient.ZCallHit;
import com.zimbra.cs.zclient.ZContactHit;
import com.zimbra.cs.zclient.ZConversation;
import com.zimbra.cs.zclient.ZConversationHit;
import com.zimbra.cs.zclient.ZDocumentHit;
import com.zimbra.cs.zclient.ZJSONObject;
import com.zimbra.cs.zclient.ZMessageHit;
import com.zimbra.cs.zclient.ZSearchHit;
import com.zimbra.cs.zclient.ZVoiceMailItemHit;
import com.zimbra.cs.zclient.ZWikiHit;
import com.zimbra.cs.zclient.event.ZModifyConversationEvent;
import com.zimbra.cs.zclient.event.ZModifyEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.TimeZone;
import org.json.JSONException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZSearchResult
implements ToZJSONObject {
    private List<ZSearchHit> mHits;
    private ZConversationSummary mConvSummary;
    private boolean mHasMore;
    private String mSortBy;
    private int mOffset;

    public ZSearchResult(Element e, boolean convNest, TimeZone tz) throws ServiceException {
        if (!convNest) {
            this.init(e, e, tz);
        } else {
            Element c = e.getElement("c");
            this.mConvSummary = new ZConversationSummary(c);
            this.init(e, c, tz);
        }
    }

    public ZSearchResult(List<ZSearchHit> hits, ZConversationSummary convSummary, boolean hasMore, String sortBy, int offset) {
        this.mHits = hits;
        this.mConvSummary = convSummary;
        this.mHasMore = hasMore;
        this.mSortBy = sortBy;
        this.mOffset = offset;
    }

    private void init(Element resp, Element hits, TimeZone tz) throws ServiceException {
        this.mSortBy = resp.getAttribute("sortBy");
        this.mHasMore = resp.getAttributeBool("more");
        this.mOffset = (int)resp.getAttributeLong("offset");
        this.mHits = new ArrayList<ZSearchHit>();
        for (Element h : hits.listElements()) {
            if (h.getName().equals("c")) {
                this.mHits.add(new ZConversationHit(h));
                continue;
            }
            if (h.getName().equals("m")) {
                this.mHits.add(new ZMessageHit(h));
                continue;
            }
            if (h.getName().equals("cn")) {
                this.mHits.add(new ZContactHit(h));
                continue;
            }
            if (h.getName().equals("appt")) {
                ZAppointmentHit.addInstances(h, this.mHits, tz, false);
                continue;
            }
            if (h.getName().equals("task")) {
                ZAppointmentHit.addInstances(h, this.mHits, tz, true);
                continue;
            }
            if (h.getName().equals("doc")) {
                this.mHits.add(new ZDocumentHit(h));
                continue;
            }
            if (h.getName().equals("w")) {
                this.mHits.add(new ZWikiHit(h));
                continue;
            }
            if (h.getName().equals("vm")) {
                this.mHits.add(new ZVoiceMailItemHit(h));
                continue;
            }
            if (!h.getName().equals("cl")) continue;
            this.mHits.add(new ZCallHit(h));
        }
    }

    public List<ZSearchHit> getHits() {
        return this.mHits;
    }

    public ZConversationSummary getConversationSummary() {
        return this.mConvSummary;
    }

    public boolean hasMore() {
        return this.mHasMore;
    }

    public String getSortBy() {
        return this.mSortBy;
    }

    public int getOffset() {
        return this.mOffset;
    }

    @Override
    public ZJSONObject toZJSONObject() throws JSONException {
        ZJSONObject zjo = new ZJSONObject();
        zjo.put("more", this.mHasMore);
        zjo.put("sortBy", this.mSortBy);
        zjo.put("offset", this.mOffset);
        zjo.put("hits", this.mHits);
        return zjo;
    }

    public String toString() {
        return String.format("[ZSearchResult size=%s more=%s]", this.mHits.size(), this.mHasMore);
    }

    public String dump() {
        return ZJSONObject.toString(this);
    }

    public class ZConversationSummary
    implements ZSearchHit {
        private String mId;
        private String mFlags;
        private String mTags;
        private int mMessageCount;

        public ZConversationSummary(Element e) throws ServiceException {
            this.mId = e.getAttribute("id");
            this.mFlags = e.getAttribute("f", null);
            this.mTags = e.getAttribute("t", null);
            this.mMessageCount = (int)e.getAttributeLong("n");
        }

        public void modifyNotification(ZModifyEvent event) throws ServiceException {
            if (event instanceof ZModifyConversationEvent) {
                ZModifyConversationEvent cevent = (ZModifyConversationEvent)event;
                this.mFlags = cevent.getFlags(this.mFlags);
                this.mTags = cevent.getTagIds(this.mTags);
                this.mMessageCount = cevent.getMessageCount(this.mMessageCount);
            }
        }

        public String getId() {
            return this.mId;
        }

        public String getSortField() {
            return null;
        }

        public float getScore() {
            return 0.0f;
        }

        public ZJSONObject toZJSONObject() throws JSONException {
            ZJSONObject zjo = new ZJSONObject();
            zjo.put("id", this.mId);
            zjo.put("flags", this.mFlags);
            zjo.put("tags", this.mTags);
            zjo.put("messageCount", this.mMessageCount);
            return zjo;
        }

        public String toString() {
            return String.format("[ZConversationSummary %s]", this.mId);
        }

        public String dump() {
            return ZJSONObject.toString(this);
        }

        public String getFlags() {
            return this.mFlags;
        }

        public String getTagIds() {
            return this.mTags;
        }

        public int getMessageCount() {
            return this.mMessageCount;
        }

        public boolean hasFlags() {
            return this.mFlags != null && this.mFlags.length() > 0;
        }

        public boolean hasTags() {
            return this.mTags != null && this.mTags.length() > 0;
        }

        public boolean hasAttachment() {
            return this.hasFlags() && this.mFlags.indexOf(ZConversation.Flag.attachment.getFlagChar()) != -1;
        }

        public boolean isFlagged() {
            return this.hasFlags() && this.mFlags.indexOf(ZConversation.Flag.flagged.getFlagChar()) != -1;
        }

        public boolean isSentByMe() {
            return this.hasFlags() && this.mFlags.indexOf(ZConversation.Flag.sentByMe.getFlagChar()) != -1;
        }

        public boolean isUnread() {
            return this.hasFlags() && this.mFlags.indexOf(ZConversation.Flag.unread.getFlagChar()) != -1;
        }

        public boolean isDraft() {
            return this.hasFlags() && this.mFlags.indexOf(ZConversation.Flag.draft.getFlagChar()) != -1;
        }
    }
}

