/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.zclient;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.StringUtil;
import com.zimbra.common.zclient.ZClientException;
import com.zimbra.cs.zclient.ToZJSONObject;
import com.zimbra.cs.zclient.ZJSONObject;
import com.zimbra.cs.zclient.ZMailbox;
import com.zimbra.cs.zclient.ZSearchFolder;
import java.util.TimeZone;
import org.json.JSONException;

public class ZSearchParams
implements ToZJSONObject {
    public static final String TYPE_CONVERSATION = "conversation";
    public static final String TYPE_GAL = "gal";
    public static final String TYPE_MESSAGE = "message";
    public static final String TYPE_CONTACT = "contact";
    public static final String TYPE_VOICE_MAIL = "voicemail";
    public static final String TYPE_CALL = "calllog";
    public static final String TYPE_APPOINTMENT = "appointment";
    public static final String TYPE_TASK = "task";
    public static final String TYPE_DOCUMENT = "document";
    public static final String TYPE_BRIEFCASE = "briefcase";
    public static final String TYPE_WIKI = "wiki";
    private int mLimit = 100;
    private int mOffset;
    private ZMailbox.SearchSortBy mSortBy = ZMailbox.SearchSortBy.dateDesc;
    private String mTypes = "conversation";
    private ZMailbox.Fetch mFetch;
    private boolean mPreferHtml;
    private boolean mMarkAsRead;
    private boolean mRecipientMode;
    private String mField;
    private String mQuery;
    private Cursor mCursor;
    private long mCalExpandInstStart;
    private long mCalExpandInstEnd;
    private TimeZone mTimeZone;
    private String mConvId;

    public static String getCanonicalTypes(String list) throws ServiceException {
        if (list == null || list.length() == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (String s : list.split(",")) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            if (s.startsWith("conv") && TYPE_CONVERSATION.startsWith(s)) {
                sb.append(TYPE_CONVERSATION);
                continue;
            }
            if (s.startsWith("m") && TYPE_MESSAGE.startsWith(s)) {
                sb.append(TYPE_MESSAGE);
                continue;
            }
            if (s.startsWith("cont") && TYPE_CONTACT.startsWith(s)) {
                sb.append(TYPE_CONTACT);
                continue;
            }
            if (s.startsWith("a") && TYPE_APPOINTMENT.startsWith(s)) {
                sb.append(TYPE_APPOINTMENT);
                continue;
            }
            if (s.startsWith("d") && TYPE_DOCUMENT.startsWith(s)) {
                sb.append(TYPE_DOCUMENT);
                continue;
            }
            if (s.startsWith("b") && TYPE_BRIEFCASE.startsWith(s)) {
                sb.append(TYPE_BRIEFCASE);
                continue;
            }
            if (s.startsWith("w") && TYPE_WIKI.startsWith(s)) {
                sb.append(TYPE_WIKI);
                continue;
            }
            if (s.startsWith("t") && TYPE_TASK.startsWith(s)) {
                sb.append(TYPE_TASK);
                continue;
            }
            if (s.startsWith("g") && TYPE_GAL.startsWith(s)) {
                sb.append(TYPE_GAL);
                continue;
            }
            throw ZClientException.CLIENT_ERROR("invlaid search type: " + s, null);
        }
        return sb.toString();
    }

    public int hashCode() {
        if (this.mConvId != null) {
            return (this.mQuery + this.mConvId).hashCode();
        }
        return this.mQuery.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ZSearchParams)) {
            return false;
        }
        ZSearchParams that = (ZSearchParams)obj;
        if (this.mLimit != that.mLimit || this.mOffset != that.mOffset || this.mSortBy != that.mSortBy || this.mFetch != that.mFetch || this.mPreferHtml != that.mPreferHtml || this.mMarkAsRead != that.mMarkAsRead || this.mRecipientMode != that.mRecipientMode || this.mCalExpandInstStart != that.mCalExpandInstStart || this.mCalExpandInstEnd != that.mCalExpandInstEnd) {
            return false;
        }
        if (!(StringUtil.equal(this.mTypes, that.mTypes) && StringUtil.equal(this.mQuery, that.mQuery) && StringUtil.equal(this.mConvId, that.mConvId) && StringUtil.equal(this.mField, that.mField))) {
            return false;
        }
        if (this.mTimeZone == null && that.mTimeZone != null || this.mTimeZone != null && !this.mTimeZone.equals(that.mTimeZone)) {
            return false;
        }
        if (this.mCursor == null || that.mCursor == null) {
            return this.mCursor == that.mCursor;
        }
        return this.mCursor.equals(that.mCursor);
    }

    public ZSearchParams(ZSearchParams that) {
        this.mCursor = that.mCursor;
        this.mFetch = that.mFetch;
        this.mLimit = that.mLimit;
        this.mMarkAsRead = that.mMarkAsRead;
        this.mOffset = that.mOffset;
        this.mPreferHtml = that.mPreferHtml;
        this.mQuery = that.mQuery;
        this.mRecipientMode = that.mRecipientMode;
        this.mSortBy = that.mSortBy;
        this.mTypes = that.mTypes;
        this.mField = that.mField;
        this.mConvId = that.mConvId;
        this.mCalExpandInstEnd = that.mCalExpandInstEnd;
        this.mCalExpandInstStart = that.mCalExpandInstStart;
        this.mTimeZone = that.mTimeZone;
    }

    public ZSearchParams(String query) {
        this.mQuery = query;
    }

    public ZSearchParams(ZSearchFolder folder) {
        this.mQuery = folder.getQuery();
        this.mTypes = folder.getTypes();
        this.mSortBy = folder.getSortBy();
    }

    public void setTimeZone(TimeZone tz) {
        this.mTimeZone = tz;
    }

    public TimeZone getTimeZone() {
        return this.mTimeZone;
    }

    public Cursor getCursor() {
        return this.mCursor;
    }

    public void setCursor(Cursor cursor) {
        this.mCursor = cursor;
    }

    public ZMailbox.Fetch getFetch() {
        return this.mFetch;
    }

    public void setFetch(ZMailbox.Fetch fetch) {
        this.mFetch = fetch;
    }

    public int getLimit() {
        return this.mLimit;
    }

    public void setLimit(int limit) {
        this.mLimit = limit;
    }

    public boolean isMarkAsRead() {
        return this.mMarkAsRead;
    }

    public void setMarkAsRead(boolean markAsRead) {
        this.mMarkAsRead = markAsRead;
    }

    public void setConvId(String convId) {
        this.mConvId = convId;
    }

    public String getConvId() {
        return this.mConvId;
    }

    public int getOffset() {
        return this.mOffset;
    }

    public void setOffset(int offset) {
        this.mOffset = offset;
    }

    public boolean isPreferHtml() {
        return this.mPreferHtml;
    }

    public void setPeferHtml(boolean preferHtml) {
        this.mPreferHtml = preferHtml;
    }

    public String getQuery() {
        return this.mQuery;
    }

    public void setQuery(String query) {
        this.mQuery = query;
    }

    public boolean isRecipientMode() {
        return this.mRecipientMode;
    }

    public void setRecipientMode(boolean recipientMode) {
        this.mRecipientMode = recipientMode;
    }

    public ZMailbox.SearchSortBy getSortBy() {
        return this.mSortBy;
    }

    public void setSortBy(ZMailbox.SearchSortBy sortBy) {
        this.mSortBy = sortBy;
    }

    public String getTypes() {
        return this.mTypes;
    }

    public void setTypes(String types) {
        this.mTypes = types;
    }

    public long getCalExpandInstStart() {
        return this.mCalExpandInstStart;
    }

    public void setCalExpandInstStart(long calExpandInstStart) {
        this.mCalExpandInstStart = calExpandInstStart;
    }

    public long getCalExpandInstEnd() {
        return this.mCalExpandInstEnd;
    }

    public void setCalExpandInstEnd(long calExpandInstEnd) {
        this.mCalExpandInstEnd = calExpandInstEnd;
    }

    public String getField() {
        return this.mField;
    }

    public ZJSONObject toZJSONObject() throws JSONException {
        ZJSONObject zjo = new ZJSONObject();
        if (this.mFetch != null) {
            zjo.put("fetch", this.mFetch.name());
        }
        zjo.put("limit", this.mLimit);
        zjo.put("markAsRead", this.mMarkAsRead);
        zjo.put("offset", this.mOffset);
        zjo.put("preferHtml", this.mPreferHtml);
        zjo.put("query", this.mQuery);
        zjo.put("recipientMode", this.mRecipientMode);
        if (this.mSortBy != null) {
            zjo.put("sortBy", this.mSortBy.name());
        }
        zjo.put("types", this.mTypes);
        zjo.put("field", this.mField);
        zjo.put("convId", this.mConvId);
        zjo.put("calExpandInstEnd", this.mCalExpandInstEnd);
        zjo.put("calExpandInstStart", this.mCalExpandInstStart);
        if (this.mTimeZone != null) {
            zjo.put("timeZone", this.mTimeZone.getID());
        }
        if (this.mCursor != null) {
            zjo.put("cursor", this.mCursor);
        }
        return zjo;
    }

    public String toString() {
        return String.format("[ZSearchParams %s]", this.mQuery == null ? "" : this.mQuery);
    }

    public String dump() {
        return ZJSONObject.toString(this);
    }

    public void setField(String field) {
        this.mField = field;
    }

    public static class Cursor
    implements ToZJSONObject {
        private String mPreviousId;
        private String mPreviousSortValue;

        public Cursor(String prevoiusId, String previousSortValue) {
            this.mPreviousId = prevoiusId;
            this.mPreviousSortValue = previousSortValue;
        }

        public String getPreviousId() {
            return this.mPreviousId;
        }

        public String getPreviousSortValue() {
            return this.mPreviousSortValue;
        }

        public int hashCode() {
            return (this.mPreviousId + this.mPreviousSortValue).hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Cursor)) {
                return false;
            }
            Cursor that = (Cursor)obj;
            if (!StringUtil.equal(this.mPreviousId, that.mPreviousId)) {
                return false;
            }
            return StringUtil.equal(this.mPreviousSortValue, that.mPreviousSortValue);
        }

        public ZJSONObject toZJSONObject() throws JSONException {
            ZJSONObject zjo = new ZJSONObject();
            zjo.put("previousId", this.mPreviousId);
            zjo.put("previousSortValue", this.mPreviousSortValue);
            return zjo;
        }

        public String toString() {
            return String.format("[Cursor id=%s sort=%s]", this.mPreviousId, this.mPreviousSortValue);
        }

        public String dump() {
            return ZJSONObject.toString(this);
        }
    }
}

