/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.zclient;

import com.zimbra.cs.zclient.ToZJSONObject;
import com.zimbra.cs.zclient.ZJSONObject;
import com.zimbra.cs.zclient.ZSearchResult;
import org.json.JSONException;

public class ZSearchPagerResult
implements ToZJSONObject {
    private ZSearchResult mSearchResult;
    private int mActualPage;
    private int mRequstedPage;
    private int mLimit;

    ZSearchPagerResult(ZSearchResult result, int requestedPage, int actualPage, int limit) {
        this.mSearchResult = result;
        this.mActualPage = actualPage;
        this.mRequstedPage = requestedPage;
        this.mLimit = limit;
    }

    public ZSearchResult getResult() {
        return this.mSearchResult;
    }

    public int getActualPage() {
        return this.mActualPage;
    }

    public int getRequestedPage() {
        return this.mRequstedPage;
    }

    public int getOffset() {
        return this.mLimit * this.mActualPage;
    }

    public ZJSONObject toZJSONObject() throws JSONException {
        ZJSONObject zjo = new ZJSONObject();
        zjo.put("result", this.mSearchResult);
        zjo.put("requestedPage", this.mRequstedPage);
        zjo.put("actualPage", this.mActualPage);
        zjo.put("offset", this.getOffset());
        return zjo;
    }

    public String toString() {
        return String.format("[ZSearchPagerResult %s]", this.mActualPage);
    }

    public String dump() {
        return ZJSONObject.toString(this);
    }
}

