/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.zclient;

import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.zclient.ZMailbox;
import com.zimbra.cs.zclient.ZSearchPager;
import com.zimbra.cs.zclient.ZSearchPagerResult;
import com.zimbra.cs.zclient.ZSearchParams;
import com.zimbra.cs.zclient.ZSearchResult;
import com.zimbra.cs.zclient.event.ZCreateEvent;
import com.zimbra.cs.zclient.event.ZCreateItemEvent;
import com.zimbra.cs.zclient.event.ZCreateMessageEvent;
import com.zimbra.cs.zclient.event.ZDeleteEvent;
import com.zimbra.cs.zclient.event.ZEventHandler;
import com.zimbra.cs.zclient.event.ZModifyEvent;
import com.zimbra.cs.zclient.event.ZModifyItemEvent;
import com.zimbra.cs.zclient.event.ZModifyItemFolderEvent;
import com.zimbra.cs.zclient.event.ZRefreshEvent;
import org.apache.commons.collections.MapIterator;
import org.apache.commons.collections.map.LRUMap;

class ZSearchPagerCache
extends ZEventHandler {
    LRUMap mSearchPagerCache;
    private boolean mClearOnModifyItemFolder;

    ZSearchPagerCache(int maxItems, boolean clearOnModifyItemFolder) {
        this.mSearchPagerCache = new LRUMap(maxItems);
        this.mClearOnModifyItemFolder = clearOnModifyItemFolder;
    }

    public synchronized ZSearchPagerResult search(ZMailbox mailbox, ZSearchParams params, int page, boolean useCache, boolean useCursor) throws ServiceException {
        ZSearchPager pager = (ZSearchPager)this.mSearchPagerCache.get((Object)params);
        if (pager != null && (!useCache || pager.isDirty())) {
            this.mSearchPagerCache.remove((Object)params);
            pager = null;
        }
        if (pager == null) {
            pager = new ZSearchPager(params);
            this.mSearchPagerCache.put((Object)params, (Object)pager);
        }
        ZSearchResult result = pager.search(mailbox, page, useCursor);
        return new ZSearchPagerResult(result, page, page >= pager.getNumberOfPages() ? pager.getNumberOfPages() - 1 : page, params.getLimit());
    }

    public synchronized void clear(String type) {
        if (type == null) {
            this.mSearchPagerCache.clear();
        } else {
            MapIterator mi = this.mSearchPagerCache.mapIterator();
            while (mi.hasNext()) {
                mi.next();
                ZSearchParams params = (ZSearchParams)mi.getKey();
                if (params.getTypes() == null || !params.getTypes().contains(type)) continue;
                mi.remove();
            }
        }
    }

    public synchronized void handleRefresh(ZRefreshEvent refreshEvent, ZMailbox mailbox) throws ServiceException {
        this.mSearchPagerCache.clear();
    }

    public synchronized void handleCreate(ZCreateEvent event, ZMailbox mailbox) throws ServiceException {
        if (event instanceof ZCreateMessageEvent) {
            for (Object obj : this.mSearchPagerCache.values()) {
                ((ZSearchPager)obj).createNotification((ZCreateItemEvent)event);
            }
        }
    }

    public synchronized void handleModify(ZModifyEvent event, ZMailbox mailbox) throws ServiceException {
        ZModifyItemFolderEvent mif;
        if (this.mClearOnModifyItemFolder && event instanceof ZModifyItemFolderEvent && (mif = (ZModifyItemFolderEvent)event).getFolderId(null) != null) {
            this.mSearchPagerCache.clear();
        }
        if (event instanceof ZModifyItemEvent) {
            for (Object obj : this.mSearchPagerCache.values()) {
                ((ZSearchPager)obj).modifyNotification((ZModifyItemEvent)event);
            }
        }
    }

    public synchronized void handleDelete(ZDeleteEvent event, ZMailbox mailbox) throws ServiceException {
        this.mSearchPagerCache.clear();
    }
}

