/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.zclient;

import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.zclient.ZMailbox;
import com.zimbra.cs.zclient.ZSearchHit;
import com.zimbra.cs.zclient.ZSearchParams;
import com.zimbra.cs.zclient.ZSearchResult;
import com.zimbra.cs.zclient.event.ZCreateItemEvent;
import com.zimbra.cs.zclient.event.ZCreateMessageEvent;
import com.zimbra.cs.zclient.event.ZModifyConversationEvent;
import com.zimbra.cs.zclient.event.ZModifyItemEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZSearchPager {
    private List<ZSearchResult> mResults;
    private ZSearchParams mParams;
    private Map<String, ZSearchHit> mHitMap;
    private String mConvId;
    private boolean mDirty;

    ZSearchPager(ZSearchParams params) {
        this.mParams = new ZSearchParams(params);
        this.mResults = new ArrayList<ZSearchResult>();
        this.mHitMap = new HashMap<String, ZSearchHit>();
    }

    ZSearchResult search(ZMailbox mailbox, int page, boolean useCursor) throws ServiceException {
        while (this.mResults.size() <= page) {
            if (this.mResults.size() == 0) {
                this.mParams.setCursor(null);
                this.mParams.setOffset(0);
            } else {
                ZSearchResult lastResult = this.mResults.get(this.mResults.size() - 1);
                if (!lastResult.hasMore()) break;
                if (useCursor) {
                    List<ZSearchHit> lastHits = lastResult.getHits();
                    ZSearchHit lastHit = lastHits.get(lastHits.size() - 1);
                    this.mParams.setCursor(new ZSearchParams.Cursor(lastHit.getId(), lastHit.getSortField()));
                } else {
                    this.mParams.setCursor(null);
                    this.mParams.setOffset(page * this.mParams.getLimit());
                }
            }
            ZSearchResult result = this.mParams.getConvId() == null ? mailbox.search(this.mParams) : mailbox.searchConversation(this.mParams.getConvId(), this.mParams);
            this.mResults.add(result);
            if (result.getConversationSummary() != null) {
                this.mConvId = result.getConversationSummary().getId();
            }
            for (ZSearchHit hit : result.getHits()) {
                this.mHitMap.put(hit.getId(), hit);
            }
            if (result.hasMore()) continue;
            break;
        }
        if (page < this.mResults.size()) {
            return this.mResults.get(page);
        }
        return this.mResults.get(this.mResults.size() - 1);
    }

    public List<ZSearchResult> getResults() {
        return this.mResults;
    }

    public int getNumberOfPages() {
        return this.mResults.size();
    }

    public ZSearchResult get(int page) {
        return this.mResults.get(page);
    }

    public boolean isDirty() {
        return this.mDirty;
    }

    public String getConversationId() {
        return this.mConvId;
    }

    void modifyNotification(ZModifyItemEvent event) throws ServiceException {
        ZSearchHit hit;
        if (this.mConvId != null && event instanceof ZModifyConversationEvent) {
            ZModifyConversationEvent mce = (ZModifyConversationEvent)event;
            if (mce.getMessageCount(-1) != -1) {
                this.mDirty = true;
            }
            if (mce.getId().equals(this.mConvId)) {
                for (ZSearchResult result : this.mResults) {
                    result.getConversationSummary().modifyNotification(event);
                }
            }
        }
        if ((hit = this.mHitMap.get(event.getId())) != null) {
            hit.modifyNotification(event);
        }
    }

    void createNotification(ZCreateItemEvent event) throws ServiceException {
        ZCreateMessageEvent cme;
        if (this.mConvId != null && event instanceof ZCreateMessageEvent && this.mConvId.equals((cme = (ZCreateMessageEvent)event).getConversationId(null))) {
            this.mDirty = true;
        }
    }
}

