/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.zclient;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.cs.zclient.ZFolder;
import com.zimbra.cs.zclient.ZJSONObject;
import com.zimbra.cs.zclient.ZMailbox;
import com.zimbra.cs.zclient.ZSearchContext;
import com.zimbra.cs.zclient.ZSearchParams;
import com.zimbra.cs.zclient.event.ZModifyEvent;
import com.zimbra.cs.zclient.event.ZModifySearchFolderEvent;
import org.json.JSONException;

public class ZSearchFolder
extends ZFolder {
    private String mQuery;
    private String mTypes;
    private ZMailbox.SearchSortBy mSortBy;

    public ZSearchFolder(Element e, ZFolder parent, ZMailbox mailbox) throws ServiceException {
        super(e, parent, mailbox);
        this.mQuery = e.getAttribute("query");
        this.mTypes = e.getAttribute("types", null);
        try {
            this.mSortBy = ZMailbox.SearchSortBy.fromString(e.getAttribute("sortBy", ZMailbox.SearchSortBy.dateDesc.name()));
        }
        catch (ServiceException se) {
            this.mSortBy = ZMailbox.SearchSortBy.dateDesc;
        }
    }

    public void modifyNotification(ZModifyEvent e) throws ServiceException {
        ZModifySearchFolderEvent sfe;
        if (e instanceof ZModifySearchFolderEvent && (sfe = (ZModifySearchFolderEvent)e).getId().equals(this.getId())) {
            this.mQuery = sfe.getQuery(this.mQuery);
            this.mTypes = sfe.getTypes(this.mTypes);
            this.mSortBy = sfe.getSortBy(this.mSortBy);
            super.modifyNotification(e);
        }
    }

    public ZJSONObject toZJSONObject() throws JSONException {
        ZJSONObject jo = super.toZJSONObject();
        jo.put("query", this.mQuery);
        jo.put("types", this.mTypes);
        jo.put("sortBy", this.mSortBy.name());
        return jo;
    }

    public String getQuery() {
        return this.mQuery;
    }

    public ZMailbox.SearchSortBy getSortBy() {
        return this.mSortBy;
    }

    public String getTypes() {
        return this.mTypes;
    }

    public String toString() {
        return String.format("[ZSearchFolder %s]", this.getPath());
    }

    public ZSearchContext getSearchContext() {
        ZSearchParams params = new ZSearchParams(this.mQuery);
        params.setTypes(this.mTypes);
        params.setSortBy(this.mSortBy);
        return new ZSearchContext(params, this.getMailbox());
    }
}

