/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.zclient;

import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.zclient.ToZJSONObject;
import com.zimbra.cs.zclient.ZJSONObject;
import com.zimbra.cs.zclient.ZMailbox;
import com.zimbra.cs.zclient.ZSearchHit;
import com.zimbra.cs.zclient.ZSearchParams;
import com.zimbra.cs.zclient.ZSearchResult;
import java.util.List;
import org.json.JSONException;

public class ZSearchContext
implements ToZJSONObject {
    private ZMailbox mMailbox;
    private ZSearchParams mParams;
    private ZSearchResult mResult;
    private int mIndex;
    private int mCount;
    private int mMaxHits = Integer.MAX_VALUE;
    private boolean mByOffset = false;
    private boolean mHasMore;

    public ZSearchContext(ZSearchParams params, ZMailbox mailbox) {
        this.mParams = params;
        this.mMailbox = mailbox;
    }

    public ZSearchHit getNextHit() throws ServiceException {
        if (this.mCount < this.mMaxHits) {
            if (this.mResult == null || this.mIndex + 1 >= this.mResult.getHits().size() && this.mResult.hasMore()) {
                if (this.mResult != null) {
                    if (this.mByOffset) {
                        this.mParams.setOffset(this.mParams.getOffset() + this.mResult.getHits().size());
                    } else {
                        List<ZSearchHit> hits = this.mResult.getHits();
                        ZSearchHit lastHit = hits.get(hits.size() - 1);
                        this.mParams.setCursor(new ZSearchParams.Cursor(lastHit.getId(), lastHit.getSortField()));
                    }
                }
                this.mResult = this.mParams.getConvId() != null ? this.mMailbox.searchConversation(this.mParams.getConvId(), this.mParams) : this.mMailbox.search(this.mParams);
                this.mIndex = 0;
            } else {
                ++this.mIndex;
            }
        }
        if (this.mCount >= this.mMaxHits || this.mIndex >= this.mResult.getHits().size()) {
            this.mHasMore = false;
            return null;
        }
        ++this.mCount;
        this.mHasMore = this.mCount < this.mMaxHits && (this.mIndex + 1 < this.mResult.getHits().size() || this.mResult.hasMore());
        return this.mResult.getHits().get(this.mIndex);
    }

    public void setByOffset(boolean byOffset) {
        this.mByOffset = byOffset;
    }

    public void setMaxHits(int maxHits) {
        this.mMaxHits = maxHits;
    }

    public boolean isHasMore() {
        return this.mHasMore;
    }

    public boolean isByOffset() {
        return this.mByOffset;
    }

    public int getIndex() {
        return this.mIndex;
    }

    public int getCount() {
        return this.mCount;
    }

    public ZSearchResult getResult() {
        return this.mResult;
    }

    public ZSearchParams getParams() {
        return this.mParams;
    }

    public ZSearchHit getCurrentHit() {
        return this.mResult != null && this.mIndex < this.mResult.getHits().size() ? this.mResult.getHits().get(this.mIndex) : null;
    }

    public ZJSONObject toZJSONObject() throws JSONException {
        ZJSONObject zjo = new ZJSONObject();
        zjo.put("more", this.mHasMore);
        zjo.put("index", this.mIndex);
        zjo.put("count", this.mCount);
        zjo.put("maxHits", this.mMaxHits);
        zjo.put("searchResult", this.mResult);
        zjo.put("searchParams", this.mParams);
        return zjo;
    }

    public String toString() {
        return String.format("[ZSearchContext count=%d more=%s]", this.mCount, this.mHasMore);
    }

    public String dump() {
        return ZJSONObject.toString(this);
    }
}

