/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.zclient;

import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.zclient.ZMailbox;
import com.zimbra.cs.zclient.ZSearchHit;
import com.zimbra.cs.zclient.ZSearchParams;
import com.zimbra.cs.zclient.ZSearchResult;
import com.zimbra.cs.zclient.event.ZCreateItemEvent;
import com.zimbra.cs.zclient.event.ZCreateMessageEvent;
import com.zimbra.cs.zclient.event.ZModifyConversationEvent;
import com.zimbra.cs.zclient.event.ZModifyItemEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ZSearchCache {
    private List<ZSearchCacheHit> mHits;
    private ZSearchParams mParams;
    private Map<String, ZSearchCacheHit> mHitMap;
    private String mConvId;
    private ZSearchResult.ZConversationSummary mConvSummary;
    private boolean mDirty;
    private boolean mHasMore;
    private int mSize;
    private ZSearchHit mLastHit;

    ZSearchCache(ZSearchParams params) {
        this.mParams = new ZSearchParams(params);
        this.mHitMap = new HashMap<String, ZSearchCacheHit>();
        this.mHasMore = true;
    }

    synchronized ZSearchResult search(ZMailbox mailbox, int page) throws ServiceException {
        int limit = this.mParams.getLimit();
        int offset = page * limit;
        ArrayList<ZSearchHit> hits = new ArrayList<ZSearchHit>();
        int actualIndex = 0;
        int nonDeletedIndex = -1;
        while (hits.size() < limit && this.mHasMore) {
            ZSearchCacheHit hit;
            if (actualIndex >= this.mHits.size()) {
                this.fetchMoreHits(mailbox);
            }
            if ((hit = this.mHits.get(actualIndex++)) == null || ++nonDeletedIndex < offset) continue;
            hits.add(hit.hit);
        }
        return new ZSearchResult(hits, this.mConvSummary, this.mHasMore, this.mParams.getSortBy().name(), offset);
    }

    private void fetchMoreHits(ZMailbox mailbox) throws ServiceException {
        if (!this.mHasMore) {
            return;
        }
        if (this.mLastHit == null) {
            this.mParams.setCursor(null);
            this.mParams.setOffset(0);
        } else {
            this.mParams.setCursor(new ZSearchParams.Cursor(this.mLastHit.getId(), this.mLastHit.getSortField()));
        }
        ZSearchResult result = this.mParams.getConvId() == null ? mailbox.search(this.mParams) : mailbox.searchConversation(this.mParams.getConvId(), this.mParams);
        int i = this.mHits.size();
        for (ZSearchHit hit : result.getHits()) {
            ZSearchCacheHit ch = new ZSearchCacheHit();
            ch.hit = hit;
            ch.index = i++;
            this.mHits.add(ch);
            this.mHitMap.put(hit.getId(), ch);
            this.mLastHit = hit;
        }
        this.mConvSummary = result.getConversationSummary();
        if (this.mConvSummary != null) {
            this.mConvId = this.mConvSummary.getId();
        }
        this.mHasMore = result.hasMore();
    }

    public String getConversationId() {
        return this.mConvId;
    }

    public boolean getDirty() {
        return this.mDirty;
    }

    void modifyNotification(ZModifyItemEvent event) throws ServiceException {
        ZSearchCacheHit hit;
        if (this.mConvId != null && event instanceof ZModifyConversationEvent) {
            ZModifyConversationEvent mce = (ZModifyConversationEvent)event;
            if (mce.getMessageCount(-1) != -1) {
                this.mDirty = true;
            }
            if (mce.getId().equals(this.mConvId)) {
                this.mConvSummary.modifyNotification(event);
            }
        }
        if ((hit = this.mHitMap.get(event.getId())) != null) {
            hit.hit.modifyNotification(event);
        }
    }

    void createNotification(ZCreateItemEvent event) throws ServiceException {
        ZCreateMessageEvent cme;
        if (this.mConvId != null && event instanceof ZCreateMessageEvent && this.mConvId.equals((cme = (ZCreateMessageEvent)event).getConversationId(null))) {
            this.mDirty = true;
        }
    }

    static class ZSearchCacheHit {
        ZSearchHit hit;
        int index;

        ZSearchCacheHit() {
        }
    }
}

