/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.zclient;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.cs.account.DataSource;
import com.zimbra.cs.zclient.ToZJSONObject;
import com.zimbra.cs.zclient.ZDataSource;
import com.zimbra.cs.zclient.ZJSONObject;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZRssDataSource
implements ZDataSource,
ToZJSONObject {
    private String mId;
    private String mName;
    private String mFolderId;
    private boolean mEnabled;

    public ZRssDataSource(String name, String folderId, boolean enabled) {
        this.mName = name;
        this.mFolderId = folderId;
        this.mEnabled = enabled;
    }

    public ZRssDataSource(Element e) throws ServiceException {
        this.mId = e.getAttribute("id");
        this.mName = e.getAttribute("name");
        this.mEnabled = e.getAttributeBool("isEnabled");
        this.mFolderId = e.getAttribute("l");
    }

    @Override
    public Map<String, Object> getAttrs() {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        attrs.put("zimbraDataSourceId", this.mId);
        attrs.put("zimbraDataSourceName", this.mName);
        attrs.put("zimbraDataSourceEnabled", this.mEnabled ? "TRUE" : "FALSE");
        attrs.put("zimbraDataSourceFolderId", this.mFolderId);
        return attrs;
    }

    @Override
    public String getId() {
        return this.mId;
    }

    @Override
    public String getName() {
        return this.mName;
    }

    @Override
    public DataSource.Type getType() {
        return DataSource.Type.rss;
    }

    public String getFolderId() {
        return this.mFolderId;
    }

    public boolean isEnabled() {
        return this.mEnabled;
    }

    @Override
    public Element toElement(Element parent) {
        Element src = parent.addElement("rss");
        if (this.mId != null) {
            src.addAttribute("id", this.mId);
        }
        src.addAttribute("name", this.mName);
        src.addAttribute("isEnabled", this.mEnabled);
        src.addAttribute("l", this.mFolderId);
        return src;
    }

    @Override
    public Element toIdElement(Element parent) {
        Element src = parent.addElement("rss");
        src.addAttribute("id", this.mId);
        return src;
    }

    @Override
    public ZJSONObject toZJSONObject() throws JSONException {
        ZJSONObject zjo = new ZJSONObject();
        zjo.put("id", this.mId);
        zjo.put("name", this.mName);
        zjo.put("enabled", this.mEnabled);
        zjo.put("folderId", this.mFolderId);
        return zjo;
    }
}

