/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.zclient;

import com.zimbra.common.calendar.TZIDMapper;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZPrefs {
    private Map<String, List<String>> mPrefs;
    private TimeZone mCachedTimeZone;
    private String mCachedTimeZoneId;

    public ZPrefs(Map<String, List<String>> prefs) {
        this.mPrefs = prefs;
    }

    public String get(String name) {
        List<String> value = this.mPrefs.get(name);
        return value == null || value.isEmpty() ? null : value.get(0);
    }

    public boolean getBool(String name) {
        return "TRUE".equals(this.get(name));
    }

    public long getLong(String name) {
        String v = this.get(name);
        try {
            return v == null ? -1L : Long.parseLong(v);
        }
        catch (NumberFormatException e) {
            return -1L;
        }
    }

    public Map<String, List<String>> getPrefs() {
        return this.mPrefs;
    }

    public String getAppleiCalDelegationEnabled() {
        return this.get("zimbraPrefAppleIcalDelegationEnabled");
    }

    public String getComposeFormat() {
        return this.get("zimbraPrefComposeFormat");
    }

    public String getHtmlEditorDefaultFontFamily() {
        return this.get("zimbraPrefHtmlEditorDefaultFontFamily");
    }

    public String getHtmlEditorDefaultFontSize() {
        return this.get("zimbraPrefHtmlEditorDefaultFontSize");
    }

    public String getHtmlEditorDefaultFontColor() {
        return this.get("zimbraPrefHtmlEditorDefaultFontColor");
    }

    public String getLocale() {
        return this.get("zimbraPrefLocale");
    }

    public String getYintl() {
        return this.get("zimbraPrefLocale");
    }

    public boolean getUseTimeZoneListInCalendar() {
        return this.getBool("zimbraPrefUseTimeZoneListInCalendar");
    }

    public boolean getReadingPaneEnabled() {
        return this.getBool("zimbraPrefReadingPaneEnabled");
    }

    public boolean getMailSignatureEnabled() {
        return this.getBool("zimbraPrefMailSignatureEnabled");
    }

    public boolean getIncludeSpamInSearch() {
        return this.getBool("zimbraPrefIncludeSpamInSearch");
    }

    public boolean getIncludeTrashInSearch() {
        return this.getBool("zimbraPrefIncludeTrashInSearch");
    }

    public boolean getShowSearchString() {
        return this.getBool("zimbraPrefShowSearchString");
    }

    public boolean getShowFragments() {
        return this.getBool("zimbraPrefShowFragments");
    }

    public boolean getSaveToSent() {
        return this.getBool("zimbraPrefSaveToSent");
    }

    public boolean getOutOfOfficeReplyEnabled() {
        return this.getBool("zimbraPrefOutOfOfficeReplyEnabled");
    }

    public boolean getNewMailNotificationsEnabled() {
        return this.getBool("zimbraPrefNewMailNotificationEnabled");
    }

    public boolean getMailLocalDeliveryDisabled() {
        return this.getBool("zimbraPrefMailLocalDeliveryDisabled");
    }

    public boolean getMessageViewHtmlPreferred() {
        return this.getBool("zimbraPrefMessageViewHtmlPreferred");
    }

    public boolean getAutoAddAddressEnabled() {
        return this.getBool("zimbraPrefAutoAddAddressEnabled");
    }

    public String getShortcuts() {
        return this.get("zimbraPrefShortcuts");
    }

    public boolean getUseKeyboardShortcuts() {
        return this.getBool("zimbraPrefUseKeyboardShortcuts");
    }

    public boolean getSignatureEnabled() {
        return this.getBool("zimbraPrefMailSignatureEnabled");
    }

    public String getClientType() {
        return this.get("zimbraPrefClientType");
    }

    public boolean getIsAdvancedClient() {
        return "advanced".equals(this.getClientType());
    }

    public boolean getIsStandardClient() {
        return "standard".equals(this.getClientType());
    }

    public String getSignatureStyle() {
        return this.get("zimbraPrefMailSignatureStyle");
    }

    public boolean getSignatureStyleTop() {
        return "outlook".equals(this.getSignatureStyle());
    }

    public boolean getSignatureStyleBottom() {
        return "internet".equals(this.getSignatureStyle());
    }

    public String getGroupMailBy() {
        return this.get("zimbraPrefGroupMailBy");
    }

    public boolean getGroupByConversation() {
        String gb = this.getGroupMailBy();
        return "conversation".equals(gb);
    }

    public boolean getGroupByMessage() {
        String gb = this.getGroupMailBy();
        return gb == null || "message".equals(gb);
    }

    public String getSkin() {
        return this.get("zimbraPrefSkin");
    }

    public String getDedupeMessagesSentToSelf() {
        return this.get("zimbraPrefDedupeMessagesSentToSelf");
    }

    public String getMailInitialSearch() {
        return this.get("zimbraPrefMailInitialSearch");
    }

    public String getNewMailNotificationAddress() {
        return this.get("zimbraPrefNewMailNotificationAddress");
    }

    public String getMailForwardingAddress() {
        return this.get("zimbraPrefMailForwardingAddress");
    }

    public String getOutOfOfficeReply() {
        return this.get("zimbraPrefOutOfOfficeReply");
    }

    public String getOutOfOfficeFromDate() {
        return this.get("zimbraPrefOutOfOfficeFromDate");
    }

    public String getOutOfOfficeUntilDate() {
        return this.get("zimbraPrefOutOfOfficeUntilDate");
    }

    public String getMailSignature() {
        return this.get("zimbraPrefMailSignature");
    }

    public long getMailItemsPerPage() {
        return this.getLong("zimbraPrefMailItemsPerPage");
    }

    public long getContactsPerPage() {
        return this.getLong("zimbraPrefContactsPerPage");
    }

    public long getVoiceItemsPerPage() {
        return this.getLong("zimbraPrefVoiceItemsPerPage");
    }

    public long getCalendarFirstDayOfWeek() {
        return this.getLong("zimbraPrefCalendarFirstDayOfWeek");
    }

    public String getInboxUnreadLifetime() {
        return this.get("zimbraPrefInboxUnreadLifetime");
    }

    public String getInboxReadLifetime() {
        return this.get("zimbraPrefInboxReadLifetime");
    }

    public String getSentLifetime() {
        return this.get("zimbraPrefSentLifetime");
    }

    public String getJunkLifetime() {
        return this.get("zimbraPrefJunkLifetime");
    }

    public String getTrashLifetime() {
        return this.get("zimbraPrefTrashLifetime");
    }

    public boolean getDisplayExternalImages() {
        return this.getBool("zimbraPrefDisplayExternalImages");
    }

    public long getCalendarDayHourStart() {
        long hour = this.getLong("zimbraPrefCalendarDayHourStart");
        return hour == -1L ? 8L : hour;
    }

    public long getCalendarDayHourEnd() {
        long hour = this.getLong("zimbraPrefCalendarDayHourEnd");
        return hour == -1L ? 18L : hour;
    }

    public String getCalendarInitialView() {
        return this.get("zimbraPrefCalendarInitialView");
    }

    public String getTimeZoneId() {
        return this.get("zimbraPrefTimeZoneId");
    }

    public String getTimeZoneCanonicalId() {
        return TZIDMapper.canonicalize(this.get("zimbraPrefTimeZoneId"));
    }

    public synchronized TimeZone getTimeZone() {
        if (this.mCachedTimeZone == null || this.mCachedTimeZoneId != null && !this.mCachedTimeZoneId.equals(this.getTimeZoneId())) {
            this.mCachedTimeZoneId = this.getTimeZoneId();
            TimeZone timeZone = this.mCachedTimeZone = this.mCachedTimeZoneId == null ? null : TimeZone.getTimeZone(TZIDMapper.canonicalize(this.mCachedTimeZoneId));
            if (this.mCachedTimeZone == null) {
                this.mCachedTimeZone = TimeZone.getDefault();
            }
        }
        return this.mCachedTimeZone;
    }

    public String getReplyIncludeOriginalText() {
        return this.get("zimbraPrefReplyIncludeOriginalText");
    }

    public boolean getReplyIncludeAsAttachment() {
        return "includeAsAttachment".equals(this.getReplyIncludeOriginalText());
    }

    public boolean getReplyIncludeBody() {
        return "includeBody".equals(this.getReplyIncludeOriginalText());
    }

    public boolean getReplyIncludeBodyWithPrefx() {
        return "includeBodyWithPrefix".equals(this.getReplyIncludeOriginalText());
    }

    public boolean getReplyIncludeNone() {
        return "includeNone".equals(this.getReplyIncludeOriginalText());
    }

    public boolean getReplyIncludeSmart() {
        return "includeSmart".equals(this.getReplyIncludeOriginalText());
    }

    public String getForwardIncludeOriginalText() {
        return this.get("zimbraPrefForwardIncludeOriginalText");
    }

    public boolean getForwardIncludeAsAttachment() {
        return "includeAsAttachment".equals(this.getForwardIncludeOriginalText());
    }

    public boolean getForwardIncludeBody() {
        return "includeBody".equals(this.getForwardIncludeOriginalText());
    }

    public boolean getForwardIncludeBodyWithPrefx() {
        return "includeBodyWithPrefix".equals(this.getForwardIncludeOriginalText());
    }

    public String getForwardReplyFormat() {
        return this.get("zimbraPrefForwardReplyFormat");
    }

    public boolean getForwardReplyTextFormat() {
        return "text".equals(this.getForwardReplyFormat());
    }

    public boolean getForwardReplyHtmlFormat() {
        return "html".equals(this.getForwardReplyFormat());
    }

    public boolean getForwardReplySameFormat() {
        return "same".equals(this.getForwardReplyFormat());
    }

    public boolean getForwardReplyInOriginalFormat() {
        return this.getBool("zimbraPrefForwardReplyInOriginalFormat");
    }

    public String getForwardReplyPrefixChar() {
        return this.get("zimbraPrefForwardReplyPrefixChar");
    }

    public String getCalendarReminderDuration1() {
        return this.get("zimbraPrefCalendarReminderDuration1");
    }

    public String getCalendarReminderDuration2() {
        return this.get("zimbraPrefCalendarReminderDuration2");
    }

    public String getCalendarReminderEmail() {
        return this.get("zimbraPrefCalendarReminderEmail");
    }

    public boolean getCalendarReminderSendEmail() {
        return this.getBool("zimbraPrefCalendarReminderSendEmail");
    }

    public boolean getCalendarReminderMobile() {
        return this.getBool("zimbraPrefCalendarReminderMobile");
    }

    public boolean getCalendarReminderYMessenger() {
        return this.getBool("zimbraPrefCalendarReminderYMessenger");
    }

    public String getPop3DownloadSince() {
        return this.get("zimbraPrefPop3DownloadSince");
    }
}

