/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.zclient;

import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.zclient.ToZJSONObject;
import com.zimbra.cs.zclient.ZJSONObject;
import org.json.JSONException;

public class ZPhone
implements ToZJSONObject {
    private String mName;
    private String mCallerId;

    public ZPhone(String name, String callerId) throws ServiceException {
        this.mName = name;
        this.mCallerId = callerId != null && (callerId.equals(name) || callerId.equals("Unavailable")) ? null : callerId;
    }

    public ZPhone(String name) throws ServiceException {
        this(name, null);
    }

    public String getName() {
        return this.mName;
    }

    public String getDisplay() {
        return ZPhone.getDisplay(this.mName);
    }

    public String getCallerId() {
        return this.mCallerId;
    }

    public ZJSONObject toZJSONObject() throws JSONException {
        ZJSONObject zjo = new ZJSONObject();
        zjo.put("name", this.mName);
        return zjo;
    }

    public String toString() {
        return String.format("[ZPhone %s]", this.mName);
    }

    public String dump() {
        return ZJSONObject.toString(this);
    }

    public static String getDisplay(String name) {
        int offset = 0;
        boolean doIt = false;
        if (name.length() == 10) {
            doIt = true;
        } else if (name.length() == 11 && name.charAt(0) == '1') {
            doIt = true;
            offset = 1;
        }
        if (doIt) {
            StringBuilder builder = new StringBuilder();
            builder.append('(');
            builder.append(name, offset, offset + 3);
            builder.append(") ");
            builder.append(name, offset + 3, offset + 6);
            builder.append('-');
            builder.append(name, offset + 6, offset + 10);
            return builder.toString();
        }
        return name;
    }

    public static String getName(String display) {
        if (display == null) {
            return display;
        }
        StringBuilder builder = new StringBuilder(display.length());
        int count = display.length();
        for (int i = 0; i < count; ++i) {
            char ch = display.charAt(i);
            if (!Character.isDigit(ch)) continue;
            builder.append(ch);
        }
        return builder.toString();
    }
}

